/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.gui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.product.ProdStatusRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.projects.qit.product.gui.SelectProdListener;
import com.ibm.nzna.projects.qit.product.prodedit.ProdEditPanel;
import com.ibm.nzna.projects.qit.product.storedProc.prodListReader.ProdListReaderBuffer;
import com.ibm.nzna.projects.qit.product.storedProc.prodListReader.ProdListReaderProdBuffer;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.sql.CallableStatement;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SelectProdDlg
extends JDialog
implements Runnable,
AppConst,
ProductConstants,
ActionListener {
    private static final String[] listTitle = new String[]{Str.getStr(334), Str.getStr(100), Str.getStr(319), Str.getStr(708)};
    private static SelectProdDlg instance = null;
    private JPanel findBorder = null;
    private JPanel searchArgBorder = null;
    private JComboBox cb_SEARCH = null;
    private JLabel st_IS = null;
    private JTextField ef_SEARCH = null;
    private DButton pb_FIND = null;
    private DButton pb_SELECT = null;
    private DButton pb_EDIT = null;
    private DButton pb_CANCEL = null;
    private MultiList cnr_PRODUCTS = null;
    private ButtonPanel buttonPanel = null;
    private Vector listenerVec = new Vector(1, 1);

    private void initialize() {
        this.setTitle(Str.getStr(876));
        this.findBorder = new JPanel();
        this.searchArgBorder = new JPanel();
        this.cb_SEARCH = new JComboBox(this.getSearchTypes());
        this.ef_SEARCH = new JTextField("", 20);
        this.st_IS = new JLabel(Str.getStr(463));
        this.cnr_PRODUCTS = new MultiList(GUISystem.getFontUtil());
        this.pb_FIND = new DButton(Str.getStr(470));
        this.pb_SELECT = new DButton(Str.getStr(404));
        this.pb_EDIT = new DButton(Str.getStr(50));
        this.pb_CANCEL = new DButton(Str.getStr(2));
        this.buttonPanel = new ButtonPanel();
        this.ef_SEARCH.setDocument(new MaskDocument(1, 12));
        this.findBorder.setBorder(new TitledBorder(Str.getStr(299) + " - 0"));
        this.searchArgBorder.setBorder(new TitledBorder(Str.getStr(470)));
        this.searchArgBorder.setLayout(new FlowLayout(0));
        this.findBorder.setLayout(new BorderLayout());
        this.cnr_PRODUCTS.setColumnHeadings(listTitle);
        this.cnr_PRODUCTS.setColumnWidth(1, 250);
        GUISystem.setPreferredButton(this.pb_FIND);
        GUISystem.setPreferredButton(this.pb_EDIT);
        GUISystem.setPreferredButton(this.pb_SELECT);
        GUISystem.setPreferredButton(this.pb_CANCEL);
        this.pb_FIND.addActionListener(this);
        this.pb_SELECT.addActionListener(this);
        this.pb_EDIT.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.cnr_PRODUCTS.addActionListener(this);
        this.cb_SEARCH.addActionListener(this);
        this.ef_SEARCH.addActionListener(this);
        this.findBorder.add((Component)this.cnr_PRODUCTS, "Center");
        this.searchArgBorder.add(this.cb_SEARCH);
        this.searchArgBorder.add(this.st_IS);
        this.searchArgBorder.add(this.ef_SEARCH);
        this.getContentPane().setLayout(new BorderLayout());
        this.buttonPanel.add(this.pb_FIND);
        this.buttonPanel.add(this.pb_SELECT);
        this.buttonPanel.add(this.pb_EDIT);
        this.buttonPanel.add(this.pb_CANCEL);
        this.getContentPane().add((Component)this.findBorder, "Center");
        this.getContentPane().add((Component)this.searchArgBorder, "North");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        GUISystem.setPropertiesOnPanel(this.getContentPane());
        ((Component)this).setSize(400, 300);
        WinUtil.centerWindow(this);
        this.setVisible(true);
    }

    private Vector getSearchTypes() {
        Vector<String> vector = new Vector<String>(1, 1);
        vector.addElement(Str.getStr(334));
        vector.addElement(Str.getStr(264));
        vector.addElement(Str.getStr(100));
        vector.addElement(Str.getStr(340));
        vector.addElement(Str.getStr(341));
        return vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Vector vector;
        if (actionEvent.getSource() == this.pb_CANCEL) {
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cb_SEARCH) {
            this.refreshSearchFields();
        } else if (actionEvent.getSource() == this.pb_FIND || actionEvent.getSource() == this.ef_SEARCH) {
            new Thread(this).start();
        } else if (actionEvent.getSource() == this.pb_EDIT) {
            ProductRec productRec = (ProductRec)this.cnr_PRODUCTS.getSelectedItem();
            if (productRec != null && productRec.valid() && productRec.readProductForEdit()) {
                ProdEditPanel prodEditPanel = new ProdEditPanel(null, productRec);
                WindowSystem.createPanel(prodEditPanel);
                this.setVisible(false);
            }
        } else if (actionEvent.getSource() == this.pb_SELECT && (vector = this.cnr_PRODUCTS.getSelection()) != null && vector.size() > 0) {
            this.fireProdSelectedEvent(vector);
            this.setVisible(false);
        }
    }

    private void refreshSearchFields() {
        String string = (String)this.cb_SEARCH.getSelectedItem();
        if (string.equals(Str.getStr(334))) {
            this.ef_SEARCH.setDocument(new MaskDocument(1, 12));
        } else if (string.equals(Str.getStr(264))) {
            this.ef_SEARCH.setDocument(new MaskDocument(3));
        }
        if (string.equals(Str.getStr(341))) {
            this.ef_SEARCH.setDocument(new MaskDocument(4, "VVV", this.ef_SEARCH));
        }
        if (string.equals(Str.getStr(340))) {
            this.ef_SEARCH.setDocument(new MaskDocument(4, "VVVV", this.ef_SEARCH));
        }
        if (string.equals(Str.getStr(100))) {
            this.ef_SEARCH.setDocument(new MaskDocument(0, 50));
        }
        this.ef_SEARCH.requestFocus();
    }

    private void search() {
        SQLMethod sQLMethod = new SQLMethod(1, "SelectProdDlg.search", 5);
        String string = (String)this.cb_SEARCH.getSelectedItem();
        String string2 = this.ef_SEARCH.getText();
        String string3 = null;
        String string4 = null;
        this.cnr_PRODUCTS.removeAll();
        this.enableGUI(false);
        try {
            if (string2 != null && string2.length() > 0) {
                string2 = Text.cleanDBString(string2);
                if ((string2 = Text.replaceAllStrInStr(string2, "*", "%")).indexOf("%") == -1) {
                    string2 = "%" + string2 + "%";
                }
                string3 = string2.indexOf("%") >= 0 ? "LIKE" : "=";
                if (string.equals(Str.getStr(334))) {
                    string4 = " PRODNUM " + string3 + " '" + string2 + "' AND ";
                } else if (string.equals(Str.getStr(100))) {
                    string4 = " PRODDESC " + string3 + " '" + string2 + "' AND ";
                } else if (string.equals(Str.getStr(341))) {
                    string4 = " MODEL " + string3 + " '" + string2 + "' AND ";
                } else if (string.equals(Str.getStr(340))) {
                    string4 = " MACHINE " + string3 + " '" + string2 + "' AND ";
                } else if (string.equals(Str.getStr(264))) {
                    string4 = " PRODINT = " + string2 + " AND ";
                }
                if (string4 != null) {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.ProdListReader", 4);
                    int n = 0;
                    String string5 = null;
                    string4 = string4 + " RECYCLED = 'N' AND MACHINE <> 'All' AND MODEL <> 'All' ORDER BY PRODNUM";
                    LogSystem.log(1, "Executing Product Search:" + string4);
                    callableStatement.setString(1, string4);
                    callableStatement.registerOutParameter(2, -4);
                    callableStatement.registerOutParameter(3, 4);
                    callableStatement.registerOutParameter(4, -1);
                    callableStatement.execute();
                    n = callableStatement.getInt(3);
                    string5 = callableStatement.getString(4);
                    if (n != 0) {
                        GUISystem.printBox(Str.getStr(6), Str.getStr(212) + n);
                    } else if (string5 != null) {
                        LogSystem.log(1, "Got this From Return of ProdListReader:" + string5 + "\nSQLCODE:" + n);
                    } else {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(callableStatement.getBytes(2));
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        ProdListReaderBuffer prodListReaderBuffer = (ProdListReaderBuffer)objectInputStream.readObject();
                        int n2 = 0;
                        int n3 = prodListReaderBuffer.retVec.size();
                        ProductRec productRec = null;
                        ProdListReaderProdBuffer prodListReaderProdBuffer = null;
                        Vector<ProductRec> vector = new Vector<ProductRec>(1, 1);
                        while (n2 < n3) {
                            productRec = new ProductRec();
                            prodListReaderProdBuffer = (ProdListReaderProdBuffer)prodListReaderBuffer.retVec.elementAt(n2);
                            productRec.setFieldData(4, prodListReaderProdBuffer.prodNum);
                            productRec.setFieldData(5, prodListReaderProdBuffer.prodDesc);
                            productRec.setFieldData(3, prodListReaderProdBuffer.model);
                            productRec.setFieldData(6, new ProdStatusRec(prodListReaderProdBuffer.statusInd, prodListReaderProdBuffer.statusDate));
                            productRec.setFieldData(9, prodListReaderProdBuffer.dbUser);
                            productRec.setFieldData(16, new Integer(prodListReaderProdBuffer.prodInt));
                            productRec.setFieldData(11, new Integer(prodListReaderProdBuffer.brandGroupInd));
                            productRec.setFieldData(10, prodListReaderProdBuffer.changedTime);
                            productRec.setFieldData(2, prodListReaderProdBuffer.machine);
                            vector.addElement(productRec);
                            ++n2;
                        }
                        this.cnr_PRODUCTS.add(vector);
                        ((TitledBorder)this.findBorder.getBorder()).setTitle(Str.getStr(299) + " - " + vector.size());
                    }
                }
            } else {
                GUISystem.printBox(7, 411);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        this.enableGUI(true);
        this.ef_SEARCH.requestFocus();
        sQLMethod.close();
    }

    private void enableGUI(boolean bl) {
        this.pb_FIND.setEnabled(bl);
        this.pb_EDIT.setEnabled(bl);
        this.pb_SELECT.setEnabled(bl);
        this.pb_CANCEL.setEnabled(bl);
        this.findBorder.setEnabled(bl);
        this.searchArgBorder.setEnabled(bl);
    }

    public void addSelectProdListener(SelectProdListener selectProdListener) {
        this.listenerVec.addElement(selectProdListener);
    }

    private void removeAllListeners() {
        this.listenerVec.removeAllElements();
    }

    private void fireProdSelectedEvent(Vector vector) {
        int n = 0;
        int n2 = this.listenerVec.size();
        while (n < n2) {
            ((SelectProdListener)this.listenerVec.elementAt(n)).selectProdComplete(vector);
            ++n;
        }
    }

    public void removeSelectProdListener(SelectProdListener selectProdListener) {
        this.listenerVec.removeElement(selectProdListener);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.removeAllListeners();
        }
    }

    public static SelectProdDlg getInstance() {
        return instance;
    }

    public void run() {
        this.search();
    }

    public SelectProdDlg() {
        if (instance == null) {
            instance = this;
            this.initialize();
        } else {
            instance.setVisible(true);
            this.dispose();
        }
    }
}

