/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.history;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductSQL;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.ThemeSystem;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.history.ProductHistoryPanel;
import com.ibm.nzna.projects.qit.product.history.ProductHistoryRow;
import com.ibm.nzna.projects.qit.product.history.ProductHistorySQL;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProductHistoryNavPanel
extends JPanel
implements Runnable,
NavPanel,
AppConst,
ProductConst,
ActionListener,
MouseListener {
    private static final String THREAD_READ_HISTORY = "READ_HIST";
    private static final String[] listTitle = new String[]{Str.getStr(18004), Str.getStr(288), Str.getStr(266)};
    private ProductDraft productDraft = null;
    private Product product = null;
    private JTextField ef_PRODIND = null;
    private JLabel st_PRODIND = null;
    private JLabel st_PUBLISHDATES = null;
    private MultiList historyList = null;
    private DButton pb_GO = null;
    private JCheckBox ck_REQUEST = null;
    private ProductHistoryPanel productHistoryPanel = null;
    private boolean request = false;
    private int prodInd = 0;

    public void initialize() {
        this.pb_GO = new DButton(Str.getStr(112));
        this.ef_PRODIND = new JTextField("");
        this.st_PRODIND = new JLabel(Str.getStr(18004));
        this.historyList = new MultiList(GUISystem.getFontUtil());
        this.st_PUBLISHDATES = new JLabel(Str.getStr(891));
        this.ck_REQUEST = new JCheckBox(Str.getStr(1066));
        this.st_PUBLISHDATES.setFont(FontSystem.smallTitleFont);
        this.st_PRODIND.setFont(FontSystem.smallTitleFont);
        this.historyList.setBorder(null);
        this.historyList.setColumnHeadings(listTitle);
        this.historyList.setColumnHeadingsBackground(Color.white);
        this.historyList.setColumnWidth(0, 75);
        this.historyList.setColumnWidth(1, 75);
        this.historyList.setColumnWidth(2, 175);
        this.ck_REQUEST.setOpaque(false);
        this.historyList.setOpaque(false);
        this.ef_PRODIND.setOpaque(true);
        this.historyList.setBackground(ThemeSystem.getColor("NAVPANEL_BG_COLOR"));
        this.historyList.setOddLinesColor(ThemeSystem.getColor("NAVPANEL_BG_COLOR"));
        this.historyList.getJList().addMouseListener(this);
        this.ef_PRODIND.addActionListener(this);
        this.pb_GO.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_PRODIND);
        this.add(this.ef_PRODIND);
        this.add(this.pb_GO);
        this.add(this.ck_REQUEST);
        this.add(this.st_PUBLISHDATES);
        this.add(this.historyList);
    }

    public void doLayout() {
        int n = 5;
        int n2 = 5;
        int n3 = GUISystem.getRowHeight();
        Dimension dimension = this.getSize();
        this.st_PRODIND.setBounds(n, n2, dimension.width - n * 2, n3);
        this.ef_PRODIND.setBounds(n, n2 += n3, dimension.width - n * 2 - 55, n3);
        this.pb_GO.setBounds(dimension.width - n * 2 - 50, n2, 45, n3);
        this.ck_REQUEST.setBounds(n, n2 += n3, dimension.width - n * 2, n3);
        this.st_PUBLISHDATES.setBounds(n, n2 += n3 * 2, dimension.width - n * 2, n3);
        this.historyList.setBounds(n, n2 += n3, dimension.width - n * 2, dimension.height - n2 - 10);
    }

    public void start() {
        this.ef_PRODIND.requestFocus();
    }

    public void stop() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_GO || actionEvent.getSource() == this.ef_PRODIND) {
            try {
                this.setProdInd(new Integer(this.ef_PRODIND.getText()), this.ck_REQUEST.isSelected());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        ProductHistoryRow productHistoryRow = (ProductHistoryRow)this.historyList.getSelectedItem();
        if (productHistoryRow != null) {
            this.productDraft = new ProductDraft(productHistoryRow.getProductInd());
            this.readDatabase(this.productDraft);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public String getTitle() {
        return Str.getStr(18000);
    }

    public JComponent getJComponent() {
        return this;
    }

    public void setProduct(ProductDraft productDraft) {
        this.productDraft = productDraft;
    }

    public ProductDraft getProduct() {
        return this.productDraft;
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_READ_HISTORY)) {
            this.readHistory(new Integer(this.ef_PRODIND.getText()));
        }
    }

    private void readHistory(int n) {
        AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this);
        this.pb_GO.setEnabled(false);
        this.ef_PRODIND.setEnabled(false);
        appDefaultWin.setStatus(Str.getStr(14));
        try {
            if (this.request) {
                int n2 = ProductSQL.getExistingProductInd(n);
                this.ef_PRODIND.setText("" + n2);
            }
            if (n != 0) {
                Vector vector = ProductHistorySQL.readHistory(GUISystem.getParentDefWin(this), n);
                if (vector != null && vector.size() > 0) {
                    this.historyList.removeAll();
                    this.historyList.add(vector);
                } else {
                    GUISystem.printBox(7, 18009);
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        this.pb_GO.setEnabled(true);
        this.ef_PRODIND.setEnabled(true);
        appDefaultWin.setStatus(null);
    }

    protected int getProdInd() {
        try {
            return new Integer(this.ef_PRODIND.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected void setProdInd(int n, boolean bl) {
        this.ef_PRODIND.setText("" + n);
        this.request = bl;
        this.ck_REQUEST.setSelected(bl);
        this.historyList.removeAll();
        new Thread((Runnable)this, THREAD_READ_HISTORY).start();
    }

    private boolean readDatabase(ProductDraft productDraft) {
        int n = 0;
        if (productDraft != null) {
            LogSystem.beginLogSection("Reading Product Selected");
            n = productDraft.readFromDatabase();
            switch (n) {
                case 0: {
                    LogSystem.log(1, "Successful Read");
                    this.productHistoryPanel.setProduct(productDraft);
                    break;
                }
                case 100: {
                    LogSystem.log(1, "Unsuccessful Read");
                    GUISystem.printBox(7, 18010);
                    break;
                }
                default: {
                    LogSystem.log(1, "Return Code: " + n);
                    break;
                }
            }
        }
        return n == 0;
    }

    public ProductHistoryNavPanel(ProductHistoryPanel productHistoryPanel) {
        this.productHistoryPanel = productHistoryPanel;
    }
}

