/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.manager;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.product.CreateProductDraft;
import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.batchrunner.BatchRunnerPanel;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.bookmark.BookmarkSystem;
import com.ibm.nzna.projects.qit.customview.CustomView;
import com.ibm.nzna.projects.qit.customview.CustomViewDlg;
import com.ibm.nzna.projects.qit.customview.CustomViewDlgListener;
import com.ibm.nzna.projects.qit.customview.CustomViewSystem;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.SingleMLEDlg;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.projects.qit.gui.ToolBarButton;
import com.ibm.nzna.projects.qit.help.HelpSource;
import com.ibm.nzna.projects.qit.print.Print;
import com.ibm.nzna.projects.qit.print.PrintPanel;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.compare.ProductComparePanel;
import com.ibm.nzna.projects.qit.product.gui.BrandMappingRow;
import com.ibm.nzna.projects.qit.product.gui.CountryMappingRow;
import com.ibm.nzna.projects.qit.product.gui.FindProductListener;
import com.ibm.nzna.projects.qit.product.gui.ProductDlg;
import com.ibm.nzna.projects.qit.product.gui.ProductSearchDlg;
import com.ibm.nzna.projects.qit.product.history.ProductHistoryPanel;
import com.ibm.nzna.projects.qit.product.manager.BrandMapDlg;
import com.ibm.nzna.projects.qit.product.manager.CountryMapDlg;
import com.ibm.nzna.projects.qit.product.manager.NewProductDlg;
import com.ibm.nzna.projects.qit.product.manager.ProductCustomView;
import com.ibm.nzna.projects.qit.product.manager.ProductNavPanel;
import com.ibm.nzna.projects.qit.product.manager.masschange.FieldChangerWizard;
import com.ibm.nzna.projects.qit.product.manager.property.PropertyDlg;
import com.ibm.nzna.projects.qit.product.manager.views.PMView;
import com.ibm.nzna.projects.qit.product.manager.views.PMViewModel;
import com.ibm.nzna.projects.qit.product.manager.views.PMViews;
import com.ibm.nzna.projects.qit.product.manager.views.RefreshTreeViewThread;
import com.ibm.nzna.projects.qit.product.productEdit.EditProduct;
import com.ibm.nzna.projects.qit.product.productEdit.ProductEditPanel;
import com.ibm.nzna.projects.qit.product.productEdit.ProductSaveCheck;
import com.ibm.nzna.projects.qit.product.productEdit.ProductSaver;
import com.ibm.nzna.projects.qit.product.productExport.ExportWizard;
import com.ibm.nzna.projects.qit.product.productImport.ProductImport;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DetailJTree;
import com.ibm.nzna.shared.gui.DetailTreeCellRenderer;
import com.ibm.nzna.shared.gui.MutableTreeWrapper;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.gui.ViewTreeNode;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ProductManagementPanel
extends JPanel
implements Runnable,
ProductConst,
ActionListener,
AppConst,
FindProductListener,
CustomViewDlgListener,
PrintPanel,
TreeSelectionListener,
TreeExpansionListener,
QuestPanel,
Authority,
HelpSource {
    private static final String THREAD_REFRESH_VIEW = "REFRESH_VIEW";
    private static final String THREAD_REFRESHVIEW_NODE = "REFRESH_VIEW_NODE";
    private static final String THREAD_UNLOCK_PRODUCTS = "UNLOCK";
    private static final String THREAD_REFRESH_PREVIEW = "REFRESH_PREVIEW";
    private static final String THREAD_COMPLETEREQUESTS = "RCOMREQ";
    private ActionButton pb_SAVE = null;
    private ToolBarButton pb_PROPERTY = null;
    private JMenu showMenu = new JMenu("Show");
    private JCheckBoxMenuItem ck_SHOW_PARTNUM = new JCheckBoxMenuItem("Part/Product Number");
    private JCheckBoxMenuItem ck_SHOW_DESCRIPTION = new JCheckBoxMenuItem("Description");
    private JCheckBoxMenuItem ck_SHOW_ANNOUNCE = new JCheckBoxMenuItem("Announce Date");
    private JCheckBoxMenuItem ck_SHOW_CREATEDATE = new JCheckBoxMenuItem("Create Date");
    private JCheckBoxMenuItem ck_SHOW_LASTTOUCHEDBY = new JCheckBoxMenuItem("Last Touched By");
    private JCheckBoxMenuItem ck_SHOW_LASTTOUCHEDON = new JCheckBoxMenuItem("Last Touched On");
    private ProductNavPanel navPanel = null;
    private ToolBarButton pb_UNLOCK = null;
    private ToolBarButton pb_FIND = null;
    private ToolBarButton pb_WIZARD = null;
    private ToolBarButton pb_CUSTOM_QUERY = null;
    private ToolBarButton pb_HISTORY = null;
    private ToolBarButton pb_PREVIEW = null;
    private ToolBarButton pb_COMPARE = null;
    private JToolBar toolBar = null;
    private DButton pb_EDIT = null;
    private DButton pb_CLOSE = null;
    private DButton pb_NEW = null;
    private DButton pb_DELETE = null;
    private DButton pb_COMPLETE = null;
    private DButton pb_CANCEL = null;
    private ToolBarButton pb_EXPORT = null;
    private JLabel st_FIRST_TEXT = new JLabel(Str.getStr(17058));
    private JSplitPane splitPane = new JSplitPane(0);
    private ProductEditPanel previewPanel = new ProductEditPanel();
    private boolean showingDrafts = false;
    private AppDefaultWin parentWin = null;
    private String currentView = null;
    private PMView currentPMView = null;
    private DefaultTreeModel treeModel = null;
    private DetailTreeCellRenderer treeRenderer = null;
    private JTitle st_TITLE = new JTitle();
    private JLabel st_KEY = null;
    private TypeCategoryRec currentBrandRec = null;
    private int sort = 0;
    private DetailJTree productTree = new DetailJTree();
    private ViewTreeNode currentViewNode = null;
    private JPanel contentPane = new JPanel();
    private CustomView currentCustomView = null;
    private AppDefaultWin defaultWin = GUISystem.getParentDefWin(this);

    public boolean initialize() {
        boolean bl = false;
        try {
            this.navPanel = new ProductNavPanel(this);
            this.pb_EDIT = new ActionButton(Str.getStr(50), ImageSystem.getImageIcon((Object)this, 56), Str.getStr(50));
            this.pb_NEW = new ActionButton(Str.getStr(171), ImageSystem.getImageIcon((Object)this, 59), Str.getStr(171));
            this.pb_DELETE = new ActionButton(Str.getStr(172), ImageSystem.getImageIcon((Object)this, 58), Str.getStr(172));
            this.pb_COMPLETE = new ActionButton(Str.getStr(375), ImageSystem.getImageIcon((Object)this, 57), Str.getStr(17117));
            this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(203));
            this.toolBar = new JToolBar();
            this.pb_FIND = new ToolBarButton(Str.getStr(470), ImageSystem.getImageIcon((Object)this, 7), Str.getStr(17047));
            this.pb_EXPORT = new ToolBarButton(Str.getStr(1193), ImageSystem.getImageIcon((Object)this, 171), Str.getStr(1193));
            this.pb_WIZARD = new ToolBarButton(Str.getStr(689), ImageSystem.getImageIcon((Object)this, 105), Str.getStr(17048));
            this.pb_CUSTOM_QUERY = new ToolBarButton(Str.getStr(669), ImageSystem.getImageIcon((Object)this, 101), Str.getStr(668));
            this.pb_COMPARE = new ToolBarButton(Str.getStr(17031), ImageSystem.getImageIcon((Object)this, 239), Str.getStr(17031));
            this.pb_HISTORY = new ToolBarButton(Str.getStr(1206), ImageSystem.getImageIcon((Object)this, 125), Str.getStr(1206));
            this.pb_PROPERTY = new ToolBarButton(Str.getStr(1320), ImageSystem.getImageIcon((Object)this, 166), Str.getStr(1513));
            this.pb_PREVIEW = PropertySystem.getBool(205) ? new ToolBarButton(Str.getStr(961), ImageSystem.getImageIcon((Object)this, 148), Str.getStr(75)) : new ToolBarButton(Str.getStr(959), ImageSystem.getImageIcon((Object)this, 148), Str.getStr(75));
            this.toolBar.add(new ToolBarSeparator());
            this.toolBar.add(this.pb_FIND);
            this.toolBar.add(this.pb_PREVIEW);
            this.toolBar.add(this.pb_HISTORY);
            this.toolBar.add(this.pb_EXPORT);
            this.toolBar.add(this.pb_COMPARE);
            this.toolBar.add(this.pb_WIZARD);
            this.toolBar.add(this.pb_CUSTOM_QUERY);
            this.toolBar.add(new ToolBarSeparator());
            this.toolBar.add(this.pb_PROPERTY);
            if (UserSystem.hasAuthority(40)) {
                this.pb_UNLOCK = new ToolBarButton(Str.getStr(394), ImageSystem.getImageIcon((Object)this, 228), Str.getStr(394) + " " + Str.getStr(299));
                this.pb_UNLOCK.addActionListener(this);
                this.toolBar.add(this.pb_UNLOCK);
            }
            this.showMenu.add(this.ck_SHOW_PARTNUM);
            this.showMenu.add(this.ck_SHOW_DESCRIPTION);
            this.showMenu.add(this.ck_SHOW_ANNOUNCE);
            this.showMenu.add(this.ck_SHOW_CREATEDATE);
            this.showMenu.add(this.ck_SHOW_LASTTOUCHEDBY);
            this.showMenu.add(this.ck_SHOW_LASTTOUCHEDON);
            this.toolBar.setOpaque(false);
            this.toolBar.setBorder(GUISystem.emptyBorder);
            this.st_FIRST_TEXT.setBackground(Color.white);
            this.st_FIRST_TEXT.setHorizontalAlignment(0);
            this.st_FIRST_TEXT.setVerticalAlignment(1);
            this.contentPane.setBackground(Color.white);
            this.previewPanel.setEditable(false);
            this.ck_SHOW_PARTNUM.setSelected(PropertySystem.getBool(207));
            this.ck_SHOW_DESCRIPTION.setSelected(PropertySystem.getBool(208));
            this.ck_SHOW_ANNOUNCE.setSelected(PropertySystem.getBool(209));
            this.ck_SHOW_CREATEDATE.setSelected(PropertySystem.getBool(210));
            this.ck_SHOW_LASTTOUCHEDBY.setSelected(PropertySystem.getBool(211));
            this.ck_SHOW_LASTTOUCHEDON.setSelected(PropertySystem.getBool(212));
            this.ck_SHOW_PARTNUM.addActionListener(this);
            this.ck_SHOW_DESCRIPTION.addActionListener(this);
            this.ck_SHOW_ANNOUNCE.addActionListener(this);
            this.ck_SHOW_CREATEDATE.addActionListener(this);
            this.ck_SHOW_LASTTOUCHEDBY.addActionListener(this);
            this.ck_SHOW_LASTTOUCHEDON.addActionListener(this);
            this.pb_CLOSE.addActionListener(this);
            this.pb_EDIT.addActionListener(this);
            this.pb_NEW.addActionListener(this);
            this.pb_DELETE.addActionListener(this);
            this.pb_COMPLETE.addActionListener(this);
            this.pb_EXPORT.addActionListener(this);
            this.productTree.getJTree().addTreeExpansionListener(this);
            this.productTree.getJTree().addTreeSelectionListener(this);
            this.pb_FIND.addActionListener(this);
            this.pb_WIZARD.addActionListener(this);
            this.pb_CUSTOM_QUERY.addActionListener(this);
            this.pb_COMPARE.addActionListener(this);
            this.pb_HISTORY.addActionListener(this);
            this.pb_PREVIEW.addActionListener(this);
            this.pb_PROPERTY.addActionListener(this);
            this.treeRenderer = new DetailTreeCellRenderer(GUISystem.getFontUtil(), 7);
            this.productTree.getJTree().setCellRenderer(this.treeRenderer);
            this.productTree.getJTree().setModel(new DefaultTreeModel(new StringTreeNode(Str.getStr(350))));
            this.productTree.setBorder(null);
            this.treeRenderer.setWordWrap(PropertySystem.getBool(206));
            this.productTree.setWordWrap(PropertySystem.getBool(206));
            this.treeRenderer.setPreferredWidth(800);
            this.productTree.addActionListener(this);
            this.productTree.getJTree().setRowHeight(0);
            this.setLayout(new BorderLayout());
            this.splitPane.setBottomComponent(this.previewPanel);
            this.contentPane.setLayout(new BorderLayout());
            this.contentPane.add((Component)this.st_TITLE, "North");
            this.contentPane.add((Component)this.st_FIRST_TEXT, "Center");
            if (PropertySystem.getBool(205)) {
                this.splitPane.setTopComponent(this.contentPane);
                this.add((Component)this.splitPane, "Center");
            } else {
                this.add((Component)this.contentPane, "Center");
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            return false;
        }
        bl = true;
        return bl;
    }

    public void start() {
        this.parentWin = GUISystem.getParentDefWin(this);
        this.parentWin.addActionComponent(this, this.pb_CLOSE);
        this.parentWin.addActionComponent(this, this.pb_NEW);
        this.parentWin.addActionComponent(this, this.pb_EDIT);
        this.parentWin.addActionComponent(this, this.pb_DELETE);
        this.parentWin.addActionComponent(this, this.pb_COMPLETE);
        this.pb_EDIT.setVisible(false);
        this.pb_DELETE.setVisible(false);
        this.pb_COMPLETE.setVisible(false);
        this.panelSelected();
        if (PropertySystem.getBool(205)) {
            this.splitPane.setDividerLocation(this.getSize().height - 200);
        }
    }

    public void panelSelected() {
        this.parentWin.getAppDefaultMenuBar().add(this.showMenu);
        this.showToolbar();
    }

    public void panelDeselected() {
        this.parentWin.getAppDefaultMenuBar().remove(this.showMenu);
        this.parentWin.removeToolbarButton(this.toolBar);
    }

    private void showToolbar() {
        this.parentWin.addToolbarButton(this.toolBar, 2);
    }

    public String getName() {
        return Str.getStr(17029);
    }

    public boolean copyText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public JComponent getJComponent() {
        return this;
    }

    public boolean shutdown() {
        return true;
    }

    public boolean stop() {
        if (this.currentPMView != null) {
            PropertySystem.putDetailList(203, this.productTree);
        }
        this.panelDeselected();
        return true;
    }

    public NavPanel getDefaultNavPanel() {
        return this.navPanel;
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 45);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Vector vector = this.getSelection();
        boolean bl = this.isBrandView();
        this.showingDrafts = this.refreshShowingDrafts(vector);
        if (Qit.getEnabled()) {
            if (actionEvent.getSource() == this.pb_CLOSE) {
                this.parentWin.closePanel(this, null);
            } else if (actionEvent.getSource() == this.pb_FIND) {
                if (vector != null && vector.size() > 0) {
                    new ProductSearchDlg(this.getSelection());
                    ProductSearchDlg.getInstance().addFindProductListener(this);
                } else {
                    new ProductSearchDlg();
                    ProductSearchDlg.getInstance().addFindProductListener(this);
                }
            } else if (actionEvent.getSource() == this.pb_PROPERTY) {
                new PropertyDlg(this.parentWin);
            } else if (actionEvent.getSource() == this.pb_CUSTOM_QUERY) {
                new CustomViewDlg((Frame)this.parentWin, this).getResult();
            } else if (actionEvent.getSource() == this.pb_UNLOCK) {
                new Thread((Runnable)this, THREAD_UNLOCK_PRODUCTS).start();
            } else if (actionEvent.getSource() == this.pb_WIZARD) {
                this.fieldChanger();
            } else if (actionEvent.getSource() == this.pb_HISTORY) {
                ProductRow productRow;
                if (this.getSelection() != null && this.getSelection().size() > 0 && (productRow = (ProductRow)this.getSelection().elementAt(0)) != null) {
                    WindowSystem.createPanel(new ProductHistoryPanel(productRow.getProductInd(), productRow.isDraft(), this));
                }
            } else if (actionEvent.getSource() == this.pb_PREVIEW) {
                this.togglePreview();
            } else if (actionEvent.getSource() == this.pb_COMPARE) {
                Product product = null;
                Product product2 = null;
                Vector vector2 = this.getSelection();
                int n = 0;
                if (vector2 != null) {
                    n = vector2.size();
                    if (n > 2) {
                        n = 2;
                    }
                    int n2 = 0;
                    while (n2 < n) {
                        ProductRow productRow = (ProductRow)vector2.elementAt(n2);
                        int n3 = productRow.readProduct(true);
                        if (n3 == 0) {
                            Product product3;
                            if (productRow.isDraft()) {
                                product3 = (ProductDraft)productRow.getProduct();
                                if (n2 == 0) {
                                    product = product3;
                                } else {
                                    product2 = product3;
                                }
                            } else {
                                product3 = productRow.getProduct();
                                if (n2 == 0) {
                                    product = product3;
                                } else {
                                    product2 = product3;
                                }
                            }
                        }
                        ++n2;
                    }
                    if (product != null && product2 != null) {
                        WindowSystem.createPanel(new ProductComparePanel(product, product2, this));
                    } else if (product != null && product2 == null) {
                        WindowSystem.createPanel(new ProductComparePanel(product, this));
                    } else {
                        WindowSystem.createPanel(new ProductComparePanel(this));
                    }
                } else {
                    GUISystem.printBox("Info", "You must select at least 1 product before attempting to compare. If you select <b>2</b>products, then you will be comparing those 2 products");
                }
            } else if (actionEvent.getSource() == this.pb_NEW) {
                this.performNew();
            } else if (actionEvent.getSource() == this.pb_EDIT || actionEvent.getSource() == this.productTree) {
                if (this.pb_EDIT.isVisible()) {
                    this.edit();
                }
            } else if (actionEvent.getSource() == this.pb_EXPORT) {
                if (PMViews.getViewName(this.currentView).equals(Str.getStr(17090))) {
                    GUISystem.printBox("Info", "Exporting of Brand/Family/Series Mapping is not supported");
                } else if (PMViews.getViewName(this.currentView).equals(Str.getStr(17091))) {
                    GUISystem.printBox("Info", "Exporting of Geography/Country Mapping is not supported");
                } else {
                    Vector vector3 = this.getSelection();
                    Vector vector4 = this.getAllViewableProducts();
                    if (!(vector3 != null && vector3.size() != 0 || vector4 != null && vector4.size() != 0 || this.currentPMView != null)) {
                        GUISystem.printBox("Info", "You must have one of the following to export:<br><br>1. A view selected<br>2. At least 1 product selected<br>3. At least 1 product viewable");
                    } else if (this.currentPMView.getFullSQL() != null) {
                        new ExportWizard(vector3, vector4, this.currentPMView).getResult();
                    } else {
                        GUISystem.printBox("Info", "Exporting is not supported under the current view");
                    }
                }
            } else if (actionEvent.getSource() == this.pb_COMPLETE) {
                this.completeProducts();
            } else if (actionEvent.getSource() == this.pb_DELETE) {
                this.deleteProducts();
            } else if (actionEvent.getSource() == this.ck_SHOW_PARTNUM && bl) {
                if (!this.ck_SHOW_PARTNUM.isSelected()) {
                    this.productTree.setColumnWidth(1, 0);
                } else {
                    this.productTree.setColumnWidth(1, 90);
                }
                PropertySystem.putBool(207, this.ck_SHOW_PARTNUM.isSelected());
            } else if (actionEvent.getSource() == this.ck_SHOW_DESCRIPTION && bl) {
                if (!this.ck_SHOW_DESCRIPTION.isSelected()) {
                    this.productTree.setColumnWidth(2, 0);
                } else {
                    this.productTree.setColumnWidth(2, 250);
                }
                PropertySystem.putBool(208, this.ck_SHOW_DESCRIPTION.isSelected());
            } else if (actionEvent.getSource() == this.ck_SHOW_ANNOUNCE && bl) {
                if (!this.ck_SHOW_ANNOUNCE.isSelected()) {
                    this.productTree.setColumnWidth(3, 0);
                } else {
                    this.productTree.setColumnWidth(3, 125);
                }
                PropertySystem.putBool(209, this.ck_SHOW_ANNOUNCE.isSelected());
            } else if (actionEvent.getSource() == this.ck_SHOW_CREATEDATE && bl) {
                if (!this.ck_SHOW_CREATEDATE.isSelected()) {
                    this.productTree.setColumnWidth(4, 0);
                } else {
                    this.productTree.setColumnWidth(4, 160);
                }
                PropertySystem.putBool(210, this.ck_SHOW_CREATEDATE.isSelected());
            } else if (actionEvent.getSource() == this.ck_SHOW_LASTTOUCHEDBY && bl) {
                if (!this.ck_SHOW_LASTTOUCHEDBY.isSelected()) {
                    this.productTree.setColumnWidth(5, 0);
                } else {
                    this.productTree.setColumnWidth(5, 120);
                }
                PropertySystem.putBool(211, this.ck_SHOW_LASTTOUCHEDBY.isSelected());
            } else if (actionEvent.getSource() == this.ck_SHOW_LASTTOUCHEDON && bl) {
                if (!this.ck_SHOW_LASTTOUCHEDON.isSelected()) {
                    this.productTree.setColumnWidth(6, 0);
                } else {
                    this.productTree.setColumnWidth(6, 160);
                }
                PropertySystem.putBool(212, this.ck_SHOW_LASTTOUCHEDON.isSelected());
            }
        }
    }

    public void findProductComplete(Vector vector) {
        Vector vector2 = new Vector(10);
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            vector2 = new Vector(10, 10);
            while (n < n2) {
                if (vector.elementAt(n) instanceof ProductRow) {
                    vector2.addElement(vector.elementAt(n));
                }
                ++n;
            }
            this.setProductList(Str.getStr(927), vector2);
        }
    }

    public void setProductList(String string, Vector vector) {
        StringTreeNode stringTreeNode = new StringTreeNode(string);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(stringTreeNode);
        Object[] objectArray = new String[]{"", Str.getStr(17122), Str.getStr(100), Str.getStr(17051), Str.getStr(1065), Str.getStr(266), Str.getStr(267)};
        this.refreshView();
        this.productTree.setColumnHeadings(objectArray);
        this.productTree.setColumnWidth(0, 15);
        this.productTree.setColumnWidth(1, PropertySystem.getBool(207) ? 90 : 0);
        this.productTree.setColumnWidth(2, PropertySystem.getBool(208) ? 250 : 0);
        this.productTree.setColumnWidth(3, PropertySystem.getBool(209) ? 125 : 0);
        this.productTree.setColumnWidth(4, PropertySystem.getBool(210) ? 120 : 0);
        this.productTree.setColumnWidth(5, PropertySystem.getBool(212) ? 120 : 0);
        this.productTree.setColumnWidth(6, PropertySystem.getBool(211) ? 140 : 0);
        this.st_TITLE.setText("");
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                stringTreeNode.add(new MutableTreeWrapper(vector.elementAt(n)));
                ++n;
            }
        }
        this.productTree.setTitlePadding(10);
        this.productTree.getJTree().setModel(defaultTreeModel);
        this.st_TITLE.setText(string);
    }

    public CustomView getNewCustomView() {
        ProductCustomView productCustomView = new ProductCustomView();
        productCustomView.updateRecStatus(2);
        return productCustomView;
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_REFRESH_VIEW)) {
            this.parentWin.setStatus(14);
            this.refreshView();
            this.parentWin.setStatus(null);
        } else if (string.equals(THREAD_REFRESHVIEW_NODE)) {
            this.refreshViewNode();
        } else if (string.equals(THREAD_UNLOCK_PRODUCTS)) {
            this.parentWin.setStatus(Str.getStr(1601));
            this.unlockProducts();
            this.parentWin.setStatus(null);
        } else if (string.equals(THREAD_REFRESH_PREVIEW)) {
            this.refreshPreview();
        } else if (string.equals(THREAD_COMPLETEREQUESTS)) {
            this.completeProductsThread();
        }
    }

    private void refreshViewNode() {
        this.parentWin.setStatus(14);
        if (this.currentViewNode != null) {
            this.currentPMView.refreshViewTree(this.treeModel, this.currentViewNode);
            this.productTree.reset();
        }
        this.parentWin.setStatus(null);
    }

    private void refreshView() {
        PMViewModel pMViewModel = PMViews.getViewModel(this.currentView, this.currentBrandRec);
        this.showTree();
        if (pMViewModel != null) {
            this.treeModel = pMViewModel.treeModel;
            this.currentPMView = pMViewModel.pmView;
        } else {
            this.currentPMView = null;
            this.treeModel = null;
        }
        this.setProductTreeProperties();
        this.setActionButtons();
        if (this.treeModel != null) {
            this.productTree.getJTree().setModel(this.treeModel);
            if (this.currentBrandRec != null) {
                this.st_TITLE.setText(this.currentBrandRec.getDescript() + " - " + PMViews.getViewName(this.currentView));
            } else {
                this.st_TITLE.setText(PMViews.getViewName(this.currentView));
            }
        }
    }

    protected void setBrand(TypeCategoryRec typeCategoryRec) {
        if (this.currentBrandRec != typeCategoryRec) {
            this.currentBrandRec = typeCategoryRec;
            this.currentView = null;
            this.productTree.getJTree().setModel(this.createEmptyModel());
            if (this.currentBrandRec != null) {
                this.st_TITLE.setText(this.currentBrandRec.toString());
            }
        }
    }

    protected void setView(String string) {
        this.currentView = string;
        new Thread((Runnable)this, THREAD_REFRESH_VIEW).start();
    }

    public void setSort(int n) {
        this.sort = n;
        this.refreshViewWithSort();
    }

    private void refreshViewWithSort() {
        int n = this.productTree.getJTree().getRowCount();
        int n2 = 1;
        this.parentWin.setStatus(1349);
        this.parentWin.setValueMax(n);
        while (n2 < n) {
            if (this.productTree.getJTree().isExpanded(n2)) {
                try {
                    TreePath treePath = this.productTree.getJTree().getPathForRow(n2);
                    TreePath treePath2 = this.productTree.getJTree().getPathForRow(n2 + 1);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    if (treePath2.getLastPathComponent() instanceof MutableTreeNode) {
                        int n3 = defaultMutableTreeNode.getChildCount();
                        Vector<Object> vector = new Vector<Object>(n3);
                        int n4 = 0;
                        while (n4 < n3) {
                            vector.addElement(((MutableTreeWrapper)defaultMutableTreeNode.getChildAt(n4)).getDataObject());
                            ++n4;
                        }
                        new RefreshTreeViewThread().populateTree(this.treeModel, defaultMutableTreeNode, vector);
                    }
                }
                catch (Exception exception) {
                    LogSystem.log(1, exception, false);
                }
            }
            this.parentWin.setValue(++n2);
        }
        this.parentWin.setValue(0);
        this.parentWin.setStatus(null);
    }

    public void refresh() {
        new Thread((Runnable)this, THREAD_REFRESH_VIEW).start();
    }

    protected void closeTree(TreePath treePath) {
        this.productTree.getJTree().collapsePath(treePath);
    }

    public static void createNewProduct(AppDefaultWin appDefaultWin, ProductManagementPanel productManagementPanel) {
        NewProductDlg newProductDlg = new NewProductDlg(appDefaultWin);
        ProductDraft productDraft = null;
        int n = newProductDlg.getResult();
        switch (n) {
            case 2: {
                productDraft = new ProductDraft(newProductDlg.getTemplate());
                productDraft.setWorkRequired(1);
                break;
            }
            case 1: {
                productDraft = new ProductDraft();
                productDraft.setProductType(newProductDlg.getTypeProductRec().getInd());
                break;
            }
            case 3: {
                String[] stringArray = new String[3];
                if (newProductDlg.getImportFilename() == null) break;
                stringArray[0] = "/FILE:" + newProductDlg.getImportFilename();
                stringArray[1] = newProductDlg.getImportType() == 2 ? "/INSERT" : (newProductDlg.getImportType() == 3 ? "/UPDATE" : "/INSERTUPDATE");
                stringArray[2] = newProductDlg.getImportProductType() == 3 ? "/MONITORS" : (newProductDlg.getImportProductType() == 2 ? "/OPTIONS" : "/SYSTEMS");
                ProductImport productImport = new ProductImport(stringArray);
                BatchRunnerPanel batchRunnerPanel = new BatchRunnerPanel(productImport);
                batchRunnerPanel.showCommitBtn(true);
                batchRunnerPanel.showRerunBtn(true);
                productImport.setButtons(batchRunnerPanel.getCommitButton(), batchRunnerPanel.getRerunButton());
                WindowSystem.createPanel(batchRunnerPanel);
                break;
            }
        }
        if (productDraft != null) {
            EditProduct.editProduct(productDraft);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Object object = treeExpansionEvent.getPath().getLastPathComponent();
        if (object != null && object instanceof ViewTreeNode) {
            this.currentViewNode = (ViewTreeNode)object;
            new Thread((Runnable)this, THREAD_REFRESHVIEW_NODE).start();
        }
    }

    private void editCurrentProduct() {
        TreePath treePath = this.productTree.getJTree().getSelectionPath();
        if (treePath != null) {
            MutableTreeWrapper mutableTreeWrapper = (MutableTreeWrapper)treePath.getLastPathComponent();
            try {
                ProductRow productRow = (ProductRow)mutableTreeWrapper.getDataObject();
                this.parentWin.setStatus("Reading " + productRow.getDescription());
                if (productRow != null) {
                    EditProduct.editProduct(productRow);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.parentWin.setStatus(null);
    }

    public boolean bookmark() {
        if (!this.showingDrafts) {
            Vector vector = this.getSelection();
            if (vector != null && vector.size() > 0) {
                int n = 0;
                int n2 = vector.size();
                Vector<Bookmark> vector2 = new Vector<Bookmark>(n2);
                while (n < n2) {
                    Bookmark bookmark = new Bookmark();
                    bookmark.setDescript(((ProductRow)vector.elementAt(n)).getDescription());
                    bookmark.setObject(new Integer(((ProductRow)vector.elementAt(n)).getProductInd()), 2);
                    bookmark.updateRecStatus(2);
                    vector2.addElement(bookmark);
                    ++n;
                }
                BookmarkSystem.guiAddBookmarks(vector2);
            } else {
                GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(7), Str.getStr(1028));
            }
        } else {
            GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(7), Str.getStr(1029));
        }
        return true;
    }

    private Vector getSelection() {
        Vector<Object> vector = null;
        int[] nArray = this.productTree.getJTree().getSelectionRows();
        if (nArray != null && nArray.length > 0) {
            vector = new Vector<Object>(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                try {
                    Object object = ((MutableTreeWrapper)this.productTree.getJTree().getPathForRow(nArray[n]).getLastPathComponent()).getDataObject();
                    if (object instanceof ProductRow) {
                        vector.addElement(object);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                ++n;
            }
        }
        return vector;
    }

    private Vector getAllViewableProducts() {
        Vector<Object> vector = null;
        int n = this.productTree.getJTree().getRowCount();
        if (n > 0) {
            vector = new Vector<Object>(n);
            int n2 = 0;
            while (n2 < n) {
                try {
                    Object object = ((MutableTreeWrapper)this.productTree.getJTree().getPathForRow(n2).getLastPathComponent()).getDataObject();
                    if (object instanceof ProductRow) {
                        vector.addElement(object);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return vector;
    }

    private DefaultTreeModel createEmptyModel() {
        StringTreeNode stringTreeNode = new StringTreeNode(Str.getStr(350));
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(stringTreeNode);
        return defaultTreeModel;
    }

    private void setProductTreeProperties() {
        if (this.currentView != null) {
            if (PMViews.getViewName(this.currentView).equals(Str.getStr(17090))) {
                Object[] objectArray = new String[]{"OBrand", "OFamily", "OSeries", Str.getStr(145), Str.getStr(149)};
                this.productTree.setColumnHeadings(objectArray);
                this.productTree.setColumnWidth(0, 150);
                this.productTree.setColumnWidth(1, 150);
                this.productTree.setColumnWidth(2, 150);
                this.productTree.setColumnWidth(3, 150);
                this.productTree.setColumnWidth(4, 150);
                this.productTree.setTitlePadding(20);
            } else if (PMViews.getViewName(this.currentView).equals(Str.getStr(17091))) {
                Object[] objectArray = new String[]{"OGeography", "OCountry", Str.getStr(94)};
                this.productTree.setColumnHeadings(objectArray);
                this.productTree.setColumnWidth(0, 150);
                this.productTree.setColumnWidth(1, 150);
                this.productTree.setColumnWidth(2, 150);
                this.productTree.setTitlePadding(20);
            } else {
                if (Brands.isBrandOption(this.currentBrandRec)) {
                    Object[] objectArray = new String[]{"", Str.getStr(293), Str.getStr(100), Str.getStr(17051), Str.getStr(1065), Str.getStr(266), Str.getStr(267)};
                    this.productTree.setColumnHeadings(objectArray);
                    this.productTree.setTitlePadding(this.currentPMView.getTitlePadding());
                } else {
                    Object[] objectArray = new String[]{"", Str.getStr(334), Str.getStr(100), Str.getStr(17051), Str.getStr(1065), Str.getStr(266), Str.getStr(267)};
                    this.productTree.setColumnHeadings(objectArray);
                    this.productTree.setTitlePadding(this.currentPMView.getTitlePadding());
                    this.productTree.setColumnWidth(0, 15);
                    this.productTree.setColumnWidth(1, PropertySystem.getBool(207) ? 90 : 0);
                    this.productTree.setColumnWidth(2, PropertySystem.getBool(208) ? 250 : 0);
                    this.productTree.setColumnWidth(3, PropertySystem.getBool(209) ? 125 : 0);
                    this.productTree.setColumnWidth(4, PropertySystem.getBool(210) ? 120 : 0);
                    this.productTree.setColumnWidth(5, PropertySystem.getBool(212) ? 120 : 0);
                    this.productTree.setColumnWidth(6, 160);
                }
                PropertySystem.putDetailList(203, this.productTree);
            }
        }
    }

    private void setActionButtons() {
        if (PMViews.getViewName(this.currentView).equals(Str.getStr(17090)) || PMViews.getViewName(this.currentView).equals(Str.getStr(17091))) {
            this.pb_COMPLETE.setVisible(false);
            this.pb_NEW.setVisible(true);
            this.pb_EDIT.setVisible(true);
            this.pb_DELETE.setVisible(false);
        } else if (PMViews.getViewName(this.currentView).indexOf(Str.getStr(17055)) != -1) {
            this.pb_COMPLETE.setVisible(false);
            this.pb_NEW.setVisible(true);
            this.pb_EDIT.setVisible(false);
        } else if (PMViews.getViewName(this.currentView).indexOf(Str.getStr(1066)) != -1) {
            this.pb_COMPLETE.setVisible(true);
            this.pb_NEW.setVisible(true);
            this.pb_EDIT.setVisible(true);
            this.pb_DELETE.setVisible(true);
        } else {
            this.pb_COMPLETE.setVisible(false);
            this.pb_NEW.setVisible(true);
            this.pb_EDIT.setVisible(true);
            this.pb_DELETE.setVisible(true);
        }
    }

    protected void setCustomView(String string) {
        Vector vector = new Vector(1);
        CustomView customView = CustomViewSystem.getView(string);
        if (customView != null) {
            vector = customView.getResults();
        }
        this.setProductList(Str.getStr(927), vector);
    }

    private void fieldChanger() {
        Vector<ProductDraft> vector = new Vector<ProductDraft>();
        Vector vector2 = new Vector();
        ProductDraft productDraft = null;
        StatusWin statusWin = new StatusWin(GUISystem.getParentDefWin(this));
        if (UserSystem.hasAuthority(5)) {
            try {
                if (this.haveSelection()) {
                    vector2 = this.getSelection();
                }
                statusWin.setVisible(true);
                if (vector2 != null && vector2.size() > 0) {
                    statusWin.setMaxValue(vector2.size());
                    int n = 0;
                    while (n < vector2.size()) {
                        if (vector2.elementAt(n) instanceof ProductRow) {
                            ProductRow productRow = (ProductRow)vector2.elementAt(n);
                            if (productRow.isDraft()) {
                                int n2 = 0;
                                statusWin.setText(Str.getStr(142) + " " + productRow.getDescription());
                                n2 = productRow.readProduct(true);
                                if (n2 == 0) {
                                    productDraft = (ProductDraft)productRow.getProduct();
                                    vector.addElement(productDraft);
                                } else {
                                    LogSystem.log(1, "Problem while reading productDraft" + productDraft.getDescription());
                                }
                            } else {
                                statusWin.setText(Str.getStr(142) + " " + productRow.getDescription());
                                CreateProductDraft createProductDraft = ProductDraft.createProductDraft(productRow.getProductInd());
                                if (createProductDraft != null) {
                                    ProductDraft productDraft2 = createProductDraft.getProductDraft();
                                    int n3 = 0;
                                    statusWin.setText(Str.getStr(342) + " " + productRow.getDescription());
                                    n3 = productDraft2.writeToDatabase();
                                    if (n3 == 0) {
                                        vector.addElement(productDraft2);
                                    } else {
                                        LogSystem.log(1, "Problem while writing productDraft" + productDraft.getProductInd());
                                    }
                                }
                            }
                        }
                        statusWin.setValue(n);
                        ++n;
                    }
                } else {
                    GUISystem.printBox(7, 358);
                }
                statusWin.dispose();
                if (vector != null && vector.size() > 0) {
                    FieldChangerWizard fieldChangerWizard = new FieldChangerWizard((Frame)GUISystem.getParentDefWin(this), vector);
                    fieldChangerWizard.getResult();
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                GUISystem.printBox(7, 202);
            }
            statusWin.dispose();
        } else {
            GUISystem.printBox(7, 701);
        }
    }

    public Object getPrintObject() {
        return new Print(this.productTree.getJTree(), this.parentWin, Str.getStr(299));
    }

    private boolean haveSelection() {
        return this.getSelection() != null && this.getSelection().size() > 0;
    }

    private void unlockProducts() {
        if (this.haveSelection()) {
            String string = this.showingDrafts ? "PRODRAFT" : "PRODUCT";
            Vector vector = this.getSelection();
            Object var3_3 = null;
            int n = 0;
            String string2 = "UPDATE " + string + ".PRODUCT SET CHECKEDOUTBY=NULL WHERE PRODUCTIND IN (";
            int n2 = 0;
            while (n2 < vector.size()) {
                n = this.showingDrafts ? ((ProductRow)vector.elementAt(n2)).getProductInd() : ((ProductRow)vector.elementAt(n2)).getExistingProductInd();
                string2 = string2 + n;
                if (n2 < vector.size() - 1) {
                    string2 = string2 + ",";
                }
                ++n2;
            }
            if (SqlRunner.runSingleSQL(1, string2 = string2 + ")") == 0) {
                GUISystem.printBox(Str.getStr(7), "Products Unlocked");
            } else {
                GUISystem.printBox(7, 202);
            }
        } else {
            GUISystem.printBox(7, 358);
        }
    }

    private void showTree() {
        if (this.st_FIRST_TEXT != null) {
            this.contentPane.remove(this.st_FIRST_TEXT);
            this.st_FIRST_TEXT = null;
            this.contentPane.add((Component)new JScrollPane(this.productTree), "Center");
            this.revalidate();
        }
    }

    private void togglePreview() {
        boolean bl = PropertySystem.getBool(205);
        if (bl) {
            this.pb_PREVIEW.setText(Str.getStr(959));
            this.remove(this.splitPane);
            this.splitPane.remove(this.contentPane);
            this.add((Component)this.contentPane, "Center");
            this.revalidate();
        } else {
            this.pb_PREVIEW.setText(Str.getStr(961));
            this.remove(this.contentPane);
            this.splitPane.setTopComponent(this.contentPane);
            this.add((Component)this.splitPane, "Center");
            this.splitPane.setDividerLocation(this.getSize().height - 200);
            this.revalidate();
            if (this.haveSelection()) {
                new Thread((Runnable)this, THREAD_REFRESH_PREVIEW).start();
            }
        }
        PropertySystem.putBool(205, !bl);
    }

    private void refreshPreview() {
        TreePath treePath = this.productTree.getJTree().getSelectionPath();
        this.pb_EDIT.setEnabled(false);
        this.pb_HISTORY.setEnabled(false);
        this.pb_COMPARE.setEnabled(false);
        this.pb_DELETE.setEnabled(false);
        if (treePath != null) {
            MutableTreeWrapper mutableTreeWrapper = (MutableTreeWrapper)treePath.getLastPathComponent();
            try {
                ProductRow productRow = (ProductRow)mutableTreeWrapper.getDataObject();
                if (productRow.readProduct(false) == 0) {
                    this.previewPanel.setProduct(productRow.getProduct());
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
            }
        }
        this.pb_EDIT.setEnabled(true);
        this.pb_HISTORY.setEnabled(true);
        this.pb_COMPARE.setEnabled(true);
        this.pb_DELETE.setEnabled(true);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (PropertySystem.getBool(205)) {
            new Thread((Runnable)this, THREAD_REFRESH_PREVIEW).start();
        }
    }

    private void edit() {
        if (this.productTree.getJTree().getSelectionPath() != null) {
            if (PMViews.getViewName(this.currentView).equals(Str.getStr(17090))) {
                TreePath treePath = this.productTree.getJTree().getSelectionPath();
                if (treePath != null) {
                    MutableTreeWrapper mutableTreeWrapper = (MutableTreeWrapper)treePath.getLastPathComponent();
                    BrandMappingRow brandMappingRow = (BrandMappingRow)mutableTreeWrapper.getDataObject();
                    new BrandMapDlg((Frame)this.parentWin, brandMappingRow);
                    this.productTree.invalidate();
                    this.revalidate();
                }
            } else if (PMViews.getViewName(this.currentView).equals(Str.getStr(17091))) {
                TreePath treePath = this.productTree.getJTree().getSelectionPath();
                if (treePath != null) {
                    MutableTreeWrapper mutableTreeWrapper = (MutableTreeWrapper)treePath.getLastPathComponent();
                    CountryMappingRow countryMappingRow = (CountryMappingRow)mutableTreeWrapper.getDataObject();
                    new CountryMapDlg((Frame)this.parentWin, countryMappingRow);
                    this.productTree.invalidate();
                    this.revalidate();
                }
            } else {
                this.editCurrentProduct();
            }
        } else {
            GUISystem.printBox(Str.getStr(7), Str.getStr(358));
        }
    }

    private boolean isBrandView() {
        if (this.currentView != null) {
            return !PMViews.getViewName(this.currentView).equals(Str.getStr(17091)) && !PMViews.getViewName(this.currentView).equals(Str.getStr(17090));
        }
        return false;
    }

    private void performNew() {
        if (PMViews.getViewName(this.currentView).equals(Str.getStr(17090))) {
            BrandMappingRow brandMappingRow = new BrandMappingRow();
            new BrandMapDlg((Frame)this.parentWin, brandMappingRow);
            this.productTree.invalidate();
            this.refresh();
        } else if (PMViews.getViewName(this.currentView).equals(Str.getStr(17091))) {
            CountryMappingRow countryMappingRow = new CountryMappingRow();
            new CountryMapDlg((Frame)this.parentWin, countryMappingRow);
            this.productTree.invalidate();
            this.refresh();
        } else {
            ProductManagementPanel.createNewProduct(GUISystem.getParentDefWin(this), this);
        }
    }

    private void delete() {
        StatusWin statusWin = new StatusWin(this.parentWin);
        this.parentWin.setStatus(Str.getStr(239));
        try {
            statusWin.setTitle(Str.getStr(14));
            statusWin.setVisible(true);
            if (this.haveSelection()) {
                boolean bl = UserSystem.hasAuthority(5);
                ProductRow productRow = null;
                int n = 0;
                Vector vector = this.getSelection();
                int n2 = vector.size();
                int n3 = 0;
                this.showingDrafts = this.refreshShowingDrafts(vector);
                statusWin.setMaxValue(n2);
                if (this.showingDrafts) {
                    StringBuffer stringBuffer = new StringBuffer("UPDATE PRODRAFT.PRODUCT SET RECYCLED = 'Y', LASTTOUCHEDBY = '" + UserSystem.getUserId() + "', LASTTOUCHEDON = CURRENT TIMESTAMP WHERE PRODUCTIND IN (");
                    if (bl) {
                        while (n < n2) {
                            stringBuffer.append(((ProductRow)vector.elementAt(n)).getProductInd());
                            if (n < n2 - 1) {
                                stringBuffer.append(",");
                            }
                            ++n;
                        }
                        stringBuffer.append(")");
                        n3 = SqlRunner.runSingleSQL(1, stringBuffer.toString());
                        if (n3 == 0) {
                            GUISystem.printBox(7, 375);
                        } else {
                            LogSystem.log(1, "Could not update products to recycled. rc=" + n3);
                            GUISystem.printBox(7, 202);
                        }
                    } else {
                        GUISystem.printBox("Info", "You do not have the proper authority to perform this action");
                    }
                } else {
                    int n4 = 0;
                    while (n < n2) {
                        productRow = (ProductRow)vector.elementAt(n);
                        statusWin.setText(Str.getStr(142) + " " + productRow.getDescription());
                        n3 = productRow.readProduct(true);
                        if (n3 == 0) {
                            ProductDraft productDraft = EditProduct.createDraft(productRow.getProduct());
                            if (productDraft != null) {
                                EditProduct.setDefaultValues(productDraft);
                                productDraft.setWorkRequired(3);
                                statusWin.setText(Str.getStr(342) + " " + productRow.getDescription());
                                if (!ProductSaver.saveDraft(productDraft, null)) {
                                    GUISystem.printBox(7, 202);
                                    n = n2 + 1;
                                } else {
                                    try {
                                        productDraft.checkOut(null);
                                        ++n4;
                                    }
                                    catch (Exception exception) {
                                        LogSystem.log(1, exception, false);
                                    }
                                }
                            }
                        } else {
                            GUISystem.printBox(7, 202);
                            LogSystem.log(1, "Could not read product. rc:" + n3);
                        }
                        ++n;
                    }
                    if (n4 > 0) {
                        if (n4 > 1) {
                            GUISystem.printBox("Info", "You have just created " + n4 + " drafts for deletion. To complete the deletion process please complete the drafts");
                        } else {
                            GUISystem.printBox("Info", "You have just created 1 drafts for deletion. To complete the deletion process please complete the drafts");
                        }
                    }
                }
            } else {
                GUISystem.printBox(6, 358);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        this.parentWin.setStatus(null);
        statusWin.dispose();
    }

    private void deleteProducts() {
        if (this.haveSelection()) {
            boolean bl = false;
            if (UserSystem.hasAuthority(5)) {
                bl = this.showingDrafts ? GUISystem.printBox(Str.getStr(366), "Are you sure you wish to move the product drafts to the recycle bin?") : GUISystem.printBox("Are You Sure?", "Are you sure you wish to create drafts for the deletetion of the selected products?");
            } else if (!this.showingDrafts) {
                bl = GUISystem.printBox("Are You Sure?", "Are you sure you wish to create drafts for the deletetion of the selected products?");
            } else {
                GUISystem.printBox(Str.getStr(7), "You don't have the authority to do that");
            }
            if (bl) {
                this.delete();
            }
        } else {
            GUISystem.printBox(Str.getStr(7), Str.getStr(358));
        }
    }

    private void completeProductsThread() {
        StatusWin statusWin = new StatusWin(this.parentWin);
        try {
            int n = 0;
            Vector vector = this.getSelection();
            int n2 = vector.size();
            boolean bl = true;
            ProductRow productRow = null;
            Vector<ProductRow> vector2 = new Vector<ProductRow>(1);
            String string = null;
            string = new SingleMLEDlg((Frame)this.parentWin, Str.getStr(17120), Str.getStr(17119), "", "").getResult();
            if (string != null && string.length() > 0) {
                statusWin.setTitle(Str.getStr(14));
                statusWin.setMaxValue(n2);
                while (n < n2 && bl) {
                    productRow = (ProductRow)vector.elementAt(n);
                    if (productRow != null && productRow.isDraft()) {
                        int n3 = -1;
                        statusWin.setText(Str.getStr(142) + " " + productRow.getDescription());
                        n3 = productRow.readProduct(false);
                        if (n3 == 0) {
                            ProductDraft productDraft = (ProductDraft)productRow.getProduct();
                            statusWin.setText(Str.getStr(1149) + " " + productRow.getDescription());
                            productDraft.setComment(string);
                            productDraft.updateRecStatus(1);
                            if (ProductSaveCheck.checkPublish(productDraft, statusWin, false)) {
                                if (!ProductSaver.publishDraft(productDraft, null)) {
                                    GUISystem.printBox("Error", "Could not republish " + productRow.getProductInd());
                                    bl = false;
                                }
                            } else {
                                vector2.addElement(productRow);
                            }
                        }
                    }
                    statusWin.setValue(++n);
                    System.gc();
                }
                this.refresh();
                if (vector2.size() > 0) {
                    if (vector2.size() == 1) {
                        if (GUISystem.printBox("Question", "The product did not publish because it is missing data. Would you like to edit that product?")) {
                            productRow = (ProductRow)vector2.elementAt(0);
                            this.parentWin.setStatus("Reading " + productRow.getDescription());
                            EditProduct.editProduct(productRow);
                        }
                    } else {
                        GUISystem.printBox("Info", "There were " + vector2.size() + " products which did not publish because they are missing data. Press 'Ok' to see the list of products");
                        new ProductDlg(GUISystem.getParentDefWin(this), vector2);
                    }
                }
            } else {
                GUISystem.printBox("Info", "You must enter a comment before completing the drafts");
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        statusWin.dispose();
    }

    private void completeProducts() {
        if (this.haveSelection()) {
            if (this.showingDrafts) {
                new Thread((Runnable)this, THREAD_COMPLETEREQUESTS).start();
            } else {
                GUISystem.printBox(Str.getStr(7), Str.getStr(369));
            }
        } else {
            GUISystem.printBox(Str.getStr(7), Str.getStr(358));
        }
    }

    private boolean refreshShowingDrafts(Vector vector) {
        this.showingDrafts = false;
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            n2 = vector.size();
            while (n < n2 && !this.showingDrafts) {
                if (vector.elementAt(n) instanceof ProductRow) {
                    this.showingDrafts = ((ProductRow)vector.elementAt(n)).isDraft();
                }
                ++n;
            }
        }
        return this.showingDrafts;
    }

    public String getHelpFilename() {
        return "Products/ProdMgmt.html";
    }
}

