/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.manager.views;

import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.manager.views.PMNavView;
import com.ibm.nzna.projects.qit.product.manager.views.PMView;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.MutableTreeWrapper;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.gui.ViewTreeNode;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ViewMisfitOpicmProject
implements PMView,
ProductConst,
PMNavView,
AppConst {
    private static final String LEVEL_FAMILY = "FAMILY";
    private static final String LEVEL_SERIES = "SERIES";
    private static final String LEVEL_PROJECT = "PROJECT";
    private static final String LEVEL_MACHINE = "MACHINE";
    private static final String LEVEL_MODEL = "MODEL";
    private DefaultMutableTreeNode root = null;
    private TypeCategoryRec brandRec = null;

    public String getName() {
        return Str.getStr(17055) + " " + Str.getStr(1319) + " " + Str.getStr(17019);
    }

    public String getShortName() {
        return "SHORT NAME!";
    }

    public void setBrand(TypeCategoryRec typeCategoryRec) {
        this.brandRec = typeCategoryRec;
    }

    public DefaultTreeModel getJTreeModel() {
        DefaultTreeModel defaultTreeModel = null;
        ViewTreeNode viewTreeNode = null;
        Vector vector = this.readDistinctFamilies();
        this.root = new DefaultMutableTreeNode("");
        defaultTreeModel = new DefaultTreeModel(this.root);
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                viewTreeNode = new ViewTreeNode(vector.elementAt(n).toString(), "");
                viewTreeNode.setViewLevel(LEVEL_FAMILY);
                viewTreeNode.setDataObject(vector.elementAt(n));
                viewTreeNode.add(new StringTreeNode(Str.getStr(14)));
                defaultTreeModel.insertNodeInto(viewTreeNode, this.root, 0);
                ++n;
            }
        }
        return defaultTreeModel;
    }

    public void refreshViewTree(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        if (viewTreeNode.getViewLevel().equals(LEVEL_FAMILY)) {
            this.refreshSeriesUnderFamily(defaultTreeModel, viewTreeNode);
        } else if (viewTreeNode.getViewLevel().equals(LEVEL_PROJECT)) {
            this.refreshMachinesUnderProject(defaultTreeModel, viewTreeNode);
        } else if (viewTreeNode.getViewLevel().equals(LEVEL_MACHINE)) {
            this.refreshModelsUnderMachine(defaultTreeModel, viewTreeNode);
        } else if (viewTreeNode.getViewLevel().equals(LEVEL_SERIES)) {
            this.refreshProjectsUnderSeries(defaultTreeModel, viewTreeNode);
        }
    }

    private Vector readDistinctFamilies() {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctFamilies", 5);
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT ( A.TYPECATIND ) " + "FROM PRODRAFT.TYPECATEGORY A,   " + "     PRODRAFT.CATEGORY B,       " + "     PRODRAFT.PRODUCT C " + "WHERE A.TYPECATIND = B.TYPECATIND AND" + "      B.PRODUCTIND = C.PRODUCTIND AND" + "      C.MISFIT = 'Y' AND" + "      A.CATEGORYLEVEL = '" + "opicmfamily" + "' AND " + "      A.PARENTCATIND = " + this.brandRec.getInd() + " " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.addElement(TypeCategory.getDraftCategory(resultSet.getInt(1)));
            }
            new QuickSort(vector);
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    private Vector readDistinctProjects(TypeCategoryRec typeCategoryRec) {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctProjects ()", 5);
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery(" SELECT DISTINCT (A.TYPECATIND) " + " FROM PRODRAFT.TYPECATEGORY A, " + "      PRODRAFT.CATEGORY B, " + "      PRODRAFT.PRODUCT C " + " WHERE A.PARENTCATIND = " + typeCategoryRec.getInd() + " AND " + "       A.CATEGORYLEVEL = '" + "project" + "' AND " + "       A.TYPECATIND = B.TYPECATIND AND " + "       B.PRODUCTIND = C.PRODUCTIND AND " + "       C.MISFIT = 'Y' " + " FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.addElement(TypeCategory.getDraftCategory(resultSet.getInt(1)));
            }
            new QuickSort(vector);
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    private Vector readDistinctSeries(TypeCategoryRec typeCategoryRec) {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctSeries ()", 5);
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery(" SELECT DISTINCT (A.TYPECATIND) " + " FROM PRODRAFT.TYPECATEGORY A, " + "      PRODRAFT.CATEGORY B, " + "      PRODRAFT.PRODUCT C " + " WHERE A.PARENTCATIND = " + typeCategoryRec.getInd() + " AND " + "       A.CATEGORYLEVEL = '" + "opicmseries" + "' AND " + "       A.TYPECATIND = B.TYPECATIND AND " + "       B.PRODUCTIND = C.PRODUCTIND AND " + "       C.MISFIT = 'Y' " + " FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.addElement(TypeCategory.getDraftCategory(resultSet.getInt(1)));
            }
            new QuickSort(vector);
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    private Vector readDistinctMachines(TypeCategoryRec typeCategoryRec, TypeCategoryRec typeCategoryRec2) {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctMachines ( )", 5);
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT (A.TYPECATIND) " + "FROM PRODRAFT.TYPECATEGORY A, " + "     PRODRAFT.TYPECATCHILD B, " + "     PRODRAFT.CATEGORY C, " + "     PRODRAFT.PRODUCT D " + "WHERE A.TYPECATIND = B.TYPECATIND AND " + "      A.CATEGORYLEVEL IN ( '" + "machine" + "', '" + "subcategory" + "') AND " + "      B.PARENTCATIND = " + typeCategoryRec2.getInd() + " AND " + "      A.TYPECATIND = C.TYPECATIND AND " + "      C.PRODUCTIND = D.PRODUCTIND AND " + "      D.MISFIT = 'Y' " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.addElement(TypeCategory.getDraftCategory(resultSet.getInt(1)));
            }
            new QuickSort(vector);
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    private Vector readDistinctModels(TypeCategoryRec typeCategoryRec, TypeCategoryRec typeCategoryRec2, TypeCategoryRec typeCategoryRec3) {
        SQLMethod sQLMethod = new SQLMethod(1, "readDistinctModels ( )", 5);
        Vector<ProductRow> vector = new Vector<ProductRow>(1);
        try {
            boolean bl = typeCategoryRec3.getCategoryLevel().equals("subcategory");
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODUCTIND, A.PRODNUM, A.DESCRIPTION, A.CREATEDON, " + "       A.CREATEDBY, A.LASTTOUCHEDON, A.LASTTOUCHEDBY, C.DESCRIPTION, " + "       A.CHECKEDOUTBY, D.ACTUAL, D.TARGET " + "FROM PRODRAFT.PRODUCT A, " + "     PRODRAFT.CATEGORY B, " + "     PRODRAFT.TYPECATEGORY C, " + "     PRODRAFT.DATES D " + "WHERE A.PRODUCTIND = B.PRODUCTIND AND " + "      B.TYPECATIND = C.TYPECATIND AND " + "      C.TYPECATIND IN (SELECT TYPECATIND FROM PRODRAFT.TYPECATEGORY WHERE PARENTCATIND = " + typeCategoryRec3.getInd() + ") AND " + "      A.PRODUCTIND = D.PRODUCTIND AND " + "      A.MISFIT = 'Y' AND " + "      D.TYPEDATEIND = " + 2 + " FOR FETCH ONLY");
            while (resultSet.next()) {
                ProductRow productRow = new ProductRow(resultSet.getInt(1), 0, bl ? resultSet.getString(8) : resultSet.getString(2), resultSet.getString(3), DateSystem.prettyDateFromStamp(resultSet.getString(4)), UserSystem.getNameFromUserId(resultSet.getString(5)), DateSystem.prettyDateFromDBDate(resultSet.getString(10)), DateSystem.prettyDateFromDBDate(resultSet.getString(11)), UserSystem.getNameFromUserId(resultSet.getString(7)), DateSystem.prettyDateFromStamp(resultSet.getString(6)), true);
                if (resultSet.getString(9) != null) {
                    productRow.setImage(ImageSystem.getImage((Object)MainWindow.getInstance(), 241));
                }
                vector.addElement(productRow);
            }
            new QuickSort(vector);
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return vector;
    }

    private void refreshProjectsUnderSeries(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)viewTreeNode.getDataObject();
        Vector vector = this.readDistinctProjects(typeCategoryRec);
        viewTreeNode.removeAll();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ViewTreeNode viewTreeNode2 = null;
            while (n < n2) {
                viewTreeNode2 = new ViewTreeNode(((TypeCategoryRec)vector.elementAt(n)).getDescript(), "");
                viewTreeNode2.setDataObject(vector.elementAt(n));
                viewTreeNode2.setViewLevel(LEVEL_PROJECT);
                viewTreeNode2.add(new StringTreeNode(Str.getStr(14)));
                defaultTreeModel.insertNodeInto(viewTreeNode2, viewTreeNode, 0);
                ++n;
            }
        }
        defaultTreeModel.reload(viewTreeNode);
    }

    private void refreshSeriesUnderFamily(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)viewTreeNode.getDataObject();
        Vector vector = this.readDistinctSeries(typeCategoryRec);
        viewTreeNode.removeAll();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ViewTreeNode viewTreeNode2 = null;
            while (n < n2) {
                viewTreeNode2 = new ViewTreeNode(((TypeCategoryRec)vector.elementAt(n)).getDescript(), "");
                viewTreeNode2.setDataObject(vector.elementAt(n));
                viewTreeNode2.setViewLevel(LEVEL_SERIES);
                viewTreeNode2.add(new StringTreeNode(Str.getStr(14)));
                defaultTreeModel.insertNodeInto(viewTreeNode2, viewTreeNode, 0);
                ++n;
            }
        }
        defaultTreeModel.reload(viewTreeNode);
    }

    private void refreshMachinesUnderProject(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)viewTreeNode.getDataObject();
        TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)((ViewTreeNode)viewTreeNode.getParent()).getDataObject();
        Vector vector = this.readDistinctMachines(typeCategoryRec2, typeCategoryRec);
        viewTreeNode.removeAll();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            ViewTreeNode viewTreeNode2 = null;
            while (n < n2) {
                viewTreeNode2 = new ViewTreeNode(((TypeCategoryRec)vector.elementAt(n)).getDescript(), "");
                viewTreeNode2.setDataObject(vector.elementAt(n));
                viewTreeNode2.setViewLevel(LEVEL_MACHINE);
                viewTreeNode2.add(new StringTreeNode(Str.getStr(14)));
                defaultTreeModel.insertNodeInto(viewTreeNode2, viewTreeNode, 0);
                ++n;
            }
        }
        defaultTreeModel.reload(viewTreeNode);
    }

    private void refreshModelsUnderMachine(DefaultTreeModel defaultTreeModel, ViewTreeNode viewTreeNode) {
        ViewTreeNode viewTreeNode2 = (ViewTreeNode)viewTreeNode.getParent();
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)viewTreeNode2.getDataObject();
        TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)viewTreeNode.getDataObject();
        TypeCategoryRec typeCategoryRec3 = (TypeCategoryRec)((ViewTreeNode)viewTreeNode2.getParent()).getDataObject();
        Vector vector = this.readDistinctModels(typeCategoryRec3, typeCategoryRec, typeCategoryRec2);
        viewTreeNode.removeAll();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            MutableTreeWrapper mutableTreeWrapper = null;
            while (n < n2) {
                mutableTreeWrapper = new MutableTreeWrapper();
                mutableTreeWrapper.setDataObject(vector.elementAt(n));
                defaultTreeModel.insertNodeInto(mutableTreeWrapper, viewTreeNode, 0);
                ++n;
            }
        }
        defaultTreeModel.reload(viewTreeNode);
    }

    public int getTitlePadding() {
        return 80;
    }

    public String getFullSQL() {
        return "SELECT A.PRODUCTIND, A.PRODNUM,       A.DESCRIPTION,   A.CREATEDON, " + "       A.CREATEDBY,  A.LASTTOUCHEDON, A.LASTTOUCHEDBY, C.DESCRIPTION, " + "       A.CHECKEDOUTBY " + "FROM PRODRAFT.PRODRAFT A, " + "     PRODRAFT.CATEGORY B, " + "     PRODRAFT.TYPECATEGORY C " + "WHERE A.PRODUCTIND = B.PRODUCTIND AND " + "      A.TEMPLATE   = 'N' AND " + "      A.MISFIT     = 'Y' AND " + "      A.PUBLISH    = 'Y' AND " + "      A.RECYCLED   = 'N' AND " + "      A.STOPDATE   IS NULL AND " + "      B.TYPECATIND IN (SELECT TYPECATIND " + "                       FROM PRODUCT.TYPECATEGORY " + "                       WHERE PARENTCATIND = " + this.brandRec.getInd() + ") AND " + "      C.TYPECATIND  = B.TYPECATIND ";
    }

    public TypeCategoryRec getBrand() {
        return this.brandRec;
    }
}

