/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDate;
import com.ibm.nzna.projects.common.quest.product.ProductDateRow;
import com.ibm.nzna.projects.common.quest.product.ProductPropertyListener;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeDateRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.SingleDateEntryDlg;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.productEdit.dateEdit.DateEditDlg;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.JListDlg;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.sort.QuickSort;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class DatePanel
extends DPanel
implements ActionListener,
ProductPropertyListener,
AppConst,
ProductConst {
    private boolean editable = true;
    public JLabel st_COUNTRY = new JLabel(Str.getStr(94));
    private DButton pb_SHOW_ALL = new DButton(Str.getStr(17020));
    private JComboBox cb_COUNTRY = new JComboBox();
    private MultiList cnr_DATES = new MultiList(GUISystem.getFontUtil());
    private DButton pb_ADD_COUNTRY = new DButton(Str.getStr(1102));
    private DButton pb_EDIT = new DButton(Str.getStr(50));
    private DButton pb_REMOVE_COUNTRY = new DButton(Str.getStr(17021));
    private JLabel st_REQUIRED = null;
    private Product product = null;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = GUISystem.getRowHeight();
        this.st_REQUIRED.setBounds(n, n2, dimension.width, 15);
        this.st_COUNTRY.setBounds(n, n2 += 17, dimension.width, n3);
        this.cb_COUNTRY.setBounds(n, n2 += n3, dimension.width - 92, n3);
        this.pb_SHOW_ALL.setBounds(dimension.width - 90, n2, 90, n3);
        this.cnr_DATES.setBounds(n, n2 += n3, dimension.width, dimension.height - n2 - 37);
        this.pb_ADD_COUNTRY.setBounds(n, dimension.height - 25, 80, 20);
        this.pb_EDIT.setBounds(n + 85, dimension.height - 25, 70, 20);
        this.pb_REMOVE_COUNTRY.setBounds(n + 85 + 75, dimension.height - 25, 100, 20);
    }

    public void setProduct(Product product) {
        if (this.product != product) {
            if (this.product != null) {
                this.product.removeProductPropertyListener(this);
            }
            this.product = product;
            product.addProductPropertyListener(this);
        }
        this.refresh();
    }

    private final void refresh() {
        Vector vector = this.getUniqueCountries();
        if (vector.size() == 0) {
            vector.addElement("No countries, please press 'Add Country' to add a country");
        }
        this.cb_COUNTRY.removeActionListener(this);
        this.remove(this.cb_COUNTRY);
        this.cb_COUNTRY = new JComboBox(vector);
        this.add(this.cb_COUNTRY);
        this.refreshDatesFromCountry();
        this.cb_COUNTRY.addActionListener(this);
        this.revalidate();
    }

    private final Vector getUniqueCountries() {
        Vector<TypeCountryCodeRec> vector = new Vector<TypeCountryCodeRec>(1);
        Vector vector2 = this.product.getDates();
        if (vector2 != null && vector2.size() > 0) {
            int n = 0;
            int n2 = vector2.size();
            ProductDate productDate = null;
            TypeCountryCodeRec typeCountryCodeRec = null;
            while (n < n2) {
                productDate = (ProductDate)vector2.elementAt(n);
                typeCountryCodeRec = (TypeCountryCodeRec)TypeList.getInstance().objectFromInd(productDate.getCountryCodeInd(), 3);
                if (!vector.contains(typeCountryCodeRec)) {
                    vector.addElement(typeCountryCodeRec);
                }
                ++n;
            }
        }
        vector2.removeAllElements();
        vector2 = null;
        new QuickSort(vector);
        return vector;
    }

    public void productChanged(Product product, int n) {
        if (n == 10) {
            this.refresh();
        }
    }

    private final void refreshDatesFromCountry() {
        if (this.cb_COUNTRY.getSelectedItem() instanceof TypeCountryCodeRec) {
            Vector vector = TypeList.getInstance().getTypeList(27);
            TypeCountryCodeRec typeCountryCodeRec = (TypeCountryCodeRec)this.cb_COUNTRY.getSelectedItem();
            Vector vector2 = this.product.getDates();
            Vector<ProductDateRow> vector3 = new Vector<ProductDateRow>(1);
            if (vector != null && vector.size() > 0 && typeCountryCodeRec != null) {
                int n = 0;
                int n2 = vector.size();
                Object var7_7 = null;
                ProductDateRow productDateRow = null;
                while (n < n2) {
                    productDateRow = this.getProductDateRowFromCountryType(vector2, typeCountryCodeRec.getInd(), ((TypeDateRec)vector.elementAt(n)).getInd());
                    if (productDateRow == null) {
                        productDateRow = new ProductDateRow((TypeDateRec)vector.elementAt(n));
                    }
                    vector3.addElement(productDateRow);
                    ++n;
                }
            }
            this.cnr_DATES.setData(vector3);
        }
    }

    private final ProductDateRow getProductDateRowFromCountryType(Vector vector, int n, int n2) {
        ProductDateRow productDateRow = null;
        if (vector != null && vector.size() > 0) {
            int n3 = 0;
            int n4 = vector.size();
            while (productDateRow == null && n3 < n4) {
                if (((ProductDate)vector.elementAt(n3)).getCountryCodeInd() == n && ((ProductDate)vector.elementAt(n3)).getDateType() == n2) {
                    productDateRow = new ProductDateRow((ProductDate)vector.elementAt(n3));
                }
                ++n3;
            }
        }
        return productDateRow;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cb_COUNTRY) {
            this.refreshDatesFromCountry();
        } else if (actionEvent.getSource() == this.pb_SHOW_ALL) {
            new DateEditDlg((Frame)GUISystem.getParentDefWin(this), this.product, this.editable);
        } else if (actionEvent.getSource() == this.pb_EDIT || actionEvent.getSource() == this.cnr_DATES) {
            this.editDate();
        } else if (actionEvent.getSource() == this.pb_ADD_COUNTRY) {
            this.addCountry();
        } else if (actionEvent.getSource() == this.pb_REMOVE_COUNTRY) {
            this.removeCountry();
        }
    }

    private final void editDate() {
        ProductDateRow productDateRow = (ProductDateRow)this.cnr_DATES.getSelectedItem();
        if (productDateRow != null) {
            ProductDate productDate = productDateRow.getProductDate();
            String string = null;
            if (productDate == null) {
                productDate = new ProductDate(this.product.getProductInd(), productDateRow.getDateType());
                productDate.setCountryCodeInd(((TypeCountryCodeRec)this.cb_COUNTRY.getSelectedItem()).getInd());
            }
            if ((string = new SingleDateEntryDlg((Frame)GUISystem.getParentDefWin(this), (String)productDateRow.getColumnData(0), (String)productDateRow.getColumnData(0), productDate.getActualDate() == null ? productDate.getTargetDate() : productDate.getActualDate()).getResult()) != null) {
                Vector vector = this.product.getDates();
                productDate.setActualDate(string);
                if (!vector.contains(productDate)) {
                    vector.addElement(productDate);
                } else {
                    ((ProductDate)vector.elementAt(vector.indexOf(productDate))).setActualDate(string);
                }
                this.product.setPropertyChangeEnabled(false);
                this.product.setDates(vector);
                this.product.setPropertyChangeEnabled(true);
                this.refreshDatesFromCountry();
            }
        } else {
            GUISystem.printBox(7, 358);
        }
    }

    private final void addCountry() {
        Vector vector = null;
        JListDlg jListDlg = new JListDlg((Frame)GUISystem.getParentDefWin(this), Str.getStr(1102), TypeList.getInstance().getTypeList(3));
        jListDlg.setSelectionMode(0);
        vector = jListDlg.getResult();
        if (vector != null && vector.size() > 0) {
            TypeCountryCodeRec typeCountryCodeRec = (TypeCountryCodeRec)vector.elementAt(0);
            Vector vector2 = this.getUniqueCountries();
            if (!vector2.contains(typeCountryCodeRec)) {
                vector2.insertElementAt(typeCountryCodeRec, 0);
                new QuickSort(vector2);
                this.cb_COUNTRY.removeActionListener(this);
                this.remove(this.cb_COUNTRY);
                this.cb_COUNTRY = new JComboBox(vector2);
                this.add(this.cb_COUNTRY);
                this.cb_COUNTRY.setSelectedItem(typeCountryCodeRec);
                this.cb_COUNTRY.addActionListener(this);
                this.refreshDatesFromCountry();
                this.revalidate();
            } else {
                GUISystem.printBox(7, 17113);
            }
        }
    }

    private final void removeCountry() {
        TypeCountryCodeRec typeCountryCodeRec = (TypeCountryCodeRec)this.cb_COUNTRY.getSelectedItem();
        if (typeCountryCodeRec != null) {
            if (GUISystem.printBox(8, 17072)) {
                Vector vector = this.product.getDates();
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    if (((ProductDate)vector.elementAt(n)).getCountryCodeInd() == typeCountryCodeRec.getInd()) {
                        vector.removeElementAt(n);
                        --n2;
                        continue;
                    }
                    ++n;
                }
                this.cnr_DATES.removeAll();
                this.product.setDates(vector);
            }
        } else {
            GUISystem.printBox(7, 17073);
        }
    }

    protected void setEditable(boolean bl) {
        this.pb_ADD_COUNTRY.setEnabled(bl);
        this.pb_REMOVE_COUNTRY.setEnabled(bl);
        this.pb_EDIT.setEnabled(bl);
        this.editable = bl;
    }

    public DatePanel() {
        Object[] objectArray = new String[]{Str.getStr(17071), Str.getStr(412)};
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(550, 200));
        this.cnr_DATES.setColumnHeadings(objectArray);
        this.cnr_DATES.setColumnWidth(0, 140);
        this.cnr_DATES.setColumnWidth(1, 140);
        this.cnr_DATES.setBorder(GUISystem.blackBorder);
        this.cb_COUNTRY.addActionListener(this);
        this.pb_EDIT.addActionListener(this);
        this.pb_SHOW_ALL.addActionListener(this);
        this.pb_ADD_COUNTRY.addActionListener(this);
        this.pb_REMOVE_COUNTRY.addActionListener(this);
        this.cnr_DATES.addActionListener(this);
        this.setLayout(null);
        this.st_REQUIRED = GUISystem.getRequiredJLabel();
        this.add(this.st_REQUIRED);
        this.add(this.st_COUNTRY);
        this.add(this.cb_COUNTRY);
        this.add(this.pb_SHOW_ALL);
        this.add(this.cnr_DATES);
        this.add(this.pb_ADD_COUNTRY);
        this.add(this.pb_EDIT);
        this.add(this.pb_REMOVE_COUNTRY);
        this.st_REQUIRED.setText("Required For Publish");
    }
}

