/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductPropertyListener;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.ToolBarButton;
import com.ibm.nzna.projects.qit.print.Print;
import com.ibm.nzna.projects.qit.print.PrintPanel;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.compare.ProductComparePanel;
import com.ibm.nzna.projects.qit.product.history.ProductHistoryPanel;
import com.ibm.nzna.projects.qit.product.productEdit.ProductEditPanel;
import com.ibm.nzna.projects.qit.product.productEdit.property.PropertyDlg;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ProductEditor
extends JPanel
implements PrintPanel,
ActionListener,
ProductPropertyListener,
QuestPanel,
AppConst,
ProductConst {
    private ProductDraft draft = null;
    private ProductEditPanel prodEditPanel = null;
    private boolean focusButtonSet = false;
    private ToolBarButton pb_PROPERTY = null;
    private ToolBarButton pb_COMPARE = null;
    private ToolBarButton pb_HISTORY = null;
    private JToolBar toolBar = null;
    private ActionButton pb_SAVE = new ActionButton(Str.getStr(515), ImageSystem.getImageIcon((Object)MainWindow.getInstance(), 62), Str.getStr(515));
    private ActionButton pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)MainWindow.getInstance(), 8), Str.getStr(28));
    private AppDefaultWin parentWin = null;
    private boolean productChanged = false;

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 45);
    }

    public String getName() {
        return Str.getStr(50);
    }

    public NavPanel getDefaultNavPanel() {
        return null;
    }

    public boolean initialize() {
        this.prodEditPanel = new ProductEditPanel();
        this.pb_PROPERTY = new ToolBarButton(Str.getStr(1320), ImageSystem.getImageIcon((Object)this, 166), Str.getStr(1320));
        this.pb_COMPARE = new ToolBarButton(Str.getStr(17031), ImageSystem.getImageIcon((Object)this, 239), Str.getStr(17031));
        this.pb_HISTORY = new ToolBarButton(Str.getStr(1206), ImageSystem.getImageIcon((Object)this, 125), Str.getStr(1206));
        this.toolBar = new JToolBar();
        this.toolBar.setBorder(GUISystem.emptyBorder);
        this.toolBar.setOpaque(false);
        this.setBackground(Color.white);
        this.toolBar.add(this.pb_PROPERTY);
        this.toolBar.add(this.pb_COMPARE);
        this.toolBar.add(this.pb_HISTORY);
        this.pb_SAVE.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_PROPERTY.addActionListener(this);
        this.pb_COMPARE.addActionListener(this);
        this.pb_HISTORY.addActionListener(this);
        this.setLayout(null);
        this.add(this.prodEditPanel);
        return true;
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.prodEditPanel.setBounds(5, 5, dimension.width - 6, dimension.height - 6);
    }

    public void start() {
        this.parentWin = GUISystem.getParentDefWin(this);
        this.prodEditPanel.setProduct(this.draft);
        this.parentWin.addActionComponent(this, this.pb_CLOSE);
        this.parentWin.addActionComponent(this, this.pb_SAVE);
        this.panelSelected();
        if (this.productCheckedOut()) {
            this.pb_SAVE.setVisible(false);
            GUISystem.printBox("Info", "The product is currently locked by " + UserSystem.getNameFromUserId(this.draft.getLastTouchedBy()));
        }
    }

    public boolean stop() {
        if (!this.productCheckedOut()) {
            if (this.productChanged && GUISystem.printBox("Question", "Do you wish to save your product?")) {
                return this.saveProduct();
            }
            try {
                this.draft.checkOut(null);
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
            }
        }
        this.panelDeselected();
        return true;
    }

    public boolean shutdown() {
        return true;
    }

    public void enable(boolean bl) {
    }

    public JComponent getJComponent() {
        return this;
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public boolean copyText() {
        return false;
    }

    public void refresh() {
        GUISystem.printBox("Info", "Refresh not supported here");
    }

    public void panelSelected() {
        GUISystem.getParentDefWin(this).addToolbarButton(this.toolBar, 2);
    }

    public void panelDeselected() {
        GUISystem.getParentDefWin(this).removeToolbarButton(this.toolBar);
    }

    public boolean bookmark() {
        return true;
    }

    public void productChanged(Product product, int n) {
        this.productChanged = true;
        try {
            if (!this.focusButtonSet) {
                String string = null;
                String string2 = product.getDescription();
                int n2 = product.getProductInd();
                if (product.getProductType() == 2) {
                    if (product.getPartNumber() != null) {
                        string = product.getPartNumber().toString();
                    }
                } else {
                    string = product.getProdNum();
                }
                if (string != null && string.length() > 0) {
                    this.parentWin.setFocusButtonText(this, string);
                } else if (n2 > 0) {
                    this.parentWin.setFocusButtonText(this, "" + n2);
                } else if (string2 != null && string2.length() > 10) {
                    this.parentWin.setFocusButtonText(this, string2.substring(0, 10) + "...");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ProductDraft) {
            ProductDraft productDraft = (ProductDraft)object;
            if (productDraft.getExistingProductInd() == 0) {
                return false;
            }
            if (productDraft.getExistingProductInd() == 0 && this.draft.getExistingProductInd() == 0) {
                return false;
            }
            return productDraft.getExistingProductInd() == this.draft.getExistingProductInd();
        }
        return object == this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CLOSE) {
            this.parentWin.closePanel(this, null);
        } else if (actionEvent.getSource() == this.pb_SAVE) {
            if (this.saveProduct()) {
                this.parentWin.closePanel(this, null);
            }
        } else if (actionEvent.getSource() == this.pb_PROPERTY) {
            new PropertyDlg(this.parentWin);
        } else if (actionEvent.getSource() == this.pb_COMPARE) {
            WindowSystem.createPanel(new ProductComparePanel(this.draft, this));
        } else if (actionEvent.getSource() == this.pb_HISTORY) {
            WindowSystem.createPanel(new ProductHistoryPanel(this.draft.getProductInd(), true, this));
        }
    }

    private boolean saveProduct() {
        switch (this.prodEditPanel.saveProduct()) {
            case 2: 
            case 3: 
            case 4: {
                this.productChanged = false;
                this.parentWin.closePanel(this, null);
                return true;
            }
            case 1: {
                this.productChanged = false;
                return true;
            }
        }
        return false;
    }

    private boolean productCheckedOut() {
        String string = this.draft.getCheckedOutBy();
        if (string == null) {
            return false;
        }
        return !string.equals(UserSystem.getUserId());
    }

    public Object getPrintObject() {
        return new Print(this.prodEditPanel.getFormPanel(), GUISystem.getParentDefWin(this), Str.getStr(206));
    }

    public ProductEditor(ProductDraft productDraft) {
        this.draft = productDraft;
        productDraft.addProductPropertyListener(this);
        this.productChanged(productDraft, 0);
    }
}

