/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productEdit.dateEdit;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDate;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeDateRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.EntrySystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.DateEntryField;
import com.ibm.nzna.projects.qit.print.Print;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.productEdit.dateEdit.ProductDateTableModel;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.JListDlg;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DateEditDlg
extends JDialog
implements MouseListener,
ListSelectionListener,
ActionListener,
AppConst,
ProductConst {
    private JTable dateTable = null;
    private ProductDateTableModel dateModel = null;
    private Product product = null;
    private JScrollPane scrollPane = null;
    private DButton pb_OK = new DButton(Str.getStr(1));
    private DButton pb_ADD_COUNTRY = new DButton(Str.getStr(1102));
    private DButton pb_REMOVE_COUNTRY = new DButton(Str.getStr(17021));
    private DButton pb_PRINT = new DButton(Str.getStr(1115));
    private JLabel st_HELP = new JLabel("To edit a single date, double click on that date");
    private DButton pb_CANCEL = new DButton(Str.getStr(2));
    private ButtonPanel buttonPanel = new ButtonPanel();
    private JLabel st_DATE = new JLabel(Str.getStr(412));
    private JComboBox cb_DATE = new JComboBox(TypeList.getInstance().getTypeList(27));
    private DButton pb_SET = new DButton("Set");
    private DateEntryField ef_DATE = new DateEntryField();
    private boolean editable = true;

    private final void initialize() {
        Rectangle rectangle = (Rectangle)PropertySystem.get(204);
        this.dateModel = new ProductDateTableModel(this.product.getDates());
        this.dateTable = new JTable(this.dateModel);
        this.scrollPane = new JScrollPane(this.dateTable);
        this.dateTable.setAutoResizeMode(0);
        this.dateTable.setShowHorizontalLines(false);
        this.scrollPane.setBackground(Color.white);
        this.dateTable.setColumnSelectionAllowed(true);
        this.dateTable.addMouseListener(this);
        this.pb_SET.setEnabled(this.editable);
        this.pb_OK.setEnabled(this.editable);
        this.pb_ADD_COUNTRY.setEnabled(this.editable);
        this.pb_REMOVE_COUNTRY.setEnabled(this.editable);
        this.cb_DATE.setEnabled(this.editable);
        if (!this.editable) {
            this.pb_CANCEL.setText(Str.getStr(28));
        }
        this.ef_DATE.addFocusListener(EntrySystem.getDateFieldFixer());
        this.ef_DATE.addActionListener(EntrySystem.getDateFieldFixer());
        this.dateTable.setPreferredScrollableViewportSize(new Dimension(300, 400));
        WinUtil.setBackgroundAll(this.scrollPane, Color.white);
        this.pb_OK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_ADD_COUNTRY.addActionListener(this);
        this.pb_REMOVE_COUNTRY.addActionListener(this);
        this.cb_DATE.addActionListener(this);
        this.dateTable.getSelectionModel().addListSelectionListener(this);
        this.ef_DATE.addActionListener(this);
        this.pb_SET.addActionListener(this);
        this.pb_PRINT.addActionListener(this);
        this.buttonPanel.add(this.pb_OK);
        this.buttonPanel.add(this.pb_ADD_COUNTRY);
        this.buttonPanel.add(this.pb_REMOVE_COUNTRY);
        this.buttonPanel.add(this.pb_CANCEL);
        this.buttonPanel.add(this.pb_PRINT);
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)this.st_HELP, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add(this.st_DATE);
        this.getContentPane().add(this.cb_DATE);
        this.getContentPane().add(this.ef_DATE);
        this.getContentPane().add(this.pb_SET);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        GUISystem.setPropertiesOnPanel(this.getContentPane());
        if (rectangle == null) {
            ((Component)this).setSize(500, 400);
            WinUtil.centerWindow(this);
        } else {
            ((Component)this).setBounds(rectangle);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CANCEL) {
            PropertySystem.put(204, this.getBounds());
            this.dispose();
        } else if (actionEvent.getSource() == this.pb_OK) {
            this.product.setDates(this.dateModel.getDates());
            PropertySystem.put(204, this.getBounds());
            this.dispose();
        } else if (actionEvent.getSource() == this.pb_ADD_COUNTRY) {
            this.addCountry();
        } else if (actionEvent.getSource() == this.pb_PRINT) {
            this.getPrintObject();
        } else if (actionEvent.getSource() == this.cb_DATE) {
            int n = this.dateTable.getSelectedRow();
            if (n >= 0) {
                TypeCountryCodeRec typeCountryCodeRec = this.dateModel.getCountryForRow(n);
                this.refreshDate(this.dateModel.getProductDateFromCountryType(this.dateModel.getCountryForRow(n).getInd(), ((TypeDateRec)this.cb_DATE.getSelectedItem()).getInd()));
                this.ef_DATE.requestFocus();
            } else {
                GUISystem.printBox((JDialog)this, "Info", "Please select a date from one of the countries listed");
            }
        } else if (actionEvent.getSource() == this.pb_SET || actionEvent.getSource() == this.ef_DATE) {
            int n = this.dateTable.getSelectedRow();
            if (n >= 0) {
                TypeCountryCodeRec typeCountryCodeRec = this.dateModel.getCountryForRow(n);
                if (typeCountryCodeRec != null) {
                    this.editDate(typeCountryCodeRec);
                } else {
                    GUISystem.printBox((JDialog)this, 7, 358);
                }
            } else {
                GUISystem.printBox((JDialog)this, 7, 358);
            }
        } else if (actionEvent.getSource() == this.pb_REMOVE_COUNTRY) {
            int n = this.dateTable.getSelectedRow();
            if (n >= 0) {
                TypeCountryCodeRec typeCountryCodeRec = this.dateModel.getCountryForRow(n);
                if (typeCountryCodeRec != null) {
                    this.removeCountry(typeCountryCodeRec);
                }
            } else {
                GUISystem.printBox((JDialog)this, 7, 358);
            }
        }
    }

    private final void addCountry() {
        Vector vector = null;
        JListDlg jListDlg = new JListDlg((Frame)GUISystem.getParentDefWin(this), Str.getStr(1102), TypeList.getInstance().getTypeList(3));
        jListDlg.setSelectionMode(0);
        vector = jListDlg.getResult();
        if (vector != null && vector.size() > 0) {
            TypeCountryCodeRec typeCountryCodeRec = (TypeCountryCodeRec)vector.elementAt(0);
            if (!this.dateModel.contains(typeCountryCodeRec)) {
                this.dateModel.addCountry(typeCountryCodeRec);
                this.dateTable.revalidate();
            } else {
                GUISystem.printBox((JDialog)this, "Info", "That country is already in the list. Please select another country");
            }
        }
    }

    private final Object getPrintObject() {
        return new Print(this, GUISystem.getParentDefWin(this), Str.getStr(353));
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = 5;
        super.doLayout();
        this.st_HELP.setBounds(5, 5, dimension.width - 15, n);
        this.scrollPane.setBounds(5, n + 5, dimension.width - 15, dimension.height - 113);
        this.st_DATE.setBounds(n2, dimension.height - 86, 50, n);
        this.cb_DATE.setBounds(n2 += 55, dimension.height - 86, 150, n);
        this.ef_DATE.setBounds(n2 += 155, dimension.height - 86, 90, n);
        this.pb_SET.setBounds(n2 += 95, dimension.height - 85, 60, n - 2);
        this.buttonPanel.setBounds(5, dimension.height - 60, dimension.width - 15, 25);
    }

    private final void editDate(TypeCountryCodeRec typeCountryCodeRec) {
        String string = null;
        TypeDateRec typeDateRec = (TypeDateRec)this.cb_DATE.getSelectedItem();
        string = this.ef_DATE.getText();
        if (CDate.checkDate(string, 2) == 0) {
            ProductDate productDate = this.dateModel.getProductDateFromCountryType(typeCountryCodeRec.getInd(), typeDateRec.getInd());
            if (productDate == null) {
                productDate = new ProductDate(this.product.getProductInd(), string, string, typeDateRec.getInd(), typeCountryCodeRec.getInd());
                this.dateModel.addDate(productDate);
            } else {
                productDate.setActualDate(string);
            }
            productDate.setToString("<html><body><font color=\"blue\">" + string + "</font></body></html>");
            this.repaintTable();
        } else {
            GUISystem.printBox((JDialog)this, 7, 414);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.mouseClicked(null);
    }

    private final void refreshDate(ProductDate productDate) {
        if (productDate != null) {
            this.cb_DATE.setSelectedItem(TypeList.getInstance().objectFromInd(productDate.getDateType(), 27));
            if (productDate.getActualDate() != null) {
                this.ef_DATE.setText(productDate.getActualDate());
            } else {
                this.ef_DATE.setText(productDate.getTargetDate());
            }
        } else {
            this.ef_DATE.setText("");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.editable) {
            int n = this.dateTable.getSelectedRow();
            int n2 = this.dateTable.getSelectedColumn();
            if (n >= 0 && n2 >= 1) {
                ProductDate productDate = (ProductDate)this.dateModel.getValueAt(n, n2);
                this.refreshDate(productDate);
                this.cb_DATE.setSelectedItem(this.dateModel.getDateTypeFromColumn(n2));
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void repaintTable() {
        this.dateTable.setShowGrid(true);
        this.dateTable.setShowHorizontalLines(false);
        this.scrollPane.invalidate();
        ((JComponent)this.getContentPane()).revalidate();
    }

    private final void removeCountry(TypeCountryCodeRec typeCountryCodeRec) {
        if (typeCountryCodeRec != null && GUISystem.printBox(8, 17072)) {
            Vector vector = this.dateModel.getDates();
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                if (((ProductDate)vector.elementAt(n)).getCountryCodeInd() == typeCountryCodeRec.getInd()) {
                    vector.removeElementAt(n);
                    --n2;
                    continue;
                }
                ++n;
            }
            this.dateModel.setProductDates(vector);
        }
    }

    public DateEditDlg(Frame frame, Product product, boolean bl) {
        super(frame, Str.getStr(17015), true);
        this.editable = bl;
        this.product = product;
        this.initialize();
        ((Component)this).setVisible(true);
    }
}

