/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productExport;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.productExport.ProductExportListener;
import com.ibm.nzna.projects.qit.product.productExport.ProductExportProperty;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class ProductExport
implements AppConst,
ProductConst,
Runnable {
    private ProductExportProperty exportProperty = null;
    private ProductExportListener listener = null;
    private FileOutputStream outFile = null;

    public void run() {
        Vector vector = null;
        this.listener.productExportStatusChange("Opening export file");
        if (this.openFile()) {
            this.listener.productExportStatusChange("Gathering list of products");
            switch (this.exportProperty.getExportType()) {
                case 3: {
                    vector = this.exportProperty.getViewableProducts();
                    break;
                }
                case 2: {
                    vector = this.exportProperty.getSelectedProducts();
                    break;
                }
                case 1: {
                    vector = this.getRowsFromView();
                    break;
                }
            }
            if (vector != null && vector.size() > 0) {
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    this.writeProduct((ProductRow)vector.elementAt(n));
                    this.listener.productExported(++n);
                }
            } else {
                this.listener.productExportStatusChange("No products to export");
            }
        } else {
            this.listener.productExportStatusChange("Could not open export file");
        }
        this.listener.productExportComplete();
    }

    private boolean openFile() {
        boolean bl = false;
        try {
            File file = new File(this.exportProperty.getFilename());
            Vector vector = this.exportProperty.getFieldNames();
            this.outFile = new FileOutputStream(file);
            if (vector != null && vector.size() > 0) {
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    this.outFile.write(vector.elementAt(n).toString().getBytes());
                    if (n < n2 - 1) {
                        this.outFile.write(",".getBytes());
                    }
                    ++n;
                }
                this.outFile.write("\n".getBytes());
            }
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        return bl;
    }

    private void writeProduct(ProductRow productRow) {
        Vector vector = this.exportProperty.getFieldNames();
        int n = 0;
        int n2 = vector.size();
        this.listener.productExportStatusChange("Reading " + productRow.getDescription());
        productRow.readProduct(false);
        while (n < n2) {
            try {
                this.outFile.write(this.getFieldString(productRow, vector.elementAt(n).toString()).getBytes());
                if (n < n2 - 1) {
                    this.outFile.write(",".getBytes());
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, "Could not write product out. Product Ind:" + productRow.getProductInd());
            }
            ++n;
        }
        try {
            this.outFile.write("\n".getBytes());
        }
        catch (Exception exception) {
            LogSystem.log(1, "Could not write product out. Product Ind:" + productRow.getProductInd());
        }
    }

    private String getFieldString(ProductRow productRow, String string) {
        String string2 = "";
        if (string.equals(Str.getStr(334))) {
            string2 = productRow.getProduct().getProdNum();
        } else if (string.equals(Str.getStr(17037))) {
            string2 = productRow.getProduct().getPartNumber() != null ? productRow.getProduct().getPartNumber().toString() : "NA";
        }
        if (string.equals(Str.getStr(100))) {
            string2 = productRow.getProduct().getDescription();
        } else if (string.equals(Str.getStr(145))) {
            string2 = productRow.getProduct().getBrand() != null ? productRow.getProduct().getBrand().toString() : "NA";
        } else if (string.equals(Str.getStr(149))) {
            string2 = productRow.getProduct().getFamily() != null ? productRow.getProduct().getFamily().toString() : "NA";
        } else if (string.equals(Str.getStr(340))) {
            string2 = productRow.getProduct().getMachine() != null ? productRow.getProduct().getMachine().toString() : "NA";
        } else if (string.equals(Str.getStr(341))) {
            string2 = productRow.getProduct().getModel() != null ? productRow.getProduct().getModel().toString() : "NA";
        } else if (string.equals(Str.getStr(1665))) {
            string2 = productRow.getProduct().getSubCategory() != null ? productRow.getProduct().getSubCategory().toString() : "NA";
        } else if (string.equals(Str.getStr(17015))) {
            string2 = "NA";
        } else if (string.equals(Str.getStr(17041))) {
            string2 = "NA";
        } else if (string.equals(Str.getStr(94))) {
            string2 = "NA";
        } else if (string.equals(Str.getStr(266))) {
            string2 = UserSystem.getNameFromUserId(productRow.getProduct().getLastTouchedBy());
        } else if (string.equals(Str.getStr(267))) {
            string2 = DateSystem.prettyDateFromStamp(productRow.getProduct().getLastTouchedOn());
        } else if (string.equals(Str.getStr(17028))) {
            string2 = DateSystem.prettyDateFromStamp(productRow.getProduct().getCreatedOn());
        } else if (string.equals(Str.getStr(17027))) {
            string2 = UserSystem.getNameFromUserId(productRow.getProduct().getLastTouchedBy());
        }
        return string2;
    }

    private Vector getRowsFromView() {
        String string = this.exportProperty.getPMView().getName();
        Vector<ProductRow> vector = new Vector<ProductRow>(1);
        String string2 = null;
        SQLMethod sQLMethod = new SQLMethod(1, "getRowsFromView", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            boolean bl = Brands.getOptionBrand().getInd() == this.exportProperty.getPMView().getBrand().getInd();
            boolean bl2 = string.indexOf(Str.getStr(1066)) != -1;
            string2 = this.exportProperty.getPMView().getFullSQL();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                ProductRow productRow = new ProductRow(resultSet.getInt(1), resultSet.getInt(1), bl ? resultSet.getString(8) : resultSet.getString(2), resultSet.getString(3).trim(), DateSystem.prettyDateFromStamp(resultSet.getString(4).trim()), UserSystem.getNameFromUserId(resultSet.getString(5).trim()), "", "", DateSystem.prettyDateFromStamp(resultSet.getString(6).trim()), UserSystem.getNameFromUserId(resultSet.getString(7).trim()), bl2);
                vector.addElement(productRow);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
        return vector;
    }

    public ProductExport(ProductExportProperty productExportProperty, ProductExportListener productExportListener) {
        this.exportProperty = productExportProperty;
        this.listener = productExportListener;
        new Thread(this).start();
    }
}

