/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product.productImport;

import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.product.CreateProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductDate;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductSQL;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.ProcessManagerSystem;
import com.ibm.nzna.projects.qit.app.QuestProcess;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.projects.qit.product.productImport.ProductImportConst;
import com.ibm.nzna.shared.batch.Batch;
import com.ibm.nzna.shared.batch.BatchLogSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProductImport
extends Batch
implements ProductImportConst,
ProductConst,
ActionListener,
QuestProcess {
    private String userId = UserSystem.getUserId().trim();
    private String importFilename = null;
    private BatchLogSystem logSystem = new BatchLogSystem("ProductImport", this);
    private int productActionType = 0;
    private int productImportType = 1;
    private int step = 0;
    private boolean continueImport = true;
    private boolean parsingComplete = false;
    private Vector productStrVec = null;
    private Vector productVec = null;
    private int MAX_NUMBER_OF_STEPS = 12;
    private ActionButton pb_COMMIT = null;
    private ActionButton pb_RERUN = null;
    private String machineStr = null;
    private String modelStr = null;
    private String subCategoryStr = null;
    private String partNumStr = null;
    private String warrantyStr = null;

    public void startBatch() {
        this.continueImport = true;
        ProcessManagerSystem.addProcess(this);
        if (this.continueImport) {
            this.pb_RERUN.setEnabled(true);
            this.continueImport = this.parseCSVFile();
        }
        if (this.continueImport) {
            this.continueImport = this.processProductStrVec(this.productStrVec);
        }
    }

    public void stopBatch() {
        ProcessManagerSystem.removeProcess(this);
        this.logProgress("Shutting Down", this.MAX_NUMBER_OF_STEPS, this.step++);
        this.logProgress("Batch Completed", this.MAX_NUMBER_OF_STEPS, this.step++);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_COMMIT && this.continueImport && this.parsingComplete) {
            this.pb_COMMIT.setEnabled(false);
            this.pb_RERUN.setEnabled(false);
            this.commitImport();
        }
        if (actionEvent.getSource() == this.pb_RERUN && !this.parsingComplete) {
            this.rerun();
        }
    }

    public boolean readParams(String[] stringArray) {
        boolean bl = false;
        try {
            if (stringArray != null && stringArray.length > 0) {
                int n = stringArray.length;
                int n2 = 0;
                BatchLogSystem.beginLogSection("Reading Parameters. Number of params passed:" + stringArray.length);
                while (n2 < n) {
                    this.processParam(stringArray[n2].toUpperCase(), stringArray[n2]);
                    ++n2;
                }
                bl = true;
                BatchLogSystem.endLogSection();
            }
        }
        catch (Exception exception) {
            this.logSevereError(exception);
        }
        return bl;
    }

    public void processParam(String string, String string2) throws Exception {
        this.logProgress("Parameter:" + string2, this.MAX_NUMBER_OF_STEPS, this.step++);
        if (string.startsWith("/FILE:")) {
            this.importFilename = string2.substring(6, string.length());
        } else if (string.startsWith("/INSERTUPDATE")) {
            this.productActionType = 0;
        } else if (string.startsWith("/INSERT")) {
            this.productActionType = 1;
        } else if (string.startsWith("/UPDATE")) {
            this.productActionType = 2;
        } else if (string.startsWith("/SYSTEMS")) {
            this.productImportType = 1;
        } else if (string.startsWith("/MONITORS")) {
            this.productImportType = 3;
        } else if (string.startsWith("/OPTIONS")) {
            this.productImportType = 2;
        }
    }

    private boolean parseCSVFile() {
        boolean bl = false;
        this.logProgress("Parsing import file", this.MAX_NUMBER_OF_STEPS, this.step++);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.importFilename));
            String string = null;
            int n = 0;
            if (this.productStrVec != null) {
                this.productStrVec.removeAllElements();
            } else {
                this.productStrVec = new Vector(10, 10);
            }
            while ((string = bufferedReader.readLine()) != null) {
                this.productStrVec.addElement(string);
                ++n;
            }
            if (this.productStrVec.size() == 0) {
                this.logError("The import file contains no data.");
                this.stopBatch();
            } else {
                bl = true;
                this.MAX_NUMBER_OF_STEPS += n;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            this.logSevereError(exception);
        }
        return bl;
    }

    private boolean processProductStrVec(Vector vector) {
        boolean bl = false;
        int n = vector.size();
        int n2 = 0;
        ProductDraft productDraft = null;
        try {
            if (this.productVec != null) {
                this.productVec.removeAllElements();
            } else {
                this.productVec = new Vector(10, 10);
            }
            while (n2 < n && this.continueImport) {
                productDraft = this.createProductDraft(vector.elementAt(n2).toString(), n2);
                if (productDraft != null) {
                    this.productVec.addElement(productDraft);
                    if (this.productImportType == 2) {
                        this.logProgress("Parsed PartNumber:    " + productDraft.getPartNumber().toString(), this.MAX_NUMBER_OF_STEPS, this.step++);
                    } else {
                        this.logProgress("Parsed ProductNumber: " + productDraft.getProdNum(), this.MAX_NUMBER_OF_STEPS, this.step++);
                    }
                    this.logProgress("       Description:   " + productDraft.getDescription(), this.MAX_NUMBER_OF_STEPS, this.step++);
                }
                ++n2;
            }
            if (this.productVec.size() == 0 || !this.continueImport) {
                if (this.productVec.size() == 0) {
                    this.logError("There are no products to import.");
                }
                this.stopBatch();
            } else {
                bl = true;
                this.logProgress("Parsing Complete. Please press the Commit button to commit these Products.", this.MAX_NUMBER_OF_STEPS, this.step++);
                this.parsingComplete = true;
                ProcessManagerSystem.removeProcess(this);
                this.pb_COMMIT.setEnabled(true);
            }
        }
        catch (Exception exception) {
            this.logSevereError(exception);
        }
        return bl;
    }

    private ProductDraft createProductDraft(String string, int n) {
        int n2 = 0;
        ProductDraft productDraft = null;
        boolean bl = true;
        ++n;
        try {
            productDraft = new ProductDraft();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens() && bl && this.continueImport) {
                if (n2 == 4 && this.productImportType == 2) {
                    ++n2;
                }
                bl = this.processProductString(productDraft, stringTokenizer.nextToken().trim(), n, n2);
                ++n2;
            }
            if (!this.continueImport) {
                productDraft = null;
            } else {
                if (bl && (n2 < 8 && this.productImportType != 2 || n2 < 7 && this.productImportType == 2)) {
                    this.logError("The product is missing one or more required fields on line: " + n);
                    bl = false;
                }
                if (!bl) {
                    productDraft = null;
                }
            }
        }
        catch (Exception exception) {
            this.logSevereError(exception);
            productDraft = null;
        }
        return productDraft;
    }

    private boolean processProductString(ProductDraft productDraft, String string, int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: {
                if (string.length() != 0) {
                    TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(string, "brand");
                    if (typeCategoryRec == null) {
                        this.logError("The brand on row " + n + " was not found. Brand:" + string);
                        break;
                    }
                    productDraft.setBrand(typeCategoryRec);
                    bl = true;
                    break;
                }
                this.logError("The Brand on row " + n + " is missing and is required.");
                break;
            }
            case 1: {
                if (string.length() != 0) {
                    TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(string, "family");
                    if (typeCategoryRec == null) {
                        this.logError("The Family on row " + n + " was not found. Family:" + string);
                        break;
                    }
                    productDraft.setFamily(typeCategoryRec);
                    bl = true;
                    break;
                }
                this.logError("The Family on row " + n + " is missing and is required.");
                break;
            }
            case 2: {
                if (this.productImportType == 2) {
                    if (string.length() != 0) {
                        this.partNumStr = new String(string);
                        bl = true;
                        break;
                    }
                    this.logError("The Part Number on row " + n + " is missing and is required.");
                    break;
                }
                bl = true;
                break;
            }
            case 3: {
                if (this.productImportType == 2) {
                    if (string.length() != 0) {
                        this.subCategoryStr = new String(string);
                        bl = true;
                        break;
                    }
                    this.logError("The OBI Family Type on row " + n + " is missing and is required.");
                    break;
                }
                if (string.length() != 0) {
                    this.machineStr = new String(string);
                    bl = true;
                    break;
                }
                this.logError("The Machine on row " + n + " is missing and is required.");
                break;
            }
            case 4: {
                if (string.length() != 0) {
                    this.modelStr = new String(string);
                    bl = true;
                    break;
                }
                this.logError("The Model on row " + n + " is missing and is required.");
                break;
            }
            case 5: {
                if (string.length() != 0) {
                    if (string.length() > 254) {
                        this.logError("The Description on row " + n + " exceeds the 254 character limit.");
                        break;
                    }
                    productDraft.setDescription(string);
                    bl = true;
                    break;
                }
                this.logError("The Description on row " + n + " is missing and is required.");
                break;
            }
            case 6: {
                if (string.length() != 0) {
                    bl = this.processLocaleString(productDraft, string, n);
                    break;
                }
                this.logError("The Locale on row " + n + " is missing and is required.");
                break;
            }
            case 7: {
                TypeCategoryRec typeCategoryRec = null;
                if (string.length() != 0) {
                    typeCategoryRec = TypeCategory.getCategoryFromDescription(string, "project", productDraft.getFamily().getInd());
                    if (typeCategoryRec != null) {
                        productDraft.setProject(typeCategoryRec);
                    } else {
                        typeCategoryRec = TypeCategory.createTypeCategory(productDraft.getFamily().getInd(), "Default", "project", 0, "N", "QUEST");
                        productDraft.setProject(typeCategoryRec);
                    }
                } else {
                    typeCategoryRec = TypeCategory.getCategoryFromDescription("Default", "project", productDraft.getFamily().getInd());
                    if (typeCategoryRec != null) {
                        productDraft.setProject(typeCategoryRec);
                    } else {
                        typeCategoryRec = TypeCategory.createTypeCategory(productDraft.getFamily().getInd(), "Default", "project", 0, "N", "QUEST");
                        productDraft.setProject(typeCategoryRec);
                    }
                }
                if (this.productImportType != 2) {
                    TypeCategoryRec typeCategoryRec2 = null;
                    TypeCategoryRec typeCategoryRec3 = null;
                    typeCategoryRec2 = TypeCategory.getCategoryFromDescription(this.machineStr, "machine", productDraft.getProject().getInd());
                    if (typeCategoryRec2 == null) {
                        productDraft.setMachine(TypeCategory.createTypeCategory(typeCategoryRec.getInd(), this.machineStr, "machine", 0, "N", "QUEST"));
                    } else {
                        productDraft.setMachine(typeCategoryRec2);
                    }
                    typeCategoryRec3 = TypeCategory.getCategoryFromDescription(this.modelStr, "model", productDraft.getMachine().getInd());
                    if (typeCategoryRec3 == null) {
                        productDraft.setModel(TypeCategory.lazyCreateTypeCategory(productDraft.getMachine().getInd(), this.modelStr, "model", 0, "N", "QUEST"));
                    } else {
                        productDraft.setModel(typeCategoryRec3);
                    }
                    bl = true;
                    break;
                }
                TypeCategoryRec typeCategoryRec4 = TypeCategory.getCategoryFromDescription(this.subCategoryStr, "subcategory", productDraft.getProject().getInd());
                TypeCategoryRec typeCategoryRec5 = null;
                if (typeCategoryRec4 == null) {
                    productDraft.setSubCategory(TypeCategory.createTypeCategory(typeCategoryRec.getInd(), this.subCategoryStr, "subcategory", 0, "N", "QUEST"));
                } else {
                    productDraft.setSubCategory(typeCategoryRec4);
                }
                typeCategoryRec5 = TypeCategory.getCategoryFromDescription(this.partNumStr, "partnum", productDraft.getSubCategory().getInd());
                if (typeCategoryRec5 == null) {
                    productDraft.setPartNumber(TypeCategory.lazyCreateTypeCategory(productDraft.getSubCategory().getInd(), this.partNumStr, "partnum", 0, "N", "QUEST"));
                } else {
                    productDraft.setPartNumber(typeCategoryRec5);
                }
                bl = true;
                break;
            }
            case 8: {
                if (string.length() != 0) {
                    if (string.length() > 1024) {
                        this.logError("The Comment on row " + n + " exceeds the 1024 character limit.");
                        break;
                    }
                    productDraft.setComment(string);
                    bl = true;
                    break;
                }
                this.logError("The Comment on row " + n + " is missing and is required.");
                break;
            }
            case 9: {
                if (string.length() != 0) {
                    int n3 = TypeList.getInstance().indFromString(string, 26);
                    if (n3 != 0) {
                        productDraft.setWarranty(n3);
                        bl = true;
                        break;
                    }
                    this.logError("The Warranty on row " + n + " was not found. Warranty:" + string);
                    break;
                }
                bl = true;
                break;
            }
            case 10: {
                if (string.length() != 0) {
                    productDraft.setOffering(TypeList.getInstance().indFromString(string, 24));
                }
                bl = true;
                break;
            }
            case 11: {
                if (string.length() != 0) {
                    productDraft.setCustomer(TypeList.getInstance().indFromString(string, 25));
                }
                bl = true;
                break;
            }
            default: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean processLocaleString(ProductDraft productDraft, String string, int n) {
        boolean bl = false;
        String string2 = string + ";";
        int n2 = 0;
        LocaleRec localeRec = new LocaleRec();
        ProductDate productDate = null;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        int n5 = 0;
        String string3 = null;
        int n6 = 0;
        while (!bl3 && !bl2 && this.continueImport) {
            n5 = string2.indexOf(":", n4);
            if (n5 == -1) {
                if (n4 >= string2.length()) {
                    productDraft.setLocale(localeRec);
                    bl3 = true;
                    bl = true;
                } else {
                    this.logError("The Country on row " + n + " is missing and is required.");
                    bl2 = true;
                }
            } else {
                n2 = TypeList.getInstance().indFromString(string2.substring(n4, n5).trim(), 3);
                if (n2 != 0) {
                    localeRec.addCountry(n2);
                } else {
                    this.logError("The Country on row " + n + " was not found. Country: " + string2.substring(n4, n5).trim());
                    bl2 = true;
                }
            }
            while (!bl3 && !bl2 && n3 < 10 && this.continueImport) {
                n4 = n5 + 1;
                n5 = string2.indexOf(";", n4);
                if (n4 == -1) {
                    this.logError("One or more dates in row " + n + " is missing and is required.");
                    bl2 = true;
                    continue;
                }
                switch (n3) {
                    case 0: {
                        productDate = new ProductDate(2);
                        break;
                    }
                    case 1: {
                        productDate = new ProductDate(4);
                        break;
                    }
                    case 2: {
                        productDate = new ProductDate(5);
                        break;
                    }
                    case 3: {
                        productDate = new ProductDate(1);
                        break;
                    }
                    case 4: {
                        productDate = new ProductDate(6);
                        break;
                    }
                    case 5: {
                        productDate = new ProductDate(9);
                        break;
                    }
                    case 6: {
                        productDate = new ProductDate(7);
                        break;
                    }
                    case 7: {
                        productDate = new ProductDate(8);
                        break;
                    }
                    case 8: {
                        productDate = new ProductDate(11);
                        break;
                    }
                    case 9: {
                        productDate = new ProductDate(10);
                        break;
                    }
                }
                string3 = CDate.format4DigitYear(string2.substring(n4, n5), 2);
                n6 = CDate.checkDate(string3, 2);
                if (n6 != 0) {
                    this.logError("A date in row " + n + " is formatted incorrectly.  The date was: " + string3);
                    bl2 = true;
                } else {
                    productDate.setActualDate(string3);
                    productDate.setCountryCodeInd(n2);
                    productDraft.addDate(productDate);
                }
                ++n3;
            }
            n4 = n5 + 1;
            n3 = 0;
        }
        if (!this.continueImport) {
            bl = false;
        }
        return bl;
    }

    public void commitImport() {
        boolean bl = true;
        boolean bl2 = false;
        if (this.productVec != null && this.productVec.size() > 0) {
            int n = 0;
            int n2 = this.productVec.size();
            ProductDraft productDraft = null;
            while (n < n2 && this.continueImport) {
                productDraft = (ProductDraft)this.productVec.elementAt(n);
                switch (this.checkForNewProduct(productDraft)) {
                    case 0: {
                        bl = this.importProductDraft(productDraft);
                        break;
                    }
                    case 1: {
                        bl = this.importCreateProductDraft(productDraft);
                        break;
                    }
                    case 2: {
                        if (this.productImportType == 2) {
                            this.logError("The Product Draft you attempted to import already exists for Part Number:" + productDraft.getPartNumber().toString());
                        } else {
                            this.logError("The Product Draft you attempted to import already exists for Product Number:" + productDraft.getProdNum());
                        }
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl2 = true;
                        break;
                    }
                }
                ++n;
                if (bl && !bl2) {
                    if (this.productImportType == 2) {
                        this.logProgress("Committed Product:" + productDraft.getPartNumber().toString(), this.MAX_NUMBER_OF_STEPS, this.step++);
                        continue;
                    }
                    this.logProgress("Committed Product:" + productDraft.getProdNum(), this.MAX_NUMBER_OF_STEPS, this.step++);
                    continue;
                }
                if (this.productImportType == 2) {
                    this.logProgress("Unable to commit Product:" + productDraft.getPartNumber().toString(), this.MAX_NUMBER_OF_STEPS, this.step++);
                    continue;
                }
                this.logProgress("Unable to commit Product:" + productDraft.getProdNum(), this.MAX_NUMBER_OF_STEPS, this.step++);
            }
            this.logProgress("Shutting Down", this.MAX_NUMBER_OF_STEPS, this.step++);
            this.logProgress("Batch Completed", this.MAX_NUMBER_OF_STEPS, this.step++);
        }
    }

    public int checkForNewProduct(ProductDraft productDraft) {
        int n = 1;
        int n2 = 0;
        try {
            if (this.productImportType == 2) {
                TypeCategoryRec typeCategoryRec = TypeCategory.getCategoryFromDescription(productDraft.getPartNumber().toString(), productDraft.getSubCategory().getInd());
                TypeCategoryRec typeCategoryRec2 = TypeCategory.getDraftCategoryFromDescription(productDraft.getProject().toString(), "project", productDraft.getFamily().getInd());
                TypeCategoryRec typeCategoryRec3 = null;
                TypeCategoryRec typeCategoryRec4 = null;
                if (typeCategoryRec2 != null) {
                    typeCategoryRec3 = TypeCategory.getDraftCategoryFromDescription(productDraft.getSubCategory().toString(), "subcategory", typeCategoryRec2.getInd());
                }
                if (typeCategoryRec3 != null) {
                    typeCategoryRec4 = TypeCategory.getDraftCategoryFromDescription(productDraft.getPartNumber().toString(), "partnum", typeCategoryRec3.getInd());
                }
                if (typeCategoryRec4 != null && (n2 = ProductSQL.getDraftProductIndFromModel(typeCategoryRec4)) != 0 && this.draftExists(n2)) {
                    n = 2;
                }
                if (n != 2) {
                    if (typeCategoryRec != null) {
                        n2 = ProductSQL.getProductIndFromModel(typeCategoryRec);
                        if (n2 == 0) {
                            n = 0;
                        }
                    } else {
                        n = 0;
                    }
                }
            } else {
                TypeCategoryRec typeCategoryRec;
                TypeCategoryRec typeCategoryRec5 = TypeCategory.getCategoryFromDescription(productDraft.getMachine().toString(), productDraft.getProject().getInd());
                TypeCategoryRec typeCategoryRec6 = TypeCategory.getDraftCategoryFromDescription(productDraft.getProject().toString(), "project", productDraft.getFamily().getInd());
                TypeCategoryRec typeCategoryRec7 = null;
                if (typeCategoryRec6 != null) {
                    typeCategoryRec7 = TypeCategory.getDraftCategoryFromDescription(productDraft.getMachine().toString(), "machine", typeCategoryRec6.getInd());
                }
                if (typeCategoryRec7 != null && (typeCategoryRec = TypeCategory.getDraftCategoryFromDescription(productDraft.getModel().toString(), "model", typeCategoryRec7.getInd())) != null && (n2 = ProductSQL.getDraftProductIndFromModel(typeCategoryRec)) != 0 && this.draftExists(n2)) {
                    n = 2;
                }
                if (n != 2) {
                    if (typeCategoryRec5 != null) {
                        typeCategoryRec = TypeCategory.getCategoryFromDescription(productDraft.getModel().toString(), typeCategoryRec5.getInd());
                        if (typeCategoryRec != null) {
                            n2 = ProductSQL.getProductIndFromModel(typeCategoryRec);
                            if (n2 == 0) {
                                n = 0;
                            }
                        } else {
                            n = 0;
                        }
                    } else {
                        n = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logError(exception.toString());
            n = -1;
        }
        return n;
    }

    private boolean importProductDraft(ProductDraft productDraft) {
        boolean bl = false;
        int n = 0;
        if (this.productActionType == 2) {
            if (this.productImportType == 2) {
                this.logError("The Product Draft could not be updated. A Product with Part Number:" + productDraft.getPartNumber().toString() + " does not exist.");
            } else {
                this.logError("The Product Draft could not be updated. A Product with Product Number:" + productDraft.getProdNum() + " does not exist.");
            }
        } else {
            productDraft.setProductType(this.productImportType);
            productDraft.setLastTouchedBy(this.userId);
            productDraft.setWorkRequired(1);
            productDraft.setCreatedBy(this.userId);
            productDraft.setInput("Author");
            productDraft.setSource(this.userId);
            n = productDraft.writeToDatabase();
            if (n == 0) {
                bl = true;
            } else {
                this.logError("The Product Draft could not be imported due to SQL Error: " + n);
            }
        }
        return bl;
    }

    private boolean importCreateProductDraft(ProductDraft productDraft) {
        boolean bl;
        block23: {
            bl = false;
            CreateProductDraft createProductDraft = null;
            ProductDraft productDraft2 = null;
            String string = null;
            String string2 = null;
            int n = 0;
            Object var8_8 = null;
            Object var9_9 = null;
            Object var10_10 = null;
            try {
                if (this.productActionType == 1) {
                    if (this.productImportType == 2) {
                        this.logError("The Product Draft could not be inserted.  A Product already exists for Part Number:" + productDraft.getPartNumber().toString());
                    } else {
                        this.logError("The Product Draft could not be inserted.  A Product already exists for Product Number:" + productDraft.getProdNum());
                    }
                    break block23;
                }
                createProductDraft = this.productImportType == 2 ? ProductDraft.createProductDraft(productDraft.getPartNumber().toString()) : ProductDraft.createProductDraft(productDraft.getFamily(), productDraft.getMachine().toString(), productDraft.getModel().toString());
                switch (createProductDraft.getReturnCode()) {
                    case 4: {
                        productDraft2 = createProductDraft.getProductDraft();
                        string2 = productDraft2.getPublish();
                        if (this.productActionType == 2 && string2.equals("N")) {
                            if (this.productImportType == 2) {
                                this.logError("The Product Draft could not be updated. A Product with Part Number:" + productDraft2.getPartNumber().toString() + " does not exist.");
                                break;
                            }
                            this.logError("The Product Draft could not be updated. A Product with Product Number:" + productDraft2.getProdNum() + " does not exist.");
                            break;
                        }
                        productDraft2.setCustomer(productDraft.getCustomer());
                        productDraft2.setDates(productDraft.getDates());
                        productDraft2.setDescription(productDraft.getDescription());
                        productDraft2.setLocale(productDraft.getLocale());
                        productDraft2.setOffering(productDraft.getOffering());
                        productDraft2.setWarranty(productDraft.getWarranty());
                        productDraft2.setProductType(this.productImportType);
                        productDraft2.setLastTouchedBy(this.userId);
                        productDraft2.setInput("Author");
                        if (this.productActionType == 2 || this.productActionType == 0 && string2.equals("Y")) {
                            productDraft2.setWorkRequired(2);
                            string = productDraft2.getSource();
                            if (string.startsWith("OPIC/M")) {
                                productDraft2.setSource(new String(string + "-" + this.userId));
                            } else {
                                productDraft2.setSource(this.userId);
                            }
                            n = productDraft2.writeToDatabase();
                            if (n == 0) {
                                bl = true;
                                break;
                            }
                            this.logError("The Product Draft could not be imported due to SQL Error: " + n);
                        }
                        break;
                    }
                    case 1: {
                        if (this.productImportType == 2) {
                            this.logError("The Product Draft you attempted to import already exists for Part Number:" + productDraft.getPartNumber().toString());
                            break;
                        }
                        this.logError("The Product Draft you attempted to import already exists for Product Number:" + productDraft.getProdNum());
                        break;
                    }
                    case 3: {
                        if (this.productImportType == 2) {
                            this.logError("The Product Draft you attempted to import for Part Number:" + productDraft2.getPartNumber().toString() + " already exists and is a misfit");
                            break;
                        }
                        this.logError("The Product Draft you attempted to import for Product Number:" + productDraft2.getProdNum() + " already exists and is a misfit");
                        break;
                    }
                    case 2: {
                        if (this.productImportType == 2) {
                            this.logError("The Product Draft you attempted to import already exists and is in the recycling bin for Part Number:" + productDraft2.getPartNumber().toString());
                            break;
                        }
                        this.logError("The Product Draft you attempted to import already exists and is in the recycling bin for Product Number:" + productDraft2.getProdNum());
                        break;
                    }
                    case 5: {
                        if (this.productImportType == 2) {
                            this.logError("The Product Draft could not be created due to SQL Error: " + createProductDraft.getSqlCode() + " for Part Number:" + productDraft.getPartNumber().toString());
                            break;
                        }
                        this.logError("The Product Draft could not be created due to SQL Error: " + createProductDraft.getSqlCode() + " for Product Number:" + productDraft.getProdNum());
                        break;
                    }
                    default: {
                        if (this.productImportType == 2) {
                            this.logError("The Product Draft could not be created due to an error for Part Number:" + productDraft.getPartNumber().toString());
                            break;
                        }
                        this.logError("The Product Draft could not be created due to an error for Product Number:" + productDraft.getProdNum());
                        break;
                    }
                }
            }
            catch (Exception exception) {
                this.logSevereError(exception);
                this.logError(exception.toString());
            }
        }
        return bl;
    }

    public String getProcessName() {
        return Str.getStr(17009);
    }

    public void stopProcess() {
        this.continueImport = false;
        this.logProgress("**Product Import was stopped by user request.**", this.MAX_NUMBER_OF_STEPS, this.step++);
    }

    public void setButtons(ActionButton actionButton, ActionButton actionButton2) {
        this.pb_COMMIT = actionButton;
        this.pb_RERUN = actionButton2;
        this.pb_COMMIT.addActionListener(this);
        this.pb_RERUN.addActionListener(this);
    }

    public void rerun() {
        this.stopBatch();
        this.MAX_NUMBER_OF_STEPS = 12;
        this.logProgress("Rerunning the Batch", this.MAX_NUMBER_OF_STEPS, this.step++);
        this.startBatch();
    }

    public boolean draftExists(int n) {
        Object var2_2 = null;
        SQLMethod sQLMethod = new SQLMethod(1, "ProductImport.findDraft ( " + n + " )", 5);
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT PRODUCTIND FROM PRODRAFT.PRODUCT WHERE PRODUCTIND = " + n + " AND STOPDATE IS NULL FOR FETCH ONLY");
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return bl;
    }

    public ProductImport(String[] stringArray) {
        this.continueImport = this.readParams(stringArray);
    }
}

