/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.promail;

import com.ibm.nzna.projects.common.quest.doc.DocumentRow;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.promail.ProMailSQL;
import com.ibm.nzna.projects.qit.promail.ProMailSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ProMailPreviewPane
extends JPanel
implements Runnable,
AppConst {
    private static final String THREAD_REFRESHDATA = "REFRESH";
    private JTextArea mle_MAIL = null;
    private JScrollPane scr_MAIL = null;
    private JLabel st_IMAGE = null;
    private JLabel st_SENTBY = null;
    private JLabel stt_SENTBY = null;
    private JLabel st_SENTON = null;
    private JLabel stt_SENTON = null;
    private DocumentRow document = null;
    private Dimension prefSize = new Dimension(100, 100);

    private void createControls() {
        this.mle_MAIL = new JTextArea(Str.getStr(355));
        this.scr_MAIL = new JScrollPane(this.mle_MAIL);
        this.st_IMAGE = new JLabel(ImageSystem.getImageIcon((Object)this, 48));
        this.st_SENTBY = new JLabel(Str.getStr(658));
        this.stt_SENTBY = new JLabel("-");
        this.st_SENTON = new JLabel(Str.getStr(790));
        this.stt_SENTON = new JLabel("-");
        this.stt_SENTBY.setForeground(Color.blue);
        this.stt_SENTON.setForeground(Color.blue);
        this.mle_MAIL.setFont(new Font("Courier", 0, 12));
        this.mle_MAIL.setEditable(false);
        this.setBackground(new Color(230, 230, 230));
        this.scr_MAIL.setBorder(null);
        this.setLayout(null);
        this.add(this.scr_MAIL);
        this.add(this.st_IMAGE);
        this.add(this.st_SENTON);
        this.add(this.stt_SENTON);
        this.add(this.st_SENTBY);
        this.add(this.stt_SENTBY);
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_IMAGE.setBounds(n, n2, 45, 45);
        this.st_SENTBY.setBounds(n + 50, n2, 100, n3);
        this.stt_SENTBY.setBounds(n + 150, n2, 200, n3);
        this.st_SENTON.setBounds(n + 50, n2 += n3, 100, n3);
        this.stt_SENTON.setBounds(n + 150, n2, 200, n3);
        this.scr_MAIL.setBounds(0, n2 += n3 + 10, dimension.width, dimension.height - n2);
    }

    public void setDocument(DocumentRow documentRow) {
        if (documentRow != null) {
            if (this.document != documentRow) {
                this.document = documentRow;
                new Thread((Runnable)this, THREAD_REFRESHDATA).start();
            }
        } else {
            this.stt_SENTBY.setText("-");
            this.stt_SENTON.setText("-");
            this.mle_MAIL.setText("");
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_REFRESHDATA)) {
            this.refreshData();
        }
    }

    private void refreshData() {
        if (this.document != null) {
            String string = ProMailSQL.getSentTime(this.document.getFilename());
            if (string == null || string.length() == 0) {
                string = Str.getStr(791);
            }
            this.stt_SENTON.setText(string);
            this.stt_SENTBY.setText(UserSystem.getNameFromUserId(this.document.getLastTouchedBy()));
            if (this.document.readDocument(false) == 0) {
                String string2 = null;
                string2 = ProMailSystem.createEMailPreview(this.document.getDocument());
                if (string2 != null && string2.length() > 0) {
                    this.mle_MAIL.setText(string2);
                } else {
                    this.mle_MAIL.setText(Str.getStr(792));
                }
            } else {
                this.mle_MAIL.setText("Cannot read document");
            }
        }
        this.invalidate();
        this.revalidate();
    }

    public ProMailPreviewPane() {
        this.createControls();
    }
}

