/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.web;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.bookmark.AddBookmarkDlg;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.Browser;
import com.ibm.nzna.projects.qit.gui.BrowserListener;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.ToolBarButton;
import com.ibm.nzna.projects.qit.web.WebBrowserNavPanel;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.util.Text;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class WebBrowserPanel
extends JPanel
implements BrowserListener,
Authority,
QuestPanel,
AppConst,
ActionListener,
DocConst {
    private Browser browser = null;
    private JTextField ef_URL = null;
    private DButton pb_GO = null;
    private WebBrowserNavPanel navPanel = null;
    private AppDefaultWin parentWin = null;
    private String prevStatus = null;
    private JToolBar toolBar = null;
    private ToolBarButton pb_BACK = null;
    private ToolBarButton pb_FORWARD = null;
    private ToolBarButton pb_HOME = null;
    private ActionButton pb_EDIT = null;
    private ActionButton pb_CLOSE = null;
    private boolean lastSearchDidRequests = false;

    public boolean initialize() {
        JLabel jLabel = null;
        JPanel jPanel = null;
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(203));
        this.pb_EDIT = new ActionButton(Str.getStr(50), ImageSystem.getImageIcon((Object)this, 56), Str.getStr(50));
        this.browser = GUISystem.createBrowser();
        this.ef_URL = new JTextField();
        this.pb_GO = new DButton(Str.getStr(112));
        jPanel = new JPanel();
        jLabel = new JLabel(Str.getStr(111));
        this.navPanel = new WebBrowserNavPanel(this);
        this.toolBar = new JToolBar();
        this.pb_BACK = new ToolBarButton(Str.getStr(34), ImageSystem.getImageIcon((Object)this, 15), Str.getStr(35));
        this.pb_FORWARD = new ToolBarButton(Str.getStr(36), ImageSystem.getImageIcon((Object)this, 16), Str.getStr(37));
        this.ef_URL.addActionListener(this);
        this.pb_GO.addActionListener(this);
        this.browser.addBrowserListener(this);
        this.pb_BACK.addActionListener(this);
        this.pb_FORWARD.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_EDIT.addActionListener(this);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setOpaque(false);
        this.setLayout(new BorderLayout(4, 4));
        jPanel.setLayout(new BorderLayout(4, 4));
        this.add((Component)jPanel, "North");
        jPanel.add((Component)this.ef_URL, "Center");
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)this.pb_GO, "East");
        this.add(this.browser.getComponent(), "Center");
        this.toolBar.add((Component)this.pb_BACK, 0);
        this.toolBar.add((Component)this.pb_FORWARD, 1);
        this.toolBar.add((Component)new ToolBarSeparator(), 2);
        return true;
    }

    public boolean copyText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        this.ef_URL.setText("Pasted!");
        return true;
    }

    public void refresh() {
        this.browser.reload();
    }

    public JComponent getJComponent() {
        return this;
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 18);
    }

    public NavPanel getDefaultNavPanel() {
        return this.navPanel;
    }

    public boolean shutdown() {
        return true;
    }

    public boolean stop() {
        this.removeAll();
        GUISystem.getParentDefWin(this).removeToolbarButton(this.toolBar);
        this.browser = null;
        return true;
    }

    protected void gotoURL(String string) {
        this.ef_URL.setText(string);
        this.loadURL();
    }

    public void start() {
        this.parentWin = GUISystem.getParentDefWin(this);
        this.parentWin.addActionComponent(this, this.pb_CLOSE);
        this.parentWin.addActionComponent(this, this.pb_EDIT);
        this.addToolBarButtons();
        this.ef_URL.requestFocus();
    }

    public String getName() {
        return Str.getStr(104);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ef_URL || actionEvent.getSource() == this.pb_GO) {
            this.gotoURL(this.ef_URL.getText());
        } else if (actionEvent.getSource() == this.pb_BACK) {
            this.browser.back();
        } else if (actionEvent.getSource() == this.pb_FORWARD) {
            this.browser.forward();
        } else if (actionEvent.getSource() == this.pb_CLOSE) {
            GUISystem.getParentDefWin(this).closePanel(this, null);
        } else if (actionEvent.getSource() == this.pb_EDIT) {
            this.editPage();
        }
    }

    private String fixURL(String string) {
        return string;
    }

    private void loadURL() {
        this.browser.loadURL(this.ef_URL.getText());
    }

    public void pageStarted(String string) {
        this.ef_URL.setText(string);
        this.parentWin.setStatus(Str.getStr(137) + " " + string);
        this.pb_BACK.setEnabled(this.browser.canGoBack());
        this.pb_FORWARD.setEnabled(this.browser.canGoForward());
    }

    public void pageStopped() {
        if (this.parentWin != null) {
            this.parentWin.setStatus(this.prevStatus);
        }
        this.pb_BACK.setEnabled(this.browser.canGoBack());
        this.pb_FORWARD.setEnabled(this.browser.canGoForward());
    }

    public void mouseLinkExit() {
        if (this.parentWin != null) {
            this.parentWin.setStatus(this.prevStatus, false);
        }
        this.prevStatus = null;
    }

    public void mouseOverLink(String string) {
        this.prevStatus = this.parentWin.getStatus();
        this.parentWin.setStatus(string);
    }

    public void panelSelected() {
        this.addToolBarButtons();
    }

    public void panelDeselected() {
        GUISystem.getParentDefWin(this).removeToolbarButton(this.toolBar);
    }

    public void addToolBarButtons() {
        GUISystem.getParentDefWin(this).addToolbarButton(this.toolBar, 0);
    }

    public boolean bookmark() {
        String string = this.ef_URL.getText();
        if (string != null && string.length() > 0) {
            Bookmark bookmark = new Bookmark();
            bookmark.setObject(string, 10);
            bookmark.updateRecStatus(2);
            new AddBookmarkDlg((Frame)GUISystem.getParentDefWin(this), bookmark);
        }
        return true;
    }

    public void editPage() {
        String string = this.ef_URL.getText();
        if (UserSystem.hasAuthority(4) && (UserSystem.hasAuthority(20) || UserSystem.hasAuthority(5))) {
            try {
                if (string.indexOf("pc.ibm.com") >= 0 || string.indexOf("w3.ibm.com") >= 0) {
                    int n;
                    int n2 = n = string.indexOf(".html") + 5;
                    String string2 = null;
                    n = string.lastIndexOf("/", n2) + 1;
                    string2 = string.substring(n, n2);
                    if (string2.indexOf("html") != -1) {
                        this.editDocument(Text.replaceInStr(string2, ".html", ""));
                    } else {
                        GUISystem.printBox(7, 1064);
                    }
                } else {
                    GUISystem.printBox(7, 1064);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GUISystem.printBox(7, 1064);
            }
        }
    }

    private void editDocument(String string) {
        GUISystem.printBox("ERROR", "NOT IMPLEMENTED! - WebBrowserPanel.editDocument");
    }

    public boolean linkClicked(String string) {
        this.ef_URL.setText(string);
        return true;
    }

    public void statusChange(String string, int n, int n2) {
        this.parentWin.setStatus(string);
        this.parentWin.setValueMax(n2);
        this.parentWin.setValue(n);
    }
}

