/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.workspace;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.AppletRec;
import com.ibm.nzna.projects.qit.app.AppletSystem;
import com.ibm.nzna.projects.qit.app.AppletSystemListener;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.QuestApplet;
import com.ibm.nzna.projects.qit.app.QuestAppletNotFoundException;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.UserStatPanel;
import com.ibm.nzna.projects.qit.workspace.DesktopPanel;
import com.ibm.nzna.projects.qit.workspace.FirstAppletRunDlg;
import com.ibm.nzna.projects.qit.workspace.WorkspaceWhatsNew;
import com.ibm.nzna.shared.gui.DButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WorkspacePanel
extends JPanel
implements PropertyListener,
QuestPanel,
AppConst,
AppletSystemListener,
ActionListener {
    private static WorkspacePanel instance = null;
    private Image backgroundImage = null;
    private UserStatPanel userStatPanel = null;
    private JScrollPane deskScrollPane = null;
    private DesktopPanel desktopPanel = null;
    private long lastAppletRecTime = 0L;
    private AppletRec lastAppletRec = null;
    private boolean skinned = false;
    private boolean firstAppletStarted = false;

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 34);
    }

    public JComponent getJComponent() {
        return this;
    }

    public Object notification(Component component, String string, Object object, Object object2) {
        return null;
    }

    public boolean shutdown() {
        return true;
    }

    public boolean stop() {
        AppletSystem.removeAppletSystemListener(this);
        PropertySystem.removePropertyListener(1, this);
        PropertySystem.removePropertyListener(9, this);
        return true;
    }

    public boolean initialize() {
        this.userStatPanel = new UserStatPanel();
        this.desktopPanel = new DesktopPanel();
        this.deskScrollPane = new JScrollPane(this.desktopPanel);
        this.setBackground(Color.white);
        this.deskScrollPane.setBackground(Color.white);
        this.deskScrollPane.setBackground(Color.white);
        this.skinned = PropertySystem.getBool(9);
        if (this.skinned) {
            this.deskScrollPane.setBorder(null);
        }
        AppletSystem.addAppletSystemListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.deskScrollPane, "Center");
        this.refreshApplets();
        PropertySystem.addPropertyListener(1, this);
        PropertySystem.addPropertyListener(9, this);
        this.setOpaque(true);
        return true;
    }

    public void start() {
        AppletRec appletRec;
        String string = PropertySystem.getString(76);
        new WorkspaceWhatsNew(this);
        if (string != null && string.length() > 0 && (appletRec = AppletSystem.getAppletFromName(string)) != null) {
            AppletSystem.createApplet(appletRec);
        }
    }

    public NavPanel getDefaultNavPanel() {
        return this.userStatPanel;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public boolean copyText() {
        return false;
    }

    public void refresh() {
    }

    public void appletRemoved() {
        this.refreshApplets();
    }

    public void appletAdded() {
        this.refreshApplets();
    }

    private void refreshApplets() {
        Vector vector = AppletSystem.getAppletList();
        int n = 0;
        DButton dButton = null;
        AppletRec appletRec = null;
        boolean bl = true;
        this.desktopPanel.removeAll();
        if (vector != null) {
            int n2 = vector.size();
            while (n < n2) {
                QuestApplet questApplet = null;
                appletRec = (AppletRec)vector.elementAt(n);
                try {
                    questApplet = appletRec.createQuestApplet();
                    if (UserSystem.hasAuthority(questApplet.getAuthority())) {
                        dButton = new DButton(appletRec.getName(), appletRec.getIcon());
                        this.desktopPanel.add(dButton);
                        dButton.addActionListener(this);
                        dButton.setOpaque(false);
                        dButton.setFocusPainted(false);
                        dButton.setBorder(null);
                        dButton.actAsLink(true);
                        dButton.setHighlightForeground(Color.blue);
                        dButton.setVerticalTextPosition(3);
                        dButton.setVerticalAlignment(1);
                        dButton.setHorizontalTextPosition(0);
                    }
                }
                catch (QuestAppletNotFoundException questAppletNotFoundException) {
                    GUISystem.printBox(Str.getStr(7), Str.getStr(1293) + ": " + appletRec.getClassName());
                }
                ++n;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof DButton) {
            long l;
            String string = ((DButton)actionEvent.getSource()).getText();
            AppletRec appletRec = AppletSystem.getAppletFromName(string);
            boolean bl = true;
            if (this.lastAppletRec != null && appletRec.equals(this.lastAppletRec) && (l = System.currentTimeMillis()) - this.lastAppletRecTime < 500L) {
                bl = false;
            }
            if (appletRec != null && bl) {
                AppletSystem.createApplet(appletRec);
                if (!this.firstAppletStarted) {
                    String string2 = PropertySystem.getString(76);
                    if (string2 == null || string2.length() < 3) {
                        String string3 = PropertySystem.getString(74);
                        int n = PropertySystem.getInt(75);
                        if (string3.equals(appletRec.getName())) {
                            PropertySystem.putInt(75, ++n);
                            if (n > 5 && PropertySystem.getBool(77)) {
                                switch (new FirstAppletRunDlg((Frame)GUISystem.getParentDefWin(this), appletRec.getName()).getResult()) {
                                    case 1: {
                                        PropertySystem.putString(76, appletRec.getName());
                                        break;
                                    }
                                    case 2: {
                                        PropertySystem.putInt(75, 0);
                                        break;
                                    }
                                    case 3: {
                                        PropertySystem.putBool(77, false);
                                        break;
                                    }
                                }
                            }
                        } else {
                            PropertySystem.putString(74, appletRec.getName());
                        }
                    }
                    this.firstAppletStarted = true;
                }
            }
            this.lastAppletRec = appletRec;
            this.lastAppletRecTime = System.currentTimeMillis();
        }
    }

    public String getName() {
        return Str.getStr(110);
    }

    public void panelSelected() {
    }

    public void panelDeselected() {
    }

    public void propertyChanged(int n, Object object) {
        if (n == 1) {
            this.refreshApplets();
        } else if (n == 9) {
            this.skinned = (Boolean)object;
            if (this.skinned) {
                this.deskScrollPane.setBorder(null);
            } else {
                this.deskScrollPane.setBorder(GUISystem.loweredBorder);
            }
        }
    }

    public boolean bookmark() {
        return false;
    }

    public static WorkspacePanel getInstance() {
        return instance;
    }

    public WorkspacePanel() {
        instance = this;
    }
}

