/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.scrape;

import com.ibm.nzna.projects.scrape.SmallDoc;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.ftp.FTPFile;
import com.ibm.nzna.shared.ftp.FTPManager;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.StandardPropertyLoader;
import com.ibm.nzna.shared.util.Text;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Scrape {
    static Properties properties = new Properties();
    static String outFile = "scrappy.txt";
    static String logFile = "scrape.out";
    static String ftpSite = "";
    static String ftpDir = "";
    static Hashtable docs = new Hashtable();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        boolean bl = false;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        long l3 = 0L;
        if (stringArray == null || stringArray.length < 3) {
            System.out.println("Usage: java com.ibm.nzna.projects.scrape.Scrape <databaseName> <databaseServer> <portNumber>");
            System.exit(-1);
        }
        try {
            Properties properties = StandardPropertyLoader.load("scrape.properties");
            if (properties != null) {
                outFile = properties.getProperty("outFile", "scrappy.txt");
                ftpSite = properties.getProperty("publishFTPSite", "f3.pc.ibm.com");
                ftpDir = properties.getProperty("publishFTPDir", "/home/ftp/pub/pccbbs/incoming/scrappy");
                logFile = properties.getProperty("outputLog", "/home/quest/logs/scrape.out");
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, "Cannot load scrape.property");
            LogSystem.log(1, exception, false);
            bl = true;
        }
        new LogSystem(1, logFile);
        if (bl) {
            LogSystem.log(1, "Loading Default Properties");
            outFile = "scrappy.txt";
            ftpSite = "ftp.pc.ibm.com";
            ftpDir = "/pub/pccbbs/etsosurvey/scrappy";
        }
        if (Scrape.connectToDatabase(stringArray[0], stringArray[1], stringArray[2])) {
            if (Scrape.readInfo() && Scrape.readCountryInfo() && Scrape.writeFile()) {
                Scrape.publishFile();
            }
            DatabaseSystem.shutdown();
        }
        LogSystem.beginLogSection("Batch Run Stats");
        l2 = System.currentTimeMillis();
        l3 = l2 - l;
        LogSystem.log(1, "Total Run Time:" + l3 + "(ms)");
        System.exit(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean connectToDatabase(String string, String string2, String string3) {
        boolean bl = false;
        try {
            new DatabaseSystem(true, LogSystem.getInstance(), false);
            bl = DatabaseSystem.createConnection(1, string, string2, string3, "quest", "k1ngarthur");
            LogSystem.log(1, "Connected to database " + string + " on Server " + string2);
            return bl;
        }
        catch (Exception exception) {
            bl = false;
            LogSystem.log(1, exception, false);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean readInfo() {
        SQLMethod sQLMethod = new SQLMethod(1, "readInfo", 5);
        SmallDoc smallDoc = null;
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            resultSet = statement.executeQuery("SELECT DOC.DOCIND, DOC.LNDOCID,      DOC.TITLE,            TYPECLASS.DESCRIPT, " + "       TYPEGEO.DESCRIPT, TYPEBRAND.DESCRIPT, DOC.WEBABLE " + "FROM TIGRIS.DOCUMENTS       DOC," + "     TIGRIS.DOCBRAND        DOCBRAND, " + "     TIGRIS.DOCGEO          DOCGEO, " + "     TIGRIS.TYPEGEOGRAPHY   TYPEGEO," + "     TIGRIS.TYPEBRAND       TYPEBRAND, " + "     TIGRIS.TYPEDOCCLASS    TYPECLASS, " + "     TIGRIS.BRANDS          BRANDS " + "WHERE DOCBRAND.DOCIND            = DOC.DOCIND AND " + "      BRANDS.BRANDGROUPIND       = DOCBRAND.BRANDGROUPIND AND " + "      TYPEBRAND.BRANDIND         = BRANDS.BRANDIND AND " + "      DOCGEO.DOCIND              = DOC.DOCIND AND " + "      TYPEGEO.GEOIND             = DOCGEO.GEOIND AND " + "      TYPECLASS.DOCCLASSIND      = DOC.DOCCLASSIND AND " + "      DOC.LNDOCID IS NOT NULL AND " + "      DOC.PUBLISH                = 'Y' FOR FETCH ONLY");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    bl = true;
                    break;
                }
                smallDoc = (SmallDoc)docs.get("" + resultSet.getInt(1));
                if (smallDoc != null) {
                    if (smallDoc.geography.indexOf(resultSet.getString(5).trim()) != -1) continue;
                    smallDoc.geography = smallDoc.geography + ";" + resultSet.getString(5).trim();
                    continue;
                }
                smallDoc = new SmallDoc();
                smallDoc.lnDocId = resultSet.getString(2).trim();
                smallDoc.title = resultSet.getString(3).trim();
                smallDoc.classification = resultSet.getString(4).trim();
                smallDoc.geography = resultSet.getString(5).trim();
                smallDoc.brand = resultSet.getString(6).trim();
                smallDoc.webable = resultSet.getString(7).trim();
                docs.put("" + resultSet.getInt(1), smallDoc);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean readCountryInfo() {
        SQLMethod sQLMethod = new SQLMethod(1, "readCountryInfo", 5);
        SmallDoc smallDoc = null;
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            LogSystem.log(1, "Entering Phase 2");
            resultSet = statement.executeQuery("SELECT DOCCOUNTRY.DOCIND,  TYPECOUNTRYCODE.DESCRIPT, TYPEGEO.DESCRIPT,  " + "       DOCUMENTS.TITLE,    DOCUMENTS.LNDOCID,        TYPEDOCCLASS.DESCRIPT, " + "       TYPEBRAND.DESCRIPT, DOCUMENTS.WEBABLE " + "FROM TIGRIS.DOCCOUNTRY      DOCCOUNTRY, " + "     TIGRIS.TYPECOUNTRYCODE TYPECOUNTRYCODE, " + "     TIGRIS.TYPEGEOGRAPHY   TYPEGEO, " + "     TIGRIS.GEOCOUNTRY      GEOCOUNTRY, " + "     TIGRIS.DOCUMENTS       DOCUMENTS, " + "     TIGRIS.TYPEDOCCLASS    TYPEDOCCLASS, " + "     TIGRIS.TYPEBRAND       TYPEBRAND, " + "     TIGRIS.DOCBRAND        DOCBRAND, " + "     TIGRIS.BRANDS          BRANDS " + "WHERE DOCCOUNTRY.COUNTRYCODEIND      = GEOCOUNTRY.COUNTRYCODEIND AND " + "      TYPEGEO.GEOIND                 = GEOCOUNTRY.GEOIND AND " + "      TYPECOUNTRYCODE.COUNTRYCODEIND = DOCCOUNTRY.COUNTRYCODEIND AND " + "      DOCUMENTS.DOCIND               = DOCCOUNTRY.DOCIND AND " + "      DOCUMENTS.PUBLISH              = 'Y' AND " + "      TYPEDOCCLASS.DOCCLASSIND       = DOCUMENTS.DOCCLASSIND AND " + "      DOCBRAND.DOCIND                = DOCCOUNTRY.DOCIND AND " + "      BRANDS.BRANDGROUPIND           = DOCBRAND.BRANDGROUPIND AND " + "      DOCUMENTS.LNDOCID              IS NOT NULL AND " + "      TYPEBRAND.BRANDIND             = BRANDS.BRANDIND FOR FETCH ONLY");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    bl = true;
                    break;
                }
                smallDoc = (SmallDoc)docs.get("" + resultSet.getInt(1));
                if (smallDoc != null) {
                    if (smallDoc.geography.indexOf(resultSet.getString(3).trim()) == -1) {
                        smallDoc.geography = smallDoc.geography + ";" + resultSet.getString(3).trim();
                    }
                    if (smallDoc.country.indexOf(resultSet.getString(2).trim()) != -1) continue;
                    smallDoc.country = smallDoc.country + ";" + resultSet.getString(2).trim();
                    continue;
                }
                smallDoc = new SmallDoc();
                smallDoc.country = resultSet.getString(2).trim();
                smallDoc.geography = resultSet.getString(3).trim();
                smallDoc.title = resultSet.getString(4).trim();
                smallDoc.lnDocId = resultSet.getString(5).trim();
                smallDoc.classification = resultSet.getString(6).trim();
                smallDoc.brand = resultSet.getString(7).trim();
                smallDoc.webable = resultSet.getString(8).trim();
                docs.put("" + resultSet.getInt(1), smallDoc);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, "Exception while processing Countries.");
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean writeFile() {
        File file = new File(outFile);
        FileOutputStream fileOutputStream = null;
        SmallDoc smallDoc = null;
        Enumeration enumeration = null;
        boolean bl = true;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception exception) {
            LogSystem.log(1, "Cannot open out file " + outFile + " for writing");
            LogSystem.log(1, exception, false);
            bl = false;
        }
        if (fileOutputStream == null) return bl;
        enumeration = docs.elements();
        while (enumeration.hasMoreElements()) {
            try {
                smallDoc = (SmallDoc)enumeration.nextElement();
                if (smallDoc == null) continue;
                if (smallDoc.title.indexOf("|") >= 0) {
                    smallDoc.title = Text.replaceAllStrInStr(smallDoc.title, "|", " ");
                }
                if (smallDoc.title.indexOf("\n") >= 0) {
                    smallDoc.title = Text.replaceAllStrInStr(smallDoc.title, "\n", " ");
                }
                fileOutputStream.write(new String(smallDoc.lnDocId + "|" + smallDoc.title + "|" + smallDoc.classification + "|" + smallDoc.geography + "|" + smallDoc.country + "|" + smallDoc.brand + "|" + smallDoc.webable + "\n").getBytes());
            }
            catch (Exception exception) {
                LogSystem.log(1, "Exception caught writing file");
                LogSystem.log(1, exception, false);
                bl = false;
            }
        }
        try {
            fileOutputStream.close();
            return bl;
        }
        catch (Exception exception) {
            LogSystem.log(1, "Cannot close " + outFile);
            LogSystem.log(1, exception, false);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean publishFile() {
        boolean bl = false;
        LogSystem.beginLogSection("Publishing " + outFile);
        try {
            FTPManager fTPManager = new FTPManager(ftpSite, "ftpbot", "java0ne");
            FTPFile fTPFile = new FTPFile(new File(outFile));
            fTPManager.setLogging(LogSystem.getInstance());
            fTPFile.setRemoteFilename(Text.stripPath(outFile));
            fTPFile.setRemoteDirectory(ftpDir);
            if (fTPManager.open()) {
                fTPManager.copyToFtp(fTPFile);
            } else {
                LogSystem.log(1, "Could not FTP outFile:" + outFile);
            }
            LogSystem.log(1, "Disconnecting from FTP Site");
            fTPManager.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, "Exception while publishing File");
            LogSystem.log(1, exception, false);
        }
        LogSystem.endLogSection();
        return bl;
    }
}

