/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.batch;

import com.ibm.nzna.shared.batch.Batch;
import com.ibm.nzna.shared.batch.BatchListener;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.Log;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.Vector;

public class BatchLogSystem
extends LogSystem
implements BatchListener {
    private static String batchName = null;
    private static String currentDirectory = null;
    private static String errorFile = null;
    private static String progressFile = null;
    private static CDate date = null;
    private static String runTimestamp = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteOldLogs(int n) {
        File file = new File(currentDirectory);
        String[] stringArray = file.list();
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n2 = 0;
        int n3 = 0;
        String string = null;
        String string2 = null;
        BatchLogSystem.beginLogSection("Scanning all log files");
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (stringArray[n4].startsWith(batchName + "_error") || stringArray[n4].startsWith(batchName + "_out")) {
                vector.addElement(stringArray[n4]);
            }
            ++n4;
        }
        n3 = vector.size();
        while (n2 < n3) {
            string = (String)vector.elementAt(n2);
            try {
                string2 = string.substring(string.length() - 26);
                BatchLogSystem.log("Found Old Header with Date:" + string2);
            }
            catch (Exception exception) {
                BatchLogSystem.log("Could not parse date from file: " + string);
            }
            if (CDate.differenceDate(runTimestamp, string2, 1) > 2L) {
                File file2 = new File(string);
                BatchLogSystem.log("Deleting old log file:" + string);
                file2.delete();
            } else {
                BatchLogSystem.log("Preserving old log file:" + string);
            }
            ++n2;
        }
        BatchLogSystem.endLogSection();
    }

    public static void log(String string) {
        Log.log(progressFile, string + "\n");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logSevereError(Exception exception) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            Object var4_5 = null;
            String string = "";
            exception.printStackTrace(printWriter);
            string = printWriter.toString();
            Log.log(errorFile, exception);
            Log.log(errorFile, "-----------------------------------------\n");
            return;
        }
        catch (Exception exception2) {
            System.out.println("Could not log Message:\n----------------------------------");
            exception.printStackTrace();
            System.out.println("\n\nReceived Exception during log:\n");
            exception2.printStackTrace();
        }
    }

    public static void beginLogSection(String string) {
        Log.beginLogSection(progressFile, string);
    }

    public static void endLogSection() {
        Log.endLogSection(progressFile);
        Log.log(progressFile, "\n\n\n");
    }

    public void logProgress(String string, int n, int n2) {
        BatchLogSystem.log(string);
    }

    public void logSevereError(String string) {
        Log.log(errorFile, string + "\n");
    }

    public void batchStart() {
    }

    public void batchStop() {
    }

    public void logError(String string) {
        Log.log(errorFile, string + "\n");
    }

    public static void log(int n, Exception exception) {
        BatchLogSystem.log(n, exception, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(int n, Exception exception, boolean bl) {
        try {
            System.out.println("Logging exception!");
            if (LogSystem.getDebugLevel() > n) return;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            Object var5_6 = null;
            String string = "";
            exception.printStackTrace(printWriter);
            string = printWriter.toString();
            Log.log(errorFile, exception);
            Log.log(errorFile, "-----------------------------------------\n");
            return;
        }
        catch (Exception exception2) {
            System.out.println("Could not log Message:\n----------------------------------");
            exception.printStackTrace();
            System.out.println("\n\nReceived Exception during log:\n");
            exception2.printStackTrace();
        }
    }

    public static String getProgressFile() {
        return progressFile;
    }

    public static String getErrorFile() {
        return errorFile;
    }

    public BatchLogSystem(String string, Batch batch) {
        Properties properties = System.getProperties();
        date = new CDate();
        currentDirectory = properties.getProperty("user.dir");
        runTimestamp = date.getDate(1);
        errorFile = string + "_error." + runTimestamp;
        progressFile = string + "_out." + runTimestamp;
        Log.clearLogFile(errorFile);
        Log.clearLogFile(progressFile);
        this.setLogFile(1, progressFile);
        BatchLogSystem.log("*---------------------------------------------------------------------------------------*");
        BatchLogSystem.log("*");
        BatchLogSystem.log("* Batch Name:         " + string);
        BatchLogSystem.log("* Start Time:         " + runTimestamp);
        BatchLogSystem.log("* Home Dir:           " + currentDirectory);
        BatchLogSystem.log("* JDK Level:          " + properties.getProperty("java.fullversion"));
        BatchLogSystem.log("* Platform:           " + properties.getProperty("os.name"));
        BatchLogSystem.log("* Platform Version:   " + properties.getProperty("os.version"));
        BatchLogSystem.log("* User Home:          " + properties.getProperty("user.home"));
        BatchLogSystem.log("*");
        BatchLogSystem.log("*---------------------------------------------------------------------------------------*");
        BatchLogSystem.log("");
        BatchLogSystem.log("");
        Log.log(errorFile, "*---------------------------------------------------------------------------------------*\n");
        Log.log(errorFile, "*\n");
        Log.log(errorFile, "* Batch Name:         " + string + "\n");
        Log.log(errorFile, "* Start Time:         " + runTimestamp + "\n");
        Log.log(errorFile, "* Home Dir:           " + currentDirectory + "\n");
        Log.log(errorFile, "* JDK Level:          " + properties.getProperty("java.fullversion") + "\n");
        Log.log(errorFile, "* Platform:           " + properties.getProperty("os.name") + "\n");
        Log.log(errorFile, "* Platform Version:   " + properties.getProperty("os.version") + "\n");
        Log.log(errorFile, "* User Home:          " + properties.getProperty("user.home") + "\n");
        Log.log(errorFile, "*\n");
        Log.log(errorFile, "*---------------------------------------------------------------------------------------*\n");
        Log.log(errorFile, "\n");
        Log.log(errorFile, "\n");
        batch.addBatchListener(this);
        batchName = string;
    }
}

