/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.db;

import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.Connection;
import java.sql.DriverManager;

public class Database
implements Runnable,
MultiListRow {
    private String name = null;
    private String server = null;
    private String port = null;
    private String url = null;
    private Connection connection = null;
    private boolean connected = false;
    private String userId = null;
    private String password = null;
    private boolean secondaryConnection = false;
    private boolean busy = false;
    private int databaseId = 0;
    private boolean useAppDriver = false;
    private Thread idleThread = null;
    private boolean continueIdleThread = true;

    public void finalize() {
        try {
            this.continueIdleThread = false;
            this.interruptIdleThread();
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setName(String string) {
        this.name = string;
        this.setURL();
    }

    public String getName() {
        return this.name;
    }

    protected void setServer(String string) {
        this.server = string;
        this.setURL();
    }

    protected String getServer() {
        return this.server;
    }

    protected void setPort(String string) {
        this.port = string;
        this.setURL();
    }

    public String getPort() {
        return this.port;
    }

    protected boolean connect(boolean bl) throws Exception {
        block6: {
            if (this.url != null) {
                this.secondaryConnection = bl;
                if (LogSystem.getInstance() != null) {
                    LogSystem.log(2, "Connecting to " + this.url + " Using user " + this.userId + " Password is " + this.password.length() + " characters long.");
                }
                try {
                    this.connection = DriverManager.getConnection(this.url, this.userId, this.password);
                    boolean bl2 = this.connected = this.connection != null;
                    if (this.connected && DatabaseSystem.getAutoDisconnect() && !bl && this.idleThread == null) {
                        this.idleThread = new Thread(this);
                        this.idleThread.setPriority(1);
                        this.idleThread.start();
                    }
                }
                catch (Exception exception) {
                    String string = exception.toString();
                    if (LogSystem.getInstance() != null) {
                        LogSystem.log(1, exception, false);
                    }
                    if (string.indexOf("suitable") < 0) break block6;
                    new Exception("The DB/2 Driver could not be located");
                }
            }
        }
        return this.connected;
    }

    protected void disconnect() {
        if (this.getConnected()) {
            block4: {
                try {
                    if (LogSystem.getInstance() != null) {
                        LogSystem.log(1, "Disconnecting From Database " + this.name + "  on server " + this.server);
                    }
                    this.connection.close();
                }
                catch (Exception exception) {
                    if (LogSystem.getInstance() == null) break block4;
                    LogSystem.log(1, exception, false);
                }
            }
            this.connected = false;
        }
    }

    private void setURL() {
        this.url = this.useAppDriver ? "jdbc:db2:" + this.name : "jdbc:db2://" + this.server + ":" + this.port + "/" + this.name;
    }

    public boolean getConnected() {
        return this.connected;
    }

    protected void setUserId(String string) {
        this.userId = string;
    }

    public String getUserId() {
        return this.userId;
    }

    protected void setPassword(String string) {
        this.password = string;
    }

    public boolean getSecondaryConnection() {
        return this.secondaryConnection;
    }

    protected void setSecondaryConnection(boolean bl) {
        this.secondaryConnection = bl;
    }

    protected void setBusy(boolean bl) {
        this.busy = bl;
    }

    public boolean getBusy() {
        return this.busy;
    }

    public Object getColumnData(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.connected ? "Connected" : "Disconnected";
                break;
            }
            case 1: {
                string = this.name;
                break;
            }
            case 2: {
                string = this.server;
                break;
            }
            case 3: {
                string = this.port;
                break;
            }
            case 4: {
                string = "" + this.busy;
                break;
            }
            case 5: {
                string = "" + this.secondaryConnection;
                break;
            }
        }
        return string;
    }

    public int compareTo(MultiListSort multiListSort, int n) {
        int n2 = 0;
        if (multiListSort instanceof Database) {
            Database database = (Database)((Object)multiListSort);
            switch (n) {
                case 0: {
                    database.connected = this.connected;
                    if (database.connected) {
                        n2 = 0;
                        break;
                    }
                    n2 = 1;
                    break;
                }
                case 1: {
                    n2 = database.name.compareTo(this.name);
                    break;
                }
                case 2: {
                    n2 = database.server.compareTo(this.server);
                    break;
                }
                case 3: {
                    n2 = database.port.compareTo(this.port);
                    break;
                }
                case 4: {
                    if (database.busy == this.busy) {
                        n2 = 0;
                        break;
                    }
                    n2 = 1;
                    break;
                }
                case 5: {
                    if (database.secondaryConnection == this.secondaryConnection) {
                        n2 = 0;
                        break;
                    }
                    n2 = 1;
                    break;
                }
            }
        }
        return n2;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    public int getDatabaseId() {
        return this.databaseId;
    }

    protected String getPassword() {
        return this.password;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Database) {
            Database database = (Database)object;
            if (database.databaseId == this.databaseId && database.secondaryConnection == this.secondaryConnection) {
                bl = true;
            }
        }
        return bl;
    }

    protected void commit() {
        try {
            this.connection.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        while (this.continueIdleThread && DatabaseSystem.getAutoDisconnect()) {
            try {
                Thread.sleep(300000L);
                if (!DatabaseSystem.getAutoDisconnect() || !this.connected || this.busy) continue;
                DatabaseSystem.disconnect(this.databaseId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void interruptIdleThread() {
        if (this.idleThread != null) {
            this.idleThread.interrupt();
        }
    }

    public Database(int n, String string, String string2, String string3, boolean bl) {
        this.useAppDriver = bl;
        this.databaseId = n;
        this.setName(string);
        this.setServer(string2);
        this.setPort(string3);
    }

    public Database(int n, Connection connection) {
        this.databaseId = n;
        this.connection = connection;
    }
}

