/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.db;

import com.ibm.nzna.shared.db.Database;
import com.ibm.nzna.shared.db.DatabaseStatusListener;
import com.ibm.nzna.shared.db.DatabaseStatusNotify;
import com.ibm.nzna.shared.db.DatabaseSystemListener;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class DatabaseSystem {
    public static final int QUEST = 1;
    public static final int CLIO = 2;
    public static final int OPICM = 3;
    private static Vector activeDatabaseVec = null;
    private static Vector activeMethodVec = null;
    private static Vector dormantMethodVec = null;
    private static Vector listenerVec = null;
    private static Vector statusListenerVec = null;
    private static LogSystem log = null;
    private static boolean debug = false;
    private static boolean useAppDriver = false;
    private static boolean allowMultiple = true;
    private static boolean autoDisconnect = true;
    private static DatabaseSystem instance = null;

    public static boolean createConnection(int n, String string, String string2, String string3, String string4, String string5) {
        Database database = DatabaseSystem.findDatabase(string, string2, string3, string4);
        boolean bl = false;
        try {
            if (database == null) {
                database = new Database(n, string, string2, string3, useAppDriver);
                database.setUserId(string4);
                database.setPassword(string5);
                new DatabaseStatusNotify(1, database, statusListenerVec);
                bl = database.connect(false);
                if (bl) {
                    DatabaseSystem.addDatabase(database);
                }
                new DatabaseStatusNotify(2, database, statusListenerVec);
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            if (log != null) {
                LogSystem.log(1, exception);
            }
            exception.printStackTrace();
        }
        return bl;
    }

    public static void autoAllocateConnections(int n, int n2) {
        Database database = DatabaseSystem.findDatabase(n);
        try {
            int n3 = 0;
            while (n3 < n2) {
                Database database2 = new Database(database.getDatabaseId(), database.getName(), database.getServer(), database.getPort(), useAppDriver);
                database2.setUserId(database.getUserId());
                database2.setPassword(database.getPassword());
                database2.setSecondaryConnection(false);
                new DatabaseStatusNotify(1, database2, statusListenerVec);
                if (database2.connect(false)) {
                    database2.getConnection();
                    database2.setBusy(false);
                    DatabaseSystem.addDatabase(database2);
                }
                new DatabaseStatusNotify(2, database2, statusListenerVec);
                ++n3;
            }
            if (log != null) {
                LogSystem.log(1, "Auto Allocated " + n2 + " connections to database " + database.getName() + " on server " + database.getServer());
            } else {
                System.out.println("Auto Allocated " + n2 + " connections to database " + database.getName() + " on server " + database.getServer());
            }
        }
        catch (Exception exception) {
            if (log != null) {
                LogSystem.log(1, exception);
            }
            exception.printStackTrace();
        }
    }

    public static Connection getConnection(int n) {
        Database database = null;
        Database database2 = DatabaseSystem.findDatabase(n);
        Connection connection = null;
        if (database2 != null) {
            try {
                if (database2.getBusy() && allowMultiple) {
                    database = new Database(database2.getDatabaseId(), database2.getName(), database2.getServer(), database2.getPort(), useAppDriver);
                    database.setUserId(database2.getUserId());
                    database.setPassword(database2.getPassword());
                    database.setSecondaryConnection(true);
                    new DatabaseStatusNotify(1, database, statusListenerVec);
                    if (database.connect(true)) {
                        connection = database.getConnection();
                        DatabaseSystem.addDatabase(database);
                        database.setBusy(true);
                    }
                    new DatabaseStatusNotify(2, database, statusListenerVec);
                } else {
                    if (!database2.getConnected()) {
                        new DatabaseStatusNotify(1, database2, statusListenerVec);
                        database2.connect(false);
                        new DatabaseStatusNotify(2, database2, statusListenerVec);
                    }
                    if (database2.getConnected()) {
                        connection = database2.getConnection();
                        database2.setBusy(true);
                    }
                }
            }
            catch (Exception exception) {
                if (log != null) {
                    LogSystem.log(1, exception);
                }
                exception.printStackTrace();
            }
        }
        return connection;
    }

    public static void setConnection(int n, Connection connection) {
        Database database = new Database(n, connection);
        activeDatabaseVec.addElement(database);
    }

    private static Database findDatabase(String string, String string2, String string3, String string4) {
        Database database = null;
        if (activeDatabaseVec != null) {
            int n = 0;
            int n2 = activeDatabaseVec.size();
            Database database2 = null;
            while (n < n2 && database == null) {
                database2 = (Database)activeDatabaseVec.elementAt(n);
                if (database2.getName().equals(string) && database2.getServer().equals(string2) && database2.getUserId().equals(string4) && database2.getPort().equals(string3)) {
                    database = database2;
                }
                ++n;
            }
        }
        return database;
    }

    private static Database findDatabase(int n) {
        Database database = null;
        if (activeDatabaseVec != null) {
            int n2 = 0;
            int n3 = activeDatabaseVec.size();
            Database database2 = null;
            while (n2 < n3 && database == null) {
                database2 = (Database)activeDatabaseVec.elementAt(n2);
                if (database2.getDatabaseId() == n) {
                    database = database2;
                }
                ++n2;
            }
        }
        return database;
    }

    private static Database findNotBusyDatabase(int n) {
        Database database = null;
        if (activeDatabaseVec != null) {
            int n2 = 0;
            int n3 = activeDatabaseVec.size();
            Database database2 = null;
            while (n2 < n3 && database == null) {
                database2 = (Database)activeDatabaseVec.elementAt(n2);
                if (database2.getDatabaseId() == n && !database2.getBusy()) {
                    database = database2;
                }
                ++n2;
            }
        }
        return database;
    }

    public static Database getDatabaseFromConnection(Connection connection) {
        Database database = null;
        if (activeDatabaseVec != null) {
            int n = 0;
            int n2 = activeDatabaseVec.size();
            Database database2 = null;
            while (n < n2 && database == null) {
                database2 = (Database)activeDatabaseVec.elementAt(n);
                if (database2.getConnection() == connection) {
                    database = database2;
                }
                ++n;
            }
        }
        return database;
    }

    private static void addDatabase(Database database) {
        if (activeDatabaseVec == null) {
            activeDatabaseVec = new Vector(1, 1);
        }
        activeDatabaseVec.addElement(database);
        DatabaseSystem.fireDatabaseAdded(database);
    }

    private static void removeDatabase(Database database) {
        database.disconnect();
        if (activeDatabaseVec != null) {
            activeDatabaseVec.removeElement(database);
            database.finalize();
        }
        DatabaseSystem.fireDatabaseRemoved(database);
    }

    protected static Vector getActiveDatabases() {
        return activeDatabaseVec;
    }

    public static void addDatabaseSystemListener(DatabaseSystemListener databaseSystemListener) {
        if (listenerVec == null) {
            listenerVec = new Vector(1, 1);
        }
        listenerVec.addElement(databaseSystemListener);
    }

    public static void removeDatabaseSystemListener(DatabaseSystemListener databaseSystemListener) {
        if (listenerVec != null) {
            listenerVec.removeElement(databaseSystemListener);
        }
    }

    private static void fireDatabaseAdded(Database database) {
        if (listenerVec != null) {
            int n = 0;
            int n2 = listenerVec.size();
            while (n < n2) {
                ((DatabaseSystemListener)listenerVec.elementAt(n)).databaseAdded(database);
                ++n;
            }
        }
    }

    private static void fireDatabaseRemoved(Database database) {
        if (listenerVec != null) {
            int n = 0;
            int n2 = listenerVec.size();
            while (n < n2) {
                ((DatabaseSystemListener)listenerVec.elementAt(n)).databaseRemoved(database);
                ++n;
            }
        }
    }

    private static void fireMethodAdded(Database database, SQLMethod sQLMethod) {
        if (listenerVec != null) {
            int n = 0;
            int n2 = listenerVec.size();
            while (n < n2) {
                ((DatabaseSystemListener)listenerVec.elementAt(n)).methodAdded(database, sQLMethod);
                ++n;
            }
        }
    }

    private static void fireMethodRemoved(Database database, SQLMethod sQLMethod) {
        if (listenerVec != null) {
            int n = 0;
            int n2 = listenerVec.size();
            while (n < n2) {
                ((DatabaseSystemListener)listenerVec.elementAt(n)).methodRemoved(database, sQLMethod);
                ++n;
            }
        }
    }

    public static boolean shutdown() {
        if (activeDatabaseVec != null) {
            int n = 0;
            int n2 = activeDatabaseVec.size();
            while (n < n2) {
                ((Database)activeDatabaseVec.elementAt(n)).disconnect();
                DatabaseSystem.fireDatabaseRemoved((Database)activeDatabaseVec.elementAt(n));
                ++n;
            }
        }
        return true;
    }

    protected static void addSQLMethod(Database database, SQLMethod sQLMethod) {
        try {
            if (database != null) {
                database.interruptIdleThread();
                if (debug) {
                    if (activeMethodVec == null) {
                        activeMethodVec = new Vector(1, 1);
                    }
                    activeMethodVec.addElement(sQLMethod);
                    if (log != null) {
                        LogSystem.log(1, "DatabaseSystem Added method:" + sQLMethod.getColumnData(0));
                    }
                }
                DatabaseSystem.fireMethodAdded(database, sQLMethod);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    protected static void removeSQLMethod(Database database, SQLMethod sQLMethod) {
        try {
            if (database != null) {
                if (debug) {
                    if (dormantMethodVec == null) {
                        dormantMethodVec = new Vector(1, 1);
                    }
                    dormantMethodVec.addElement(sQLMethod);
                    if (activeMethodVec != null) {
                        activeMethodVec.removeElement(sQLMethod);
                    }
                    if (log != null) {
                        LogSystem.log(1, "DatabaseSystem removed method:" + sQLMethod.getColumnData(0));
                    }
                }
                DatabaseSystem.fireMethodRemoved(database, sQLMethod);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public static void releaseConnection(Database database) {
        database.setBusy(false);
        if (database.getSecondaryConnection()) {
            DatabaseSystem.removeDatabase(database);
        }
    }

    protected static Vector getActiveMethods() {
        return activeMethodVec;
    }

    public static void addStatusListener(DatabaseStatusListener databaseStatusListener) {
        if (statusListenerVec == null) {
            statusListenerVec = new Vector(1, 1);
        }
        statusListenerVec.addElement(databaseStatusListener);
    }

    public static void removeStatusListener(DatabaseStatusListener databaseStatusListener) {
        if (statusListenerVec != null) {
            statusListenerVec.removeElement(databaseStatusListener);
        }
    }

    public static void disconnect(int n) {
        DatabaseSystem.disconnect(DatabaseSystem.findDatabase(n));
    }

    private static void disconnect(Database database) {
        if (database != null) {
            new DatabaseStatusNotify(3, database, statusListenerVec);
            database.disconnect();
            new DatabaseStatusNotify(4, database, statusListenerVec);
        }
    }

    public static boolean getAutoDisconnect() {
        return autoDisconnect;
    }

    public static void setAutoDisconnect(boolean bl) {
        autoDisconnect = bl;
    }

    public static void setAllowMultipleConnections(boolean bl) {
        allowMultiple = bl;
    }

    public static void handleSQLException(SQLMethod sQLMethod, SQLException sQLException) {
        int n = sQLException.getErrorCode();
        if (log != null) {
            LogSystem.beginLogSection("DB/2 Error");
            LogSystem.log(1, "Logging DB/2 Exception");
            LogSystem.log(1, "   SQLCODE: " + n);
            LogSystem.log(1, "   SQLSTATE:" + sQLException.getSQLState());
            LogSystem.log(1, "   Method:  " + sQLMethod.getMethodName());
            LogSystem.log(1, "");
            LogSystem.log(1, "DB/2 Exception thrown:");
            LogSystem.log(1, sQLException, false);
        }
        if (n == -99999) {
            DatabaseSystem.handleSQLState(sQLMethod, sQLException.getSQLState());
        } else {
            switch (n) {
                default: 
            }
        }
    }

    private static void handleSQLState(SQLMethod sQLMethod, String string) {
        if (string.equals("08S01")) {
            DatabaseSystem.disconnect(sQLMethod.getDatabase());
            if (log != null) {
                LogSystem.log(1, "Received SQL State 08S01, meaning that the DB/2 JDBC Daemon on the server is no longer responding");
            }
        }
    }

    public static boolean isDatabaseConnected(int n) {
        boolean bl = false;
        if (activeDatabaseVec != null) {
            int n2 = 0;
            int n3 = activeDatabaseVec.size();
            Database database = null;
            while (n2 < n3 && !bl) {
                database = (Database)activeDatabaseVec.elementAt(n2);
                if (database.getDatabaseId() == n && !database.getSecondaryConnection()) {
                    bl = database.getConnected();
                }
                ++n2;
            }
        }
        return bl;
    }

    public static DatabaseSystem getInstance() {
        return instance;
    }

    public DatabaseSystem(boolean bl, LogSystem logSystem, boolean bl2) throws Exception {
        useAppDriver = bl2;
        debug = bl;
        log = logSystem;
        try {
            String string = null;
            string = bl2 ? "COM.ibm.db2.jdbc.app.DB2Driver" : "COM.ibm.db2.jdbc.net.DB2Driver";
            if (logSystem != null) {
                LogSystem.log(1, "Loading DB/2 Driver: " + string);
            }
            Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.out.println("Could not load DB/2 Driver:\nException:" + exception);
            if (logSystem != null) {
                LogSystem.log(1, "Could not load DB/2 Drvier: Exception:");
                LogSystem.log(1, exception);
            }
            throw exception;
        }
        instance = this;
    }
}

