/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.db;

import com.ibm.nzna.shared.db.Database;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.QuestCallableStatement;
import com.ibm.nzna.shared.db.QuestPreparedStatement;
import com.ibm.nzna.shared.db.QuestStatement;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class SQLMethod
implements MultiListRow {
    private String methodName = null;
    private int runSeconds = 0;
    private String currentSQL = null;
    private int databaseId = -1;
    private String databaseName = null;
    private String userId = null;
    private Connection connection = null;
    private Database database = null;
    private CallableStatement callableStatement = null;
    private LogSystem log = null;
    private Vector statements = new Vector(1);
    private boolean open = true;

    public SQLMethod(int n, String string, int n2) {
        this.log = LogSystem.getInstance();
        this.methodName = string;
        this.runSeconds = n2;
        this.databaseId = n;
        this.connection = DatabaseSystem.getConnection(n);
        this.database = DatabaseSystem.getDatabaseFromConnection(this.connection);
        DatabaseSystem.addSQLMethod(this.database, this);
    }

    public void close() {
        block10: {
            try {
                if (this.statements != null && this.statements.size() > 0) {
                    int n = 0;
                    int n2 = this.statements.size();
                    while (n < n2) {
                        ((QuestStatement)this.statements.elementAt(n)).close();
                        ++n;
                    }
                } else if (this.callableStatement != null) {
                    this.callableStatement.close();
                }
                if (this.database != null) {
                    this.database.commit();
                }
                if (this.database != null) {
                    DatabaseSystem.removeSQLMethod(this.database, this);
                }
                if (this.database != null) {
                    DatabaseSystem.releaseConnection(this.database);
                }
                this.database = null;
                if (this.statements != null) {
                    this.statements.removeAllElements();
                    this.statements = null;
                }
                this.open = false;
            }
            catch (Exception exception) {
                if (this.log == null) break block10;
                LogSystem.log(1, exception, false);
            }
        }
    }

    public Statement createStatement() {
        QuestStatement questStatement = null;
        QuestStatement questStatement2 = null;
        if (this.connection != null) {
            try {
                questStatement2 = questStatement = new QuestStatement(this.connection.createStatement());
                if (questStatement2 != null && questStatement != null) {
                    this.statements.addElement(questStatement);
                }
            }
            catch (SQLException sQLException) {
                DatabaseSystem.handleSQLException(this, sQLException);
                questStatement2 = null;
                questStatement = null;
            }
            catch (Exception exception) {
                if (this.log != null) {
                    LogSystem.log(1, exception, false);
                } else {
                    exception.printStackTrace();
                }
                questStatement2 = null;
                questStatement = null;
            }
        }
        return questStatement2;
    }

    public CallableStatement createStoredProc(String string, int n) {
        QuestCallableStatement questCallableStatement = null;
        String string2 = this.constructDB2StoredProcCall(string, n);
        try {
            questCallableStatement = new QuestCallableStatement(this.connection.prepareCall(string2), string, n);
            this.callableStatement = questCallableStatement;
        }
        catch (Exception exception) {
            if (this.log != null) {
                LogSystem.log(1, exception);
            }
            exception.printStackTrace();
        }
        return questCallableStatement;
    }

    private String constructDB2StoredProcCall(String string, int n) {
        String string2 = "CALL " + string + " ( ";
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            string2 = string2 + "?";
            if (n2 != n - 1) {
                string2 = string2 + ", ";
            }
            ++n2;
        }
        if (this.log != null) {
            LogSystem.log(1, "SQLMethod Creating Stored Procedure Call:" + string2 + ")");
        }
        return string2 + ")";
    }

    public Object getColumnData(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.methodName;
                break;
            }
            case 1: {
                string = "" + this.runSeconds;
            }
        }
        return string;
    }

    public int getDatabaseId() {
        return this.databaseId;
    }

    public String getStatementSQL() {
        return "Statement SQL not supported yet";
    }

    public void rollBack() {
        try {
            this.connection.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String cleanDBString(String string) {
        String string2 = null;
        if (string != null) {
            string2 = Text.replaceAllStrInStr(string, "''", "'");
            string2 = Text.replaceAllStrInStr(string2, "'", "''");
        }
        return string2;
    }

    public PreparedStatement createPreparedStatement(String string) {
        QuestPreparedStatement questPreparedStatement = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            questPreparedStatement = new QuestPreparedStatement(preparedStatement);
        }
        catch (Exception exception) {
            if (this.log != null) {
                LogSystem.log(1, exception);
            }
            exception.printStackTrace();
        }
        return questPreparedStatement;
    }

    protected Database getDatabase() {
        return this.database;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected String getMethodName() {
        return this.methodName;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

