/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.ftp.FTP;

import com.ibm.nzna.shared.ftp.FTP.FileTransfer;
import com.ibm.nzna.shared.ftp.FTP.FtpListener;
import com.ibm.nzna.shared.ftp.FTP.FtpReplyImpl;
import com.ibm.nzna.shared.ftp.FTP.ListTransfer;
import com.ibm.nzna.shared.ftp.FTP.ReplyEvent;
import com.ibm.nzna.shared.ftp.FTP.StreamGet;
import com.ibm.nzna.shared.ftp.FTP.StreamPut;
import com.ibm.nzna.shared.ftp.FTP.Transfer;
import com.ibm.nzna.shared.ftp.FTP.TransferEvent;
import com.ibm.nzna.shared.ftp.FtpClient;
import com.ibm.nzna.shared.ftp.FtpError;
import com.ibm.nzna.shared.ftp.FtpReply;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class Ftp
implements FtpClient,
Serializable {
    public static final String PORT = "port";
    public static final String BUFFER_SIZE = "bufferSize";
    public static final String CONNECTED = "connected";
    public static final String HOST = "host";
    public static final String PASSWORD = "password";
    public static final String TIMEOUT = "timeout";
    public static final String TRACE = "trace";
    public static final String TRACE_DESTINATION = "traceDestination";
    public static final String TYPE = "type";
    public static final String USER = "user";
    protected static final String CRLF = "\r\n";
    protected static DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss z");
    protected int port = 21;
    protected String host = "";
    protected String user = "anonymous";
    protected String password = "";
    protected String account = "";
    protected transient boolean connected = false;
    protected int bufferSize = 4096;
    protected int timeout;
    protected char type = (char)65;
    protected boolean trace = false;
    protected transient PrintWriter traceDestination = new PrintWriter(System.out, true);
    protected transient FtpReply reply;
    protected transient Socket controlSocket;
    protected transient BufferedReader controlIn;
    protected transient OutputStreamWriter controlOut;
    protected transient Transfer transfer;
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected Vector ftpListeners = new Vector();

    public void setPort(int n) {
        if (n != this.port) {
            int n2 = this.port;
            this.port = n;
            this.changes.firePropertyChange(PORT, new Integer(n2), new Integer(this.port));
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setBufferSize(int n) {
        if (n != this.bufferSize) {
            int n2 = this.bufferSize;
            this.bufferSize = n;
            this.changes.firePropertyChange(BUFFER_SIZE, new Integer(n2), new Integer(this.bufferSize));
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized void setTimeout(int n) throws SocketException {
        if (this.timeout != n) {
            int n2 = this.timeout;
            this.timeout = n;
            this.changes.firePropertyChange(TIMEOUT, new Integer(n2), new Integer(n));
            if (this.controlSocket != null) {
                this.controlSocket.setSoTimeout(n);
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setHost(String string) {
        if (!string.equals(this.host)) {
            String string2 = this.host;
            this.host = string;
            this.changes.firePropertyChange(HOST, string2, this.host);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setUser(String string) {
        if (!string.equals(this.user)) {
            String string2 = this.user;
            this.user = string;
            this.changes.firePropertyChange(USER, string2, this.user);
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String string) {
        if (!string.equals(this.password)) {
            String string2 = this.password;
            this.password = string;
            this.changes.firePropertyChange(PASSWORD, string2, this.password);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setTrace(boolean bl) {
        if (this.trace != bl) {
            this.trace = bl;
            this.changes.firePropertyChange(TRACE, new Boolean(!this.trace), new Boolean(this.trace));
        }
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setTraceDestination(PrintWriter printWriter) {
        if (this.traceDestination != printWriter) {
            PrintWriter printWriter2 = this.traceDestination;
            this.traceDestination = printWriter;
            this.changes.firePropertyChange(TRACE_DESTINATION, printWriter2, this.traceDestination);
        }
    }

    public PrintWriter getTraceDestination() {
        return this.traceDestination;
    }

    public synchronized void connect() throws UnknownHostException, IOException {
        this.connect(this.host);
    }

    public synchronized void connect(String string) throws UnknownHostException, IOException {
        if (this.isConnected()) {
            this.disconnect();
        }
        this.setHost(string);
        if (this.trace) {
            this.traceDestination.println(" --> Connecting to " + string);
        }
        this.controlSocket = new Socket(string, this.port);
        if (this.timeout > 0) {
            this.controlSocket.setSoTimeout(this.timeout);
        }
        this.controlIn = new BufferedReader(new InputStreamReader(this.controlSocket.getInputStream()));
        this.controlOut = new OutputStreamWriter(this.controlSocket.getOutputStream());
        this.readReply();
        this.connected = true;
        this.changes.firePropertyChange(CONNECTED, new Boolean(false), new Boolean(true));
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void disconnect() throws IOException {
        this.connected = false;
        if (this.controlIn != null) {
            this.controlIn.close();
            this.controlIn = null;
        }
        if (this.controlOut != null) {
            this.controlOut.close();
            this.controlOut = null;
        }
        if (this.controlSocket != null) {
            this.controlSocket.close();
            this.controlSocket = null;
        }
    }

    public synchronized void login() throws FtpError, IOException {
        this.login(this.user, this.password, "");
    }

    public synchronized void login(String string, String string2) throws FtpError, IOException {
        this.login(string, string2, "");
    }

    public synchronized void login(String string, String string2, String string3) throws FtpError, IOException {
        this.user = string;
        this.password = string2;
        this.account = string3;
        this.command("USER " + string);
        if (this.getReply().getType() == 3) {
            this.command("PASS " + string2);
            if (this.getReply().getType() == 3) {
                this.command("ACCT " + string3);
            }
        }
    }

    public synchronized void logout() throws FtpError, IOException {
        this.command("QUIT");
    }

    public synchronized String[] dir() throws FtpError, IOException {
        return this.getList(null, true);
    }

    public synchronized String[] dir(String string) throws FtpError, IOException {
        return this.getList(string, true);
    }

    public synchronized String[] list() throws FtpError, IOException {
        return this.getList(null, false);
    }

    public synchronized String[] list(String string) throws FtpError, IOException {
        return this.getList(string, false);
    }

    protected synchronized String[] getList(String string, boolean bl) throws FtpError, IOException {
        this.transfer = new ListTransfer(this, string, bl);
        return ((ListTransfer)this.transfer).getList();
    }

    public synchronized void cd(String string) throws FtpError, IOException {
        this.command(string.equals("..") ? "CDUP" : "CWD " + string);
    }

    public synchronized String pwd() throws FtpError, IOException {
        this.command("PWD");
        String string = this.getReply().getMessage();
        return string.substring(1, string.indexOf(34, 1));
    }

    public synchronized void setType(char c) throws FtpError, IOException {
        if (c == 'A' || c == 'I') {
            if (this.type != c) {
                char c2 = this.type;
                this.type = c;
                this.changes.firePropertyChange(TYPE, new Character(c2), new Character(this.type));
            }
            if (this.isConnected()) {
                this.command("TYPE " + this.type);
            }
        }
    }

    public char getType() {
        return this.type;
    }

    public synchronized void get(String string) throws FtpError, IOException {
        this.get(string, string);
    }

    public synchronized void get(String string, String string2) throws FtpError, IOException {
        this.transfer = new StreamGet(this, new File(string2), string);
        this.transfer.start();
    }

    public synchronized void put(String string) throws FtpError, IOException {
        this.put(string, new File(string).getName(), false);
    }

    public synchronized void put(String string, boolean bl) throws FtpError, IOException {
        this.put(string, new File(string).getName(), bl);
    }

    public synchronized void put(String string, String string2, boolean bl) throws FtpError, IOException {
        this.transfer = new StreamPut(this, new File(string), string2, bl);
        this.transfer.start();
    }

    public synchronized boolean isRestartable() {
        if (this.transfer != null && this.transfer instanceof FileTransfer) {
            return ((FileTransfer)this.transfer).isRestartable();
        }
        return false;
    }

    public synchronized void restart() throws FtpError, IOException {
        if (this.transfer != null && this.transfer instanceof FileTransfer) {
            ((FileTransfer)this.transfer).restart();
        }
    }

    public synchronized void rename(String string, String string2) throws FtpError, IOException {
        this.command("RNFR " + string);
        this.command("RNTO " + string2);
    }

    public synchronized void delete(String string) throws FtpError, IOException {
        this.command("DELE " + string);
    }

    public synchronized void mkdir(String string) throws FtpError, IOException {
        this.command("MKD " + string);
    }

    public synchronized void rmdir(String string) throws FtpError, IOException {
        this.command("RMD " + string);
    }

    public long size(String string) throws FtpError, IOException {
        this.command("SIZE " + string);
        try {
            return Long.parseLong(this.getReply().getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public Date time(String string) throws FtpError, IOException {
        this.command("MDTM " + string);
        String string2 = this.getReply().getMessage();
        int n = string2.indexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        try {
            return dateFormat.parse(String.valueOf(string2) + " GMT.");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void abort() {
        Transfer transfer = this.transfer;
        if (transfer != null) {
            transfer.abort();
        }
    }

    public FtpReply getReply() {
        return this.reply;
    }

    public synchronized void command(String string) throws FtpError, IOException {
        if (this.trace) {
            this.traceDestination.println(" --> " + (string.startsWith("PASS") ? "PASS ******" : string));
        }
        if (this.isConnected()) {
            this.controlOut.write(String.valueOf(string) + CRLF);
            this.controlOut.flush();
            this.readReply();
        } else {
            this.reply = new FtpReplyImpl(530, "Not logged in.");
        }
        int n = this.getReply().getType();
        if (n == 4 || n == 5) {
            throw new FtpError(this.getReply());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addFtpListener(FtpListener ftpListener) {
        this.ftpListeners.addElement(ftpListener);
    }

    public synchronized void removeFtpListener(FtpListener ftpListener) {
        this.ftpListeners.removeElement(ftpListener);
    }

    protected void fireTransferStartedEvent(TransferEvent transferEvent) {
        Object[] objectArray;
        if (this.ftpListeners.size() == 0) {
            return;
        }
        Ftp ftp = this;
        synchronized (ftp) {
            objectArray = new FtpListener[this.ftpListeners.size()];
            this.ftpListeners.copyInto(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n].transferStarted(transferEvent);
            ++n;
        }
    }

    protected void fireTransferProgressEvent(TransferEvent transferEvent) {
        Object[] objectArray;
        if (this.ftpListeners.size() == 0) {
            return;
        }
        Ftp ftp = this;
        synchronized (ftp) {
            objectArray = new FtpListener[this.ftpListeners.size()];
            this.ftpListeners.copyInto(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n].transferProgress(transferEvent);
            ++n;
        }
    }

    protected void fireTransferEndedEvent(TransferEvent transferEvent) {
        Object[] objectArray;
        if (this.ftpListeners.size() == 0) {
            return;
        }
        Ftp ftp = this;
        synchronized (ftp) {
            objectArray = new FtpListener[this.ftpListeners.size()];
            this.ftpListeners.copyInto(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n].transferEnded(transferEvent);
            ++n;
        }
    }

    protected void fireReplyEvent() {
        Object[] objectArray;
        if (this.ftpListeners.size() == 0) {
            return;
        }
        ReplyEvent replyEvent = new ReplyEvent(this, this.getReply());
        Ftp ftp = this;
        synchronized (ftp) {
            objectArray = new FtpListener[this.ftpListeners.size()];
            this.ftpListeners.copyInto(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n].ftpReply(replyEvent);
            ++n;
        }
    }

    protected void readReply() throws IOException {
        String string;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if ((string = this.controlIn.readLine()) == null) {
                throw new IOException("EOF while reading from control connection");
            }
            if (string.length() > 3 && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(1)) && Character.isDigit(string.charAt(2)) && string.charAt(3) == ' ') break;
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        n = Integer.parseInt(string.substring(0, 3));
        stringBuffer.append(string.substring(4));
        this.reply = new FtpReplyImpl(n, stringBuffer.toString());
        if (this.trace) {
            this.traceDestination.println("<--  " + this.reply.getCode() + " " + this.reply.getMessage());
        }
        this.fireReplyEvent();
    }
}

