/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.ftp.FTP;

import java.util.EventObject;

public class TransferEvent
extends EventObject {
    public static final int GET = 1;
    public static final int PUT = 2;
    public static final int ACTIVE = 1;
    public static final int COMPLETED = 2;
    public static final int ABORTED = 3;
    public static final int ERROR = 4;
    protected String filename;
    protected int type;
    protected int state;
    protected long startsize;
    protected long byteCount;
    long filesize;
    protected long duration;

    public TransferEvent(Object object, int n, String string, long l) {
        super(object);
        this.type = n;
        this.filename = string;
        this.filesize = l;
        this.state = 1;
        this.byteCount = 0L;
        this.duration = 0L;
        this.startsize = 0L;
    }

    protected void setStartsize(long l) {
        this.startsize = l;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public int getType() {
        return this.type;
    }

    public int getState() {
        return this.state;
    }

    protected void setState(int n) {
        this.state = n;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    protected void setByteCount(long l) {
        this.byteCount = l;
    }

    public long getDuration() {
        return this.duration;
    }

    protected void setDuration(long l) {
        this.duration = l;
    }

    public int getTransferRate() {
        if (this.duration != 0L) {
            return (int)(1000L * (this.byteCount - this.startsize) / this.duration);
        }
        return 0;
    }

    public int getPercent() {
        if (this.filesize > 0L) {
            if (this.state == 2) {
                return 100;
            }
            return (int)(100L * this.byteCount / this.filesize);
        }
        return -1;
    }

    protected void update(long l, long l2) {
        this.byteCount = l;
        this.duration = l2;
    }

    public String toString() {
        switch (this.state) {
            case 1: {
                return String.valueOf(this.type == 1 ? "Getting " : "Putting ") + this.filename + " " + (this.filesize >= 0L ? this.getPercent() + "% of " + this.filesize + " bytes" : "") + " at " + this.getTransferRate() + " bytes/sec";
            }
            case 2: {
                return String.valueOf(this.type == 1 ? "Did get " : "Did put ") + this.filename + " " + (this.filesize >= 0L ? this.filesize + " bytes" : "") + " at " + this.getTransferRate() + " bytes/sec";
            }
            case 3: {
                return String.valueOf(this.type == 1 ? "Get " : "Put ") + this.filename + " " + (this.filesize >= 0L ? this.filesize + " bytes" : "") + " aborted after " + this.byteCount + " bytes";
            }
            case 4: {
                return String.valueOf(this.type == 1 ? "Get " : "Put ") + this.filename + " " + (this.filesize >= 0L ? String.valueOf(this.filesize) + " bytes" : "") + " failed after " + this.byteCount + " bytes";
            }
        }
        return null;
    }
}

