/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.ftp;

import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.ftp.FTPFile;
import com.ibm.nzna.shared.ftp.FTPSiteNotConnectedException;
import com.ibm.nzna.shared.ftp.FtpError;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.IOException;
import java.net.UnknownHostException;

public class FTPManager {
    public static final int ERROR_NONE = 200;
    public static final int ERROR_COMMAND_UNRECOGNIZED = 500;
    public static final int ERROR_SYNTAX_ERROR = 501;
    public static final int ERROR_COMMAND_NOT_IMPLEMENTED_SUPERFLUOUS = 202;
    public static final int ERROR_COMMAND_NOT_IMPLEMENTED = 502;
    public static final int ERROR_BAD_SEQUENCE_OF_COMMANDS = 503;
    public static final int ERROR_COMMAND_NOT_IMPLEMENTED_FOR_PARAM = 504;
    public static final int ERROR_IOEXCEPTION = 1;
    public static final int ERROR_EXCEPTION = 2;
    private Ftp ftpBean = null;
    private String host = null;
    private String userId = null;
    private String password = null;
    private LogSystem logSystem = null;
    private int lastError = 200;

    public void setHost(String string) {
        this.host = string;
        if (this.isConnected()) {
            this.close();
        }
    }

    public void setUserId(String string) {
        this.userId = string;
        if (this.isConnected()) {
            this.close();
        }
    }

    public void setPassword(String string) {
        this.password = string;
        if (this.isConnected()) {
            this.close();
        }
    }

    public boolean isConnected() {
        return this.ftpBean != null;
    }

    public void close() {
        if (this.isConnected()) {
            block3: {
                try {
                    this.ftpBean.disconnect();
                }
                catch (Exception exception) {
                    if (!this.getLogging()) break block3;
                    LogSystem.log(1, exception, false);
                    this.lastError = 2;
                }
            }
            this.ftpBean = null;
        }
    }

    public boolean getLogging() {
        return this.logSystem != null;
    }

    public void setLogging(LogSystem logSystem) {
        this.logSystem = logSystem;
    }

    public boolean open() {
        try {
            if (this.getLogging()) {
                LogSystem.log(1, "Connecting to FTP Site: " + this.host);
            }
            this.ftpBean = new Ftp();
            this.ftpBean.connect(this.host);
            this.ftpBean.login(this.userId, this.password);
            if (this.getLogging()) {
                LogSystem.log(1, "Connected to " + this.host);
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (this.getLogging()) {
                LogSystem.log(1, "Unknown Host. Cannot connect to FTP site :" + this.host);
                LogSystem.log(1, "-----------------------------------------------------------");
                LogSystem.log(1, unknownHostException, false);
                this.lastError = 2;
            }
        }
        catch (Exception exception) {
            if (this.getLogging()) {
                LogSystem.log(1, exception, false);
                this.lastError = 2;
            }
            this.ftpBean = null;
        }
        return this.isConnected();
    }

    public boolean processFile(FTPFile fTPFile) {
        boolean bl = false;
        if (fTPFile != null && fTPFile.validForFTP()) {
            String string = fTPFile.getAbsoluteRemote();
            String string2 = fTPFile.getAbsoluteLocal();
            switch (fTPFile.getRecStatus()) {
                case 1: 
                case 2: 
                case 12: {
                    this.copyToFtp(fTPFile);
                    break;
                }
                case 13: {
                    break;
                }
                case 11: {
                    break;
                }
                case 10: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean copyToFtp(FTPFile fTPFile) {
        boolean bl;
        block10: {
            bl = false;
            try {
                if (this.isConnected()) {
                    if (this.getLogging()) {
                        LogSystem.log(1, "Changing to remote directory: " + fTPFile.getRemoteDirectory());
                    }
                    this.ftpBean.cd(fTPFile.getRemoteDirectory());
                    if (this.getLogging()) {
                        LogSystem.log(1, "Putting File: " + fTPFile.getAbsoluteLocal());
                    }
                    this.ftpBean.put(fTPFile.getAbsoluteLocal(), fTPFile.getRemoteFilename(), false);
                    if (this.getLogging()) {
                        LogSystem.log(1, "File Put");
                    }
                } else {
                    throw new FTPSiteNotConnectedException(fTPFile);
                }
                bl = true;
            }
            catch (FtpError ftpError) {
                this.lastError = ftpError.getReplyCode();
            }
            catch (IOException iOException) {
                if (this.getLogging()) {
                    LogSystem.log(1, iOException, false);
                    this.lastError = 1;
                }
            }
            catch (Exception exception) {
                if (!this.getLogging()) break block10;
                LogSystem.log(1, exception, false);
                this.lastError = 2;
            }
        }
        return bl;
    }

    private boolean moveToFtp(FTPFile fTPFile) {
        boolean bl;
        block3: {
            bl = false;
            if (this.copyToFtp(fTPFile)) {
                try {
                    FileUtil.deleteFile(fTPFile.getAbsoluteLocal());
                    bl = true;
                }
                catch (Exception exception) {
                    if (!this.getLogging()) break block3;
                    LogSystem.log(1, exception, false);
                    this.lastError = 2;
                }
            }
        }
        return bl;
    }

    public int getLastError() {
        return this.lastError;
    }

    public FTPManager() {
    }

    public FTPManager(String string, String string2, String string3) {
        this.setHost(string);
        this.setUserId(string2);
        this.setPassword(string3);
    }
}

