/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import com.ibm.nzna.shared.util.CDate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Date;
import javax.swing.JComponent;

public class AnalogClock
extends JComponent
implements Runnable {
    static final double pi = Math.PI;
    static final double _2pi = Math.PI * 2;
    static final int DATE_WIDTH = 170;
    static final Color mediumGray = new Color(100, 100, 100);
    static final Color lighterGray = new Color(170, 170, 170);
    static final Color darkBlue = new Color(0, 0, 180);
    private Font boldFont = new Font("SansSerif", 0, 12);
    private Font titleFont = new Font("SansSerif", 1, 16);
    protected int second = 0;
    protected int minute = 0;
    protected int hour = 0;
    protected int year = 0;
    protected int month = 0;
    protected int day = 0;
    protected int width = 0;
    protected int height = 0;
    protected int width_org = 0;
    protected int height_org = 0;
    protected Point center = new Point(0, 0);
    protected int radius = 80;
    protected int inside_radius = 0;
    protected int h_len = 0;
    protected int m_len = 0;
    protected int s_len = 0;
    protected boolean am = false;
    private Image clockFaceImage = null;
    protected Image bufImage = null;
    protected boolean showDate = false;
    protected String strDay = "Wednesday";
    protected String strMonth = "February";
    protected Image backImage = null;
    protected boolean pause = false;
    protected Dimension size = new Dimension(0, 0);
    private int clockFaceImageX = 0;
    private int clockFaceImageY = 0;

    public void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.hour = n;
        this.minute = n2;
        this.second = n3;
        this.year = n4;
        this.month = n5;
        this.day = n6;
        this.createBufImage();
        this.paint(this.getGraphics());
    }

    public void showDate(boolean bl) {
        this.showDate = bl;
        this.createBufImage();
    }

    private final void init() {
        new Thread(this).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.revalidate();
        while (true) {
            this.updateSecond();
            try {
                if (!this.pause && this.isVisible()) {
                    this.repaint();
                }
                Thread.currentThread();
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public void setBackground(Image image) {
        this.backImage = image;
        if (this.bufImage != null) {
            this.drawImage(this.bufImage.getGraphics());
            this.repaint();
        }
    }

    void setCoordinates() {
        if (this.showDate) {
            this.size.width = 100;
            this.size.height = 70;
        }
        this.width_org = this.size.width;
        this.height_org = this.size.height;
        this.height = (int)(0.8 * (double)this.height_org);
        this.width = this.width_org;
        if (this.width < this.height) {
            this.height = this.width;
        } else {
            this.width = this.height;
        }
        this.center.x = this.width_org / 2;
        this.center.y = this.height / 2;
        this.radius = this.width * 8 / 20;
        this.inside_radius = this.radius * 8 / 10;
        this.h_len = this.radius * 4 / 10;
        this.m_len = this.radius * 7 / 10;
        this.s_len = this.radius * 6 / 10;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintComponent(Graphics graphics) {
        try {
            this.drawImage(graphics);
            return;
        }
        catch (NullPointerException nullPointerException) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createBufImage() {
        Dimension dimension = this.getSize();
        if (this.bufImage != null) {
            this.bufImage.flush();
            this.bufImage = null;
            System.gc();
        }
        try {
            this.bufImage = this.createImage(dimension.width, dimension.height);
            return;
        }
        catch (Exception exception) {
        }
    }

    void drawImage(Graphics graphics) {
        int n = this.center.x;
        int n2 = this.center.y;
        double d = (double)this.hour + (double)this.minute / 60.0 + (double)this.second / 3600.0;
        double d2 = (double)this.minute + (double)this.second / 60.0;
        double d3 = (double)this.second * (Math.PI * 2) / 60.0;
        this.setCoordinates();
        if (this.showDate) {
            n -= 25;
            n2 -= 5;
        }
        if (this.clockFaceImage == null) {
            graphics.setColor(Color.white);
            graphics.drawOval(n - 1 - this.inside_radius, n2 - 1 - this.inside_radius, this.inside_radius * 2, this.inside_radius * 2);
            graphics.setColor(lighterGray);
            graphics.drawOval(n - this.inside_radius, n2 - this.inside_radius, this.inside_radius * 2, this.inside_radius * 2);
        } else {
            graphics.drawImage(this.clockFaceImage, this.clockFaceImageX, this.clockFaceImageY, this);
        }
        graphics.setColor(this.getForeground());
        graphics.drawLine(n, n2, (int)((double)n + (double)this.h_len * Math.sin(d *= 0.5235987755982988)), (int)((double)n2 - (double)this.h_len * Math.cos(d)));
        graphics.drawLine(n - 1, n2 - 1, (int)((double)n + (double)this.h_len * Math.sin(d)), (int)((double)n2 - (double)this.h_len * Math.cos(d)));
        graphics.drawLine(n + 1, n2 + 1, (int)((double)n + (double)this.h_len * Math.sin(d)), (int)((double)n2 - (double)this.h_len * Math.cos(d)));
        graphics.drawLine(n, n2, (int)((double)n + (double)this.m_len * Math.sin(d2 *= 0.10471975511965977)), (int)((double)n2 - (double)this.m_len * Math.cos(d2)));
        graphics.setColor(mediumGray);
        graphics.drawLine(n, n2, (int)((double)n + (double)this.s_len * Math.sin(d3)), (int)((double)n2 - (double)this.s_len * Math.cos(d3)));
        if (this.showDate) {
            graphics.setColor(darkBlue);
            graphics.setFont(this.titleFont);
            graphics.drawString(this.strDay, 45, 20);
            graphics.setFont(this.boldFont);
            graphics.drawString(this.strMonth + " " + this.day + ", " + this.year, 45, 33);
        }
    }

    public void updateSecond() {
        ++this.second;
        if (this.second == 60) {
            this.second = 0;
            this.updateMinute();
        }
    }

    public void updateMinute() {
        ++this.minute;
        if (this.minute == 60) {
            this.minute = 0;
            this.updateHour();
        }
    }

    public void updateHour() {
        ++this.hour;
        if (this.hour == 12 && !this.am) {
            this.updateDay();
            this.am = true;
        } else if (this.hour == 12 && this.am) {
            this.am = false;
        } else if (this.hour == 13) {
            this.hour = 1;
        }
    }

    public void updateDay() {
        String string = CDate.createDate(this.year, this.month, this.day, 0, 0, 0, 2);
        string = CDate.addDaysToDate(string, 1, 2);
        this.day = CDate.parse(string, 9, 2);
        this.month = CDate.parse(string, 8, 2);
        this.year = CDate.parse(string, 7, 2);
        this.fillStrDates();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalize() {
        if (this.bufImage != null) {
            this.bufImage.flush();
            this.bufImage = null;
        }
        try {
            super.finalize();
            return;
        }
        catch (Throwable throwable) {
        }
    }

    public void fillStrDates() {
        String string = new Date().toString();
        String string2 = string.substring(0, 4).trim();
        String string3 = string.substring(4, 7).trim();
        if (string2.equals("Sun")) {
            this.strDay = "Sunday";
        } else if (string2.equals("Mon")) {
            this.strDay = "Monday";
        } else if (string2.equals("Tue")) {
            this.strDay = "Tuesday";
        } else if (string2.equals("Wed")) {
            this.strDay = "Wednesday";
        } else if (string2.equals("Thu")) {
            this.strDay = "Thursday";
        } else if (string2.equals("Fri")) {
            this.strDay = "Friday";
        } else if (string2.equals("Sat")) {
            this.strDay = "Saturday";
        }
        switch (this.month) {
            case 1: {
                this.strMonth = "January";
                break;
            }
            case 2: {
                this.strMonth = "February";
                break;
            }
            case 3: {
                this.strMonth = "March";
                break;
            }
            case 4: {
                this.strMonth = "April";
                break;
            }
            case 5: {
                this.strMonth = "May";
                break;
            }
            case 6: {
                this.strMonth = "June";
                break;
            }
            case 7: {
                this.strMonth = "July";
                break;
            }
            case 8: {
                this.strMonth = "August";
                break;
            }
            case 9: {
                this.strMonth = "September";
                break;
            }
            case 10: {
                this.strMonth = "October";
                break;
            }
            case 11: {
                this.strMonth = "November";
                break;
            }
            case 12: {
                this.strMonth = "December";
                break;
            }
        }
    }

    public void pause(boolean bl) {
        this.pause = bl;
    }

    public void setBoldFont(Font font) {
        this.boldFont = font;
        this.repaint();
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        this.repaint();
    }

    public void setClockFaceImage(Image image) {
        this.clockFaceImage = image;
    }

    public void setClockFaceImageOffset(int n, int n2) {
        this.clockFaceImageX = n;
        this.clockFaceImageY = n2;
    }

    public AnalogClock() {
        CDate cDate = new CDate(1);
        String string = cDate.today();
        this.hour = CDate.parse(string, 4, 1);
        this.minute = CDate.parse(string, 5, 1);
        this.second = CDate.parse(string, 6, 1);
        this.day = CDate.parse(string, 9, 1);
        this.month = CDate.parse(string, 8, 1);
        this.year = CDate.parse(string, 7, 1);
        this.fillStrDates();
        this.init();
    }

    public AnalogClock(int n, int n2, int n3, int n4, int n5, int n6) {
        this.hour = n;
        this.minute = n2;
        this.second = n3;
        this.year = n4;
        this.month = n5;
        this.day = n6;
        this.init();
    }
}

