/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import com.ibm.nzna.shared.gui.MaskDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DTextArea
extends JPanel
implements DocumentListener,
FocusListener {
    private JTextArea textArea = new JTextArea();
    private JLabel st_MAX = new JLabel("0");
    private JLabel st_CURSORPOS = new JLabel("0");
    private JProgressBar gauge = new JProgressBar();
    private JPanel statusPanel = new JPanel();
    private JScrollPane scrollPane = new JScrollPane(this.textArea);
    private int maximumText = 0;
    private MaskDocument maskDocument = null;

    public void setText(String string) {
        this.textArea.setText(string);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
    }

    public void setMaximumText(int n) {
        if (n > 0) {
            this.maximumText = n;
            this.maskDocument = new MaskDocument(0, n);
            this.maskDocument.addDocumentListener(this);
            this.textArea.setDocument(this.maskDocument);
            this.st_MAX.setText("" + n);
            this.gauge.setMaximum(n);
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.statusPanel, "South");
        this.statusPanel.setLayout(new BorderLayout(5, 5));
        this.statusPanel.add((Component)this.st_MAX, "East");
        this.statusPanel.add((Component)this.st_CURSORPOS, "West");
        this.statusPanel.add((Component)this.gauge, "Center");
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.gauge.setFont(new Font("SansSerif", 0, 10));
        this.gauge.setStringPainted(true);
        this.gauge.setString("Length:0");
        this.setBorder(new BevelBorder(1));
        this.addFocusListener(this);
        this.st_MAX.addFocusListener(this);
        this.gauge.addFocusListener(this);
        this.st_CURSORPOS.addFocusListener(this);
    }

    private void updateGauge() {
        int n = this.textArea.getText().length();
        boolean bl = false;
        this.gauge.setValue(n);
        this.gauge.setString("Length:" + n);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateGauge();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateGauge();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateGauge();
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.textArea.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public DTextArea() {
        this.initialize();
    }

    public DTextArea(String string) {
        this.setText(string);
        this.initialize();
    }

    public DTextArea(int n) {
        this.setMaximumText(n);
        this.initialize();
    }
}

