/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import com.ibm.nzna.shared.gui.DetailList;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;

public class DetailColumnComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    private Object title = null;
    private BevelBorder bevelBorder = new BevelBorder(0);
    private int width = 0;
    private int height = 0;
    private int x = 0;
    private int y = 0;
    private Dimension prefSize = new Dimension(100, 17);
    private boolean cursorSizing = false;
    private boolean mouseDown = false;
    private DetailList detailList = null;
    private int columnNum = 0;
    private boolean bevelDown = false;
    private Polygon ascendingPoly = null;
    private Polygon descendingPoly = null;

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        --dimension.width;
        --dimension.height;
        super.paintComponent(graphics);
        if (this.detailList.getSortColumn() == this.columnNum) {
            Polygon polygon = this.detailList.getSortType() == 1 ? this.ascendingPoly : this.descendingPoly;
            graphics.setColor(Color.darkGray);
        }
        graphics.setColor(this.bevelDown ? Color.darkGray : Color.white);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.setColor(this.bevelDown ? Color.white : Color.darkGray);
        graphics.drawLine(dimension.width, 0, dimension.width, dimension.height);
        graphics.drawLine(1, dimension.height, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        if (this.title instanceof String) {
            if (this.bevelDown) {
                graphics.drawString((String)this.title, 5, 14);
            } else {
                graphics.drawString((String)this.title, 3, 12);
            }
        }
        ++dimension.width;
        ++dimension.height;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n5 = n3 - 10;
        this.width = n3;
        this.height = n4;
        this.x = n;
        this.y = n2;
        super.setBounds(n, n2, n3, n4);
        nArray[0] = n5;
        nArray2[0] = this.height - 3;
        nArray[1] = n5 + 4;
        nArray2[1] = 3;
        nArray[2] = n5 + 8;
        nArray2[2] = this.height - 3;
        this.ascendingPoly = new Polygon(nArray, nArray2, 3);
        nArray[0] = n5;
        nArray2[0] = 3;
        nArray[1] = n5 + 8;
        nArray2[1] = 3;
        nArray[2] = n5 + 4;
        nArray2[2] = this.height - 3;
        this.descendingPoly = new Polygon(nArray, nArray2, 3);
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.prefSize;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.prefSize.width;
    }

    protected void setWidth(int n) {
        this.prefSize.width = n;
        this.invalidate();
    }

    protected void setHeight(int n) {
        this.prefSize.height = n;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.bevelDown = false;
        this.detailList.switchSortType();
        this.detailList.setSortColumn(this.columnNum);
        this.repaintAll();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.cursorSizing) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.cursorSizing) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.bevelDown = false;
        this.repaintAll();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.cursorSizing) {
            this.detailList.showDivider(this.x + mouseEvent.getX());
        }
        this.bevelDown = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDown = true;
        if (!this.cursorSizing) {
            this.bevelDown = true;
        }
        this.repaintAll();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.cursorSizing && mouseEvent.getX() > 18) {
            this.detailList.setColumnWidth(this.columnNum, mouseEvent.getX());
        }
        this.detailList.hideDivider();
        this.mouseDown = false;
        this.cursorSizing = false;
        this.bevelDown = false;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.repaintAll();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.mouseDown) {
            if (mouseEvent.getX() > this.prefSize.width - 4) {
                this.setCursor(Cursor.getPredefinedCursor(11));
                this.cursorSizing = true;
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.cursorSizing = false;
            }
        }
    }

    private final void repaintAll() {
        this.repaint();
    }

    public DetailColumnComponent(int n, DetailList detailList, Object object) {
        this.title = object;
        this.detailList = detailList;
        this.columnNum = n;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }
}

