/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import com.ibm.nzna.shared.gui.DetailTreeCellRenderer;
import com.ibm.nzna.shared.gui.ExtendedMultiListRow;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MutableTreeWrapper;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.gui.ViewTreeNode;
import com.ibm.nzna.shared.util.FontUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class DetailTreeCellComponent
extends JComponent {
    private static Color selBackground = (Color)UIManager.getDefaults().get("Tree.selectionBackground");
    private static Color selForeground = (Color)UIManager.getDefaults().get("Tree.selectionForeground");
    protected Object data = null;
    protected boolean selected = false;
    protected boolean leaf = false;
    protected boolean expanded = false;
    private int defaultHeight = 18;
    private Dimension prefSize = new Dimension(120, this.defaultHeight);
    private Dimension noShowDim = new Dimension(120, 0);
    private boolean noShow = false;
    private DetailTreeCellRenderer treeRenderer = null;
    private int[] colDim = null;
    private FontUtil fontUtil = null;
    private String tempString = null;
    private int tempStringLength = 0;
    private boolean wordWrap = false;
    private boolean evenRow = false;
    private Color lightGray = new Color(246, 246, 246);

    public void refreshData(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.data = object;
        this.selected = bl;
        this.expanded = bl2;
        this.leaf = bl3;
        if (this.data != null && this.data instanceof MutableTreeWrapper && !(this.data instanceof StringTreeNode) && !(this.data instanceof ViewTreeNode)) {
            this.data = ((MutableTreeWrapper)this.data).getDataObject();
        }
        this.noShow = this.data == null || this.data.toString() == null || this.data.toString().length() == 0;
        this.evenRow = n / 2 * 2 != n;
    }

    public Dimension getPreferredSize() {
        if (this.noShow) {
            return this.noShowDim;
        }
        this.prefSize.height = this.defaultHeight;
        if (this.wordWrap && (this.data instanceof MultiListRow || this.data instanceof ExtendedMultiListRow)) {
            this.prefSize.height = this.getPreferredHeightFromMultiListRow((MultiListRow)this.data);
        }
        return this.prefSize;
    }

    public void setPreferredWidth(int n) {
        this.prefSize.width = n;
    }

    public void paint(Graphics graphics) {
        this.getPreferredSize();
        if (this.selected) {
            graphics.setColor(selBackground);
            graphics.fillRect(0, 0, this.prefSize.width, this.prefSize.height);
        } else {
            if (this.evenRow) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(this.lightGray);
            }
            graphics.fillRect(0, 0, this.prefSize.width, this.prefSize.height);
        }
        if (this.selected) {
            graphics.setColor(selForeground);
        } else {
            graphics.setColor(Color.black);
        }
        if (this.data instanceof MultiListRow) {
            this.paintMultiListRow(graphics, (MultiListRow)this.data);
        } else {
            this.paintData(graphics, this.data, 0, 11, 1800, this.prefSize.height, (Rectangle)graphics.getClip());
        }
    }

    private final void paintMultiListRow(Graphics graphics, MultiListRow multiListRow) {
        int n = 0;
        int n2 = 0;
        Rectangle rectangle = (Rectangle)graphics.getClip();
        if (this.colDim.length > 0) {
            int n3 = this.colDim.length;
            while (n < n3) {
                if (multiListRow instanceof ExtendedMultiListRow) {
                    ((ExtendedMultiListRow)multiListRow).adjustColumnGraphics(n3, graphics);
                }
                if (this.data instanceof String) {
                    this.paintData(graphics, multiListRow.getColumnData(n), n2, 11, this.treeRenderer.getColumnWidth(n), this.prefSize.height, rectangle);
                } else {
                    this.paintData(graphics, multiListRow.getColumnData(n), n2, 0, this.treeRenderer.getColumnWidth(n), this.prefSize.height, rectangle);
                }
                n2 += this.treeRenderer.getColumnWidth(n);
                ++n;
            }
        }
    }

    private final int getPreferredHeightFromMultiListRow(MultiListRow multiListRow) {
        int n = 0;
        int n2 = 0;
        if (this.colDim.length > 0) {
            int n3 = this.colDim.length;
            Object object = null;
            while (n < n3) {
                object = multiListRow.getColumnData(n);
                if (object instanceof String[]) {
                    if (n2 < ((String[])object).length * this.defaultHeight) {
                        n2 = ((String[])object).length * this.defaultHeight;
                    }
                } else if (object instanceof Image) {
                    if (n2 < ((Image)object).getHeight(this)) {
                        n2 = ((Image)object).getHeight(this);
                    }
                } else if (n2 < this.defaultHeight) {
                    n2 = this.defaultHeight;
                }
                ++n;
            }
        }
        return n2;
    }

    public void paintData(Graphics graphics, Object object, int n, int n2, int n3, int n4, Rectangle rectangle) {
        if (object != null) {
            if (object instanceof Image) {
                graphics.drawImage((Image)object, n, n2, this);
            } else if (object instanceof ImageIcon) {
                graphics.drawImage(((ImageIcon)object).getImage(), n, n2, this);
            } else if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                int n5 = 0;
                int n6 = 0;
                int n7 = n2 + 11;
                if (stringArray.length == 1) {
                    n7 += 2;
                }
                n5 = 0;
                while (n5 < stringArray.length) {
                    n6 = stringArray[n5].length();
                    if (n6 > 0) {
                        if (this.fontUtil.getFont() != graphics.getFont()) {
                            this.fontUtil.setFont(graphics.getFont());
                        }
                        this.fontUtil.drawCharsEtc(graphics, stringArray[n5].toCharArray(), n6, n, n7, rectangle, n3);
                        n7 += this.defaultHeight;
                    }
                    ++n5;
                }
            } else {
                this.tempString = object.toString();
                if (this.tempString != null) {
                    this.tempStringLength = this.tempString.length();
                    if (this.tempStringLength > 0) {
                        if (this.fontUtil.getFont() != graphics.getFont()) {
                            this.fontUtil.setFont(graphics.getFont());
                        }
                        this.fontUtil.drawCharsEtc(graphics, this.tempString.toCharArray(), this.tempStringLength, n, this.wordWrap && this.prefSize.height != this.defaultHeight ? n2 + 11 : this.fontUtil.getYCentered(n4 - 1), rectangle, n3);
                    }
                }
            }
        }
    }

    protected void setColumnWidth(int n, int n2) {
        this.colDim[n] = n2;
        this.prefSize.width = 0;
        int n3 = 0;
        while (n3 < this.colDim.length) {
            this.prefSize.width += this.colDim[n3];
            ++n3;
        }
        this.prefSize.width += 400;
    }

    protected void setWordWrap(boolean bl) {
        this.wordWrap = bl;
    }

    public DetailTreeCellComponent(DetailTreeCellRenderer detailTreeCellRenderer, int n, FontUtil fontUtil) {
        this.fontUtil = fontUtil;
        this.treeRenderer = detailTreeCellRenderer;
        this.prefSize = new Dimension(120, 18);
        this.colDim = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.colDim[n2] = 100;
            ++n2;
        }
        this.prefSize.width = n * 100 + 400;
    }
}

