/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public final class DropButton
extends JPanel
implements Runnable,
ActionListener {
    private static final String THREAD_FIREACTIONEVENT = "FAE";
    private Vector listenerVec = null;
    private JButton mainButton = null;
    private JButton dropButton = null;
    private JPopupMenu popupMenu = null;
    private Dimension prefSize = null;

    public void init() {
        this.mainButton = new JButton();
        this.dropButton = new JButton("");
        this.popupMenu = new JPopupMenu();
        this.dropButton.setVisible(false);
        this.dropButton.setFocusPainted(false);
        this.dropButton.addActionListener(this);
        this.mainButton.addActionListener(this);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.mainButton, "Center");
        this.add((Component)this.dropButton, "East");
    }

    public void setBorderPainted(boolean bl) {
        this.mainButton.setBorderPainted(bl);
        this.dropButton.setBorderPainted(bl);
    }

    public void setHorizontalAlignment(int n) {
        this.mainButton.setHorizontalAlignment(n);
    }

    public void setMargin(Insets insets) {
        this.mainButton.setMargin(insets);
        this.dropButton.setMargin(insets);
    }

    public void setMnemonic(int n) {
        this.mainButton.setMnemonic(n);
    }

    public void setMnemonic(char c) {
        this.mainButton.setMnemonic(c);
    }

    void setModel(ButtonModel buttonModel) {
        this.mainButton.setModel(buttonModel);
    }

    public void setPressedIcon(Icon icon) {
        this.mainButton.setPressedIcon(icon);
    }

    public void setRolloverEnabled(boolean bl) {
        this.mainButton.setRolloverEnabled(bl);
    }

    public void setRolloverIcon(Icon icon) {
        this.mainButton.setRolloverIcon(icon);
    }

    public void setRolloverSelectedIcon(Icon icon) {
        this.mainButton.setRolloverSelectedIcon(icon);
    }

    public void setSelected(boolean bl) {
        this.mainButton.setSelected(bl);
    }

    public void setSelectedIcon(Icon icon) {
        this.mainButton.setSelectedIcon(icon);
    }

    public void setText(String string) {
        this.mainButton.setText(string);
    }

    public void setActionCommand(String string) {
        this.mainButton.setActionCommand(string);
    }

    public void setContentAreaFilled(boolean bl) {
        this.mainButton.setContentAreaFilled(bl);
        this.dropButton.setContentAreaFilled(bl);
    }

    public void setDisabledIcon(Icon icon) {
        this.mainButton.setDisabledIcon(icon);
    }

    public void setDisabledSelectedIcon(Icon icon) {
        this.mainButton.setDisabledSelectedIcon(icon);
    }

    public void setFocusPainted(boolean bl) {
        this.mainButton.setFocusPainted(bl);
    }

    public void setHorizontalTextPosition(int n) {
        this.mainButton.setHorizontalTextPosition(n);
    }

    public void setIcon(Icon icon) {
        this.mainButton.setIcon(icon);
    }

    public void setIcon(ImageIcon imageIcon) {
        this.mainButton.setIcon(imageIcon);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listenerVec == null) {
            this.listenerVec = new Vector(1, 1);
        }
        this.listenerVec.addElement(actionListener);
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        int n = 0;
        if (this.listenerVec != null) {
            int n2 = this.listenerVec.size();
            while (n < n2) {
                ((ActionListener)this.listenerVec.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_FIREACTIONEVENT)) {
            this.fireActionEvent(new ActionEvent(this, 1001, this.mainButton.getActionCommand()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mainButton) {
            new Thread((Runnable)this, THREAD_FIREACTIONEVENT).start();
        } else if (actionEvent.getSource() == this.dropButton) {
            Point point = this.getLocation();
            this.popupMenu.setLightWeightPopupEnabled(true);
            this.popupMenu.setInvoker(this);
            SwingUtilities.convertPointToScreen(point, this);
            point.y += this.getSize().height;
            this.popupMenu.setLocation(point);
            this.popupMenu.setVisible(true);
        }
    }

    public void setDropButtonPosition(String string) {
        if (!string.equals("Center")) {
            this.remove(this.dropButton);
            this.add((Component)this.dropButton, string);
        }
    }

    public void addJMenu(JMenu jMenu) {
        this.popupMenu.add(jMenu);
        this.dropButton.setVisible(true);
    }

    public void addJMenuItem(JMenuItem jMenuItem) {
        this.popupMenu.add(jMenuItem);
        this.dropButton.setVisible(true);
    }

    public void addSeparator() {
        this.popupMenu.addSeparator();
        this.dropButton.setVisible(true);
    }

    public void remove(Component component) {
        this.popupMenu.remove(component);
        this.dropButton.setVisible(this.popupMenu.getComponentCount() > 0);
    }

    public void remove(int n) {
        this.popupMenu.remove(n);
        this.dropButton.setVisible(this.popupMenu.getComponentCount() > 0);
    }

    public Insets getMargin() {
        return this.mainButton.getMargin();
    }

    public Icon getIcon() {
        return this.mainButton.getIcon();
    }

    public Icon getPressedIcon() {
        return this.mainButton.getPressedIcon();
    }

    public Icon getSelectedIcon() {
        return this.mainButton.getSelectedIcon();
    }

    public Icon getRolloverIcon() {
        return this.mainButton.getRolloverIcon();
    }

    public Icon getRolloverSelectedIcon() {
        return this.mainButton.getRolloverSelectedIcon();
    }

    public Icon getDisabledIcon() {
        return this.mainButton.getDisabledIcon();
    }

    public Icon getDisabledSelectedIcon() {
        return this.mainButton.getDisabledSelectedIcon();
    }

    public int getVerticalAlignment() {
        return this.mainButton.getVerticalAlignment();
    }

    public int getHorizontalAlignment() {
        return this.mainButton.getHorizontalAlignment();
    }

    public int getVerticalTextPosition() {
        return this.mainButton.getVerticalTextPosition();
    }

    public int getHorizontalTextPosition() {
        return this.mainButton.getHorizontalTextPosition();
    }

    public boolean isFocusPainted() {
        return this.mainButton.isFocusPainted();
    }

    public boolean isBorderPainted() {
        return this.mainButton.isBorderPainted();
    }

    public boolean isContentAreaFilled() {
        return this.mainButton.isContentAreaFilled();
    }

    public boolean isRolloverEnabled() {
        return this.mainButton.isRolloverEnabled();
    }

    public int getMnemonic() {
        return this.mainButton.getMnemonic();
    }

    public ButtonModel getModel() {
        return this.mainButton.getModel();
    }

    public void setVerticalTextPosition(int n) {
        this.mainButton.setVerticalTextPosition(n);
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            Dimension dimension = this.mainButton.getMinimumSize();
            Dimension dimension2 = this.dropButton.getMinimumSize();
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
            dimension.width += dimension2.width;
            return dimension;
        }
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public void setDropIcon(ImageIcon imageIcon) {
        this.dropButton.setIcon(imageIcon);
    }

    public DropButton() {
        this.init();
    }

    public DropButton(String string) {
        this.init();
        this.setText(string);
    }

    public DropButton(ImageIcon imageIcon) {
        this.init();
        this.setIcon(imageIcon);
    }

    public DropButton(String string, ImageIcon imageIcon) {
        this.init();
        this.setText(string);
        this.setIcon(imageIcon);
    }
}

