/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class HotLinkLabel
extends JComponent
implements Runnable,
MouseListener,
MouseMotionListener {
    private static final String THREAD_FIREACTION = "FA";
    private Vector listenerVec = null;
    private String text = null;
    private int fontLeading = 0;
    private int fontDescent = 0;
    private int fontHeight = 0;
    private int fontWidth = 0;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private boolean mouseOver = false;
    private boolean mouseDown = false;
    private ImageIcon imageIcon = null;
    private Dimension minSize = new Dimension(0, 0);
    private String actionCommand = null;
    private boolean enabled = true;
    private int buttonId = 0;
    private Object data = null;
    private boolean selected = false;
    private boolean showSelection = true;
    private boolean autoSelect = true;
    private Font currentFont = null;
    private Color selectedForeground = null;
    private Color selectedBackground = null;

    private void initialize() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (this.currentFont == null) {
            this.currentFont = (Font)UIManager.getDefaults().get("Button.font");
        }
        if (this.selectedForeground == null) {
            this.selectedForeground = (Color)UIManager.getDefaults().get("List.selectionForeground");
        }
        if (this.selectedBackground == null) {
            this.selectedBackground = (Color)UIManager.getDefaults().get("List.selectionBackground");
        }
        this.setFont(this.currentFont);
    }

    public void setText(String string) {
        this.text = string;
        this.fontWidth = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont()).stringWidth(string);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listenerVec == null) {
            this.listenerVec = new Vector(1, 1);
        }
        this.listenerVec.addElement(actionListener);
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paintComponent(graphics);
        --dimension.height;
        --dimension.width;
        if (this.selected) {
            if (this.showSelection) {
                graphics.setColor(this.selectedBackground);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
        } else if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.enabled) {
            if (!this.mouseOver) {
                graphics.setColor(this.getForeground());
            } else {
                graphics.setColor(this.selectedBackground);
            }
            if (this.mouseDown && this.mouseOver) {
                graphics.setColor(Color.red);
            }
        } else {
            graphics.setColor(Color.darkGray);
        }
        if (this.text != null) {
            int n = (dimension.height - this.fontHeight) / 2;
            int n2 = dimension.height - n - this.fontDescent - this.fontLeading / 2;
            if (this.selected) {
                if (this.showSelection) {
                    graphics.setColor(this.selectedForeground);
                }
            } else {
                graphics.setColor(this.getForeground());
            }
            graphics.setFont(this.currentFont);
            graphics.drawString(this.text, this.imageWidth + 1, n2);
            if (this.imageIcon != null) {
                graphics.drawImage(this.imageIcon.getImage(), 0, dimension.height / 2 - this.imageHeight / 2, this);
            }
            if (this.mouseOver && this.enabled) {
                graphics.drawLine(0, n2 + 1, this.fontWidth + this.imageWidth, n2 + 1);
            }
        }
    }

    public void setFont(Font font) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.fontHeight = fontMetrics.getHeight();
        this.fontDescent = fontMetrics.getDescent();
        this.fontLeading = fontMetrics.getLeading();
        if (this.text != null) {
            this.fontWidth = Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth(this.text);
        }
        this.currentFont = font;
        super.setFont(font);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getX() < this.fontWidth + this.imageWidth && !this.mouseDown) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.mouseDown = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseDown = false;
        if (this.enabled && this.mouseOver) {
            new Thread((Runnable)this, THREAD_FIREACTION).start();
            if (this.autoSelect) {
                this.setSelected(true);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getX() < this.fontWidth + this.imageWidth) {
            if (!this.mouseOver) {
                this.mouseOver = true;
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.repaint();
            }
        } else if (this.mouseOver) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.mouseOver = false;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_FIREACTION)) {
            this.fireActionEvent();
        }
    }

    private void fireActionEvent() {
        if (this.listenerVec != null) {
            ActionEvent actionEvent = null;
            int n = this.listenerVec.size();
            int n2 = 0;
            actionEvent = this.actionCommand == null ? new ActionEvent(this, 1001, this.text, 0) : new ActionEvent(this, 1001, this.actionCommand, 0);
            while (n2 < n) {
                ((ActionListener)this.listenerVec.elementAt(n2)).actionPerformed(actionEvent);
                ++n2;
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n;
        this.minSize.height = this.fontHeight;
        if (this.fontWidth == 0) {
            this.setText(this.text);
        }
        this.minSize.width = this.fontWidth + 3 + this.imageWidth + 4 * this.text.length();
        if (this.imageIcon != null && (n = this.imageIcon.getImage().getHeight(this) + 4) > this.minSize.height) {
            this.minSize.height = n;
        }
        return this.minSize;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
        if (imageIcon != null) {
            this.imageWidth = imageIcon.getImage().getWidth(this);
            this.imageHeight = imageIcon.getImage().getHeight(this);
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        this.revalidate();
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getText() {
        return this.text;
    }

    public ImageIcon getIcon() {
        return this.imageIcon;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.repaint();
    }

    public void setId(int n) {
        this.buttonId = n;
    }

    public int getId() {
        return this.buttonId;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public Object getData() {
        return this.data;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelectedForeground(Color color) {
        this.selectedForeground = color;
        this.revalidate();
    }

    public void setSelectedBackground(Color color) {
        this.selectedBackground = color;
        this.revalidate();
    }

    public void showSelection(boolean bl) {
        this.showSelection = bl;
        this.revalidate();
    }

    public void setAutoSelect(boolean bl) {
        this.autoSelect = bl;
    }

    public String toString() {
        return this.getText();
    }

    public HotLinkLabel() {
        this.initialize();
    }

    public HotLinkLabel(String string) {
        this.initialize();
        this.setText(string);
    }

    public HotLinkLabel(ImageIcon imageIcon) {
        this.initialize();
        this.setIcon(imageIcon);
    }

    public HotLinkLabel(String string, ImageIcon imageIcon) {
        this.initialize();
        this.setText(string);
        this.setIcon(imageIcon);
    }

    public HotLinkLabel(String string, ImageIcon imageIcon, String string2) {
        this.initialize();
        this.setText(string);
        this.setActionCommand(string2);
        this.setIcon(imageIcon);
    }

    public HotLinkLabel(String string, ImageIcon imageIcon, String string2, int n) {
        this.initialize();
        this.setId(n);
        this.setText(string);
        this.setActionCommand(string2);
        this.setIcon(imageIcon);
    }

    public HotLinkLabel(String string, int n) {
        this.initialize();
        this.setId(n);
        this.setText(string);
    }

    public HotLinkLabel(ImageIcon imageIcon, int n) {
        this.initialize();
        this.setIcon(imageIcon);
        this.setId(n);
    }

    public HotLinkLabel(String string, ImageIcon imageIcon, int n) {
        this.initialize();
        this.setText(string);
        this.setId(n);
        this.setIcon(imageIcon);
    }

    public HotLinkLabel(String string, ImageIcon imageIcon, String string2, int n, Object object) {
        this.initialize();
        this.setData(object);
        this.setId(n);
        this.setText(string);
        this.setActionCommand(string2);
        this.setIcon(imageIcon);
    }

    public HotLinkLabel(String string, int n, Object object) {
        this.initialize();
        this.setData(object);
        this.setId(n);
        this.setText(string);
    }

    public HotLinkLabel(ImageIcon imageIcon, int n, Object object) {
        this.initialize();
        this.setData(this.data);
        this.setIcon(imageIcon);
        this.setId(n);
    }

    public HotLinkLabel(String string, ImageIcon imageIcon, int n, Object object) {
        this.initialize();
        this.setData(object);
        this.setText(string);
        this.setId(n);
        this.setIcon(imageIcon);
    }

    public HotLinkLabel(String string, ActionListener actionListener) {
        this.initialize();
        this.setText(string);
        this.addActionListener(actionListener);
    }
}

