/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import com.ibm.nzna.shared.util.CDate;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class MaskDocument
extends PlainDocument
implements FocusListener {
    private static final int BLANKCHAR = 250;
    public static final int MASKTYPE_UNKNOWN = 0;
    public static final int MASKTYPE_UPPER = 1;
    public static final int MASKTYPE_LOWER = 2;
    public static final int MASKTYPE_NUMERIC = 3;
    public static final int MASKTYPE_STRING = 4;
    public static final int MASKTYPE_DATE = 5;
    private JTextComponent textComponent = null;
    private int maxTextLen = 1024;
    private int maskType = 0;
    private String mask = null;
    private char[] maskArray = null;
    private char[] maskDisplayArray = null;
    private int dateType = 2;
    private int minimumOffset = 0;

    public void setMinimumOffset(int n) {
        this.minimumOffset = n;
    }

    public void setMaxTextLength(int n) {
        this.maxTextLen = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertString(int n, String string, AttributeSet attributeSet) {
        if (string == null) return;
        try {
            int n2 = string.length();
            boolean bl = true;
            switch (this.maskType) {
                case 1: {
                    string = string.toUpperCase();
                    break;
                }
                case 2: {
                    string = string.toLowerCase();
                    break;
                }
                case 3: {
                    try {
                        int n3 = new Integer(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                        string = "";
                    }
                    break;
                }
                case 4: 
                case 5: {
                    this.formatCharForMask(n, string, attributeSet);
                    bl = false;
                    break;
                }
            }
            if (bl && this.getLength() + n2 > this.maxTextLen) {
                if (n2 > 1) {
                    string = string.substring(0, this.maxTextLen - this.getLength());
                } else {
                    bl = false;
                }
            }
            if (!bl) return;
            super.insertString(n, string, attributeSet);
            return;
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Bad Location:");
            badLocationException.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(int var1_1, int var2_2) {
        try {
            if (!this.isMaskString() || var2_2 == 0) {
                super.remove(var1_1, var2_2);
                return;
            }
            var3_3 = null;
            var4_5 = new char[var2_2];
            var5_6 = 0;
            if (true) ** GOTO lbl14
        }
        catch (BadLocationException var3_4) {
        }
        return;
        do {
            var4_5[var5_6++] = 250;
lbl14:
            // 2 sources

        } while (var5_6 < var2_2);
        this.formatCharForMask(var1_1, new String(var4_5), null);
        this.textComponent.setCaretPosition(var1_1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void formatCharForMask(int n, String string, AttributeSet attributeSet) {
        char c = ' ';
        int n2 = string.length();
        int n3 = 0;
        int n4 = this.getLength();
        while (n3 < n2 && n >= 0 && n < this.maskDisplayArray.length) {
            c = string.charAt(n3);
            if (c != this.maskDisplayArray[n] && (n = this.getNextMaskInsertPoint(n)) >= 0 && this.doesCharFitMask(c, this.maskArray[n])) {
                if (c == '\u00fa') {
                    this.maskDisplayArray[n] = 32;
                } else {
                    if ((this.maskArray[n] == 'U' || this.maskArray[n] == 'V') && MaskDocument.isAlpha(c)) {
                        c = new String("" + c).toUpperCase().charAt(0);
                    }
                    this.maskDisplayArray[n] = c;
                }
            }
            if (n >= 0) {
                ++n;
            }
            ++n3;
        }
        try {
            super.remove(0, n4);
            super.insertString(0, new String(this.maskDisplayArray), attributeSet);
            if (n + 1 > n4) {
                n = n4 - 1;
            }
            if (n < 0) {
                n = 0;
            }
            this.textComponent.setCaretPosition(n);
            return;
        }
        catch (BadLocationException badLocationException) {
        }
    }

    /*
     * Unable to fully structure code
     */
    private final int getNextMaskInsertPoint(int var1_1) {
        block1: {
            var2_2 = var1_1;
            if (this.mask == null) break block1;
            var3_3 = this.mask.length();
            if (var1_1 < var3_3) ** GOTO lbl9
            var2_2 = -1;
            break block1;
lbl-1000:
            // 1 sources

            {
                if (++var2_2 <= var3_3) continue;
                var2_2 = -1;
lbl9:
                // 3 sources

                ** while (!this.isMaskChar((char)this.mask.charAt((int)var2_2)) && var2_2 >= 0)
            }
        }
        return var2_2;
    }

    private final boolean isMaskChar(char c) {
        boolean bl = false;
        if (c == 'A' || c == 'X' || c == 'V' || c == 'U' || c == '9') {
            bl = true;
        }
        return bl;
    }

    private final boolean doesCharFitMask(char c, char c2) {
        boolean bl = false;
        if (c2 == '9') {
            bl = MaskDocument.isNumeric(c) && !MaskDocument.isSpace(c);
        } else if (c2 == 'X') {
            bl = MaskDocument.isAlpha(c) || MaskDocument.isNumeric(c);
        } else if (c2 == 'A') {
            bl = MaskDocument.isAlpha(c);
        } else if (c2 == 'U') {
            bl = MaskDocument.isAlpha(c);
        } else if (c2 == 'V') {
            boolean bl2 = bl = MaskDocument.isAlpha(c) || MaskDocument.isNumeric(c);
        }
        if (c == '\u00fa') {
            bl = true;
        }
        return bl;
    }

    private static final boolean isAlpha(char c) {
        return Character.isLetter(Character.toUpperCase(c)) || c == ' ';
    }

    private static final boolean isNumeric(char c) {
        return Character.isDigit(c);
    }

    private static final boolean isSpace(int n) {
        return n == 32;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setStringMask(String var1_1) {
        block5: {
            block4: {
                var2_2 = 0;
                var3_3 = "";
                if (var1_1 == null) break block4;
                this.mask = var1_1;
                this.maskArray = var1_1.toCharArray();
                this.maskDisplayArray = var1_1.toCharArray();
                if (true) ** GOTO lbl15
            }
            this.maskType = 0;
            break block5;
            do {
                if (this.isMaskChar(this.maskDisplayArray[var2_2])) {
                    this.maskDisplayArray[var2_2] = 32;
                }
                ++var2_2;
lbl15:
                // 2 sources

            } while (var2_2 < this.maskDisplayArray.length);
            var3_3 = new String(this.maskDisplayArray);
        }
        try {
            super.remove(0, this.getLength());
            super.insertString(0, var3_3, null);
            return;
        }
        catch (BadLocationException var4_4) {
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.format4DigitYear();
    }

    public void setTextComponent(JTextComponent jTextComponent) throws NullPointerException {
        if (jTextComponent == null) {
            throw new NullPointerException();
        }
        if (this.textComponent != null) {
            this.textComponent.removeFocusListener(this);
        }
        this.textComponent = jTextComponent;
        if (this.maskType == 5) {
            jTextComponent.addFocusListener(this);
        }
    }

    public void setDateType(int n) {
        this.dateType = n;
    }

    private final void format4DigitYear() {
        if (this.textComponent != null) {
            String string = this.textComponent.getText();
            string = CDate.format4DigitYear(string, this.dateType);
            this.formatCharForMask(0, string, null);
        }
    }

    private final boolean isMaskString() {
        return this.maskType == 4 || this.maskType == 5;
    }

    public int getMaxTextLength() {
        return this.maxTextLen;
    }

    public MaskDocument(int n, String string, JTextComponent jTextComponent) throws NullPointerException {
        if (string != null && string.length() > 0 && jTextComponent != null) {
            this.maskType = n;
            this.setMaxTextLength(string.length());
            this.setStringMask(string);
            this.setTextComponent(jTextComponent);
        }
    }

    public MaskDocument(int n) {
        this.maskType = n;
    }

    public MaskDocument(int n, int n2) {
        if (n == 4 || n == 5) {
            n = 0;
        }
        this.maskType = n;
        this.setMaxTextLength(n2);
    }
}

