/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.shared.gui.DList;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.DetailColumnHeader;
import com.ibm.nzna.shared.gui.DetailList;
import com.ibm.nzna.shared.gui.ExtendedMultiListRow;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MultiListRowRenderer;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.gui.MultiListSorter;
import com.ibm.nzna.shared.util.FontUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultiList
extends DPanel
implements AppConst,
DetailList,
Runnable,
MouseListener,
ListSelectionListener {
    private static int PAGE_TOP = 40;
    private static int PAGE_LEFT = 20;
    private JScrollPane scr_PANE = null;
    protected JList lb_LIST = null;
    private DetailColumnHeader titlePanel = null;
    private Panel pnl_SPLIT = new Panel();
    private DPanel pnl_HOLDPANEL = new DPanel();
    private Vector headings = null;
    private MultiListRowRenderer cellRenderer = null;
    private FontUtil fontUtil = null;
    private int columnCount = 0;
    private DefaultListModel listModel = null;
    private Color oddLinesColor = Color.white;
    private Vector actionVec = null;
    private Vector selectionVec = null;
    private int firstIndex = 0;
    private int lastIndex = 0;
    private boolean isAdjusting = false;
    private int sortColumn = -1;
    private int sortType = 1;
    private ListSelectionEvent lastSelectionEvent = null;
    private int numRows = 0;

    private void initialize(FontUtil fontUtil) {
        this.fontUtil = fontUtil;
        this.titlePanel = new DetailColumnHeader(this);
        this.listModel = new DefaultListModel();
        this.setLayout(null);
        this.add(this.pnl_HOLDPANEL);
        this.pnl_HOLDPANEL.setLayout(new BorderLayout());
        this.lb_LIST = new DList();
        this.scr_PANE = new JScrollPane(this.lb_LIST);
        this.pnl_HOLDPANEL.add((Component)this.scr_PANE, "Center");
        this.add(this.pnl_SPLIT);
        this.pnl_SPLIT.setVisible(false);
        this.scr_PANE.setBorder(new BevelBorder(1));
        this.scr_PANE.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        this.cellRenderer = new MultiListRowRenderer(this, fontUtil);
        this.lb_LIST.setCellRenderer(this.cellRenderer);
        this.lb_LIST.setModel(this.listModel);
        this.lb_LIST.addListSelectionListener(this);
        this.pnl_SPLIT.setBackground(Color.black);
        this.setBackground(Color.white);
        this.lb_LIST.setBackground(Color.white);
        this.lb_LIST.addMouseListener(this);
    }

    public void setWordWrap(boolean bl) {
        this.cellRenderer.setWordWrap(bl);
        this.setRowHeight(-1);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        super.doLayout();
        this.pnl_HOLDPANEL.setBounds(0, 0, dimension.width, dimension.height);
    }

    public void setColumnHeadings(Vector vector) {
        int n = 0;
        int n2 = 0;
        this.titlePanel = new DetailColumnHeader(this);
        if (vector == null) {
            this.titlePanel.removeAll();
        } else {
            this.scr_PANE.setColumnHeaderView(this.titlePanel);
            n2 = vector.size();
            this.headings = vector;
            while (n < n2) {
                this.titlePanel.addColumn(vector.elementAt(n));
                ++n;
            }
            this.cellRenderer.setRowWidth(this.titlePanel.getPreferredSize().width);
            this.cellRenderer.setColumnNum(n2);
            this.columnCount = n2;
        }
    }

    public void setColumnHeadings(Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            Vector<Object> vector = new Vector<Object>(objectArray.length);
            while (n < objectArray.length) {
                vector.addElement(objectArray[n++]);
            }
            this.setColumnHeadings(vector);
        }
    }

    public void setColumnHeadingBorder(Border border) {
        this.titlePanel.setColumnHeadingBorder(border);
    }

    public Vector getColumnHeadings() {
        return this.headings;
    }

    public int getColumnCount() {
        if (this.headings != null) {
            return this.headings.size();
        }
        return 0;
    }

    public void setData(Vector vector) {
        this.removeAll();
        this.add(vector);
    }

    public void setData(Object[] objectArray) {
        this.removeAll();
        if (objectArray != null) {
            this.add(objectArray);
        }
    }

    public int getColumnX(int n) {
        return this.titlePanel.getColumnX(n);
    }

    public int getColumnWidth(int n) {
        return this.titlePanel.getColumnWidth(n);
    }

    public void setColumnWidth(int n, int n2) {
        this.titlePanel.setColumnWidth(n, n2);
        this.refreshExtendedColumnWidths(n, n2);
        this.refreshColumns();
    }

    private void refreshExtendedColumnWidths(int n, int n2) {
        int n3 = 0;
        int n4 = this.listModel.size();
        while (n3 < n4) {
            if (this.listModel.getElementAt(n3) instanceof ExtendedMultiListRow) {
                ((ExtendedMultiListRow)this.listModel.getElementAt(n3)).columnSized(n, n2);
            }
            ++n3;
        }
    }

    public void refreshExtendedColumnWidths() {
        try {
            int n = 0;
            int n2 = this.listModel.size();
            int n3 = 0;
            int n4 = this.headings.size();
            while (n < n2) {
                if (this.listModel.getElementAt(n) instanceof ExtendedMultiListRow) {
                    n3 = 0;
                    while (n3 < n4) {
                        ((ExtendedMultiListRow)this.listModel.getElementAt(n)).columnSized(n3, this.titlePanel.getColumnWidth(n3));
                        ++n3;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshColumns() {
        this.invalidate();
        this.scr_PANE.invalidate();
        this.scr_PANE.revalidate();
        this.revalidate();
        this.scr_PANE.repaint();
        this.cellRenderer.setRowWidth(this.titlePanel.getPreferredSize().width);
        this.cellRenderer.setColumnNum(this.columnCount);
        this.lb_LIST.setFixedCellWidth(this.titlePanel.getPreferredSize().width);
    }

    public void showDivider(int n) {
        this.pnl_SPLIT.setVisible(true);
        this.pnl_SPLIT.setBounds(n, 0, 2, this.height);
    }

    public void hideDivider() {
        this.pnl_SPLIT.setVisible(false);
    }

    public JList getJList() {
        return this.lb_LIST;
    }

    public void setBorder(Border border) {
        if (this.scr_PANE != null) {
            this.scr_PANE.setBorder(border);
        }
    }

    public void setRowHeight(int n) {
        this.lb_LIST.setFixedCellHeight(n);
        if (this.cellRenderer != null) {
            this.cellRenderer.setRowHeight(n);
        }
    }

    public JScrollPane getJScrollPane() {
        return this.scr_PANE;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        try {
            if (this.lb_LIST != null) {
                this.lb_LIST.setBackground(color);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBackground(Image image) {
        this.cellRenderer.setBackground(image);
        this.pnl_HOLDPANEL.setBackground(image);
        this.lb_LIST.setOpaque(false);
    }

    public void add(MultiListRow multiListRow) {
        if (this.sortColumn != -1) {
            this.listModel.add(this.sortedIndex((MultiListSort)((Object)multiListRow)), multiListRow);
        } else {
            this.listModel.add(this.listModel.getSize(), multiListRow);
        }
    }

    public void add(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            if (this.sortColumn >= 0) {
                objectArray2 = this.listModel.toArray();
                if (objectArray2 != null) {
                    objectArray = new Object[objectArray2.length + vector.size()];
                    while (n < n2) {
                        objectArray[n + objectArray2.length] = vector.elementAt(n);
                        ++n;
                    }
                } else {
                    objectArray = new Object[vector.size()];
                    vector.copyInto(objectArray);
                }
                new MultiListSorter(objectArray, this.sortColumn, this.sortType);
                n = 0;
                this.removeAll();
                this.listModel.ensureCapacity(objectArray.length);
                while (n < objectArray.length) {
                    this.listModel.add(n, objectArray[n]);
                    ++n;
                }
            } else {
                int n3 = 0;
                this.listModel = new DefaultListModel();
                this.listModel.ensureCapacity(this.listModel.getSize() + n2);
                while (n < n2) {
                    this.listModel.add(n3++, vector.elementAt(n));
                    ++n;
                }
                this.lb_LIST.setModel(this.listModel);
                this.scr_PANE.getHorizontalScrollBar().setValue(0);
            }
        }
        this.refreshExtendedColumnWidths();
        this.invalidate();
        this.lb_LIST.invalidate();
        this.scr_PANE.invalidate();
        this.revalidate();
    }

    public void selectAll(boolean bl) {
        if (bl) {
            int[] nArray = new int[this.listModel.getSize()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = n;
                ++n;
            }
            this.lb_LIST.setSelectedIndices(nArray);
        } else {
            this.lb_LIST.clearSelection();
        }
    }

    public void remove(MultiListRow multiListRow) {
        if (multiListRow != null) {
            this.listModel.removeElement(multiListRow);
        }
    }

    public Vector getData() {
        Vector<Object> vector = new Vector<Object>(10, 1);
        Object[] objectArray = this.listModel.toArray();
        int n = 0;
        if (objectArray != null) {
            while (n < objectArray.length) {
                vector.addElement(objectArray[n]);
                ++n;
            }
        }
        return vector;
    }

    public void removeAll() {
        this.listModel.removeAllElements();
        this.listModel = new DefaultListModel();
        this.listModel.ensureCapacity(1000);
        this.lb_LIST.setModel(this.listModel);
    }

    public Vector getSelection() {
        Object[] objectArray = this.lb_LIST.getSelectedValues();
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        return vector;
    }

    public void add(Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            Vector<Object> vector = null;
            vector = new Vector<Object>(10, 10);
            while (n < objectArray.length) {
                vector.addElement(objectArray[n]);
                ++n;
            }
            this.add(vector);
        }
    }

    public void addPanel(Component component, String string) {
        if (!string.equals("Center")) {
            this.pnl_HOLDPANEL.add(component, string);
        }
    }

    public void removePanel(Component component) {
        this.pnl_HOLDPANEL.remove(component);
    }

    public void removeSelectedItems() {
        Vector vector = this.getSelection();
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.listModel.removeElement(vector.elementAt(n));
                ++n;
            }
        }
    }

    public void showColumnHeadings(boolean bl) {
        this.titlePanel.setShowing(bl);
    }

    public void setSelectedItem(Object object, boolean bl) {
        this.lb_LIST.setSelectedValue(object, bl);
    }

    public void setSelectedIndices(int[] nArray) {
        this.lb_LIST.setSelectedIndices(nArray);
    }

    public Object getSelectedItem() {
        return this.lb_LIST.getSelectedValue();
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals("SELECTION")) {
            this.fireSelectionEvent();
        } else if (string.equals("ACTION")) {
            this.fireActionEvent();
        }
    }

    private void fireActionEvent() {
        if (this.actionVec != null) {
            ActionEvent actionEvent = null;
            int n = 0;
            int n2 = this.actionVec.size();
            actionEvent = new ActionEvent(this, 1001, "");
            while (n < n2) {
                ((ActionListener)this.actionVec.elementAt(n++)).actionPerformed(actionEvent);
            }
        }
    }

    private void fireSelectionEvent() {
        if (this.selectionVec != null) {
            int n = 0;
            int n2 = this.selectionVec.size();
            ListSelectionEvent listSelectionEvent = null;
            listSelectionEvent = new ListSelectionEvent(this, this.lastSelectionEvent.getFirstIndex(), this.lastSelectionEvent.getLastIndex(), this.lastSelectionEvent.getValueIsAdjusting());
            while (n < n2) {
                ((ListSelectionListener)this.selectionVec.elementAt(n++)).valueChanged(listSelectionEvent);
            }
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.selectionVec == null) {
            this.selectionVec = new Vector(1, 1);
        }
        this.selectionVec.addElement(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.actionVec != null) {
            this.actionVec.removeElement(listSelectionListener);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionVec == null) {
            this.actionVec = new Vector(1, 1);
        }
        this.actionVec.addElement(actionListener);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.lastSelectionEvent = listSelectionEvent;
        new Thread((Runnable)this, "SELECTION").start();
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionVec != null) {
            this.actionVec.removeElement(actionListener);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && this.actionVec != null) {
            new Thread((Runnable)this, "ACTION").start();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean containsItem(Object object) {
        boolean bl = false;
        Object[] objectArray = this.listModel.toArray();
        if (objectArray != null) {
            int n = 0;
            while (!bl && n < objectArray.length) {
                if (objectArray[n] != null) {
                    bl = objectArray[n].equals(object);
                }
                ++n;
            }
        }
        return bl;
    }

    public void setSort(int n) {
        if (n == 1 || n == 2) {
            this.sortType = n;
        }
    }

    public void switchSortType() {
        this.sortType = this.sortType == 1 ? 2 : 1;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(int n) {
        Object[] objectArray = this.listModel.toArray();
        this.sortColumn = n;
        if (objectArray != null) {
            Object object = this.getSelectedItem();
            this.removeAll();
            this.add(objectArray);
            this.setSelectedItem(object, true);
        }
        this.titlePanel.repaint();
    }

    private int sortedIndex(MultiListSort multiListSort) {
        int n = 0;
        int n2 = 0;
        int n3 = this.listModel.getSize();
        while (n < n3 && n2 == 0) {
            if (this.sortType == 2 && ((MultiListSort)this.listModel.elementAt(n)).compareTo(multiListSort, this.sortColumn) == 1) {
                n2 = n - 1;
            } else if (((MultiListSort)this.listModel.elementAt(n)).compareTo(multiListSort, this.sortColumn) == 1) {
                n2 = n + 1;
            }
            ++n;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    public void setOddLinesColor(Color color) {
        this.oddLinesColor = color;
        this.repaint();
    }

    public Color getOddLinesColor() {
        return this.oddLinesColor;
    }

    public void setColumnHeadingsBackground(Color color) {
        this.titlePanel.setBackground(color);
    }

    public int getSortType() {
        return this.sortType;
    }

    public void printRow(MultiListRow multiListRow, Graphics graphics) {
        this.cellRenderer.getListCellRendererComponent(this.lb_LIST, multiListRow, 1, false, false);
        this.cellRenderer.paint(graphics);
    }

    public void print(PrintJob printJob, Dimension dimension) {
        Panel panel = new Panel();
        DList dList = new DList();
        dList.setCellRenderer(this.cellRenderer);
        dList.setModel(this.listModel);
        Graphics graphics = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.listModel.getSize();
        n = 0;
        while (this.numRows < n3) {
            graphics = printJob.getGraphics();
            MultiList.paintHeader(graphics, dimension);
            int n4 = this.numRows;
            while (n2 <= 648) {
                this.printRow((MultiListRow)this.listModel.elementAt(n4), graphics);
                int n5 = this.cellRenderer.getPreferredHeightFromMultiListRow((MultiListRow)this.listModel.elementAt(n4));
                n2 += n5;
                graphics.translate(0, n5);
                ++this.numRows;
                if (this.numRows >= n3) break;
                ++n4;
            }
            n2 = 0;
            System.out.println("Multilist  printrow");
            ++n;
        }
        panel = null;
        dList = null;
    }

    private static void paintHeader(Graphics graphics, Dimension dimension) {
        if (graphics != null) {
            Font font = graphics.getFont();
            graphics.setFont(FontSystem.largeTitleFont);
            graphics.setColor(Color.black);
            graphics.drawString("Quest", PAGE_LEFT, 30);
            graphics.drawLine(PAGE_LEFT, 32, dimension.width - PAGE_LEFT, 32);
            graphics.drawLine(PAGE_LEFT, 33, dimension.width - PAGE_LEFT, 33);
            graphics.drawLine(PAGE_LEFT, 34, dimension.width - PAGE_LEFT, 34);
            graphics.drawLine(PAGE_LEFT, 35, dimension.width - PAGE_LEFT, 35);
            graphics.setFont(font);
        }
        graphics.translate(15, 40);
    }

    private static void paintFooter(Graphics graphics, Dimension dimension, int n, int n2) {
        if (graphics != null) {
            Font font = graphics.getFont();
            String string = n + " " + Str.getStr(408) + " " + n2;
            FontMetrics fontMetrics = null;
            graphics.drawLine(PAGE_LEFT, 675, dimension.width - PAGE_LEFT, 675);
            graphics.drawLine(PAGE_LEFT, 677, dimension.width - PAGE_LEFT, 677);
            graphics.drawLine(PAGE_LEFT, 678, dimension.width - PAGE_LEFT, 678);
            graphics.setFont(FontSystem.smallFont);
            fontMetrics = graphics.getFontMetrics();
            graphics.drawString(DateSystem.getDate(2), PAGE_LEFT, 686);
            graphics.drawString(string, dimension.width / 2 - SwingUtilities.computeStringWidth(fontMetrics, string) / 2, 686);
            graphics.setFont(font);
        }
    }

    public int getNumOfPages(Dimension dimension) {
        try {
            int n = 0;
            n = this.lb_LIST.getSize().height / dimension.height + 1;
            return n;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public void exportToFile(String string) throws Exception {
        int n;
        int n2;
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (this.headings != null) {
            n2 = 0;
            n = this.headings.size();
            while (n2 < n) {
                fileOutputStream.write(this.headings.elementAt(n2).toString().getBytes());
                if (n2 < n - 1) {
                    fileOutputStream.write(",".getBytes());
                }
                ++n2;
            }
            fileOutputStream.write("\n".getBytes());
        }
        if (this.listModel != null) {
            n2 = 0;
            n = this.listModel.size();
            while (n2 < n) {
                MultiListRow multiListRow = (MultiListRow)this.listModel.elementAt(n2);
                int n3 = 0;
                while (n3 < this.columnCount) {
                    block9: {
                        try {
                            fileOutputStream.write(multiListRow.getColumnData(n3).toString().getBytes());
                            if (n3 < this.columnCount - 1) {
                                fileOutputStream.write(",".getBytes());
                            }
                        }
                        catch (Exception exception) {
                            if (n3 >= this.columnCount - 1) break block9;
                            fileOutputStream.write(",".getBytes());
                        }
                    }
                    ++n3;
                }
                fileOutputStream.write("\n".getBytes());
                ++n2;
            }
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public MultiList(FontUtil fontUtil) {
        this.initialize(fontUtil);
    }

    MultiList(Vector vector, ListSelectionEvent listSelectionEvent) {
        this.selectionVec = vector;
        this.lastSelectionEvent = listSelectionEvent;
    }

    public MultiList(FontUtil fontUtil, Vector vector) throws NullPointerException {
        this.initialize(fontUtil);
        this.setColumnHeadings(vector);
    }

    public MultiList(FontUtil fontUtil, Object[] objectArray) {
        this.initialize(fontUtil);
        this.setColumnHeadings(objectArray);
    }

    public MultiList(FontUtil fontUtil, Object[] objectArray, Object[] objectArray2) {
        this.initialize(fontUtil);
        this.setColumnHeadings(objectArray);
    }

    public MultiList(FontUtil fontUtil, Vector vector, Vector vector2) {
        this.initialize(fontUtil);
        this.setColumnHeadings(vector);
    }
}

