/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui;

import com.ibm.nzna.shared.gui.ExtendedMultiListRow;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.util.FontUtil;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class MultiListRowRenderer
extends Component
implements ListCellRenderer {
    private static Color selBackground = (Color)UIManager.getDefaults().get("List.selectionBackground");
    private static Color selForeground = (Color)UIManager.getDefaults().get("List.selectionForeground");
    private static Font selFont = null;
    private static Image focusImage = null;
    private static FontUtil fontUtil = null;
    private MultiListRow dataRow = null;
    private boolean selected = false;
    private boolean hasFocus = false;
    private int defaultHeight = 18;
    private Dimension prefSize = new Dimension(300, this.defaultHeight);
    private int columnNum = 1;
    private MultiList multiList = null;
    private ExtendedMultiListRow xMultiListRow = null;
    private Rectangle newClip = new Rectangle(0, 0, 0, 0);
    private int[][] colDim = new int[this.columnNum][2];
    private boolean paintBackground = true;
    private Image backImage = null;
    private boolean wordWrap = false;

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof ExtendedMultiListRow) {
            this.dataRow = null;
            this.xMultiListRow = (ExtendedMultiListRow)object;
        } else if (object instanceof MultiListRow) {
            this.dataRow = (MultiListRow)object;
            this.xMultiListRow = null;
        }
        if (n / 2 * 2 != n) {
            this.setBackground(this.multiList.getOddLinesColor());
        } else {
            this.setBackground(this.multiList.getBackground());
        }
        this.selected = bl;
        this.hasFocus = bl2;
        return this;
    }

    protected void setWordWrap(boolean bl) {
        this.wordWrap = bl;
    }

    public void paint(Graphics graphics) {
        Shape shape = graphics.getClip();
        Rectangle rectangle = null;
        if (this.prefSize.height == -1) {
            this.getPreferredSize();
        }
        rectangle = shape == null ? new Rectangle(0, 0, this.prefSize.width, this.prefSize.height) : (Rectangle)shape;
        this.newClip.x = rectangle.x;
        this.newClip.y = 0;
        this.newClip.width = this.prefSize.width;
        this.newClip.height = rectangle.height;
        if (!this.selected) {
            graphics.setColor(this.getBackground());
            if (this.backImage != null) {
                WinUtil.wallPaper(this.newClip, this, graphics, this.backImage);
            } else {
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else {
            if (selFont == null) {
                selFont = graphics.getFont();
            }
            graphics.setFont(selFont);
            graphics.setColor(selBackground);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.dataRow != null || this.xMultiListRow != null) {
            Object var4_4 = null;
            int n = 0;
            boolean bl = false;
            int n2 = rectangle.width - rectangle.x;
            if (!this.selected) {
                graphics.setColor(this.getForeground());
            } else {
                graphics.setColor(selForeground);
            }
            if (this.columnNum > 0) {
                while (n < this.columnNum) {
                    if (this.colDim[n][1] == 0 || this.colDim[n][0] == 0) {
                        this.colDim[n][0] = this.multiList.getColumnX(n);
                        this.colDim[n][1] = this.multiList.getColumnWidth(n);
                    }
                    if (rectangle.x < this.colDim[n][0] + this.colDim[n][1]) {
                        if (rectangle.width > this.multiList.getColumnX(n) + this.colDim[n][1]) {
                            graphics.setClip(rectangle.x, rectangle.y, this.multiList.getColumnX(n) + this.colDim[n][1], rectangle.height);
                        }
                        if (this.xMultiListRow != null) {
                            this.paintObject(graphics, this.xMultiListRow, this.xMultiListRow.getColumnData(n), this.colDim[n][0], 10, this.colDim[n][1], this.prefSize.height, rectangle, n);
                        } else {
                            this.paintObject(graphics, null, this.dataRow.getColumnData(n), this.colDim[n][0], 10, this.colDim[n][1], this.prefSize.height, rectangle, n);
                        }
                        graphics.setClip(rectangle);
                    }
                    ++n;
                }
            } else if (this.xMultiListRow != null) {
                this.paintObject(graphics, this.xMultiListRow, this.xMultiListRow.getColumnData(0), 0, 10, 1800, this.prefSize.height, rectangle, n);
            } else {
                this.paintObject(graphics, null, this.dataRow.getColumnData(0), 0, 10, 1800, this.prefSize.height, rectangle, n);
            }
            if (this.hasFocus) {
                if (this.wordWrap) {
                    if (focusImage != null) {
                        focusImage.flush();
                    }
                    this.createFocusImage();
                } else if (focusImage == null) {
                    this.createFocusImage();
                }
                if (focusImage != null) {
                    graphics.drawImage(focusImage, 0, 0, this);
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        this.prefSize.height = this.defaultHeight;
        if (this.wordWrap) {
            if (this.dataRow != null) {
                this.prefSize.height = this.getPreferredHeightFromMultiListRow(this.dataRow);
            } else if (this.xMultiListRow != null) {
                this.prefSize.height = this.getPreferredHeightFromMultiListRow(this.xMultiListRow);
            }
        }
        return this.prefSize;
    }

    public void setRowHeight(int n) {
        this.prefSize.height = n;
        if (focusImage != null) {
            focusImage.flush();
        }
        focusImage = null;
    }

    public void setRowWidth(int n) {
        this.prefSize.width = n;
        if (focusImage != null) {
            focusImage.flush();
        }
        focusImage = null;
    }

    public void setColumnNum(int n) {
        boolean bl = false;
        this.columnNum = n;
        this.colDim = new int[n + 1][2];
    }

    private void paintObject(Graphics graphics, ExtendedMultiListRow extendedMultiListRow, Object object, int n, int n2, int n3, int n4, Rectangle rectangle, int n5) {
        if (object != null) {
            if (object instanceof String) {
                if (fontUtil.getFont() != graphics.getFont()) {
                    fontUtil.setFont(graphics.getFont());
                }
                if (extendedMultiListRow != null) {
                    extendedMultiListRow.adjustColumnGraphics(n5, graphics);
                }
                fontUtil.drawCharsEtc(graphics, ((String)object).toCharArray(), ((String)object).length(), n, this.wordWrap && this.prefSize.height != this.defaultHeight ? n2 + 4 : fontUtil.getYCentered(n4), new Rectangle(1024, 768), n3);
            } else if (object instanceof Image) {
                graphics.drawImage((Image)object, n, 0, this);
            } else if (object instanceof ImageIcon) {
                graphics.drawImage(((ImageIcon)object).getImage(), n, 0, this);
            } else if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                int n6 = 0;
                int n7 = 0;
                int n8 = n2 + 4;
                Shape shape = graphics.getClip();
                if (extendedMultiListRow != null) {
                    extendedMultiListRow.adjustColumnGraphics(n5, graphics);
                }
                n6 = 0;
                while (n6 < stringArray.length) {
                    n7 = stringArray[n6].length();
                    if (n7 > 0) {
                        if (fontUtil.getFont() != graphics.getFont()) {
                            fontUtil.setFont(graphics.getFont());
                        }
                        fontUtil.drawCharsEtc(graphics, stringArray[n6].toCharArray(), n7, n, n8, (Rectangle)shape, n3);
                        n8 += this.defaultHeight;
                    }
                    ++n6;
                }
            } else {
                fontUtil.drawCharsEtc(graphics, object.toString().toCharArray(), object.toString().length(), n, fontUtil.getYCentered(n4), new Rectangle(1024, 768), n3);
            }
        }
    }

    public void setSelectedBackground(Color color) {
        selBackground = color;
    }

    public void setSelectedForeground(Color color) {
        selForeground = color;
    }

    public void setSelectedFont(Font font) {
        selFont = font;
    }

    private void createFocusImage() {
        if (this.prefSize.height >= 0) {
            int n;
            if (this.wordWrap) {
                this.prefSize.height = this.getPreferredHeightFromMultiListRow(this.xMultiListRow != null ? this.xMultiListRow : this.dataRow);
            }
            int n2 = 0;
            MemoryImageSource memoryImageSource = null;
            int[] nArray = new int[this.prefSize.width * this.prefSize.height];
            int n3 = -16777216;
            int n4 = n = -100;
            while (n2 < this.prefSize.width) {
                nArray[n2] = n4;
                nArray[n2 + this.prefSize.width * (this.prefSize.height - 1)] = n4;
                n2 += 2;
            }
            n2 = 0;
            while (n2 < this.prefSize.height * (this.prefSize.width - 1)) {
                nArray[n2] = n4;
                nArray[n2 + this.prefSize.width - 1] = n4;
                n2 += this.prefSize.width * 2;
            }
            memoryImageSource = new MemoryImageSource(this.prefSize.width, this.prefSize.height, nArray, 0, this.prefSize.width);
            focusImage = this.createImage(memoryImageSource);
        }
    }

    public void setBackground(Image image) {
        this.backImage = image;
        this.paintBackground = false;
    }

    protected int getPreferredHeightFromMultiListRow(MultiListRow multiListRow) {
        int n = 0;
        int n2 = 0;
        if (this.colDim.length > 0) {
            int n3 = this.colDim.length;
            Object object = null;
            while (n < n3) {
                object = multiListRow.getColumnData(n);
                if (object instanceof String[]) {
                    if (n2 < ((String[])object).length * this.defaultHeight) {
                        n2 = ((String[])object).length * this.defaultHeight;
                    }
                } else if (object instanceof Image) {
                    if (n2 < ((Image)object).getHeight(this)) {
                        n2 = ((Image)object).getHeight(this);
                    }
                } else if (n2 < this.defaultHeight) {
                    n2 = this.defaultHeight;
                }
                ++n;
            }
        }
        return n2;
    }

    public MultiListRowRenderer(MultiList multiList, FontUtil fontUtil) {
        this.multiList = multiList;
        MultiListRowRenderer.fontUtil = fontUtil;
    }

    public MultiListRowRenderer(ExtendedMultiListRow extendedMultiListRow, FontUtil fontUtil) {
        this.xMultiListRow = extendedMultiListRow;
        MultiListRowRenderer.fontUtil = fontUtil;
    }
}

