/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.gui.wizard;

import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.wizard.WizardEvent;
import com.ibm.nzna.shared.gui.wizard.WizardListener;
import com.ibm.nzna.shared.gui.wizard.WizardStep;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Wizard
extends JPanel
implements Serializable,
ActionListener,
Runnable {
    private static final int MAX_STEPS = 10;
    private static final int NOTIFY_CANCEL = 1;
    private static final int NOTIFY_FINISH = 2;
    private static final int NOTIFY_NEXT = 3;
    private static final int NOTIFY_BACK = 4;
    private static final String THREAD_PROCESSSHOW = "ProcessShow";
    private JLabel st_WIZARDIMAGE = null;
    private JPanel titlePanel = null;
    private JLabel st_TITLE = null;
    private DButton pb_NEXT = null;
    private DButton pb_CANCEL = null;
    private DButton pb_BACK = null;
    private DButton pb_FINISH = null;
    private Image wizardImage = null;
    private boolean initialized = false;
    private int stepIndex = 0;
    private int stepIndexMax = 0;
    private WizardStep curStep = null;
    private Vector listeners = new Vector(1, 10);
    private boolean autoAdvance = true;

    public Wizard() {
        this.init();
        this.initialized = true;
    }

    public Wizard(ImageIcon imageIcon) {
        this.init();
        this.setImage(imageIcon);
        this.initialized = true;
    }

    private void init() {
        this.st_WIZARDIMAGE = new JLabel();
        this.st_TITLE = new JLabel("TITLE");
        this.pb_NEXT = new DButton("Next");
        this.pb_BACK = new DButton("Back");
        this.pb_CANCEL = new DButton("Cancel");
        this.pb_FINISH = new DButton("Finish");
        this.titlePanel = new JPanel();
        this.st_WIZARDIMAGE.setBorder(null);
        this.st_WIZARDIMAGE.setBackground(Color.white);
        this.st_TITLE.setBackground(Color.white);
        this.titlePanel.setBackground(Color.white);
        this.st_TITLE.setVerticalAlignment(1);
        this.pb_NEXT.addActionListener(this);
        this.pb_BACK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_FINISH.addActionListener(this);
        this.setLayout(null);
        this.titlePanel.setLayout(new BorderLayout());
        this.titlePanel.add((Component)this.st_TITLE, "Center");
        this.titlePanel.add((Component)this.st_WIZARDIMAGE, "East");
        this.add(this.titlePanel);
        this.add(this.pb_NEXT);
        this.add(this.pb_BACK);
        this.add(this.pb_CANCEL);
        this.add(this.pb_FINISH);
        this.pb_BACK.setVisible(false);
        this.pb_FINISH.setVisible(false);
    }

    public void setCurrentStep(WizardStep wizardStep) {
        this.showStep(wizardStep);
    }

    public WizardStep getCurrentStep() {
        return this.curStep;
    }

    public ImageIcon getImage() {
        return (ImageIcon)this.st_WIZARDIMAGE.getIcon();
    }

    public void setImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.st_WIZARDIMAGE.setIcon(imageIcon);
            this.wizardImage = imageIcon.getImage();
        }
        this.doLayout();
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paintComponent(graphics);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(0, 59, dimension.width, 59);
        graphics.drawLine(0, dimension.height - 50, dimension.width, dimension.height - 50);
        graphics.setColor(Color.white);
        graphics.drawLine(0, 60, dimension.width, 60);
        graphics.drawLine(0, dimension.height - 49, dimension.width, dimension.height - 49);
    }

    public void doLayout() {
        if (this.initialized) {
            Dimension dimension = this.getSize();
            super.doLayout();
            this.titlePanel.setBounds(0, 0, dimension.width, 58);
            if (this.pb_NEXT.isVisible()) {
                this.pb_BACK.setBounds(dimension.width - 249 - 5, dimension.height - 30, 78, 23);
                this.pb_NEXT.setBounds(dimension.width - 166 - 10, dimension.height - 30, 78, 23);
            } else {
                this.pb_BACK.setBounds(dimension.width - 166 - 5, dimension.height - 30, 78, 23);
            }
            this.pb_CANCEL.setBounds(dimension.width - 83, dimension.height - 30, 78, 23);
            this.pb_FINISH.setBounds(dimension.width - 83, dimension.height - 30, 78, 23);
            if (this.curStep != null) {
                this.curStep.setBounds(35, 62, dimension.width - 70, dimension.height - 135);
            }
        }
    }

    private synchronized void showStep(WizardStep wizardStep) {
        if (this.curStep != null) {
            this.remove(this.curStep);
        }
        this.curStep = wizardStep;
        this.add(this.curStep);
        this.doLayout();
        wizardStep.setVisible(true);
        wizardStep.doLayout();
        this.st_TITLE.setText(wizardStep.getTitle());
        this.repaint();
        new Thread((Runnable)this, THREAD_PROCESSSHOW).start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_NEXT) {
            this.processNext();
        } else if (actionEvent.getSource() == this.pb_BACK) {
            if (this.curStep != null) {
                this.curStep.backOut();
            }
            this.notifyListeners(4);
            new Thread((Runnable)this, THREAD_PROCESSSHOW).start();
        } else if (actionEvent.getSource() == this.pb_CANCEL) {
            this.notifyListeners(1);
        } else if (actionEvent.getSource() == this.pb_FINISH && this.curStep != null && this.curStep.saveInfo()) {
            this.notifyListeners(2);
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_PROCESSSHOW) && this.curStep != null) {
            this.curStep.setWizard(this);
            this.curStep.refreshInfo();
        }
    }

    private synchronized void notifyListeners(int n) {
        int n2 = 0;
        int n3 = this.listeners.size();
        WizardListener wizardListener = null;
        WizardEvent wizardEvent = null;
        wizardEvent = new WizardEvent(this.curStep, this);
        while (n2 < n3) {
            wizardListener = (WizardListener)this.listeners.elementAt(n2);
            if (wizardListener != null) {
                switch (n) {
                    case 1: {
                        wizardListener.cancelPerformed(wizardEvent);
                        break;
                    }
                    case 2: {
                        wizardListener.finishPerformed(wizardEvent);
                        break;
                    }
                    case 3: {
                        wizardListener.nextPerformed(wizardEvent);
                        break;
                    }
                    case 4: {
                        wizardListener.backPerformed(wizardEvent);
                    }
                }
            }
            ++n2;
        }
    }

    public synchronized void addWizardListener(WizardListener wizardListener) {
        this.listeners.addElement(wizardListener);
    }

    public synchronized void removeWizardListener(WizardListener wizardListener) {
        this.listeners.removeElement(wizardListener);
    }

    public void enableControls(boolean bl) {
        this.pb_NEXT.setEnabled(bl);
        this.pb_BACK.setEnabled(bl);
        this.pb_CANCEL.setEnabled(bl);
        this.pb_FINISH.setEnabled(bl);
    }

    public void showNext(boolean bl) {
        this.pb_NEXT.setVisible(bl);
    }

    public void showCancel(boolean bl) {
        this.pb_CANCEL.setVisible(bl);
    }

    public void showFinish(boolean bl) {
        this.pb_FINISH.setVisible(bl);
    }

    public void showBack(boolean bl) {
        this.pb_BACK.setVisible(bl);
    }

    public void showButtons(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.showNext(bl);
        this.showBack(bl2);
        this.showCancel(bl3);
        this.showFinish(bl4);
        this.doLayout();
    }

    public void processNext() {
        if (this.curStep != null && this.curStep.saveInfo()) {
            this.notifyListeners(3);
            new Thread((Runnable)this, THREAD_PROCESSSHOW).start();
        } else if (this.curStep == null) {
            this.notifyListeners(3);
            new Thread((Runnable)this, THREAD_PROCESSSHOW).start();
        }
    }

    public void setNextText(String string) {
        this.pb_NEXT.setText(string);
    }

    public void setBackText(String string) {
        this.pb_BACK.setText(string);
    }

    public void setFinishText(String string) {
        this.pb_FINISH.setText(string);
    }

    public void setCancelText(String string) {
        this.pb_CANCEL.setText(string);
    }
}

