/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.spell;

import com.ibm.nzna.shared.spell.SpellHandler;
import com.ibm.nzna.shared.spell.SpellIndex;
import com.ibm.nzna.shared.spell.j_util;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class SpellServer
extends Thread {
    public static final int DEFAULT_PORT = 5317;
    protected static SpellIndex x;
    protected int port;
    protected ServerSocket listen_socket;

    public static void fail(Exception exception, String string) {
        System.err.println(string + ": " + exception);
        System.exit(1);
    }

    public void run() {
        try {
            while (true) {
                Socket socket = this.listen_socket.accept();
                SpellHandler spellHandler = new SpellHandler(socket, x);
            }
        }
        catch (IOException iOException) {
            SpellServer.fail(iOException, "Exception while listening for connections");
            return;
        }
    }

    public static void main(String[] stringArray) {
        SpellIndex spellIndex;
        x = spellIndex = new SpellIndex();
        if (!spellIndex.indexReady) {
            System.out.println("Building Dictionary Using 'dict.txt'");
            spellIndex.build("dict.txt");
        }
        int n = 0;
        if (stringArray.length == 1) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        if (n == 99999) {
            try {
                int n2 = 0;
                int n3 = 0;
                String[] stringArray2 = new String[10];
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream("dict.txt")));
                while (dataInputStream.available() > 0) {
                    String string = dataInputStream.readLine();
                    if (spellIndex.search(j_util.soundex(string.toUpperCase()), string.toUpperCase(), stringArray2)) {
                        System.out.print(".");
                    }
                    ++n3;
                    ++n2;
                }
                dataInputStream.close();
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
                System.exit(0);
            }
        } else {
            new SpellServer(n);
        }
    }

    public SpellServer(int n) {
        if (n == 0) {
            n = 5317;
        }
        this.port = n;
        try {
            this.listen_socket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            SpellServer.fail(iOException, "Exception creating server socket");
        }
        System.out.println("Server: listening on port " + n);
        this.start();
    }
}

