/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.Properties;

public class FileUtil {
    public static String readFile(String string) throws FileNotFoundException, IOException {
        String string2 = null;
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 1024;
        byte[] byArray = new byte[n];
        boolean bl = false;
        int n2 = 0;
        string2 = "";
        while (n2 >= 0) {
            n2 = fileInputStream.read(byArray);
            if (n2 < 0) continue;
            string2 = string2 + new String(byArray, 0, n2);
        }
        fileInputStream.close();
        return string2;
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static boolean rename(String string, String string2) {
        return new File(string).renameTo(new File(string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveFile(String string, String string2) {
        boolean bl = false;
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public static void writeException(String string, Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        FileUtil.saveFile(string, stringWriter.toString());
    }

    public static boolean dirExists(String string) {
        Properties properties = System.getProperties();
        return FileUtil.dirExists(string, properties.getProperty("user.dir"));
    }

    public static boolean dirExists(String string, String string2) {
        File file = new File(string2);
        String[] stringArray = file.list();
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && !bl) {
            if (stringArray[n] != null && stringArray[n].equals(string)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public static void deleteFile(String string) throws Exception {
        File file = new File(string);
        if (file != null) {
            file.delete();
        }
    }

    public static void appendToFile(String string, String string2) throws Exception {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.seek(randomAccessFile.length());
        randomAccessFile.write(string2.getBytes());
        randomAccessFile.close();
    }

    public static boolean copyFile(String string, String string2) throws Exception {
        boolean bl = false;
        File file = new File(string);
        File file2 = new File(string2);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        boolean bl2 = false;
        int n = 4096;
        byte[] byArray = new byte[n];
        FileUtil.copyStream(fileInputStream, fileOutputStream);
        fileOutputStream.flush();
        fileInputStream.close();
        fileOutputStream.close();
        fileInputStream = null;
        fileOutputStream = null;
        file = null;
        file2 = null;
        byArray = null;
        System.gc();
        bl = true;
        return bl;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                byte[] byArray = new byte[256];
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
        }
    }

    public static byte[] readBytesFromFile(String string) throws FileNotFoundException, IOException {
        String string2 = null;
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 1024;
        byte[] byArray = new byte[n];
        byte[] byArray2 = null;
        boolean bl = false;
        int n2 = 0;
        string2 = "";
        while (n2 >= 0) {
            n2 = fileInputStream.read(byArray);
            if (n2 < 0) continue;
            if (byArray2 == null) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                continue;
            }
            byte[] byArray3 = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            byArray2 = new byte[byArray3.length + n2];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            System.arraycopy(byArray, 0, byArray2, byArray3.length, n2);
        }
        fileInputStream.close();
        return byArray2;
    }

    public static Object readObjectFromDisk(String string) throws Exception {
        Object object = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        object = objectInputStream.readObject();
        objectInputStream.close();
        fileInputStream.close();
        return object;
    }

    public static boolean writeObjectToDisk(String string, Object object) throws Exception {
        boolean bl = false;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        fileOutputStream.close();
        objectOutputStream.close();
        bl = true;
        return bl;
    }

    public static boolean containsPathInfo(String string) {
        return string.indexOf(File.separator) >= 0;
    }

    public static String filenameFromPath(String string) {
        if (FileUtil.containsPathInfo(string)) {
            return string.substring(string.lastIndexOf(File.separator));
        }
        return string;
    }
}

