/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.shared.util;

import com.ibm.nzna.shared.util.ResourceLoader;
import com.ibm.nzna.shared.util.SecureProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class StandardPropertyLoader {
    static final String fileSeparator = System.getProperties().getProperty("file.separator");
    static final String defaultResourcePath = "com" + fileSeparator + "ibm" + fileSeparator + "nzna" + fileSeparator + "properties" + fileSeparator;
    private static Properties properties = null;
    public static final String globalPropertyFile = "global.properties";
    public static final String sitePropertyKey = "site.properties";
    public static final String securePropertyFile = "secure.properties";
    private static Properties secureProperties = null;

    public static InputStream getInputStream(String string) {
        InputStream inputStream = null;
        inputStream = string.indexOf(defaultResourcePath) > -1 ? ResourceLoader.getInputStream(string) : ResourceLoader.getInputStream(defaultResourcePath + string);
        return inputStream;
    }

    public static Properties getProperties() throws IOException {
        InputStream inputStream;
        if (secureProperties == null) {
            inputStream = StandardPropertyLoader.getInputStream(securePropertyFile);
            secureProperties = new SecureProperties();
            if (inputStream != null) {
                secureProperties.load(inputStream);
            }
        }
        if (properties == null) {
            String string;
            inputStream = StandardPropertyLoader.getInputStream(globalPropertyFile);
            properties = new Properties();
            if (inputStream != null) {
                properties.load(inputStream);
                StandardPropertyLoader.substitute(properties, properties);
            }
            if ((string = (String)((Hashtable)properties).get(sitePropertyKey)) != null) {
                properties = StandardPropertyLoader.getSiteProperties(properties, string);
            }
        }
        return properties;
    }

    static Properties getSecureProperties() throws IOException {
        InputStream inputStream = StandardPropertyLoader.getInputStream(securePropertyFile);
        SecureProperties secureProperties = null;
        if (inputStream != null) {
            secureProperties = new SecureProperties();
            secureProperties.load(inputStream);
        } else {
            System.out.println(securePropertyFile + " not loaded");
        }
        return secureProperties;
    }

    private static final Properties getSiteProperties(Properties properties, String string) throws IOException {
        System.out.println("Loading site properties");
        InputStream inputStream = StandardPropertyLoader.getInputStream(string);
        if (inputStream != null) {
            properties.load(inputStream);
            StandardPropertyLoader.substitute(properties, properties);
        } else {
            System.out.println(string + " not loaded");
        }
        return properties;
    }

    public static Properties load(String string) throws IOException {
        Properties properties = null;
        if (string.indexOf(".properties") == -1) {
            string = string + ".properties";
        }
        properties = StandardPropertyLoader.getProperties();
        properties = (Properties)((Hashtable)properties).clone();
        StandardPropertyLoader.update(properties, string);
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean load(Properties properties, String string) {
        try {
            Properties properties2 = StandardPropertyLoader.getProperties();
            Enumeration enumeration = ((Hashtable)properties2).keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)((Hashtable)properties2).get(string2);
                ((Hashtable)properties).put(string2, string3);
            }
            return StandardPropertyLoader.update(properties, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return StandardPropertyLoader.update(properties, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean update(Properties properties, String string) {
        if (string.indexOf(".properties") == -1) {
            string = string + ".properties";
        }
        boolean bl = false;
        try {
            InputStream inputStream = StandardPropertyLoader.getInputStream(string);
            if (inputStream != null) {
                properties.load(inputStream);
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            StandardPropertyLoader.substitute(properties, properties);
        }
        return bl;
    }

    public static String getPath() {
        String string = null;
        string = ResourceLoader.getPath(defaultResourcePath);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void substitute(Properties properties, Properties properties2) {
        try {
            Enumeration enumeration = ((Hashtable)properties2).keys();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                String string = (String)enumeration.nextElement();
                Object v = ((Hashtable)properties2).get(string);
                if (!(v instanceof String)) continue;
                String string2 = (String)v;
                StandardPropertyLoader.substituteKeyValue(properties, properties2, string, string2);
                StandardPropertyLoader.substituteSecure(properties2, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static final void substituteKeyValue(Properties properties, Properties properties2, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n4 = string2.indexOf("{subst:", n4)) > -1) {
            stringBuffer.append(string2.substring(n, n4));
            n2 = string2.indexOf(125, n4);
            if (n2 <= -1) continue;
            n3 = string2.indexOf(58, n4);
            String string3 = string2.substring(n3 + 1, n2);
            String string4 = properties.getProperty(string3, "{undefined value}");
            if (string4.indexOf("{subst:") > -1) {
                StandardPropertyLoader.substituteKeyValue(properties, properties2, string3, string4);
                string4 = properties.getProperty(string3, "{undefined value}");
            }
            stringBuffer.append(string4);
            n = n2 + 1;
            n4 = n2;
        }
        if (n > 0) {
            stringBuffer.append(string2.substring(n, string2.length()));
            ((Hashtable)properties2).put(string, stringBuffer.toString());
        }
    }

    public static void substituteSecure(Properties properties, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = (String)((Hashtable)properties).get(string);
        String string3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = string2.indexOf("{secure:");
        if (n > -1) {
            stringBuffer.append(string2.substring(0, n));
            n2 = string2.indexOf(125, n);
            if (n2 > -1) {
                n4 = string2.indexOf(58, n);
                String string4 = string2.substring(n4 + 1, n2);
                if (secureProperties != null) {
                    string3 = (String)((Hashtable)secureProperties).get(string4);
                    stringBuffer.append(string3);
                    n3 = n2 + 1;
                }
            }
            if (n3 > 0) {
                stringBuffer.append(string2.substring(n3, string2.length()));
                ((Hashtable)properties).put(string, stringBuffer.toString());
            }
        }
    }

    public static void setSecureProperties(Properties properties) {
        properties = StandardPropertyLoader.properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StandardPropertyLoader(String string, String[] stringArray) throws Exception {
        try {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            StandardPropertyLoader.load(string);
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return;
                }
                string2 = stringArray[n];
                string3 = string2.substring(1, string2.indexOf(":"));
                string4 = string2.substring(string2.indexOf(":") + 1);
                ((Hashtable)properties).put(string3, string4);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            throw exception;
        }
    }
}

