/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.tools.lvUpdate;

import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.FileUtil;
import java.io.FileNotFoundException;
import java.sql.PreparedStatement;

public class LVUpdate {
    private String databaseName = null;
    private String databaseServer = null;
    private String filename = null;
    private String sql = null;
    private String userId = null;
    private String password = null;
    private String longVarChar = null;
    private String portNumber = null;

    public static void main(String[] stringArray) {
        try {
            new LVUpdate(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6]);
        }
        catch (Exception exception) {
            LVUpdate.printUsage();
        }
    }

    private boolean connectToDatabase() {
        try {
            new DatabaseSystem(false, null, false);
            System.out.println("Connecting to " + this.databaseName + " on " + this.databaseServer);
            return DatabaseSystem.createConnection(1, this.databaseName, this.databaseServer, this.portNumber, this.userId, this.password);
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to database.\nException:");
            exception.printStackTrace();
            return false;
        }
    }

    private boolean readFile() {
        try {
            this.longVarChar = FileUtil.readFile(this.filename);
            return this.longVarChar != null && this.longVarChar.length() > 0;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found :" + this.filename);
        }
        catch (Exception exception) {
            System.out.println("Could not read :" + this.filename);
            exception.printStackTrace();
        }
        return false;
    }

    private boolean updateLongVarChar() {
        SQLMethod sQLMethod = new SQLMethod(1, "updateLongVarChar", 5);
        boolean bl = false;
        if (this.longVarChar.length() < 32700) {
            try {
                PreparedStatement preparedStatement = sQLMethod.createPreparedStatement(this.sql);
                System.out.println("Updating Long Var Char Field with String of " + this.longVarChar.length() + " bytes");
                preparedStatement.setString(1, this.longVarChar);
                preparedStatement.execute();
                bl = true;
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                System.out.println("\nError, cannot update Long Var Char. Full Error:");
                exception.printStackTrace();
            }
        } else {
            System.out.println("File too long to fit in Long Var Char!");
        }
        sQLMethod.close();
        return bl;
    }

    private static void printUsage() {
        System.out.println("Usage: java com.ibm.nzna.tools.lvUpdate.LVUpdate <databaseName> <serverName> <filename to import> <sql> <userId> <password>");
        System.out.println("\nDescription\n---------------------");
        System.out.println("This program updates a Long Var Char field in DB/2");
        System.out.println("\nParameter Descriptions\n-----------------------");
        System.out.println("databaseName - The database name that is cataloged on your system");
        System.out.println("serverName   - The I/P Address or full host name of the server ");
        System.out.println("               the database resides on");
        System.out.println("fileName     - The name of the file holding the text to put into");
        System.out.println("               the long var char");
        System.out.println("sql          - The SQL String used to insert/update the Long Var Char.");
        System.out.println("               An example of this SQL is as follows. If you have a table");
        System.out.println("               called MY.DOCUMENTS with the following columns: ");
        System.out.println("               DOCID       integer");
        System.out.println("               BODY        Long Var Char");
        System.out.println("               DBUSER      char(8)");
        System.out.println("               CHANGEDTIME timestamp\n");
        System.out.println("               And you wanted to insert a row, you would have an SQL");
        System.out.println("               like this:\n");
        System.out.println("               INSERT INTO MY.DOCUMENTS (DOCID, BODY, DBUSER, CHANGEDTIME )");
        System.out.println("               values ( 1, ?, 'ME', CURRENT TIMESTAMP )\n");
        System.out.println("               Please note that the column in 'values' for the long var char");
        System.out.println("               is a Question mark. This must be present.\n\n");
        System.out.println("               If you wanted to update a row, you would have an SQL");
        System.out.println("               like this:\n");
        System.out.println("               UPDATE MY.DOCUMENTS SET BODY = ? WHERE DOCIND = 1");
        System.out.println("userId       - The User Id to connect with");
        System.out.println("password     - The password to connect with");
    }

    public LVUpdate(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.databaseName = string;
        this.databaseServer = string2;
        this.filename = string4;
        this.sql = string5;
        this.userId = string6;
        this.password = string7;
        this.portNumber = string3;
        if (this.connectToDatabase()) {
            if (this.readFile() && this.updateLongVarChar()) {
                System.out.println("Row Updated Succesfully");
            }
            System.out.println("Disconnecting");
            DatabaseSystem.shutdown();
        } else {
            System.out.println("Could not connect to database! Please check Database Name, Server, User Id and Password");
        }
        System.exit(0);
    }
}

