/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class PrintPreview
extends JFrame {
    protected int m_wPage;
    protected int m_hPage;
    protected Printable m_target;
    protected JComboBox m_cbScale;
    protected PreviewContainer m_preview;

    public PrintPreview(Printable printable) {
        this(printable, "Print Preview");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrintPreview(Printable printable, String string) {
        super(string);
        Object object;
        this.setSize(600, 400);
        this.m_target = printable;
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton("Print", new ImageIcon("print.gif"));
        PrintPreview printPreview = this;
        if (printPreview == null) {
            throw null;
        }
        1 var5_5 = new /* Unavailable Anonymous Inner Class!! */;
        jButton.addActionListener((ActionListener)var5_5);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(new Insets(4, 6, 4, 6));
        jToolBar.add(jButton);
        jButton = new JButton("Close");
        PrintPreview printPreview2 = this;
        if (printPreview2 == null) {
            throw null;
        }
        var5_5 = new /* Unavailable Anonymous Inner Class!! */;
        jButton.addActionListener((ActionListener)var5_5);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(new Insets(2, 6, 2, 6));
        jToolBar.add(jButton);
        String[] stringArray = new String[]{"10 %", "25 %", "50 %", "100 %"};
        this.m_cbScale = new JComboBox<String>(stringArray);
        PrintPreview printPreview3 = this;
        if (printPreview3 == null) {
            throw null;
        }
        var5_5 = new /* Unavailable Anonymous Inner Class!! */;
        this.m_cbScale.addActionListener((ActionListener)var5_5);
        this.m_cbScale.setMaximumSize(this.m_cbScale.getPreferredSize());
        this.m_cbScale.setEditable(true);
        jToolBar.addSeparator();
        jToolBar.add(this.m_cbScale);
        this.getContentPane().add((Component)jToolBar, "North");
        PrintPreview printPreview4 = this;
        if (printPreview4 == null) {
            throw null;
        }
        this.m_preview = new PreviewContainer(printPreview4);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.m_wPage = (int)pageFormat.getWidth();
        this.m_hPage = (int)pageFormat.getHeight();
        int n = 10;
        int n2 = this.m_wPage * n / 100;
        int n3 = this.m_hPage * n / 100;
        int n4 = 0;
        try {
            while (true) {
                object = new BufferedImage(this.m_wPage, this.m_hPage, 1);
                Graphics graphics = ((BufferedImage)object).getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.m_wPage, this.m_hPage);
                if (printable.print(graphics, pageFormat, n4) == 0) {
                    PrintPreview printPreview5 = this;
                    if (printPreview5 == null) {
                        throw null;
                    }
                    PagePreview pagePreview = new PagePreview(printPreview5, n2, n3, (Image)object);
                    this.m_preview.add((Component)pagePreview);
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
            System.err.println("Printing error: " + printerException.toString());
        }
        object = new JScrollPane((Component)this.m_preview);
        this.getContentPane().add((Component)object, "Center");
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }
}

