/*
 * Decompiled with CFR 0.152.
 */
package com.elite.log;

import com.ibm.nzna.shared.gui.ErrorDlg;
import com.ibm.nzna.shared.gui.OutputWindow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.Vector;

public class Log {
    private static String defaultLogFile = null;
    private static int logDebugLevel = 0;
    private static Log instance = null;
    private static boolean provideGUI = true;
    private static OutputWindow logWindow = null;
    private static Vector alias = null;
    private boolean errRedirect = false;
    private boolean outRedirect = false;

    public static void log(int n, String string) {
        if (logWindow != null) {
            logWindow.appendText(string + "\n");
        }
        if (n == 0) {
            Log.log(defaultLogFile, string + "\n");
            Log.logAlias(string + "\n");
        } else if (logDebugLevel <= n) {
            Log.log(defaultLogFile, string + "\n");
            Log.logAlias(string + "\n");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(int n, Exception exception) {
        String string = "";
        try {
            if (logDebugLevel > n) return;
            string = Log.log(defaultLogFile, exception);
            Log.logAlias(exception);
            Log.log(defaultLogFile, "-----------------------------------------\n");
            Log.logAlias("-----------------------------------------\n");
            if (logWindow == null) return;
            logWindow.appendText(string + "\n-----------------------------------------\n");
            return;
        }
        catch (Exception exception2) {
            System.out.println("Could not log Message:\n----------------------------------");
            exception.printStackTrace();
            System.out.println("\n\nReceived Exception during log:\n");
            exception2.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(int n, Exception exception, boolean bl) {
        String string = "";
        try {
            if (logDebugLevel > n) return;
            string = Log.log(defaultLogFile, exception);
            Log.logAlias(exception);
            Log.log(defaultLogFile, "-----------------------------------------\n");
            Log.logAlias("-----------------------------------------\n");
            if (logWindow != null) {
                logWindow.appendText(string + "\n-----------------------------------------\n");
            }
            if (!bl) return;
            if (!provideGUI) return;
            new ErrorDlg(exception);
            return;
        }
        catch (Exception exception2) {
            System.out.println("Could not log Message:\n----------------------------------");
            exception.printStackTrace();
            System.out.println("\n\nReceived Exception during log:\n");
            exception2.printStackTrace();
        }
    }

    public static void beginLogSection(String string) {
        String string2 = Log.beginLogSection(defaultLogFile, string);
        Log.logAlias(string2);
        if (logWindow != null) {
            logWindow.appendText(string2 + "\n");
        }
    }

    public static void endLogSection() {
        String string = Log.endLogSection(defaultLogFile);
        Log.log(defaultLogFile, "\n\n\n");
        Log.logAlias(string + "\n\n\n");
        if (logWindow != null) {
            logWindow.appendText(string + "\n\n\n");
        }
    }

    public static Log getInstance() {
        return instance;
    }

    public static void setDebugLevel(int n) {
        logDebugLevel = n;
    }

    public void setLogFile(int n, String string) {
        defaultLogFile = string;
        Log.clearLogFile(string);
        instance = this;
        if (this.errRedirect) {
            this.setErr();
        }
        if (this.outRedirect) {
            this.setOut();
        }
    }

    public static void setProvideGUI(boolean bl) {
        provideGUI = bl;
    }

    public static int getDebugLevel() {
        return logDebugLevel;
    }

    public void setErr() {
        this.errRedirect = true;
    }

    public void setOut() {
        this.outRedirect = true;
    }

    public static void addAlias(String string) {
        if (alias == null) {
            alias = new Vector(1);
        }
        alias.addElement(string);
    }

    public static void removeAlias(String string) {
        if (alias != null) {
            alias.removeElement(string);
            if (alias.size() == 0) {
                alias = null;
            }
        }
    }

    public static void logAlias(String string) {
        if (alias != null) {
            int n = 0;
            int n2 = alias.size();
            while (n < n2) {
                Log.log((String)alias.elementAt(n), string);
                ++n;
            }
        }
    }

    public static void logAlias(Exception exception) {
        if (alias != null) {
            int n = 0;
            int n2 = alias.size();
            while (n < n2) {
                Log.log((String)alias.elementAt(n), exception);
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void clearLogFile(String string) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(new String("").getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            System.out.println("-----------------------------------------------");
            System.out.println("--     Error opening debug file: " + string);
            System.out.println("-----------------------------------------------");
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String log(String string, Exception exception) {
        String string2 = "";
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string2 = stringWriter.toString();
            Log.appendToFile(string, string2);
            return string2;
        }
        catch (Exception exception2) {
            System.out.println("-----------------------------------------------");
            System.out.println("--     Error opening debug file: " + string);
            System.out.println("-----------------------------------------------");
            System.out.println("Exception while opening:");
            exception2.printStackTrace();
            System.out.println("\n\nLogging Exception:");
            exception.printStackTrace();
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(String string, String string2) {
        try {
            Log.appendToFile(string, string2);
            return;
        }
        catch (Exception exception) {
            System.out.println("-----------------------------------------------");
            System.out.println("--     Error opening debug file: " + string);
            System.out.println("-----------------------------------------------");
            System.out.println("Exception while opening:");
            exception.printStackTrace();
            System.out.println("\n\nLogging message:\n" + string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String endLogSection(String string) {
        String string2 = "";
        try {
            String string3 = "*------------------------------------------------\n";
            Log.appendToFile(string, string3);
            return string3;
        }
        catch (Exception exception) {
            System.out.println("-----------------------------------------------");
            System.out.println("--     Error opening debug file: " + string);
            System.out.println("-----------------------------------------------");
            System.out.println("Exception while opening:");
            exception.printStackTrace();
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String beginLogSection(String string, String string2) {
        String string3 = "";
        try {
            String string4 = "*------------------------------------------------\n" + "*\n*  " + string2 + "\n*\n" + "*------------------------------------------------\n";
            Log.appendToFile(string, string4);
            return string4;
        }
        catch (Exception exception) {
            System.out.println("-----------------------------------------------");
            System.out.println("--     Error opening debug file: " + string);
            System.out.println("-----------------------------------------------");
            System.out.println("Exception while opening:");
            exception.printStackTrace();
        }
        return string3;
    }

    public static void appendToFile(String string, String string2) throws Exception {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.seek(randomAccessFile.length());
        randomAccessFile.write(string2.getBytes());
        randomAccessFile.close();
    }

    public Log(int n, String string) {
        this.setLogFile(n, string);
        instance = this;
    }

    public Log() {
    }
}

