/*
 * Decompiled with CFR 0.152.
 */
package com.elite.myside;

import com.elite.log.Log;
import com.elite.util.Stream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;

public class MySideServer
implements Runnable {
    private Socket socket = null;
    private DataInputStream inputStream = null;
    private DataOutputStream outputStream = null;
    private String inData = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.inputStream = new DataInputStream(this.socket.getInputStream());
            this.outputStream = new DataOutputStream(this.socket.getOutputStream());
            if (!this.getStreamData()) return;
            Log.beginLogSection("Processing Stream Data");
            Log.log(1, this.inData);
            Log.endLogSection();
            this.processStreamData();
            this.outputStream.flush();
            this.outputStream.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean getStreamData() {
        try {
            byte[] byArray = new byte[256];
            boolean bl = true;
            this.inData = "";
            while (true) {
                if (!bl) {
                    return true;
                }
                int n = this.inputStream.read(byArray);
                if (n == -1) {
                    return true;
                }
                if (byArray[n - 3] == 10 && byArray[n - 2] == 13 && byArray[n - 1] == 10) {
                    bl = false;
                }
                this.inData = this.inData + new String(byArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] processStreamData() {
        String string = MySideServer.getURL(this.inData);
        byte[] byArray = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
            if (uRLConnection.getContentType().equalsIgnoreCase("TEXT/HTML")) {
                Stream.copyStream(dataInputStream, this.outputStream);
            } else {
                Stream.copyStream(dataInputStream, this.outputStream);
            }
            dataInputStream.close();
            return byArray;
        }
        catch (ConnectException connectException) {
            System.out.println("Could not connect to " + string);
            Log.log(1, connectException, false);
            return byArray;
        }
        catch (Exception exception) {
            Log.log(1, exception, false);
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String getURL(String string) {
        try {
            string = string.substring(string.indexOf("GET ") + 4);
            return string.substring(0, string.indexOf(" "));
        }
        catch (Exception exception) {
            Log.log(1, "Could not parse URL from " + string);
            Log.log(1, exception, false);
            return "<html><body>Internal Error. Could not parse URL from " + string + "</body></html>";
        }
    }

    public MySideServer(Socket socket) {
        this.socket = socket;
        Log.log(1, "New Server Created");
    }
}

