/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.app.gui;

import com.ibm.appsure.AppSureException;
import com.ibm.appsure.app.AppSureTool;
import com.ibm.appsure.app.gui.AppEditDlg;
import com.ibm.appsure.app.gui.AppSureCheckDlg;
import com.ibm.appsure.app.shared.gui.ButtonPanel;
import com.ibm.appsure.app.shared.gui.DButton;
import com.ibm.appsure.app.shared.gui.MultiList;
import com.ibm.appsure.app.shared.util.WinUtil;
import com.ibm.appsure.app.system.GUISystem;
import com.ibm.appsure.common.Application;
import com.ibm.appsure.common.Log;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JFrame;

public class MainWindow
extends JFrame
implements WindowListener,
Runnable,
ActionListener {
    private static final String THREAD_INITIALIZE = "INIT";
    private static MainWindow instance = null;
    private String[] appTitles = new String[]{"Application Code", "Application Name", "Description"};
    private MultiList cnr_APPS = null;
    private DButton pb_NEW = new DButton("New");
    private DButton pb_EDIT = new DButton("Edit");
    private DButton pb_DELETE = new DButton("Delete");
    private DButton pb_CHECK = new DButton("Check");
    private ButtonPanel actionPanel = null;

    public static MainWindow getInstance() {
        return instance;
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("CLOSING");
        System.exit(0);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        super.doLayout();
        if (this.cnr_APPS != null) {
            this.cnr_APPS.setBounds(5, 5, dimension.width - 15, dimension.height - 70);
        }
        if (this.actionPanel != null) {
            this.actionPanel.setBounds(5, dimension.height - 60, dimension.width - 15, 25);
        }
    }

    private final void createGUI() {
        Container container = this.getContentPane();
        Dimension dimension = new Dimension(80, 25);
        this.cnr_APPS = new MultiList(GUISystem.getFontUtil());
        this.actionPanel = new ButtonPanel();
        this.cnr_APPS.setColumnHeadings(this.appTitles);
        this.cnr_APPS.setColumnWidth(1, 300);
        this.cnr_APPS.setColumnWidth(2, 400);
        this.pb_EDIT.setPreferredSize(dimension);
        this.pb_NEW.setPreferredSize(dimension);
        this.pb_CHECK.setPreferredSize(dimension);
        this.pb_DELETE.setPreferredSize(dimension);
        this.pb_EDIT.addActionListener(this);
        this.pb_DELETE.addActionListener(this);
        this.pb_NEW.addActionListener(this);
        this.pb_CHECK.addActionListener(this);
        this.actionPanel.add(this.pb_CHECK);
        this.actionPanel.add(this.pb_NEW);
        this.actionPanel.add(this.pb_EDIT);
        this.actionPanel.add(this.pb_DELETE);
        container.setLayout(null);
        container.add((Component)this.cnr_APPS, "Center");
        container.add((Component)this.actionPanel, "South");
        GUISystem.setPropertiesOnPanel(this.actionPanel);
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_INITIALIZE)) {
            this.refreshAppList();
            this.validate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refreshAppList() {
        Connection connection = AppSureTool.getConnection();
        try {
            Vector<Application> vector = new Vector<Application>(1);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT APPCODE, NAME, SHORTDESCRIPT " + "FROM APPSURE.APPLICATION WHERE APPCODE <> 'DEFAULT' FOR FETCH ONLY");
            this.setCursor(Cursor.getPredefinedCursor(3));
            while (true) {
                if (!resultSet.next()) {
                    this.cnr_APPS.setData(vector);
                    break;
                }
                Application application = new Application(resultSet.getString(1).trim());
                application.setName(resultSet.getString(2).trim());
                application.setShortDescript(resultSet.getString(3).trim());
                vector.addElement(application);
            }
        }
        catch (Exception exception) {
            Log.log(exception);
            GUISystem.printBox("Info", "Unable to refresh list of applications");
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_EDIT) {
            Application application = (Application)this.cnr_APPS.getSelectedItem();
            if (application == null) return;
            try {
                if (!application.readFromDatabase(AppSureTool.getConnection())) return;
                System.out.println("AppEditDlg Cllaing Starting!");
                new AppEditDlg(this, application);
                return;
            }
            catch (AppSureException appSureException) {
                GUISystem.printBox("Info", "Cannot edit that application. Check log file for more information");
                Log.log(appSureException);
                return;
            }
        }
        if (actionEvent.getSource() == this.pb_NEW) {
            Application application = new Application();
            application.updateRecStatus(2);
            new AppEditDlg(this, application);
            return;
        }
        if (actionEvent.getSource() != this.pb_CHECK) return;
        Application application = (Application)this.cnr_APPS.getSelectedItem();
        if (application == null) return;
        try {
            if (!application.readFromDatabase(AppSureTool.getConnection())) return;
            new AppSureCheckDlg(this, application);
            return;
        }
        catch (AppSureException appSureException) {
            GUISystem.printBox("Info", "Cannot Check that application. Check log file for more information");
            Log.log(appSureException);
        }
    }

    public MainWindow() {
        super("AppSure");
        ((Component)this).setSize(640, 480);
        WinUtil.centerWindow(this);
        ((Component)this).setVisible(true);
        instance = this;
        this.addWindowListener(this);
        this.createGUI();
        new Thread((Runnable)this, THREAD_INITIALIZE).start();
    }
}

