/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.app.shared.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class DragWindow
extends JWindow
implements MouseMotionListener,
MouseListener {
    private static final int RESIZE_SE = 1;
    private static final int RESIZE_NE = 2;
    private static final int RESIZE_E = 3;
    private static final int RESIZE_SW = 4;
    private static final int RESIZE_NW = 5;
    private static final int RESIZE_W = 6;
    private static final int RESIZE_N = 7;
    private static final int RESIZE_S = 8;
    protected int width = 0;
    protected int height = 0;
    protected int x = 0;
    protected int y = 0;
    private int oldWidth = -1;
    private int oldHeight = -1;
    protected int oldX = -1;
    protected int oldY = -1;
    private boolean sizeDrag = false;
    private int dragX = 0;
    private int dragY = 0;
    protected int sizeDir = 0;

    private final void init() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        super.setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
        super.setSize(dimension);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
        this.x = n;
        this.y = n2;
        super.setBounds(n, n2, n3, n4);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.drag(mouseEvent.getX(), mouseEvent.getY(), this.dragX, this.dragY);
    }

    public void drag(int n, int n2, int n3, int n4) {
        this.sizeDrag = true;
        this.dragX = n3;
        this.dragY = n4;
        if (this.sizeDir == 0) {
            this.setLocation((n += this.x) - n3, (n2 += this.y) - n4);
        } else {
            switch (this.sizeDir) {
                case 8: {
                    this.setBounds(this.x, this.y, this.width, n2 + 3);
                    break;
                }
                case 3: {
                    this.setBounds(this.x, this.y, n + 3, this.height);
                    break;
                }
                case 1: {
                    this.setBounds(this.x, this.y, n + 3, n2 + 3);
                    break;
                }
                case 7: {
                    this.setBounds(this.x, this.y + n2, this.width, this.height - n2);
                    break;
                }
                case 6: {
                    this.setBounds(this.x + n, this.y, this.width - n, this.height);
                    break;
                }
                case 5: {
                    this.setBounds(this.x + n, this.y + n2, this.width - n, this.height - n2);
                    break;
                }
                case 2: {
                    this.setBounds(this.x, this.y + n2, n + 3, this.height - n2);
                    break;
                }
                case 4: {
                    this.setBounds(this.x + n, this.y, this.width - n, n2 + 3);
                    break;
                }
            }
        }
    }

    public void setLocation(int n, int n2) {
        this.oldX = this.oldX == -1 ? n : this.x;
        this.oldY = this.oldY == -1 ? n2 : this.y;
        this.x = n;
        this.y = n2;
        super.setLocation(n, n2);
    }

    public void setLocation(Point point) {
        this.oldX = this.oldX == -1 ? point.x : this.x;
        this.oldY = this.oldY == -1 ? point.y : this.y;
        this.x = point.x;
        this.y = point.y;
        super.setLocation(point);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < 5 && n2 < 5) {
            this.setCursor(Cursor.getPredefinedCursor(6));
            this.sizeDir = 5;
        } else if (n < 5 && n2 > this.height - 5) {
            this.setCursor(Cursor.getPredefinedCursor(4));
            this.sizeDir = 4;
        } else if (n > this.width - 5 && n2 < 5) {
            this.setCursor(Cursor.getPredefinedCursor(7));
            this.sizeDir = 2;
        } else if (n > this.width - 5 && n2 > this.height - 5) {
            this.setCursor(Cursor.getPredefinedCursor(5));
            this.sizeDir = 1;
        } else if (n < 5) {
            this.setCursor(Cursor.getPredefinedCursor(10));
            this.sizeDir = 6;
        } else if (n2 < 5) {
            this.setCursor(Cursor.getPredefinedCursor(8));
            this.sizeDir = 7;
        } else if (n2 > this.height - 5) {
            this.setCursor(Cursor.getPredefinedCursor(9));
            this.sizeDir = 8;
        } else if (n > this.width - 5) {
            this.setCursor(Cursor.getPredefinedCursor(11));
            this.sizeDir = 3;
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.sizeDir = 0;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.sizeDrag = false;
        this.setBounds(this.x, this.y, this.width, this.height);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.sizeDrag = true;
        this.dragX = mouseEvent.getX();
        this.dragY = mouseEvent.getY();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.sizeDrag = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void addMouseListeners(Container container) {
        Component component = null;
        Component[] componentArray = container.getComponents();
        int n = 0;
        container.addMouseListener(this);
        while (n < componentArray.length) {
            component = componentArray[n];
            component.addMouseListener(this);
            if (!(component instanceof Container)) continue;
            this.addMouseListeners((Container)component);
            ++n;
        }
    }

    public DragWindow(Frame frame, JPanel jPanel, int n, int n2) {
        super(frame);
        this.init();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.setSize(n, n2);
    }
}

