/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.app.shared.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public final class DropButton
extends JPanel
implements Runnable,
ActionListener {
    private static final String THREAD_FIREACTIONEVENT = "FAE";
    private Vector listenerVec = null;
    private JButton mainButton = null;
    private JButton dropButton = null;
    private JPopupMenu popupMenu = null;
    private Dimension prefSize = null;

    public final void init() {
        this.mainButton = new JButton();
        this.dropButton = new JButton("");
        this.popupMenu = new JPopupMenu();
        this.dropButton.setVisible(false);
        this.dropButton.setFocusPainted(false);
        this.dropButton.addActionListener(this);
        this.mainButton.addActionListener(this);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.mainButton, "Center");
        this.add((Component)this.dropButton, "East");
    }

    public final void setBorderPainted(boolean bl) {
        this.mainButton.setBorderPainted(bl);
        this.dropButton.setBorderPainted(bl);
    }

    public final void setHorizontalAlignment(int n) {
        this.mainButton.setHorizontalAlignment(n);
    }

    public final void setMargin(Insets insets) {
        this.mainButton.setMargin(insets);
        this.dropButton.setMargin(insets);
    }

    public final void setMnemonic(int n) {
        this.mainButton.setMnemonic(n);
    }

    public final void setMnemonic(char c) {
        this.mainButton.setMnemonic(c);
    }

    final void setModel(ButtonModel buttonModel) {
        this.mainButton.setModel(buttonModel);
    }

    public final void setPressedIcon(Icon icon) {
        this.mainButton.setPressedIcon(icon);
    }

    public final void setRolloverEnabled(boolean bl) {
        this.mainButton.setRolloverEnabled(bl);
    }

    public final void setRolloverIcon(Icon icon) {
        this.mainButton.setRolloverIcon(icon);
    }

    public final void setRolloverSelectedIcon(Icon icon) {
        this.mainButton.setRolloverSelectedIcon(icon);
    }

    public final void setSelected(boolean bl) {
        this.mainButton.setSelected(bl);
    }

    public final void setSelectedIcon(Icon icon) {
        this.mainButton.setSelectedIcon(icon);
    }

    public final void setText(String string) {
        this.mainButton.setText(string);
    }

    public final void setActionCommand(String string) {
        this.mainButton.setActionCommand(string);
    }

    public final void setContentAreaFilled(boolean bl) {
        this.mainButton.setContentAreaFilled(bl);
        this.dropButton.setContentAreaFilled(bl);
    }

    public final void setDisabledIcon(Icon icon) {
        this.mainButton.setDisabledIcon(icon);
    }

    public final void setDisabledSelectedIcon(Icon icon) {
        this.mainButton.setDisabledSelectedIcon(icon);
    }

    public final void setFocusPainted(boolean bl) {
        this.mainButton.setFocusPainted(bl);
    }

    public final void setHorizontalTextPosition(int n) {
        this.mainButton.setHorizontalTextPosition(n);
    }

    public final void setIcon(Icon icon) {
        this.mainButton.setIcon(icon);
    }

    public final void setIcon(ImageIcon imageIcon) {
        this.mainButton.setIcon(imageIcon);
    }

    public final void addActionListener(ActionListener actionListener) {
        if (this.listenerVec == null) {
            this.listenerVec = new Vector(1, 1);
        }
        this.listenerVec.addElement(actionListener);
    }

    public final void fireActionEvent(ActionEvent actionEvent) {
        int n = 0;
        if (this.listenerVec != null) {
            int n2 = this.listenerVec.size();
            while (n < n2) {
                ((ActionListener)this.listenerVec.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }
    }

    public final void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_FIREACTIONEVENT)) {
            this.fireActionEvent(new ActionEvent(this, 1001, this.mainButton.getActionCommand()));
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mainButton) {
            new Thread((Runnable)this, THREAD_FIREACTIONEVENT).start();
        } else if (actionEvent.getSource() == this.dropButton) {
            Point point = this.getLocation();
            this.popupMenu.setLightWeightPopupEnabled(true);
            this.popupMenu.setInvoker(this);
            SwingUtilities.convertPointToScreen(point, this);
            point.y += this.getSize().height;
            this.popupMenu.setLocation(point);
            this.popupMenu.setVisible(true);
        }
    }

    public final void setDropButtonPosition(String string) {
        if (!string.equals("Center")) {
            this.remove(this.dropButton);
            this.add((Component)this.dropButton, string);
        }
    }

    public final void addJMenu(JMenu jMenu) {
        this.popupMenu.add(jMenu);
        this.dropButton.setVisible(true);
    }

    public final void addJMenuItem(JMenuItem jMenuItem) {
        this.popupMenu.add(jMenuItem);
        this.dropButton.setVisible(true);
    }

    public final void addSeparator() {
        this.popupMenu.addSeparator();
        this.dropButton.setVisible(true);
    }

    public final void remove(Component component) {
        this.popupMenu.remove(component);
        this.dropButton.setVisible(this.popupMenu.getComponentCount() > 0);
    }

    public final void remove(int n) {
        this.popupMenu.remove(n);
        this.dropButton.setVisible(this.popupMenu.getComponentCount() > 0);
    }

    public final Insets getMargin() {
        return this.mainButton.getMargin();
    }

    public final Icon getIcon() {
        return this.mainButton.getIcon();
    }

    public final Icon getPressedIcon() {
        return this.mainButton.getPressedIcon();
    }

    public final Icon getSelectedIcon() {
        return this.mainButton.getSelectedIcon();
    }

    public final Icon getRolloverIcon() {
        return this.mainButton.getRolloverIcon();
    }

    public final Icon getRolloverSelectedIcon() {
        return this.mainButton.getRolloverSelectedIcon();
    }

    public final Icon getDisabledIcon() {
        return this.mainButton.getDisabledIcon();
    }

    public final Icon getDisabledSelectedIcon() {
        return this.mainButton.getDisabledSelectedIcon();
    }

    public final int getVerticalAlignment() {
        return this.mainButton.getVerticalAlignment();
    }

    public final int getHorizontalAlignment() {
        return this.mainButton.getHorizontalAlignment();
    }

    public final int getVerticalTextPosition() {
        return this.mainButton.getVerticalTextPosition();
    }

    public final int getHorizontalTextPosition() {
        return this.mainButton.getHorizontalTextPosition();
    }

    public final boolean isFocusPainted() {
        return this.mainButton.isFocusPainted();
    }

    public final boolean isBorderPainted() {
        return this.mainButton.isBorderPainted();
    }

    public final boolean isContentAreaFilled() {
        return this.mainButton.isContentAreaFilled();
    }

    public final boolean isRolloverEnabled() {
        return this.mainButton.isRolloverEnabled();
    }

    public final int getMnemonic() {
        return this.mainButton.getMnemonic();
    }

    public final ButtonModel getModel() {
        return this.mainButton.getModel();
    }

    public final void setVerticalTextPosition(int n) {
        this.mainButton.setVerticalTextPosition(n);
    }

    public final Dimension getPreferredSize() {
        if (this.prefSize == null) {
            Dimension dimension = this.mainButton.getMinimumSize();
            Dimension dimension2 = this.dropButton.getMinimumSize();
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
            dimension.width += dimension2.width;
            return dimension;
        }
        return this.prefSize;
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public final void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public final void setDropIcon(ImageIcon imageIcon) {
        this.dropButton.setIcon(imageIcon);
    }

    public DropButton() {
        this.init();
    }

    public DropButton(String string) {
        this.init();
        this.setText(string);
    }

    public DropButton(ImageIcon imageIcon) {
        this.init();
        this.setIcon(imageIcon);
    }

    public DropButton(String string, ImageIcon imageIcon) {
        this.init();
        this.setText(string);
        this.setIcon(imageIcon);
    }
}

