/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.app.shared.gui;

import com.ibm.appsure.app.shared.gui.DButton;
import com.ibm.appsure.app.shared.gui.InfoBoxLayoutMgr;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfoBoxPanel
extends JPanel {
    public static final int ACTION_UNDEFINED = 0;
    public static final int ACTION_OK = 1;
    public static final int ACTION_CANCEL = 2;
    public static final int ACTION_YES = 3;
    public static final int ACTION_NO = 4;
    public static final int ICON_INFO = 1;
    public static final int ICON_QUESTION = 2;
    public static final int ICON_ERROR = 3;
    private DButton pb_OK = null;
    private DButton pb_CANCEL = null;
    private JLabel st_DESCRIPT = null;
    private JLabel st_IMAGE = null;
    private String description = null;
    private int iconType = 1;
    private ImageIcon imageIcon = null;
    private String str_OK = "Ok";
    private String str_CANCEL = "Cancel";
    private String str_NO = "No";
    private String str_YES = "Yes";
    private InfoBoxLayoutMgr layoutMgr = null;

    public void createControls() {
        this.layoutMgr = new InfoBoxLayoutMgr();
        this.setLayout(this.layoutMgr);
        this.pb_OK = new DButton(this.str_OK);
        this.add("PB_OK", this.pb_OK);
        this.pb_CANCEL = new DButton(this.str_CANCEL);
        this.add("PB_CANCEL", this.pb_CANCEL);
        this.st_DESCRIPT = new JLabel();
        this.add("ST_DESCRIPT", this.st_DESCRIPT);
        this.st_IMAGE = new JLabel("");
        this.add("ST_IMAGE", this.st_IMAGE);
        this.st_IMAGE.setVerticalAlignment(1);
    }

    public void addActionListener(ActionListener actionListener) {
        this.pb_OK.addActionListener(actionListener);
        this.pb_CANCEL.addActionListener(actionListener);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setIconType(int n) {
        this.iconType = n;
    }

    public void setImage(Image image) {
        if (image != null) {
            this.imageIcon.setImage(image);
        }
    }

    public void setImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.imageIcon = imageIcon;
        }
    }

    public void updateDisplay() {
        switch (this.iconType) {
            case 2: {
                this.pb_OK.setText(this.str_YES);
                this.pb_CANCEL.setText(this.str_NO);
                this.pb_CANCEL.setVisible(true);
                break;
            }
            default: {
                this.pb_OK.setText(this.str_OK);
                this.pb_CANCEL.setVisible(false);
                break;
            }
        }
        this.st_DESCRIPT.setText("<html><body><font size=3 face=\"Arial, Helvetica\">" + this.description + "</body></html>");
        if (this.imageIcon != null) {
            this.st_IMAGE.setIcon(this.imageIcon);
        }
        this.invalidate();
    }

    public void setYes(String string) {
        this.str_YES = string;
    }

    public void setNo(String string) {
        this.str_NO = string;
    }

    public void setOk(String string) {
        this.str_OK = string;
    }

    public void setCancel(String string) {
        this.str_CANCEL = string;
    }

    public Dimension getPreferredSize() {
        return this.layoutMgr.minimumLayoutSize(this);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public int actionEventToBoolean(ActionEvent actionEvent) {
        int n = 0;
        if (actionEvent.getSource() == this.pb_OK) {
            n = 1;
        }
        if (actionEvent.getSource() == this.pb_CANCEL) {
            n = 2;
        }
        if (this.iconType == 2) {
            n += 2;
        }
        return n;
    }

    public InfoBoxPanel() {
        this.createControls();
    }

    public InfoBoxPanel(String string) {
        this.setDescription(string);
        this.createControls();
    }

    public InfoBoxPanel(String string, Image image) {
        this.setDescription(this.description);
        this.setImage(image);
        this.createControls();
    }
}

