/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appsure.common;

import com.ibm.appsure.AppSureException;
import com.ibm.appsure.app.shared.gui.MultiListRow;
import com.ibm.appsure.common.DatabaseObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Application
extends DatabaseObject
implements MultiListRow {
    private String name = null;
    private String appCode = null;
    private String about = null;
    private String runLocation = null;
    private boolean multipleInst = false;
    private String shortDescript = null;
    private int averageRunMin = 0;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setShortDescript(String string) {
        this.shortDescript = string;
    }

    public String getShortDescript() {
        return this.shortDescript;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public void setAppCode(String string) {
        this.appCode = string;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String string) {
        this.about = string;
    }

    public String getRunLocation() {
        return this.runLocation;
    }

    public void setRunLocation(String string) {
        this.runLocation = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readFromDatabase(Connection connection) throws AppSureException {
        boolean bl = false;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT NAME, ABOUT, RUNLOCATION, MULTIPLEINST, shortdescript, averageRunTimeMin " + "FROM APPSURE.APPLICATION " + "WHERE APPCODE = '" + this.getAppCode() + "'");
            if (resultSet.next()) {
                this.setName(resultSet.getString(1).trim());
                this.setAbout(resultSet.getString(2));
                this.setRunLocation(resultSet.getString(3).trim());
                this.setMultipleInst(resultSet.getString(4).equals("Y"));
                this.setShortDescript(resultSet.getString(5));
                this.setAverageRunMin(resultSet.getInt(6));
                this.updateRecStatus(0);
                bl = true;
            }
            resultSet.close();
            statement.close();
            return bl;
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeToDatabase(Connection connection) throws AppSureException {
        int n = 0;
        try {
            Statement statement = connection.createStatement();
            switch (this.getRecStatus()) {
                case 2: {
                    statement.executeUpdate("INSERT INTO APPSURE.APPLICATION " + "values " + "( '" + this.appCode + "', " + "  '" + this.name + "', " + "  '" + this.about + "', " + "  '" + this.runLocation + "'," + "  '" + (this.multipleInst ? "Y" : "N") + "', " + "  '" + this.shortDescript + "', " + "   " + this.averageRunMin + ") ");
                    break;
                }
                case 1: {
                    statement.executeUpdate("UPDATE APPSURE.APPLICATION " + "SET NAME = '" + this.name + "', " + "    ABOUT = '" + this.about + "', " + "    RUNLOCATION = '" + this.runLocation + "'," + "    MULTIPLEINST = '" + (this.multipleInst ? "Y" : "N") + "', " + "    SHORTDESCRIPT = '" + this.shortDescript + "', " + "    AVERAGERUNTIMEMIN = " + this.averageRunMin + " WHERE APPCODE = '" + this.appCode + "' ");
                    break;
                }
                case 3: {
                    statement.executeUpdate("DELETE FROM APPSURE.FAILURE " + "WHERE LOGINDEX IN (SELECT LOGINDEX FROM APPSURE.LOGS WHERE APPCODE = '" + this.appCode + "')");
                    statement.executeUpdate("DELETE FROM APPSURE.LOGS WHERE APPCODE = '" + this.appCode + "'");
                    statement.executeUpdate("DELETE FROM APPSURE.APPPROCESS WHERE APPCODE = '" + this.appCode + "'");
                    statement.executeUpdate("DELETE FROM APPSURE.RUNTIME WHERE APPCODE = '" + this.appCode + "'");
                    statement.executeUpdate("DELETE FROM APPSURE.CONTACT WHERE APPCODE = '" + this.appCode + "'");
                    statement.executeUpdate("DELETE FROM APPSURE.APPLICATION WHERE APPCODE = '" + this.appCode + "'");
                    break;
                }
            }
            statement.close();
            return 0;
        }
        catch (SQLException sQLException) {
            throw new AppSureException(sQLException);
        }
    }

    public void setMultipleInst(boolean bl) {
        this.multipleInst = bl;
    }

    public boolean getMultipleInst() {
        return this.multipleInst;
    }

    public Object getColumnData(int n) {
        switch (n) {
            case 0: {
                return this.appCode;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.shortDescript;
            }
        }
        return "";
    }

    public int getAverageRunMin() {
        return this.averageRunMin;
    }

    public void setAverageRunMin(int n) {
        this.averageRunMin = n;
        this.updateRecStatus(1);
    }

    public Application() {
    }

    public Application(String string) {
        this.appCode = string;
    }
}

