/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.batch;

import com.ibm.appsure.AppSure;
import com.ibm.appsure.AppSureException;
import com.ibm.nzna.projects.batch.BatchInit;
import com.ibm.nzna.projects.batch.BrandFamily;
import com.ibm.nzna.projects.batch.CategoryRec;
import com.ibm.nzna.projects.batch.Constants;
import com.ibm.nzna.projects.batch.ProductDate;
import com.ibm.nzna.projects.batch.RecComparator;
import com.ibm.nzna.projects.batch.WebSite;
import com.ibm.nzna.projects.batch.event.BatchEvent;
import com.ibm.nzna.projects.batch.event.BrandFamilyEvent;
import com.ibm.nzna.projects.batch.event.DocCategoryEvent;
import com.ibm.nzna.projects.batch.event.DocsEvent;
import com.ibm.nzna.projects.batch.event.MkEvent;
import com.ibm.nzna.projects.batch.event.ProdEvent;
import com.ibm.nzna.projects.batch.exception.BatchException;
import com.ibm.nzna.projects.batch.intf.NavgenIntf;
import com.ibm.nzna.projects.batch.plugin.BFMModelKey;
import com.ibm.nzna.projects.batch.plugin.BFMachineKey;
import com.ibm.nzna.projects.batch.plugin.BrandFamilyKey;
import com.ibm.nzna.projects.batch.plugin.BrandKey;
import com.ibm.nzna.projects.batch.utils.BatchUtil;
import com.ibm.nzna.shared.batch.Batch;
import com.ibm.nzna.shared.batch.BatchListener;
import com.ibm.nzna.shared.batch.BatchLogSystem;
import com.ibm.nzna.shared.db.Database;
import com.ibm.nzna.shared.db.DatabaseStatusListener;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.DatabaseSystemListener;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.StandardPropertyLoader;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class Navgen
extends Batch
implements DatabaseStatusListener,
DatabaseSystemListener {
    public static TreeSet brandSet = new TreeSet(new RecComparator());
    public static TreeMap brandChildMap = new TreeMap();
    public static TreeMap familyChildMap = new TreeMap();
    public static final TreeMap machineChildMap = new TreeMap();
    public static TreeMap machineParentMap = new TreeMap();
    public static TreeMap modelParentMap = new TreeMap();
    public static TreeMap productMap = new TreeMap();
    public static TreeMap prodDocsMap = new TreeMap();
    private Connection conn = null;
    private DatabaseSystem dbs = null;
    private String navgen_app_name = "";
    private Vector website = new Vector();

    public void startNavgenBatch() throws Exception, AppSureException {
        super.startBatch();
        String string = BatchInit.getLogdir();
        this.navgen_app_name = BatchInit.getAppName("NavGen");
        BatchInit.logSystem = new BatchLogSystem(string + "NavGen", this);
        this.dbs = new DatabaseSystem(Constants.debug, BatchInit.logSystem, true);
        DatabaseSystem.addStatusListener(this);
        DatabaseSystem.addDatabaseSystemListener(this);
        if (!DatabaseSystem.createConnection(1, BatchInit.getDbName(), BatchInit.getDbServerName(), BatchInit.getDbPort(), BatchInit.getDbUserId(), BatchInit.getDbUserPasswd())) {
            throw new BatchException("Database connection failed, \n" + "  Name: " + BatchInit.getDbName() + "\n" + "  Server: " + BatchInit.getDbServerName() + "\n" + "  Port: " + BatchInit.getDbPort() + "\n" + "  User: " + BatchInit.getDbUserId(), 2005);
        }
        BatchUtil.logit("DatabaseSystem connection created: \n" + "  Name: " + BatchInit.getDbName() + "\n" + "  Server: " + BatchInit.getDbServerName() + "\n" + "  Port: " + BatchInit.getDbPort() + "\n" + "  User: " + BatchInit.getDbUserId(), 2002, 0);
        this.conn = DatabaseSystem.getConnection(1);
        BatchInit.appSure = new AppSure();
        if (!BatchInit.appSure.startApp(this.conn, this.navgen_app_name)) {
            BatchUtil.logit("AppSure startApp() returns false for " + this.navgen_app_name + ". Maybe another navgen instance is running.", 2003, 0);
            throw new AppSureException("AppSure startApp() navgen failed");
        }
        BatchUtil.logit("AppSure started for appcode " + this.navgen_app_name, 2002, 0);
        com.ibm.nzna.projects.common.quest.Constants.refreshConstants(BatchInit.logSystem);
        String string2 = "";
        Vector vector = BatchInit.getWebSiteNames();
        int n = 0;
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            this.website.add(new WebSite(this.conn, BatchInit.getSiteType(string3), string3, BatchInit.getLangInd()));
            string2 = string2 + string3 + " ";
            ++n;
        }
        if (this.website.size() == 0) {
            BatchUtil.logit("No website found", 2003, 0);
        } else {
            BatchUtil.logit("The websites are: " + string2, 2002, 0);
        }
        if (this.initPlugin() == 0) {
            BatchUtil.logit("No loadable plugins found", 2003, 0);
        }
    }

    public void databaseAdded(Database database) {
    }

    public void databaseRemoved(Database database) {
    }

    public void methodAdded(Database database, SQLMethod sQLMethod) {
    }

    public void methodRemoved(Database database, SQLMethod sQLMethod) {
    }

    public void databaseStatusChange(int n, Database database) {
    }

    public void stopBatch(int n) {
        super.stopBatch();
        BatchUtil.logit("****************************************************", 2002, 0);
        BatchUtil.logit("*     " + this.navgen_app_name + " Error Stat ", 2002, 0);
        BatchUtil.logit("****************************************************", 2002, 0);
        BatchUtil.logit("Total Warnings: " + BatchInit.batchWarning, 2002, 0);
        BatchUtil.logit("Total Errors:   " + BatchInit.batchError, 2002, 0);
        BatchUtil.logit("Total Fatals:   " + BatchInit.batchFatal, 2002, 0);
        if (BatchInit.appSure != null) {
            try {
                BatchInit.appSure.shutDown(BatchLogSystem.getErrorFile(), null);
            }
            catch (AppSureException appSureException) {
                BatchUtil.logit("Appsure shut down failed: " + appSureException, 2004, 0);
                appSureException.printStackTrace();
            }
        }
        System.exit(n);
    }

    public int initPlugin() throws Exception {
        int n = 0;
        String string = BatchInit.getPlugins();
        BatchUtil.logit("Loading plugins for " + string, 2002, 0);
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = 0;
                while (n2 < this.website.size()) {
                    WebSite webSite = (WebSite)this.website.elementAt(n2);
                    try {
                        Object obj = Class.forName(string2).newInstance();
                        if (obj instanceof NavgenIntf && obj instanceof BatchListener) {
                            ((NavgenIntf)obj).init(webSite, this.conn);
                            this.addBatchListener((BatchListener)obj);
                            ++n;
                            BatchUtil.logit("Added plugin: " + string2 + " for " + webSite.getSiteName(), 2002, 0);
                        } else {
                            BatchUtil.logit("Plugin " + string2 + " not loaded: not a navgen listener", 2002, 0);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        BatchUtil.logit("Plugin " + string2 + " not loaded: " + classNotFoundException, 2003, 0);
                    }
                    ++n2;
                }
            }
        } else {
            BatchUtil.logit("  No Navgen plugin found. Plugins not loaded ", 2002, 0);
        }
        return n;
    }

    public void fireBatchEvent(BatchEvent batchEvent) throws BatchException, IOException, SQLException {
        Vector vector = this.getBatchListeners();
        if (vector != null) {
            Object[] objectArray = vector.toArray();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof NavgenIntf) {
                    switch (batchEvent.getID()) {
                        case 1003: {
                            ((NavgenIntf)objectArray[n]).processProd((ProdEvent)batchEvent);
                            break;
                        }
                        case 1004: {
                            ((NavgenIntf)objectArray[n]).finishProd();
                            break;
                        }
                        case 1001: {
                            ((NavgenIntf)objectArray[n]).processDocs((DocsEvent)batchEvent);
                            break;
                        }
                        case 1002: {
                            ((NavgenIntf)objectArray[n]).finishDocs();
                            break;
                        }
                        case 1007: {
                            ((NavgenIntf)objectArray[n]).brandFamilySet(batchEvent);
                            break;
                        }
                        case 1008: {
                            ((NavgenIntf)objectArray[n]).docCategorySet((DocCategoryEvent)batchEvent);
                            break;
                        }
                        case 1009: {
                            ((NavgenIntf)objectArray[n]).finishProcess(batchEvent);
                            break;
                        }
                        case 1010: {
                            ((NavgenIntf)objectArray[n]).processMk((MkEvent)batchEvent);
                            break;
                        }
                    }
                }
                ++n;
            }
        }
    }

    public void addProdMaps(ProdEvent prodEvent) {
        Object object;
        Object object2;
        BatchUtil.logit("Add product maps ", 2001, 0);
        boolean bl = false;
        if (prodEvent.brand.indexOf("IBM Options") != -1) {
            bl = true;
        }
        brandSet.add(new CategoryRec(prodEvent.brandInd, prodEvent.brand, prodEvent.brandOrder));
        BrandKey brandKey = new BrandKey(prodEvent.brandInd);
        this.addChildMap(new CategoryRec(prodEvent.familyInd, prodEvent.family, prodEvent.familyOrder), brandKey, brandChildMap);
        BrandFamilyKey brandFamilyKey = new BrandFamilyKey(prodEvent.brandInd, prodEvent.familyInd);
        machineParentMap.put(new Integer(prodEvent.machineInd), brandFamilyKey);
        if (!familyChildMap.containsKey(brandFamilyKey)) {
            this.addChildMap(new CategoryRec(0, "All", 1), brandFamilyKey, familyChildMap);
            object2 = "";
            object2 = bl ? prodEvent.family : "All types/models for " + prodEvent.family;
            productMap.put(new BFMModelKey(prodEvent.brandInd, prodEvent.familyInd, "All", "All"), object2);
            this.addChildMap(new CategoryRec(0, "All", 1), new BFMachineKey(prodEvent.brandInd, prodEvent.familyInd, "All"), machineChildMap);
        }
        this.addChildMap(new CategoryRec(prodEvent.machineInd, prodEvent.machine, prodEvent.machineOrder), brandFamilyKey, familyChildMap);
        object2 = new BFMachineKey(prodEvent.brandInd, prodEvent.familyInd, prodEvent.machine);
        modelParentMap.put(new Integer(prodEvent.modelInd), object2);
        if (!machineChildMap.containsKey(object2)) {
            object = "";
            object = bl ? prodEvent.family + "," + prodEvent.machine : "All models for " + prodEvent.family + "," + prodEvent.machine;
            productMap.put(new BFMModelKey(prodEvent.brandInd, prodEvent.familyInd, prodEvent.machine, "All"), object);
            this.addChildMap(new CategoryRec(0, "All", 1), object2, machineChildMap);
        }
        this.addChildMap(new CategoryRec(prodEvent.modelInd, prodEvent.model, prodEvent.modelOrder), object2, machineChildMap);
        object = new BFMModelKey(prodEvent.brandInd, prodEvent.familyInd, prodEvent.machine, prodEvent.model);
        productMap.put(object, prodEvent.getProductDescript());
        prodDocsMap.put(brandKey, new Hashtable());
        prodDocsMap.put(brandFamilyKey, new Hashtable());
        prodDocsMap.put(object2, new Hashtable());
        prodDocsMap.put(object, new Hashtable());
        BatchUtil.logit("Product " + prodEvent.getProductInd() + " inserted to all the maps", 2001, 0);
    }

    private void addChildMap(CategoryRec categoryRec, Object object, TreeMap treeMap) {
        if (treeMap.containsKey(object)) {
            TreeSet treeSet = (TreeSet)treeMap.get(object);
            treeSet.add(categoryRec);
        } else {
            TreeSet<CategoryRec> treeSet = new TreeSet<CategoryRec>(new RecComparator());
            treeSet.add(categoryRec);
            treeMap.put(object, treeSet);
        }
    }

    public int readMkCatalog() throws SQLException, BatchException, IOException {
        BatchUtil.logit("Begin readMkCatalog ", 2002, 0);
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT gkey, gval  FROM navgen.gdbm  WHERE siteind = 10  FOR FETCH ONLY ");
        int n = 0;
        while (resultSet.next()) {
            this.fireBatchEvent(new MkEvent(this, 1010, resultSet.getString(1).trim(), resultSet.getString(2).trim()));
            ++n;
        }
        BatchUtil.logit(" read " + n + " market catalog key&vals", 2002, 0);
        resultSet.close();
        statement.close();
        return n;
    }

    public int readAllBrandFamily() throws SQLException, BatchException, IOException {
        BatchUtil.logit("Begin readAllBrandFamily ", 2002, 0);
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT distinct  b.typecatind, b.description, b.ordernum, f.typecatind, f.description, f.ordernum FROM product.typecategory b,      product.typecategory f  WHERE b.categorylevel = 'brand' AND   f.parentcatind  = b.typecatind AND   f.categorylevel = 'family' ORDER BY 1, 4 FOR FETCH ONLY");
        TreeMap treeMap = new TreeMap(new RecComparator());
        TreeSet<CategoryRec> treeSet = new TreeSet<CategoryRec>(new RecComparator());
        String string = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        while (resultSet.next()) {
            int n4 = resultSet.getInt(1);
            string = resultSet.getString(2).trim();
            n = resultSet.getInt(3);
            CategoryRec categoryRec = new CategoryRec(resultSet.getInt(4), resultSet.getString(5).trim(), resultSet.getInt(6));
            if (n2 != n4) {
                if (treeSet.size() > 0) {
                    if (Constants.debug) {
                        BatchUtil.logit("Brandind =  " + n2 + " brand= " + string2, 2001, 0);
                        BatchUtil.logit("familySet=  " + BatchUtil.getLists(treeSet, "{", "}", " "), 2001, 0);
                    }
                    treeMap.put(new CategoryRec(n2, string2, n3), treeSet);
                    treeSet = new TreeSet(new RecComparator());
                    treeSet.add(categoryRec);
                } else {
                    treeSet.add(categoryRec);
                }
                n2 = n4;
                string2 = string;
                n3 = n;
                continue;
            }
            treeSet.add(categoryRec);
        }
        resultSet.close();
        statement.close();
        if (Constants.debug) {
            BatchUtil.logit("Brandind =  " + n2 + " brand= " + string2, 2001, 0);
            BatchUtil.logit("familySet=  " + BatchUtil.getLists(treeSet, "{", "}", " "), 2001, 0);
        }
        if (treeSet.size() > 0) {
            treeMap.put(new CategoryRec(n2, string, n), treeSet);
        }
        BrandFamilyEvent brandFamilyEvent = new BrandFamilyEvent(this, 1007, new BrandFamily(treeMap));
        this.fireBatchEvent(brandFamilyEvent);
        return treeMap.size();
    }

    public int readAllDocCategories() throws SQLException, BatchException, IOException {
        BatchUtil.logit("Begin readAllDocCategories ", 2002, 0);
        Vector vector = new Vector();
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT distinct  b.typecatind, b.description, b.ordernum, c.typecatind, c.description, c.ordernum FROM product.typecategory b,      product.typecategory c  WHERE b.categorylevel = 'brand'  AND   c.parentcatind  = b.typecatind AND   c.categorylevel = 'doccategory'  ORDER BY 1, 4 FOR FETCH ONLY");
        TreeSet<String> treeSet = new TreeSet<String>();
        boolean bl = false;
        while (resultSet.next()) {
            treeSet.add(resultSet.getString(5).trim());
        }
        resultSet.close();
        statement.close();
        DocCategoryEvent docCategoryEvent = new DocCategoryEvent(this, 1008, treeSet);
        this.fireBatchEvent(docCategoryEvent);
        return treeSet.size();
    }

    public int readDocIdQuery() throws Exception {
        BatchUtil.logit("Begin readDocIdQuery ", 2002, 0);
        int n = 0;
        boolean bl = false;
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT distinct d.docind,    d.docclassind,    d.lndocid, tc.typecatind,  tc.description,        tc.ordernum,          tc.categorylevel, d.title,   d.faq,          d.flashnews,        d.doctypeind,         d.changedtime,    d.flashdate FROM tigris.documents d, tigris.category doccat, product.typecategory tc WHERE d.docind = doccat.docind  AND doccat.typecatind = tc.typecatind  AND d.publish = 'Y'  AND d.webable = 'Y'  Order by 12 desc, 1 FOR FETCH ONLY");
        int n2 = 0;
        Vector<CategoryRec> vector = new Vector<CategoryRec>();
        DocsEvent docsEvent = null;
        DocsEvent docsEvent2 = null;
        while (resultSet.next()) {
            int n3 = resultSet.getInt(1);
            CategoryRec categoryRec = new CategoryRec(resultSet.getInt(4), resultSet.getString(5).trim(), resultSet.getInt(6));
            categoryRec.setCategoryLevel(resultSet.getString(7).trim());
            if (n2 != n3) {
                String string;
                if (docsEvent != null) {
                    docsEvent2 = docsEvent;
                }
                docsEvent = new DocsEvent(this, 1001, resultSet.getInt(1), resultSet.getInt(2), categoryRec);
                if (resultSet.getString(3) == null) {
                    BatchUtil.logit("Docind " + n3 + " has no lndocd name. Ignored", 2003, 0);
                    continue;
                }
                docsEvent.lndocId = resultSet.getString(3).trim();
                docsEvent.title = resultSet.getString(8).trim();
                docsEvent.faq = resultSet.getString(9).compareTo("Y") == 0;
                docsEvent.hotNews = resultSet.getString(10).compareTo("Y") == 0;
                docsEvent.doctypeind = resultSet.getInt(11);
                docsEvent.releaseDate = resultSet.getString(12).trim().substring(0, 10);
                String string2 = resultSet.getString(13);
                docsEvent.flashdate = string2 == null ? "" : string2.trim();
                docsEvent.hotNews = docsEvent.flashdate.length() > 0 ? docsEvent.flashdate.compareTo(string = BatchUtil.getCurrTime("y-m-d")) > 0 : false;
                ++n;
                if (vector.size() > 0) {
                    docsEvent2.typevec = vector;
                    this.fireBatchEvent(docsEvent2);
                    vector = new Vector();
                    vector.add(categoryRec);
                } else {
                    vector.add(categoryRec);
                }
                n2 = n3;
                if (!Constants.debug) continue;
                BatchUtil.logit("Reading doc " + resultSet.getInt(1) + " ; Associated level tcInd: " + resultSet.getInt(4) + " Descript: " + categoryRec.toString() + " Category Level: " + categoryRec.getCategoryLevel(), 2001, 0);
                if (n != 10) continue;
                BatchUtil.logit("Published first " + n + " documents", 2001, 0);
                break;
            }
            vector.add(categoryRec);
        }
        if (docsEvent != null) {
            docsEvent.typevec = vector;
            this.fireBatchEvent(docsEvent);
        }
        resultSet.close();
        statement.close();
        this.fireBatchEvent(new DocsEvent(this, 1002, null, 0, 0, 0));
        return n;
    }

    public int readProdQuery() throws SQLException, BatchException, IOException {
        BatchUtil.logit("Begin readProdQuery ", 2002, 0);
        String string = "";
        if (Constants.debug) {
            string = " and b.typecatind = 4 ";
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Vector<ProductDate> vector = new Vector<ProductDate>();
        ProdEvent prodEvent = null;
        ProdEvent prodEvent2 = null;
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT DISTINCT " + "b.typecatind, b.description, f.typecatind,  f.description, " + "t.typecatind, t.description, m.typecatind,  m.description, " + "p.productind, p.prodnum,     p.description, t.ordernum, " + "m.ordernum,   b.ordernum,    f.ordernum,    pdate.actual, " + "pdate.typedateind " + "FROM   product.product p, product.category pcat, " + "    product.typecategory b, product.typecategory prj, product.typecategory f, " + "    product.typecategory t, product.typecategory m, product.dates pdate " + "WHERE  p.productind = pcat.productind " + " AND   pcat.typecatind = m.typecatind  " + " AND   (m.categorylevel = '" + "model" + "' " + "     OR m.categorylevel = '" + "partnum" + "') " + " AND   m.parentcatind    = t.typecatind " + " AND   t.parentcatind    = prj.typecatind " + " AND   prj.parentcatind  = f.typecatind " + " AND   f.parentcatind    = b.typecatind " + " AND   pdate.productind  = p.productind " + " AND   p.publish         = 'Y' " + string + " ORDER BY 1, 3, 6, 8 " + "FOR FETCH ONLY ");
        while (resultSet.next()) {
            int n4 = resultSet.getInt(9);
            ProductDate productDate = null;
            String string2 = resultSet.getString(16);
            productDate = string2 == null ? new ProductDate(resultSet.getInt(9), resultSet.getInt(17), "1970/01/31") : new ProductDate(resultSet.getInt(9), resultSet.getInt(17), string2.trim());
            if (n != n4) {
                if (prodEvent != null) {
                    prodEvent2 = prodEvent;
                }
                prodEvent = new ProdEvent(this, 1003, resultSet.getInt(9), resultSet.getString(10).trim(), resultSet.getString(11).trim());
                prodEvent.brandInd = resultSet.getInt(1);
                prodEvent.brand = resultSet.getString(2).trim();
                prodEvent.familyInd = resultSet.getInt(3);
                prodEvent.family = resultSet.getString(4).trim();
                prodEvent.machineInd = resultSet.getInt(5);
                prodEvent.machine = resultSet.getString(6).trim();
                prodEvent.modelInd = resultSet.getInt(7);
                prodEvent.model = resultSet.getString(8).trim();
                prodEvent.machineOrder = resultSet.getInt(12);
                prodEvent.modelOrder = resultSet.getInt(13);
                prodEvent.brandOrder = resultSet.getInt(14);
                prodEvent.familyOrder = resultSet.getInt(15);
                ++n2;
                if (vector.size() > 0) {
                    prodEvent2.datesvec = vector;
                    this.addProdMaps(prodEvent2);
                    this.fireBatchEvent(prodEvent2);
                    vector = new Vector();
                    vector.add(productDate);
                } else {
                    vector.add(productDate);
                }
                n = n4;
                if (!Constants.debug || n2 != 100) continue;
                BatchUtil.logit("Published first " + n2 + " products with dates", 2001, 0);
                break;
            }
            vector.add(productDate);
        }
        if (prodEvent != null) {
            prodEvent.datesvec = vector;
            this.addProdMaps(prodEvent);
            this.fireBatchEvent(prodEvent);
        }
        resultSet.close();
        statement.close();
        BatchUtil.logit("Begin the second part of readProdQuery ", 2002, 0);
        statement = this.conn.createStatement();
        resultSet = statement.executeQuery("SELECT DISTINCT " + "b.typecatind, b.description, f.typecatind,  f.description, " + "t.typecatind, t.description, m.typecatind,  m.description, " + "p.productind, p.prodnum,     p.description, t.ordernum, " + "m.ordernum,   b.ordernum,    f.ordernum " + "FROM   product.product p, product.category pcat, " + "    product.typecategory b, product.typecategory prj, product.typecategory f, " + "    product.typecategory t, product.typecategory m " + "WHERE  p.productind = pcat.productind " + " AND   pcat.typecatind = m.typecatind  " + " AND   (m.categorylevel = '" + "model" + "' " + "     OR m.categorylevel = '" + "partnum" + "') " + " AND   m.parentcatind    = t.typecatind " + " AND   t.parentcatind    = prj.typecatind " + " AND   prj.parentcatind  = f.typecatind " + " AND   f.parentcatind    = b.typecatind " + " AND   p.productind not in (select productind from product.dates)" + " AND   p.publish         = 'Y' " + string + " ORDER BY 1, 3, 6, 8 " + "FOR FETCH ONLY ");
        while (resultSet.next()) {
            prodEvent = new ProdEvent(this, 1003, resultSet.getInt(9), resultSet.getString(10).trim(), resultSet.getString(11).trim());
            prodEvent.brandInd = resultSet.getInt(1);
            prodEvent.brand = resultSet.getString(2).trim();
            prodEvent.familyInd = resultSet.getInt(3);
            prodEvent.family = resultSet.getString(4).trim();
            prodEvent.machineInd = resultSet.getInt(5);
            prodEvent.machine = resultSet.getString(6).trim();
            prodEvent.modelInd = resultSet.getInt(7);
            prodEvent.model = resultSet.getString(8).trim();
            prodEvent.machineOrder = resultSet.getInt(12);
            prodEvent.modelOrder = resultSet.getInt(13);
            prodEvent.brandOrder = resultSet.getInt(14);
            prodEvent.familyOrder = resultSet.getInt(15);
            prodEvent.datesvec = null;
            this.addProdMaps(prodEvent);
            this.fireBatchEvent(prodEvent);
            if (!Constants.debug || ++n3 != 10) continue;
            BatchUtil.logit("Published next " + n3 + " products without dates", 2001, 0);
            break;
        }
        resultSet.close();
        statement.close();
        this.fireBatchEvent(new ProdEvent(this, 1004, 0, "", ""));
        return n2 + n3;
    }

    public void navgen_main(String[] stringArray) {
        try {
            String string = File.separator;
            new StandardPropertyLoader("com" + string + "ibm" + string + "nzna" + string + "properties" + string + "batch" + string + "navgen.properties", stringArray);
            this.startNavgenBatch();
            int n = 0;
            this.readMkCatalog();
            this.readAllBrandFamily();
            this.readAllDocCategories();
            n = this.readProdQuery();
            BatchUtil.logit("Processed " + n + " products", 2002, 0);
            n = this.readDocIdQuery();
            BatchUtil.logit("Processed " + n + " documents", 2002, 0);
            if (n > 0) {
                this.fireBatchEvent(new BatchEvent(this, 1009));
            }
            this.stopBatch(0);
            Vector vector = this.getBatchListeners();
            if (vector != null) {
                Object[] objectArray = vector.toArray();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] instanceof NavgenIntf) {
                        ((NavgenIntf)objectArray[n2]).stopNavgen(0);
                    }
                    ++n2;
                }
            }
            BatchUtil.logit("NavGen finished successfully.", 2002, 0);
        }
        catch (BatchException batchException) {
            BatchUtil.logit("NavGen failed due to Application error: ", batchException, 2005, 0);
            batchException.printStackTrace();
            this.stopBatch(1);
        }
        catch (AppSureException appSureException) {
            BatchUtil.logit("NavGen failed due to AppSure exception: " + appSureException, 2005, 0);
            appSureException.printStackTrace();
            this.stopBatch(2);
        }
        catch (SQLException sQLException) {
            BatchUtil.logit("NavGen failed due to sql exception: ", sQLException, 2005, 0);
            sQLException.printStackTrace();
            this.stopBatch(3);
        }
        catch (Exception exception) {
            BatchUtil.logit("NavGen failed due to unknown exception: ", exception, 2005, 0);
            exception.printStackTrace();
            this.stopBatch(4);
        }
    }

    public static void main(String[] stringArray) {
        Navgen navgen = new Navgen();
        navgen.navgen_main(stringArray);
    }
}

