/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.batch;

import com.ibm.nzna.projects.batch.BatchInit;
import com.ibm.nzna.projects.batch.CategoryRec;
import com.ibm.nzna.projects.batch.exception.BatchException;
import com.ibm.nzna.projects.batch.utils.BatchUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class WebSite {
    private int sitetype;
    private String sitename;
    private int langInd;
    private int miniclassification;
    private String lastDocgenUpdate;
    private String imageLoc;
    private Vector templates = new Vector();
    private Vector docTypes = new Vector();
    private Vector showCat = new Vector();

    public Vector getTemplates() {
        return this.templates;
    }

    public Vector getDocTypes() {
        return this.docTypes;
    }

    public Vector getShowCat() {
        return this.showCat;
    }

    public String getTemplateDescript(int n) {
        return BatchUtil.findDescript(this.templates, n);
    }

    public String getDoctypeDescription(int n) {
        return BatchUtil.findDescript(this.docTypes, n);
    }

    public String getShowCatDescript(int n) {
        return BatchUtil.findDescript(this.showCat, n);
    }

    public String getImageLoc() {
        return this.imageLoc;
    }

    public int getMiniClassification() {
        return this.miniclassification;
    }

    public String getSiteName() {
        return this.sitename;
    }

    public String getLastDocgenUpdate() {
        return this.lastDocgenUpdate;
    }

    public String readLastDocgenUpdate(Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT strconst " + "FROM tigris.constants " + "WHERE constant = '" + "TS_DOCGEN_" + this.sitename + "' " + "FOR FETCH ONLY");
            if (resultSet.next()) {
                String string = resultSet.getString(1).trim();
                resultSet.close();
                statement.close();
                return string;
            }
            BatchUtil.logit("Get last docgen update timestamp error. ", 2004, 0);
            return null;
        }
        catch (SQLException sQLException) {
            BatchUtil.logit("Get last docgen update timestamp error. ", 2004, 0);
            return null;
        }
    }

    public int getLangInd() {
        return this.langInd;
    }

    public int getSiteType() {
        return this.sitetype;
    }

    public static int readDocTemplate(Connection connection, int n, int n2, Vector vector) {
        ResultSet resultSet;
        Statement statement;
        BatchUtil.logit("Load website template for website " + n, 2001, 0);
        String string = "";
        String string2 = "";
        int n3 = 0;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT commonind, template " + "FROM docgen.dochtmlcommon " + "WHERE siteind = " + Integer.toString(n) + " " + "AND languageind = " + Integer.toString(n2) + " " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                switch (resultSet.getInt(1)) {
                    case 1: {
                        string = resultSet.getString(2).trim();
                        BatchUtil.logit("  Header templates loaded", 2001, 0);
                        break;
                    }
                    case 2: {
                        string2 = resultSet.getString(2).trim();
                        BatchUtil.logit("  Footer templates loaded", 2001, 0);
                        break;
                    }
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            n3 = 1;
            BatchUtil.logit("  Could not get footer or header", 2004, 0);
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT doctypeind, template " + "FROM docgen.dochtmltemp " + "WHERE siteind = " + Integer.toString(n) + " " + "AND   languageind = " + Integer.toString(n2) + " " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                int n4 = resultSet.getInt(1);
                String string3 = resultSet.getString(2).trim();
                string3 = BatchUtil.substitute(string3, "###Common:HEADER###", string);
                string3 = BatchUtil.substitute(string3, "###Common:FOOTER###", string2);
                vector.add(new CategoryRec(n4, string3, 0));
                BatchUtil.logit("  added header and footer for docType: " + n4, 2001, 0);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            n3 = 1;
            BatchUtil.logit("  Could not get doc template", 2004, 0);
        }
        return n3;
    }

    public static int readDocTypes(Connection connection, int n, Vector vector, Vector vector2) {
        BatchUtil.logit("Load docTypes for site " + Integer.toString(n), 2001, 0);
        int n2 = 0;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT doctypeind, descript, showcat " + "FROM docgen.sitedoctype " + "WHERE siteind = " + n + " " + "Order by 2 " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.add(new CategoryRec(resultSet.getInt(1), resultSet.getString(2).trim(), 0));
                vector2.add(new CategoryRec(resultSet.getInt(1), resultSet.getString(3).trim(), 0));
                BatchUtil.logit("  added docTypes " + resultSet.getString(2).trim(), 2001, 0);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            n2 = 1;
            BatchUtil.logit("  Could not get doctypes ", 2004, 0);
        }
        return n2;
    }

    public static int readMiniSiteClassification(Connection connection, int n) {
        BatchUtil.logit("Load classification for site " + n, 2001, 0);
        int n2 = 3;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT min(docclassind) " + "FROM docgen.sitedocclass " + "WHERE siteind = " + n + " " + "FOR FETCH ONLY");
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
                BatchUtil.logit("  Classification for the site " + n2, 2001, 0);
            } else {
                BatchUtil.logit("  No miniclassification found, assuming unclassified ", 2001, 0);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            n2 = -1;
            BatchUtil.logit("  No miniclassification found, assuming unclassified " + sQLException, 2001, 0);
        }
        return n2;
    }

    public static String readImageLocation(Connection connection, int n, String string) {
        BatchUtil.logit("Load image location for site " + n, 2001, 0);
        String string2 = new String();
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT strconst " + "FROM tigris.constants " + "WHERE constant = 'IMAGELOC_" + string + "' " + "FOR FETCH ONLY");
            if (resultSet.next()) {
                string2 = resultSet.getString(1).trim();
                BatchUtil.logit("  Image Location: " + string2, 2001, 0);
            } else {
                BatchUtil.logit("  Image Location not found ", 2003, 0);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            BatchUtil.logit("  Image Location not found " + sQLException, 2003, 0);
            return null;
        }
        return string2;
    }

    public int updateDocgenTimestamp(Connection connection, String string) {
        BatchUtil.logit("Update docgen timestamp for website: " + this.sitename, 2002, 0);
        int n = 0;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("UPDATE tigris.constants SET strconst = " + string + " " + "WHERE  constant = 'TS_DOCGEN_" + this.sitename + "'");
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            n = 1;
            BatchUtil.logit("Update docgen timestamp error for website: " + this.sitename, 2003, 0);
        }
        return n;
    }

    public WebSite(Connection connection, int n, String string, int n2) throws BatchException {
        this.sitetype = n;
        this.langInd = n2;
        this.sitename = string;
        if (connection == null) {
            throw new BatchException("No connection(conn=null). Creating Website failed sitename=" + string + "  sitetype=" + n, 2004);
        }
        try {
            this.lastDocgenUpdate = BatchInit.getDocgenFullUpdate().compareTo("true") == 0 || BatchInit.getDocgenPublishNow().compareTo("true") == 0 ? "1980-01-01-00.00.00.000000" : this.readLastDocgenUpdate(connection);
        }
        catch (IOException iOException) {
            BatchUtil.logit("Get full update failed. Using last update from db for " + string, 2002, 0);
            this.lastDocgenUpdate = this.readLastDocgenUpdate(connection);
        }
        int n3 = WebSite.readDocTemplate(connection, n, n2, this.templates);
        int n4 = WebSite.readDocTypes(connection, n, this.docTypes, this.showCat);
        this.miniclassification = WebSite.readMiniSiteClassification(connection, n);
        this.imageLoc = WebSite.readImageLocation(connection, n, string);
        if (this.lastDocgenUpdate == null || n3 != 0 || n4 != 0 || this.miniclassification == -1 || this.imageLoc == null) {
            throw new BatchException("Creating Website failed sitename=" + string + "  sitetype=" + n, 2004);
        }
    }
}

