/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.batch.plugin;

import com.ibm.nzna.projects.batch.BatchInit;
import com.ibm.nzna.projects.batch.Docgen;
import com.ibm.nzna.projects.batch.WebSite;
import com.ibm.nzna.projects.batch.event.DocsEvent;
import com.ibm.nzna.projects.batch.exception.BatchException;
import com.ibm.nzna.projects.batch.exception.BatchFtpException;
import com.ibm.nzna.projects.batch.exception.HtmlTemplateNotFoundException;
import com.ibm.nzna.projects.batch.intf.DocgenIntf;
import com.ibm.nzna.projects.batch.utils.BatchUtil;
import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.shared.batch.BatchListener;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Vector;

public class HtmlDocgen
implements BatchListener,
DocgenIntf {
    static String tmspBefore = null;
    private WebSite website;
    private Connection conn;
    private Vector pubFileList = new Vector();
    private Vector deleteFileList = new Vector();
    private int docs_count = 0;
    private int graphics_count = 0;
    private int ftp_docs_count = 0;
    private int ftp_graphics_count = 0;
    private int files_deleted_count = 0;
    private int files_deleting_count = 0;

    public int getDocsCount() {
        return this.docs_count;
    }

    public int getGraphicsCount() {
        return this.graphics_count;
    }

    public int getFtpDocsCount() {
        return this.ftp_docs_count;
    }

    public int getFtpGraphicsCount() {
        return this.ftp_graphics_count;
    }

    public int getFilesDeleteCount() {
        return this.files_deleted_count;
    }

    public int getFilesDeletingCount() {
        return this.files_deleting_count;
    }

    public void publishStat() {
        BatchUtil.logit("****************************************************", 2002, 0);
        BatchUtil.logit("*      " + this.website.getSiteName() + " " + Docgen.docgen_app_name + " Publish Stat ", 2002, 0);
        BatchUtil.logit("*         " + tmspBefore, 2002, 0);
        BatchUtil.logit("****************************************************", 2002, 0);
        BatchUtil.logit("Document Published: " + this.docs_count, 2002, 0);
        BatchUtil.logit("Images   Published: " + this.graphics_count, 2002, 0);
        BatchUtil.logit("Document Deleted:   " + this.files_deleted_count, 2002, 0);
        BatchUtil.logit("Document ftped:     " + this.ftp_docs_count, 2002, 0);
        BatchUtil.logit("Images   ftped:     " + this.ftp_graphics_count, 2002, 0);
    }

    public void logError(String string) {
    }

    public void logSevereError(String string) {
    }

    public void logSevereError(Exception exception) {
    }

    public void logProgress(String string, int n, int n2) {
    }

    public void batchStart() {
    }

    public void batchStop() {
    }

    public void init(WebSite webSite, Connection connection) {
        this.website = webSite;
        this.conn = connection;
        Calendar calendar = Calendar.getInstance();
        tmspBefore = BatchUtil.getDb2Timestamp(calendar);
    }

    public void processDocs(DocsEvent docsEvent) throws BatchException, IOException, SQLException {
        Document document = docsEvent.getDoc();
        String string = new String();
        String string2 = document.getFilename() + ".html";
        BatchUtil.logit("  changed since " + docsEvent.getChangedSince() + "\n" + "  last update " + this.website.getLastDocgenUpdate() + " for website " + this.website.getSiteName() + "\n" + "  classification " + document.getDocumentClass(), 2001, 0);
        if (docsEvent.getChangedSince().compareTo(this.website.getLastDocgenUpdate()) < 0) {
            BatchUtil.logit("Not published. " + string2 + " not changed for " + this.website.getSiteName(), 2001, 0);
            return;
        }
        if (docsEvent.webable && docsEvent.publish && document.getDocumentClass() >= this.website.getMiniClassification()) {
            string = this.toHtml(docsEvent);
            String string3 = BatchInit.getHtmlDocOutPath(this.website.getSiteName());
            BatchUtil.createDoc(string3 + string2, string);
            BatchUtil.logit(string2 + " created ", 2002, 0);
            this.pubFileList.add(string2);
            BatchUtil.logit(string2 + " added to the pub list", 2001, 0);
            ++this.docs_count;
            Vector vector = document.getGraphics();
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    String string4 = ((DocumentGraphic)vector.elementAt(n)).getFilename();
                    if (string4 != null) {
                        this.pubFileList.add(string4);
                        BatchUtil.logit("  Assoc. graphic " + string4 + " added to the pub list", 2001, 0);
                        ++this.graphics_count;
                    } else {
                        BatchUtil.logit("  Assoc. graphic has a null filename for " + string2, 2003, 0);
                    }
                    ++n;
                }
            }
        } else if (document.getDocumentClass() >= this.website.getMiniClassification()) {
            BatchUtil.logit("  " + string2 + " unpublishable. Add to delete list", 2001, 0);
            this.deleteFileList.add(string2);
            ++this.files_deleting_count;
            Vector vector = document.getGraphics();
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    String string5 = ((DocumentGraphic)vector.elementAt(n)).getFilename();
                    if (string5 != null) {
                        this.deleteFileList.add(string5);
                        ++this.files_deleting_count;
                        BatchUtil.logit("  Assoc. graphic " + string5 + " added to delete list ", 2001, 0);
                    } else {
                        BatchUtil.logit("  Assoc. delete graphic has a null filename for " + string2, 2003, 0);
                    }
                    ++n;
                }
            }
        } else {
            BatchUtil.logit("  " + document.getFilename() + " unpublishable. Confiential for " + this.website.getSiteName(), 2001, 0);
        }
    }

    public void finishDocs() throws BatchException, IOException, SQLException {
        String string = this.website.getSiteName();
        String string2 = BatchInit.getHtmlDocOutPath(string);
        String string3 = string2 + Docgen.docgen_app_name + ".ftp.list";
        String string4 = new String();
        int n = 0;
        while (n < this.pubFileList.size()) {
            string4 = string4 + (String)this.pubFileList.elementAt(n) + "\n";
            ++n;
        }
        BatchUtil.createDoc(string3, string4);
        string3 = string2 + Docgen.docgen_app_name + ".delete.list";
        string4 = new String();
        n = 0;
        while (n < this.deleteFileList.size()) {
            string4 = string4 + (String)this.deleteFileList.elementAt(n) + "\n";
            ++n;
        }
        BatchUtil.createDoc(string3, string4);
        try {
            if (this.pubFileList.size() > 0) {
                this.ftpNewDocs();
            }
        }
        catch (BatchFtpException batchFtpException) {
            BatchUtil.logit("Ftp html doc failed ", batchFtpException, 2004, 0);
        }
        if (this.deleteFileList.size() > 0) {
            this.files_deleted_count = BatchUtil.deleteDocs(string2, this.deleteFileList);
        }
        if (!Docgen.getPublishNow()) {
            if (this.pubFileList.size() > 0) {
                BatchUtil.logit("Setting timestamp to " + tmspBefore, 2002, 0);
                Statement statement = this.conn.createStatement();
                try {
                    ResultSet resultSet = statement.executeQuery("UPDATE tigris.constants SET strconst = '" + tmspBefore + "'" + " WHERE constant = 'TS_DOCGEN_" + string + "'");
                    resultSet.close();
                    BatchUtil.logit("Set the last Docgen update timestamp to " + tmspBefore + " for " + string, 2001, 0);
                }
                catch (SQLException sQLException) {
                    BatchUtil.logit("Failed to set TS_DOCGEN_" + string + " for website " + string + sQLException, 2004, 0);
                }
            } else {
                BatchUtil.logit("No document published. Timestamp not reset ", 2002, 0);
            }
        }
        this.publishStat();
    }

    public void ftpNewDocs() throws BatchException, IOException {
        String string;
        int n = this.website.getSiteType();
        String string2 = this.website.getSiteName();
        Ftp ftp = new Ftp();
        String string3 = BatchInit.getFtpHost(string2);
        String string4 = BatchInit.getFtpHostDir(string2);
        String string5 = BatchInit.getHtmlDocOutPath(string2);
        String string6 = BatchInit.getFtpUserId(string2);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        while (n2 < this.pubFileList.size()) {
            string = (String)this.pubFileList.elementAt(n2);
            if (string.indexOf(".html") != -1) {
                vector.add(string);
            } else {
                vector2.add(string);
            }
            ++n2;
        }
        BatchUtil.logit("Ftp quest html files for website " + this.website.getSiteName(), 2002, 0);
        this.ftp_docs_count = BatchUtil.ftpFiles(string3, string4, string5, string6, BatchInit.getFtpPassword(string2), "ascii", "put", vector);
        String string7 = BatchInit.getHostImageDir(string2);
        string = BatchInit.getLocalImageDir(string2);
        BatchUtil.logit("Ftp quest images for website " + this.website.getSiteName(), 2002, 0);
        this.ftp_graphics_count = BatchUtil.ftpFiles(string3, string7, string, string6, BatchInit.getFtpPassword(string2), "image", "put", vector2);
    }

    public String toHtml(DocsEvent docsEvent) throws BatchException {
        Object object;
        Document document = docsEvent.getDoc();
        int n = document.getDocumentType();
        int n2 = docsEvent.getDocClassind();
        String string = this.website.getTemplateDescript(n);
        if (string == null || string.length() == 0) {
            throw new HtmlTemplateNotFoundException("Html template not found for doctype: " + Integer.toString(n) + " " + "for website " + this.website.getSiteName(), 2004);
        }
        Calendar calendar = Calendar.getInstance();
        string = BatchUtil.substitute(string, "###TITLE###", document.getTitle());
        if (document.getDocumentBody() != null) {
            string = BatchUtil.substitute(string, "###MAINBODY###", document.getDocumentBody().getBody());
        } else {
            string = BatchUtil.substitute(string, "###MAINBODY###", " ");
            BatchUtil.logit("Get document body failed " + document.getDocInd(), 2004, 0);
        }
        string = BatchUtil.substitute(string, "###DOCID###", document.getFilename());
        String string2 = this.website.getDoctypeDescription(n);
        if (string2 != null) {
            string = BatchUtil.substitute(string, "###DOCTYPE###", string2);
        } else {
            string = BatchUtil.substitute(string, "###DOCTYPE###", " ");
            BatchUtil.logit("Get doctype desc failed for docTypeInd " + n + " for docind " + document.getDocInd(), 2003, 0);
        }
        string = document.getLastTouched() != null && document.getLastTouched().length() >= 10 ? BatchUtil.substitute(string, "###LASTUPDATE###", document.getLastTouched().substring(0, 11)) : BatchUtil.substitute(string, "###LASTUPDATE###", BatchUtil.getCurrTime("y-m-d"));
        string = BatchUtil.substitute(string, "###LASTPUB###", BatchUtil.getCurrTime("y-m-d"));
        string = BatchUtil.substitute(string, "###FAXABLE###", document.getFaxable() ? "Yes" : "No");
        string = BatchUtil.substitute(string, "###DOCSUMMARY###", document.getEMailComments());
        string = BatchUtil.substitute(string, "###YEAR###", BatchUtil.getCurrTime(1));
        Vector vector = document.getApplicableBrands();
        Vector vector2 = document.getApplicableFamilies();
        Vector vector3 = document.getApplicableMachines();
        Vector vector4 = document.getModels();
        if (vector != null) {
            string = BatchUtil.substitute(string, "###BRAND###", BatchUtil.getLists(vector, "", "", ", "));
        } else {
            string = BatchUtil.substitute(string, "###BRAND###", " ");
            BatchUtil.logit("Get applicable brands failed " + document.getDocInd(), 2003, 0);
        }
        if (vector2 != null) {
            string = BatchUtil.substitute(string, "###FAMILY###", BatchUtil.getLists(vector2, "", "", ", "));
        } else {
            string = BatchUtil.substitute(string, "###FAMILY###", " ");
            BatchUtil.logit("Get applcable family failed " + document.getDocInd(), 2003, 0);
        }
        if (vector3 != null) {
            string = BatchUtil.substitute(string, "###MACHINETYPE###", BatchUtil.getLists(vector3, "", "", ", "));
        } else {
            string = BatchUtil.substitute(string, "###MACHINETYPE###", " ");
            BatchUtil.logit("Get applicable machine failed " + document.getDocInd(), 2003, 0);
        }
        if (vector4 != null) {
            string = BatchUtil.substitute(string, "###MODEL###", BatchUtil.getLists(vector4, "", "", ", "));
        } else {
            string = BatchUtil.substitute(string, "###MODEL###", " ");
            BatchUtil.logit("Get applcable model failed " + document.getDocInd(), 2003, 0);
        }
        if (string.indexOf("###DOCIDNODASH###") != -1) {
            object = document.getFilename();
            string = BatchUtil.substitute(string, "###DOCIDNODASH###", BatchUtil.substitute((String)object, "-", ""));
        }
        if (string.indexOf("###TITLE1###") != -1) {
            object = new String(document.getTitle());
            BatchUtil.substitute((String)object, " TP ", " ThinkPad ");
            BatchUtil.substitute((String)object, " IBM ", " ");
            string = BatchUtil.substitute(string, "###TITLE1###", (String)object);
        }
        string = BatchUtil.substitute(string, "###ABSTRACT###", document.getTitle());
        string = BatchUtil.substitute(string, "###DESCRIPTION###", document.getTitle());
        if (document.getQueryText() != null) {
            string = BatchUtil.substitute(string, "###KEYWORDS###", document.getQueryText().getQueryText());
        } else {
            string = BatchUtil.substitute(string, "###KEYWORDS###", " ");
            BatchUtil.logit("Get document query text failed " + document.getDocInd(), 2003, 0);
        }
        string = BatchUtil.substitute(string, "###LOCATION###", "");
        string = BatchUtil.substitute(string, "###LASTMODIFIED###", BatchUtil.getCurrTime("y-m-d"));
        if (string.indexOf("###CLASSIFICATION###") != -1) {
            object = new String();
            switch (n2) {
                case 1: {
                    object = "<font color=#FF0000>IBM Confidential</font>";
                    break;
                }
                case 2: {
                    object = "<font size=2 color=#993333><b>This document is provided to IBM and our Business Partners to help ";
                    object = (String)object + "sell and/or service IBM products. It is not to be distributed beyond ";
                    object = (String)object + "that audience or used for any other purpose.</b></font><p>";
                    break;
                }
                default: {
                    object = "";
                }
            }
            string = BatchUtil.substitute(string, "###CLASSIFICATION###", (String)object);
        }
        if (string.indexOf("###CLASSIFICATIONC###") != -1) {
            object = new String();
            switch (n2) {
                case 1: {
                    object = "IBM Confidential";
                    break;
                }
                default: {
                    object = "";
                    break;
                }
            }
            string = BatchUtil.substitute(string, "###CLASSIFICATIONC###", (String)object);
        }
        if (string.indexOf("###COUNTRY###") != -1) {
            object = document.getLocale();
            if (object != null) {
                string = BatchUtil.substitute(string, "###COUNTRY###", ((LocaleRec)object).getLocaleList());
            } else {
                BatchUtil.logit("Get document locale text fail " + document.getDocInd(), 2003, 0);
            }
        }
        string = BatchUtil.substitute(string, "###IMAGELOC###", this.website.getImageLoc());
        switch (n) {
            case 9: {
                string = this.toSSDHtml(document, string);
                break;
            }
            case 8: {
                string = this.toServicePubHtml(document, string);
                break;
            }
            case 2: {
                string = this.toPartsInfoHtml(document, string);
                break;
            }
            case 3: {
                string = this.toProdInfoHtml(document, string);
                break;
            }
            case 4: {
                string = this.toHintsTipsHtml(document, string);
                break;
            }
            case 10: {
                string = this.toPreloadHtml(document, string);
                break;
            }
        }
        return string;
    }

    public String toSSDHtml(Document document, String string) throws BatchException {
        Object object;
        String string2;
        BatchUtil.logit("Substitiution for SSD doc " + document.getDocInd(), 2003, 0);
        String string3 = document.getDescription();
        if (string3 != null) {
            string = BatchUtil.substitute(string, "###DISKDESC###", BatchUtil.substitute(string3, "\n", "<br>"));
        } else {
            BatchUtil.logit("Get document description failed " + document.getDocInd(), 2003, 0);
        }
        String string4 = document.getReleaseDate();
        if (string4 != null) {
            string = BatchUtil.substitute(string, "###DISKRELEASEDATE###", string4);
        } else {
            BatchUtil.logit("Get document disk release date failed " + document.getDocInd(), 2003, 0);
        }
        String string5 = document.getVersion();
        if (string5 != null) {
            string = BatchUtil.substitute(string, "###DISKVERSION###", string5);
        } else {
            BatchUtil.logit("Get document disk version failed " + document.getDocInd(), 2003, 0);
        }
        if (string.indexOf("###FILETABLEROWS###") != -1) {
            string2 = new String();
            object = document.getFileAttachments();
            int n = 0;
            while (n < ((Vector)object).size()) {
                DocumentFile documentFile = (DocumentFile)((Vector)object).elementAt(n);
                String string6 = documentFile.getURL();
                String string7 = documentFile.getFilename();
                string2 = string2 + "<TR VALIGN=\"TOP\">";
                string2 = string2 + "<TD><FONT FACE=\"ARIAL,HELVETICA,GENEVA\" SIZE=2>";
                string2 = string6 != null && string6.length() > 0 ? (string6.indexOf(".pdf") != -1 ? string2 + "<a href=\"" + string6 + "\" target=\"_blank\">" + string7 + "</a>" : string2 + "<a href=\"" + string6 + "\">" + string7 + "</a>") : string2 + string7;
                string2 = string2 + "</FONT></TD>";
                string2 = string2 + "<TD>&nbsp;</TD>";
                string2 = string2 + "<TD ALIGN=RIGHT><FONT FACE=\"ARIAL,HELVETICA,GENEVA\" SIZE=2>";
                string2 = string2 + this.insertCommas(String.valueOf(documentFile.getSize()));
                string2 = string2 + "</FONT></TD>";
                string2 = string2 + "<TD>&nbsp;</TD>\n";
                string2 = string2 + "<TD ALIGN=LEFT><FONT FACE=\"ARIAL,HELVETICA,GENEVA\" SIZE=2>";
                string2 = string2 + documentFile.getDescription();
                string2 = string2 + "<br><br></FONT></TD>";
                string2 = string2 + "</TR>\n";
                ++n;
            }
            if (string2.length() == 0) {
                string2 = string2 + "<TR><TD COLSPAN=2>";
                string2 = string2 + "<FONT FACE=\"ARIAL,HELVETICA,GENEVA\" SIZE=2>";
                string2 = string2 + "<b>No available downloads</b></FONT>";
                string2 = string2 + "</TD></TR>";
            }
            string = BatchUtil.substitute(string, "###FILETABLEROWS###", string2);
        }
        if ((string2 = document.getAdditionalInfo()) != null && string2.length() > 0) {
            if (string.indexOf("###ADDLINFO###") != -1) {
                string = BatchUtil.substitute(string, "###ADDLINFO###", string2);
            }
            if (string.indexOf("###ADDITIONALINFO###") != -1) {
                object = "\\n<tr>\\n  <td colspan=2 valign=top align=left>\\n    <table cellspacing=0 cellpadding=0 border=0>\\n      <tr>\\n        <td align=left valign=top>\\n          <font face=\"Arial, Helvetica\" size=2>\\n            <em>\\n              <u>\\n                Additional Information:\\n              </u>\\n            </em>\\n          </font>\\n        </td>\\n      </tr>\\n      <tr>\\n        <td align=left valign=top>\\n";
                object = (String)object + string2;
                object = (String)object + "\\n" + "        </td>\\n" + "      </tr>\\n" + "    </table>\\n" + "  </td>\\n" + "</tr>\\n";
                string = BatchUtil.substitute(string, "###ADDITIONALINFO###", (String)object);
            }
        } else {
            string = BatchUtil.substitute(string, "###ADDITIONALINFO###", "");
            string = BatchUtil.substitute(string, "###ADDLINFO###", "");
        }
        return string;
    }

    private String insertCommas(String string) {
        String string2 = new String();
        int n = string.length();
        int n2 = n - 3;
        while (n2 > 0) {
            string2 = "," + string.substring(n2, n2 + 3) + string2;
            n2 -= 3;
        }
        return string.substring(0, n2 + 3) + string2;
    }

    public String toServicePubHtml(Document document, String string) throws BatchException {
        String string2;
        String string3;
        BatchUtil.logit("Substitiution for Service Pub doc " + document.getDocInd(), 2003, 0);
        String string4 = document.getDescription();
        if (string4 != null) {
            string = BatchUtil.substitute(string, "###DISKDESC###", BatchUtil.substitute(string4, "\n", "<br>"));
        } else {
            BatchUtil.logit("Get document description failed " + document.getDocInd(), 2003, 0);
        }
        String string5 = document.getReleaseDate();
        if (string5 != null) {
            string = BatchUtil.substitute(string, "###DISKRELEASEDATE###", string5);
        } else {
            BatchUtil.logit("Get document disk release date failed " + document.getDocInd(), 2003, 0);
        }
        if (string.indexOf("###FILETABLEROWS###") != -1) {
            string3 = new String();
            string2 = new String();
            Vector vector = document.getFileAttachments();
            int n = 0;
            while (n < vector.size()) {
                DocumentFile documentFile = (DocumentFile)vector.elementAt(n);
                String string6 = documentFile.getURL();
                String string7 = documentFile.getFilename();
                string3 = string3 + "<TR VALIGN=\"TOP\">";
                string3 = string3 + "<TD><FONT FACE=\"ARIAL,HELVETICA,GENEVA\" SIZE=2>";
                string3 = string6 != null && string6.length() > 0 ? (string6.indexOf(".pdf") != -1 ? string3 + "<a href=\"" + string6 + "\" target=\"_blank\">" + string7 + "</a>" : string3 + "<a href=\"" + string6 + "\">" + string7 + "</a>") : string3 + string7;
                string3 = string3 + "</FONT></TD>";
                string3 = string3 + "<TD>&nbsp;</TD>";
                string3 = string3 + "<TD ALIGN=RIGHT><FONT FACE=\"ARIAL,HELVETICA,GENEVA\" SIZE=2>";
                string3 = string3 + this.insertCommas(String.valueOf(documentFile.getSize()));
                string3 = string3 + "</FONT></TD>";
                string3 = string3 + "<TD>&nbsp;</TD>\n";
                string3 = string3 + "<TD ALIGN=LEFT><FONT FACE=\"ARIAL,HELVETICA,GENEVA\" SIZE=2>";
                string3 = string3 + documentFile.getDescription();
                string3 = string3 + "<br><br></FONT></TD>";
                string3 = string3 + "</TR>\n";
                string2 = documentFile.getVersion();
                if (string2 != null) {
                    string = BatchUtil.substitute(string, "###DISKVERSION###", string2);
                } else {
                    BatchUtil.logit("Get document disk version failed " + document.getDocInd(), 2003, 0);
                }
                ++n;
            }
            if (string3 == "") {
                string3 = string3 + "<TR><TD COLSPAN=2>";
                string3 = string3 + "<FONT FACE=\"ARIAL,HELVETICA,GENEVA\" SIZE=2>";
                string3 = string3 + "<b>No available downloads</b></FONT>";
                string3 = string3 + "</TD></TR>";
            }
            string = BatchUtil.substitute(string, "###FILETABLEROWS###", string3);
            string = BatchUtil.substitute(string, "###DISKVERSION###", string2);
        } else if (string.indexOf("###FILEURL###") != -1) {
            string3 = new String();
            string2 = new String();
            String string8 = new String();
            Vector vector = document.getFileAttachments();
            int n = 0;
            while (n < vector.size()) {
                DocumentFile documentFile = (DocumentFile)vector.elementAt(n);
                String string9 = documentFile.getURL();
                String string10 = documentFile.getFilename();
                if (string9 != null) {
                    if (string3 != null) {
                        string3 = string3 + ",<br> ";
                    }
                    string3 = string3 + "<a href=\"" + string9;
                    string3 = string9.indexOf(".pdf") != -1 ? string3 + "\" target=\"_blank\">" + string10 + "</a>" : string3 + "\">" + string10 + "</a>";
                }
                if (string2 != null) {
                    string2 = string2 + ",<br> ";
                }
                string2 = string2 + string10 + " : " + documentFile.getSize();
                if (string8.length() == 0) {
                    string8 = documentFile.getVersion();
                }
                ++n;
            }
            if (string3.length() == 0) {
                string3 = "<b>No available downloads</b>";
            }
            string = BatchUtil.substitute(string, "###FILEURL###", string3);
            string = BatchUtil.substitute(string, "###ATTACHARC###", string2);
            string = BatchUtil.substitute(string, "###DISKVERSION###", string8);
        }
        string3 = document.getAdditionalInfo();
        if (string.indexOf("###ADDLINFO###") != -1) {
            string2 = new String("");
            string2 = string2 + string3;
            string = BatchUtil.substitute(string, "###ADDLINFO###", string2);
        }
        return string;
    }

    public String toPartsInfoHtml(Document document, String string) throws BatchException {
        return string;
    }

    public String toPreloadHtml(Document document, String string) throws BatchException {
        return string;
    }

    public String toProdInfoHtml(Document document, String string) throws BatchException {
        return string;
    }

    public String toHintsTipsHtml(Document document, String string) throws BatchException {
        return string;
    }
}

