/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.batch.plugin;

import com.ibm.nzna.projects.batch.BatchInit;
import com.ibm.nzna.projects.batch.Docgen;
import com.ibm.nzna.projects.batch.WebSite;
import com.ibm.nzna.projects.batch.event.DocsEvent;
import com.ibm.nzna.projects.batch.exception.BatchException;
import com.ibm.nzna.projects.batch.exception.XmlTemplateNotFoundException;
import com.ibm.nzna.projects.batch.intf.DocgenIntf;
import com.ibm.nzna.projects.batch.plugin.HtmlDocgen;
import com.ibm.nzna.projects.batch.utils.BatchUtil;
import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.shared.batch.BatchListener;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class XmlDocgen
implements BatchListener,
DocgenIntf {
    private WebSite website;
    private Connection conn;
    private Vector pubFileList = new Vector();
    private Vector deleteFileList = new Vector();
    private int docs_count = 0;
    private int ftp_docs_count = 0;
    private int files_deleted_count = 0;
    private int files_deleting_count = 0;

    public int getDocsCount() {
        return this.docs_count;
    }

    public int getFtpDocsCount() {
        return this.ftp_docs_count;
    }

    public int getFilesDeleteCount() {
        return this.files_deleted_count;
    }

    public int getFilesDeletingCount() {
        return this.files_deleting_count;
    }

    public void publishStat() {
        BatchUtil.logit("****************************************************", 2002, 0);
        BatchUtil.logit("*     " + this.website.getSiteName() + " " + Docgen.docgen_app_name + " Xml Publish Stat ", 2002, 0);
        BatchUtil.logit("*        " + HtmlDocgen.tmspBefore, 2002, 0);
        BatchUtil.logit("****************************************************", 2002, 0);
        BatchUtil.logit("Xml Doc Published: " + this.docs_count, 2002, 0);
        BatchUtil.logit("Xml Doc Deleted:   " + this.files_deleted_count, 2002, 0);
        BatchUtil.logit("Xml Doc ftped:     " + this.ftp_docs_count, 2002, 0);
    }

    public void logError(String string) {
    }

    public void logSevereError(String string) {
    }

    public void logSevereError(Exception exception) {
    }

    public void logProgress(String string, int n, int n2) {
    }

    public void batchStart() {
    }

    public void batchStop() {
    }

    public void init(WebSite webSite, Connection connection) {
        this.website = webSite;
        this.conn = connection;
    }

    public void processDocs(DocsEvent docsEvent) throws BatchException, IOException, SQLException {
        Document document = docsEvent.getDoc();
        String string = new String();
        String string2 = document.getFilename() + ".xml";
        if (docsEvent.getChangedSince().compareTo(this.website.getLastDocgenUpdate()) < 0) {
            BatchUtil.logit("  Not published. " + string2 + " not changed for " + this.website.getSiteName(), 2001, 0);
            return;
        }
        if (docsEvent.webable && docsEvent.publish && document.getDocumentClass() >= this.website.getMiniClassification()) {
            string = this.toXml(docsEvent);
            String string3 = BatchInit.getXmlDocOutPath(this.website.getSiteName());
            BatchUtil.createDoc(string3 + string2, string);
            this.pubFileList.add(string2);
            BatchUtil.logit(string2 + " added to the pub list", 2001, 0);
            ++this.docs_count;
        } else if (document.getDocumentClass() >= this.website.getMiniClassification()) {
            this.deleteFileList.add(string2);
            ++this.files_deleting_count;
            BatchUtil.logit("  " + string2 + " unpublishable. Add to delete list", 2001, 0);
        } else {
            BatchUtil.logit("  " + document.getFilename() + " xml doc unpublishable. Confiential for " + this.website.getSiteName(), 2001, 0);
        }
    }

    public void finishDocs() throws BatchException, IOException, SQLException {
        String string = BatchInit.getXmlDocOutPath(this.website.getSiteName());
        String string2 = this.website.getSiteName();
        String string3 = string + Docgen.docgen_app_name + ".ftp.xmllist";
        String string4 = new String();
        int n = 0;
        while (n < this.pubFileList.size()) {
            string4 = string4 + (String)this.pubFileList.elementAt(n) + "\n";
            ++n;
        }
        BatchUtil.createDoc(string3, string4);
        string3 = string + Docgen.docgen_app_name + ".delete.xmllist";
        string4 = new String();
        n = 0;
        while (n < this.deleteFileList.size()) {
            string4 = string4 + (String)this.deleteFileList.elementAt(n) + "\n";
            ++n;
        }
        BatchUtil.createDoc(string3, string4);
        this.files_deleted_count = BatchUtil.deleteDocs(string, this.deleteFileList);
        this.publishStat();
    }

    public void ftpNewDocs() throws BatchException, IOException {
        int n = this.website.getSiteType();
        String string = this.website.getSiteName();
        Ftp ftp = new Ftp();
        String string2 = BatchInit.getXmlFtpHost(string);
        String string3 = BatchInit.getXmlFtpHostDir(string);
        String string4 = BatchInit.getXmlDocOutPath(string);
        String string5 = BatchInit.getFtpUserId(string);
        BatchUtil.logit("Ftp quest xml files for website " + this.website.getSiteName(), 2002, 0);
        this.ftp_docs_count = BatchUtil.ftpFiles(string2, string3, string4, string5, BatchInit.getFtpPassword(string), "ascii", "put", this.pubFileList);
    }

    public String toXml(DocsEvent docsEvent) throws BatchException, IOException {
        Document document = docsEvent.getDoc();
        int n = docsEvent.getDocTypeind();
        int n2 = docsEvent.getDocClassind();
        String string = BatchInit.getXmlTemplate(this.website.getSiteName());
        if (string == null || string.length() == 0) {
            throw new XmlTemplateNotFoundException("Xml template not found from property file", 2004);
        }
        string = BatchUtil.substitute(string, "###CREATION_DATE###", BatchUtil.getCurrTime("m-d-y"));
        string = BatchUtil.substitute(string, "###DOCID###", document.getFilename());
        string = BatchUtil.substitute(string, "###HTML_FILE_NAME###", document.getFilename() + ".html");
        string = BatchUtil.substitute(string, "###PUBLISH_DATE###", document.getLastTouched());
        string = BatchUtil.substitute(string, "###TITLE###", document.getTitle());
        string = BatchUtil.substitute(string, "###DOCTYPE###", this.website.getDoctypeDescription(n));
        String string2 = new String();
        switch (n2) {
            case 1: {
                string2 = "IBM Confidential";
                break;
            }
            case 2: {
                string2 = "Dealer Confidential";
                break;
            }
            case 3: {
                string2 = "Unclassified";
                break;
            }
            default: {
                string2 = "Unknown";
                break;
            }
        }
        string = BatchUtil.substitute(string, "###CLASSIFICATION###", string2);
        LocaleRec localeRec = document.getLocale();
        string = BatchUtil.substitute(string, "###GEO###", localeRec.getLocaleList());
        String string3 = new String();
        String string4 = new String();
        Vector vector = document.getApplicableBrands();
        Vector vector2 = document.getApplicableFamilies();
        Vector vector3 = document.getApplicableMachines();
        Vector vector4 = document.getModels();
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        if (vector != null) {
            int n3 = 0;
            while (n3 < vector.size()) {
                string5 = ((TypeCategoryRec)vector.elementAt(n3)).toString();
                try {
                    string6 = ((TypeCategoryRec)vector2.elementAt(n3)).toString();
                }
                catch (Exception exception) {
                    BatchUtil.logit("  getApplicableFamilies error", 2002, 0);
                }
                try {
                    string7 = ((TypeCategoryRec)vector3.elementAt(n3)).toString();
                }
                catch (Exception exception) {
                    BatchUtil.logit("  getApplicableTypes error", 2002, 0);
                }
                try {
                    string8 = ((TypeCategoryRec)vector4.elementAt(n3)).toString();
                }
                catch (Exception exception) {
                    BatchUtil.logit("  getModels error", 2002, 0);
                }
                if (string5.compareTo("IBM Options") == 0) {
                    string4 = string4 + "\t<OPTION>\n";
                    string4 = string4 + "\t\t<BRAND>" + string5 + "</BRAND>\n";
                    string4 = string4 + "\t\t<SUPCATEGORY>" + string6 + "</SUPCATEGORY>\n";
                    string4 = string4 + "\t\t<SUBCATEGORY>" + string7 + "</SUBCATEGORY>\n";
                    string4 = string4 + "\t\t<PARTNUMBER>" + string8 + "</PARTNUMBER>\n";
                    string4 = string4 + "\t</OPTION>\n";
                } else {
                    string3 = string3 + "\t<MACHINE>\n";
                    string3 = string3 + "\t\t<BRAND>" + string5 + "</BRAND>\n";
                    string3 = string3 + "\t\t<FAMILY>" + string6 + "</FAMILY>\n";
                    string3 = string3 + "\t\t<MACHINETYPE>" + string7 + "</MACHINETYPE>\n";
                    string3 = string3 + "\t\t<MODEL>" + string8 + "</MODEL>\n";
                    string3 = string3 + "\t</MACHINE>\n";
                }
                ++n3;
            }
        } else {
            BatchUtil.logit("  getApplicableBrands returns null", 2002, 0);
        }
        string = BatchUtil.substitute(string, "###MACHINES###", string3);
        string = BatchUtil.substitute(string, "###OPTIONS###", string4);
        string = BatchUtil.substitute(string, "###HISTORY###", document.getEMailComments());
        return string;
    }
}

