/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.doc;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Lob;
import COM.ibm.db2.app.StoredProc;
import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentBody;
import com.ibm.nzna.projects.common.quest.doc.DocumentComment;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.projects.common.quest.doc.DocumentLink;
import com.ibm.nzna.projects.common.quest.doc.DocumentQueryText;
import com.ibm.nzna.projects.common.quest.doc.DocumentStatus;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.shared.util.CDate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DocumentDraftReader
extends StoredProc {
    private StoredProcRec returnRec = new StoredProcRec();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readDocument(int n, Blob blob, Blob blob2) throws Exception {
        try {
            Connection connection = this.getConnection();
            DocumentDraft documentDraft = new DocumentDraft(n);
            int n2 = 0;
            n2 = this.readDocumentDraft(connection, documentDraft);
            blob = Lob.newBlob();
            StoredProcUtil.setObjectInBlob(blob, documentDraft);
            this.set(2, blob);
            this.returnRec.sqlCode = n2;
            this.returnRec.error = n2 != 0;
            connection.commit();
            connection.close();
        }
        catch (Exception exception) {
            StoredProcUtil.writeException(exception, this.returnRec);
        }
        blob2 = Lob.newBlob();
        StoredProcUtil.setObjectInBlob(blob2, this.returnRec);
        this.set(3, blob2);
    }

    protected int readDocumentDraft(Connection connection, DocumentDraft documentDraft) throws Exception {
        int n = 0;
        n = this.readDocumentDraftBase(connection, documentDraft);
        if (n == 0 && (n = this.readDocumentBody(connection, documentDraft)) != 0) {
            this.returnRec.errorStr = "Error reading Document Body";
        }
        if (n == 0 && (n = this.readDocumentGraphics(connection, documentDraft)) != 0) {
            this.returnRec.errorStr = "Error reading Document Body";
        }
        if (n == 0 && (n = this.readDocumentDraftCategories(connection, documentDraft)) != 0) {
            this.returnRec.errorStr = "Error reading Document Categories";
        }
        if (n == 0 && (n = this.readDocumentDraftProperties(connection, documentDraft)) != 0) {
            this.returnRec.errorStr = "Error reading Document Properties";
        }
        if (n == 0 && (n = this.readDocumentQueryText(connection, documentDraft)) != 0) {
            this.returnRec.errorStr = "Error reading Document Query Text";
        }
        if (n == 0 && (n = this.readDocumentLinks(connection, documentDraft)) != 0) {
            this.returnRec.errorStr = "Error reading Document Links";
        }
        if (n == 0 && (n = this.readDocumentDraftReferringLinks(connection, documentDraft)) != 0) {
            this.returnRec.errorStr = "Error reading Document Referring Links";
        }
        if (n == 0 && (n = this.readDocumentLocale(connection, documentDraft)) != 0) {
            this.returnRec.errorStr = "Error reading Document Locale";
        }
        if (n == 0) {
            DocumentDraftReader.readCommentHistory(connection, documentDraft);
        }
        if (n == 0 && (n = DocumentDraftReader.readDocumentStatus(connection, documentDraft)) != 0) {
            this.returnRec.errorStr = "Error reading Document status";
        }
        if (n == 0) {
            n = DocumentDraftReader.readDocumentBrands(connection, documentDraft);
        }
        if (n == 0) {
            n = DocumentDraftReader.readDocumentFamilies(connection, documentDraft);
        }
        if (n == 0) {
            n = DocumentDraftReader.readDocumentMachines(connection, documentDraft);
        }
        if (n == 0) {
            n = DocumentDraftReader.readDocumentModels(connection, documentDraft);
        }
        if (n == 0) {
            n = DocumentDraftReader.readDocumentPartNumbers(connection, documentDraft);
        }
        if (n == 0) {
            n = DocumentDraftReader.readDocumentApplicable(connection, documentDraft);
        }
        if (n == 0 && (documentDraft.getDocumentType() == 9 || documentDraft.getDocumentType() == 8) && (n = DocumentDraftReader.readDocumentFiles(connection, documentDraft)) != 0) {
            this.returnRec.errorStr = "Error reading Document Locale";
        }
        return n;
    }

    private final int readDocumentDraftBase(Connection connection, DocumentDraft documentDraft) throws Exception {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        string = "SELECT DOCTYPEIND,     DOCCLASSIND, TITLE,       OWNER,         REVIEWPERIOD, " + "       AUTHIND,        WEBABLE,     WEBONLY,     FAXABLE,       FLASHNEWS,    " + "       FLASHDATE,      FAQ,         EMAILABLE,   EMAILABLEDATE, SUMMARY,      " + "       METRICIND,      ADDINFO,     PARTNUM,     PUBTYPE,       LNDOCID,      " + "       SOURCE,         MAINTLOCK,   DBUSER,      CHANGEDTIME,   KNOWLEDGEBASE," + "       EXISTINGDOCIND, REQUESTOR,   WORKIND,     COMMENT,       STARTDATE,    " + "       STOPDATE,       RECYCLED                                               " + "FROM   QUEST.DOCUMENTS                                                        " + "WHERE  DOCIND   = " + documentDraft.getDocInd() + "                                    " + "       FOR FETCH ONLY                                                         ";
        resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            documentDraft.setDocumentType(resultSet.getInt(1));
            documentDraft.setDocumentClass(resultSet.getInt(2));
            documentDraft.setTitle(resultSet.getString(3).trim());
            documentDraft.setOwner(resultSet.getString(4).trim());
            documentDraft.setMonthsToReview(resultSet.getInt(5));
            documentDraft.setAuthority(resultSet.getInt(6));
            documentDraft.setWebable(resultSet.getString(7).equals("Y"));
            documentDraft.setWebOnly(resultSet.getString(8).equals("Y"));
            documentDraft.setFaxable(resultSet.getString(9).equals("Y"));
            documentDraft.setHotNewsDate(resultSet.getString(11));
            documentDraft.setFaq(resultSet.getString(12).equals("Y"));
            documentDraft.setEMailable(resultSet.getString(13).equals("Y"));
            documentDraft.setEMailableDate(resultSet.getString(14));
            documentDraft.setEMailComments(resultSet.getString(15));
            documentDraft.setMetric(resultSet.getInt(16));
            documentDraft.setAdditionalInfo(resultSet.getString(17));
            documentDraft.setPartNumber(resultSet.getString(18));
            documentDraft.setPublicationType(resultSet.getInt(19));
            documentDraft.setFilename(resultSet.getString(20));
            documentDraft.setSource(resultSet.getString(21));
            documentDraft.setMaintLock(resultSet.getString(22));
            documentDraft.setLastTouchedBy(resultSet.getString(23).trim());
            documentDraft.setLastTouched(resultSet.getString(24).trim());
            documentDraft.setKnowledgeBase(resultSet.getString(25).equals("Y"));
            documentDraft.setExistingDocInd(resultSet.getInt(26));
            documentDraft.setRequestor(resultSet.getString(27));
            documentDraft.setWorkRequired(resultSet.getInt(28));
            documentDraft.setOriginalComments(resultSet.getString(29));
            documentDraft.setStartDate(resultSet.getString(30));
            documentDraft.setStopDate(resultSet.getString(31));
        } else {
            n = 100;
            this.returnRec.errorStr = "Document " + documentDraft.getDocInd() + " Not Found in QUEST.DOCUMENTS table";
        }
        resultSet.close();
        statement.close();
        return n;
    }

    private final int readDocumentGraphics(Connection connection, DocumentDraft documentDraft) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        Vector<DocumentGraphic> vector = new Vector<DocumentGraphic>(1, 1);
        string = "SELECT FILENAME " + "FROM QUESTNEW.GRAPHICS " + "WHERE DOCIND = " + documentDraft.getDocInd() + " " + "FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            DocumentGraphic documentGraphic = new DocumentGraphic(documentDraft.getDocInd(), resultSet.getString(1).trim());
            documentGraphic.resetRecStatus();
            vector.addElement(documentGraphic);
        }
        documentDraft.setGraphics(vector);
        resultSet.close();
        statement.close();
        return n;
    }

    public static int readDocumentFiles(Connection connection, Document document) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        Vector<DocumentFile> vector = new Vector<DocumentFile>(1, 1);
        string = "SELECT FILENAME, DESCRIPT, SIZE, URL, VERSION, FTPMODE, ORDERNUM " + "FROM QUEST.DOCFILES " + "WHERE DOCIND = " + document.getDocInd() + " " + "ORDER BY ORDERNUM FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            DocumentFile documentFile = new DocumentFile(document.getDocInd(), resultSet.getString(1).trim());
            documentFile.setDescription(resultSet.getString(2).trim());
            documentFile.setSize(resultSet.getInt(3));
            documentFile.setLocation(resultSet.getString(4));
            documentFile.setURL(resultSet.getString(4));
            documentFile.setVersion(resultSet.getString(5).trim());
            documentFile.setFTPMode(resultSet.getInt(6));
            documentFile.setOrderNum(resultSet.getInt(7));
            documentFile.resetRecStatus();
            vector.addElement(documentFile);
        }
        document.setFileAttachments(vector);
        resultSet.close();
        statement.close();
        return n;
    }

    private final int readDocumentBody(Connection connection, DocumentDraft documentDraft) throws Exception {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        string = "SELECT BODY " + "FROM QUEST.DOCBODY " + "WHERE DOCIND = " + documentDraft.getDocInd() + " " + "ORDER BY RECNUM";
        resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            DocumentBody documentBody = new DocumentBody(resultSet.getString(1).trim());
            while (resultSet.next()) {
                documentBody.addBodyChunk(resultSet.getString(1).trim());
            }
            documentDraft.setDocumentBody(documentBody);
        }
        resultSet.close();
        statement.close();
        return n;
    }

    private final int readDocumentDraftCategories(Connection connection, DocumentDraft documentDraft) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1, 1);
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER " + "FROM QUEST.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + documentDraft.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL = '" + "doccategory" + "' " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2).trim());
            typeCategoryRec.setCategoryLevel("machine");
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5).trim());
            typeCategoryRec.setOwner(resultSet.getString(6).trim());
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        documentDraft.setCategory(vector);
        return n;
    }

    private final int readDocumentDraftProperties(Connection connection, DocumentDraft documentDraft) throws Exception {
        Statement statement = connection.createStatement();
        String string = null;
        ResultSet resultSet = null;
        String string2 = "";
        String string3 = "";
        string = "SELECT PROPERTYIND, ORDERNUM, VALUE " + "FROM QUEST.DOCPROPERTIES " + "WHERE DOCIND = " + documentDraft.getDocInd() + " " + "ORDER BY ORDERNUM " + "FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            if (resultSet.getString(3) == null) continue;
            switch (resultSet.getInt(1)) {
                case 1: {
                    documentDraft.setUniversalNotesId(resultSet.getString(3).trim());
                    break;
                }
                case 2: {
                    string2 = string2 + resultSet.getString(3);
                    break;
                }
                case 3: {
                    documentDraft.setReleaseDate(CDate.dateFromDBDate(resultSet.getString(3).trim()));
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    documentDraft.setCreateDate(CDate.dateFromDBDate(resultSet.getString(3).trim()));
                    break;
                }
                case 10: {
                    documentDraft.setCreatedBy(resultSet.getString(3).trim());
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    documentDraft.setURL(resultSet.getString(3).trim());
                    break;
                }
                case 8: {
                    documentDraft.setVersion(resultSet.getString(3).trim());
                    break;
                }
                case 9: {
                    documentDraft.setCheckedOutBy(resultSet.getString(3).trim());
                    break;
                }
            }
        }
        if (string2.length() > 0) {
            documentDraft.setDescription(string2.trim());
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocumentQueryText(Connection connection, DocumentDraft documentDraft) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        string = "SELECT QUERYTEXT " + "FROM QUEST.DOCQUERYTEXT " + "WHERE  DOCIND = " + documentDraft.getDocInd();
        resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            documentDraft.setQueryText(new DocumentQueryText(resultSet.getString(1).trim()));
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocumentLinks(Connection connection, DocumentDraft documentDraft) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        Vector<DocumentLink> vector = new Vector<DocumentLink>(10, 10);
        resultSet = statement.executeQuery("SELECT A.DOCLINKIND, B.TITLE FROM " + "QUEST.DOCLINKS A, " + "QUEST.DOCUMENTS B " + "WHERE A.DOCLINKIND = B.DOCIND AND " + "A.DOCIND = " + documentDraft.getDocInd());
        while (resultSet.next()) {
            DocumentLink documentLink = new DocumentLink(documentDraft.getDocInd(), resultSet.getInt(1), resultSet.getString(2).trim());
            vector.addElement(documentLink);
        }
        documentDraft.setDocumentLinks(vector);
        resultSet.close();
        statement.close();
        return n;
    }

    private final int readDocumentDraftReferringLinks(Connection connection, DocumentDraft documentDraft) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        Vector<DocumentLink> vector = new Vector<DocumentLink>(10, 10);
        resultSet = statement.executeQuery("SELECT A.DOCLINKIND, B.TITLE FROM " + "QUEST.DOCLINKS A, " + "QUEST.DOCUMENTS B " + "WHERE A.DOCIND = B.DOCIND AND " + "A.DOCLINKIND = " + documentDraft.getDocInd());
        while (resultSet.next()) {
            DocumentLink documentLink = new DocumentLink(resultSet.getInt(1), documentDraft.getDocInd(), resultSet.getString(2).trim());
            vector.addElement(documentLink);
        }
        documentDraft.setReferringDocumentLinks(vector);
        resultSet.close();
        statement.close();
        return n;
    }

    private final int readDocumentLocale(Connection connection, DocumentDraft documentDraft) throws Exception {
        LocaleRec localeRec = new LocaleRec(connection);
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        resultSet = statement.executeQuery("SELECT A.GEOIND, B.DESCRIPT " + "FROM QUEST.DOCGEO A, " + "     TIGRIS.TYPEGEOGRAPHY B " + "WHERE DOCIND = " + documentDraft.getDocInd() + " AND " + "      A.GEOIND = B.GEOIND " + "FOR FETCH ONLY");
        while (bl && resultSet.next()) {
            if (resultSet.getInt(1) == 6) {
                localeRec.setWorldWide(true);
                bl = false;
                continue;
            }
            localeRec.addGeography(new TypeGeoRec(resultSet.getInt(1), resultSet.getString(2).trim()));
        }
        resultSet.close();
        if (bl) {
            resultSet = statement.executeQuery("SELECT A.COUNTRYCODEIND, B.PHONECOUNTRYCODE, B.DESCRIPT,     B.ZIPMASK,   " + "       B.PHONEMASK,      B.ZIPDIGITS,        B.TIMEDIFF,     B.MULTIZONE, " + "       B.USESDST,        B.CURRENCY,         B.CURRENCYMASK, B.LANG01,    " + "       B.LANG02,         B.LANG03,           C.GEOIND,       B.ISOCODE    " + "FROM QUEST.DOCCOUNTRY A,                                                  " + "     TIGRIS.TYPECOUNTRYCODE B,                                            " + "     TIGRIS.GEOCOUNTRY C                                                  " + "WHERE DOCIND = " + documentDraft.getDocInd() + "  AND                              " + "      A.COUNTRYCODEIND = B.COUNTRYCODEIND AND                             " + "      A.COUNTRYCODEIND = C.COUNTRYCODEIND                                 " + "FOR FETCH ONLY");
        }
        while (bl && resultSet.next()) {
            localeRec.addCountry(new TypeCountryCodeRec(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3).trim(), resultSet.getString(4), resultSet.getString(5), (short)resultSet.getInt(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), (short)resultSet.getInt(12), (short)resultSet.getInt(13), (short)resultSet.getInt(14), (short)resultSet.getInt(15), resultSet.getString(16)));
        }
        documentDraft.setLocale(localeRec);
        resultSet.close();
        statement.close();
        return n;
    }

    public static int readCommentHistory(Connection connection, DocumentDraft documentDraft) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        boolean bl = false;
        string = "SELECT DOCIND, COMMENT, DBUSER, CHANGEDTIME " + "FROM QUEST.DOCUMENTS " + "WHERE  EXISTINGDOCIND = " + documentDraft.getExistingDocInd() + " AND " + "       STOPDATE IS NOT NULL AND " + "       RECYCLED = 'N' AND " + "       TEMPLATE = 'N' " + "ORDER BY STOPDATE DESC FETCH FIRST 5 ROWS ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            if (resultSet.getString(2) != null) {
                documentDraft.addCommentToHistory(new DocumentComment(resultSet.getInt(1), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim()));
                continue;
            }
            documentDraft.addCommentToHistory(new DocumentComment(resultSet.getInt(1), "N/A", resultSet.getString(3).trim(), resultSet.getString(4).trim()));
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private static final int readDocumentBrands(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1, 1);
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER " + "FROM QUEST.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL = '" + "brand" + "' " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2));
            typeCategoryRec.setCategoryLevel("brand");
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5));
            typeCategoryRec.setOwner(resultSet.getString(6));
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setBrands(vector);
        return n;
    }

    private static final int readDocumentFamilies(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1, 1);
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER " + "FROM QUEST.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL = '" + "family" + "' " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2));
            typeCategoryRec.setCategoryLevel("family");
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5));
            typeCategoryRec.setOwner(resultSet.getString(6));
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setFamilies(vector);
        return n;
    }

    private static final int readDocumentMachines(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1, 1);
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER, " + "       B.CATEGORYLEVEL " + "FROM QUEST.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL in ('" + "machine" + "', '" + "subcategory" + "') " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2));
            typeCategoryRec.setCategoryLevel(resultSet.getString(7));
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5));
            typeCategoryRec.setOwner(resultSet.getString(6));
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setMachines(vector);
        return n;
    }

    private static final int readDocumentModels(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1, 1);
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER " + "FROM QUEST.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL = '" + "model" + "' " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2));
            typeCategoryRec.setCategoryLevel("model");
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5));
            typeCategoryRec.setOwner(resultSet.getString(6));
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setModels(vector);
        return n;
    }

    private static final int readDocumentPartNumbers(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = document.getModels();
        if (vector == null) {
            vector = new Vector<TypeCategoryRec>(1);
        }
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER " + "FROM QUEST.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL = '" + "partnum" + "' " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2));
            typeCategoryRec.setCategoryLevel("partnum");
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5));
            typeCategoryRec.setOwner(resultSet.getString(6));
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setModels(vector);
        return n;
    }

    public static int readDocumentStatus(Connection connection, Document document) throws Exception {
        DocumentStatus documentStatus = null;
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        resultSet = statement.executeQuery("SELECT STATUSIND, STATUSDATE " + "FROM QUEST.DOCSTATUS " + "WHERE DOCIND = " + document.getDocInd() + " " + "ORDER BY RECNUM FOR FETCH ONLY");
        while (resultSet.next()) {
            documentStatus = new DocumentStatus(document.getDocInd(), resultSet.getInt(1), resultSet.getString(2).trim());
        }
        resultSet.close();
        statement.close();
        document.setStatus(documentStatus);
        return n;
    }

    public static int readDocumentApplicable(Connection connection, Document document) throws SQLException {
        Statement statement = connection.createStatement();
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        Vector<TypeCategoryRec> vector2 = new Vector<TypeCategoryRec>(1);
        Vector<TypeCategoryRec> vector3 = new Vector<TypeCategoryRec>(1);
        ResultSet resultSet = statement.executeQuery("SELECT A.TYPECATIND, A.DESCRIPTION, A.CATEGORYLEVEL, A.PARENTCATIND " + "FROM PRODUCT.TYPECATEGORY A, " + "     PRODUCT.TYPECATCHILD B " + "WHERE A.TYPECATIND = B.PARENTCATIND AND " + "      B.TYPECATIND IN (SELECT TYPECATIND FROM QUEST.CATEGORY WHERE DOCIND = " + document.getDocInd() + ")");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2).trim());
            typeCategoryRec.setCategoryLevel(resultSet.getString(3).trim());
            typeCategoryRec.setParentCatInd(resultSet.getInt(4));
            typeCategoryRec.updateRecStatus(0);
            if (typeCategoryRec.getCategoryLevel().equals("brand")) {
                if (vector.contains(typeCategoryRec)) continue;
                vector.addElement(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("family")) {
                if (vector2.contains(typeCategoryRec)) continue;
                vector2.addElement(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("machine")) {
                if (vector3.contains(typeCategoryRec)) continue;
                vector3.addElement(typeCategoryRec);
                continue;
            }
            if (!typeCategoryRec.getCategoryLevel().equals("subcategory") || vector3.contains(typeCategoryRec)) continue;
            vector3.addElement(typeCategoryRec);
        }
        document.setApplicableBrands(vector);
        document.setApplicableFamilies(vector2);
        document.setApplicableMachines(vector3);
        resultSet.close();
        statement.close();
        return 0;
    }
}

