/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.doc;

import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentBody;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.projects.common.quest.doc.DocumentProperty;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.Text;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Vector;

public class DocumentDraftWriter {
    protected static int writeToDatabase(DocumentDraft documentDraft) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append("DELETE FROM QUEST.CATEGORY WHERE DOCIND = " + documentDraft.getDocInd() + SqlRunner.END_DELIM);
        if (DocumentDraftWriter.writeBaseInfo(documentDraft, stringBuffer)) {
            if (DocumentDraftWriter.writeGraphics(documentDraft, stringBuffer)) {
                if (DocumentDraftWriter.writeLocale(documentDraft, stringBuffer)) {
                    if (DocumentDraftWriter.writeCategories(documentDraft, stringBuffer)) {
                        if (DocumentDraftWriter.writeFileAttachments(documentDraft, stringBuffer)) {
                            if (DocumentDraftWriter.writeStatus(documentDraft, stringBuffer)) {
                                if (DocumentDraftWriter.writeProperties(documentDraft, stringBuffer)) {
                                    if (DocumentDraftWriter.writeBFTM(documentDraft, stringBuffer)) {
                                        if (DocumentDraftWriter.writeQueryText(documentDraft, stringBuffer)) {
                                            if (stringBuffer.length() > 1 && (n = SqlRunner.sqlRunnerCode(1, stringBuffer.toString())) == 0) {
                                                if (documentDraft.getDocumentType() == 9) {
                                                    DocumentDraftWriter.writeAdditionalInfo(documentDraft);
                                                } else {
                                                    DocumentDraftWriter.writeBody(documentDraft);
                                                }
                                            }
                                        } else {
                                            n = -10;
                                        }
                                    } else {
                                        n = -9;
                                    }
                                } else {
                                    n = -11;
                                }
                            } else {
                                n = -8;
                            }
                        } else {
                            n = -7;
                        }
                    } else {
                        n = -5;
                    }
                } else {
                    n = -4;
                }
            } else {
                n = -3;
            }
        } else {
            n = -2;
        }
        return n;
    }

    private static final boolean writeBaseInfo(DocumentDraft documentDraft, StringBuffer stringBuffer) {
        boolean bl = true;
        String string = documentDraft.getOriginalComments() + "\n" + documentDraft.getComments();
        string = Text.cleanNullableDBString(string);
        if (documentDraft.getTemplate()) {
            documentDraft.clearFilename();
        }
        switch (documentDraft.getRecStatus()) {
            case 3: {
                stringBuffer.append("DELETE FROM QUEST.DOCMEDIA WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.DOCBODY WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.DOCCOUNTRY WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.DOCGEO WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUESTNEW.GRAPHICS WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.DOCHISTORY WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.DOCLINKS WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.DOCPROPERTIES WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.DOCQUERYTEXT WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.DOCSTATUS WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.PRODDOCS WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.NOTIFICATION WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.CATEGORY WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                stringBuffer.append("DELETE FROM QUEST.DOCUMENTS WHERE DOCIND = " + documentDraft.getDocInd() + "" + SqlRunner.END_DELIM);
                break;
            }
            case 1: {
                stringBuffer.append("UPDATE QUEST.DOCUMENTS " + "SET RECYCLED       = 'N', " + "    DBUSER         = '" + documentDraft.getLastTouchedBy() + "', " + "    CHANGEDTIME    = CURRENT TIMESTAMP, " + "    DOCTYPEIND     = " + documentDraft.getDocumentType() + ", " + "    DOCCLASSIND    = " + documentDraft.getDocumentClass() + ", " + "    TITLE          = " + Text.cleanNullableDBString(documentDraft.getTitle()) + ", " + "    OWNER          = " + Text.cleanNullableDBString(documentDraft.getOwner()) + ", " + "    REVIEWPERIOD   = " + documentDraft.getMonthsToReview() + ", " + "    AUTHIND        = 0, " + "    KNOWLEDGEBASE  = '" + Text.getYN(documentDraft.getKnowledgeBase()) + "', " + "    WEBABLE        = '" + Text.getYN(documentDraft.getWebable()) + "', " + "    WEBONLY        = '" + Text.getYN(documentDraft.getWebOnly()) + "', " + "    FAXABLE        = '" + Text.getYN(documentDraft.getFaxable()) + "', " + "    FLASHNEWS      = '" + Text.getYN(documentDraft.getHotNews()) + "', " + "    FLASHDATE      =  " + Text.cleanNullableDBString(documentDraft.getHotNewsDate()) + ", " + "    FAQ            = '" + Text.getYN(documentDraft.getFaq()) + "', " + "    EMAILABLE      = '" + Text.getYN(documentDraft.getEMailable()) + "', " + "    EMAILABLEDATE  =  " + Text.cleanNullableDBString(documentDraft.getEMailableDate()) + ", " + "    SUMMARY        =  " + Text.cleanNullableDBString(documentDraft.getEMailComments()) + ", " + "    METRICIND      =  " + documentDraft.getMetric() + ", " + "    PARTNUM        =  " + Text.cleanNullableDBString(documentDraft.getPartNumber()) + ", " + "    PUBTYPE        =  " + documentDraft.getPublicationType() + ", " + "    LNDOCID        =  " + Text.cleanNullableDBString(documentDraft.getFilename()) + ", " + "    SOURCE         =  " + Text.cleanNullableDBString(documentDraft.getSource()) + ", " + "    COMMENT        =  " + string + ", " + "    STARTDATE      =  '" + documentDraft.getStartDate() + "', " + "    STOPDATE       =   " + Text.cleanNullableDBString(documentDraft.getStopDate()) + ", " + "    EXISTINGDOCIND =  " + documentDraft.getExistingDocInd() + ", " + "    REQUESTOR      =   " + Text.cleanNullableDBString(documentDraft.getRequestor()) + ", " + "    WORKIND        = " + documentDraft.getWorkRequired() + ", " + "    MAINTLOCK      = 'N' " + "WHERE DOCIND = " + documentDraft.getDocInd() + SqlRunner.END_DELIM);
                break;
            }
            case 2: {
                String string2 = documentDraft.getStopDate();
                string2 = string2 == null || string2.length() == 0 ? "NULL" : "'" + string2 + "'";
                stringBuffer.append("INSERT INTO QUEST.DOCUMENTS " + "( DOCIND, " + "  RECYCLED, " + "  DBUSER, " + "  CHANGEDTIME, " + "  DOCTYPEIND, " + "  DOCCLASSIND, " + "  TITLE, " + "  OWNER, " + "  REVIEWPERIOD, " + "  AUTHIND, " + "  KNOWLEDGEBASE, " + "  WEBABLE, " + "  WEBONLY, " + "  FAXABLE, " + "  FLASHNEWS, " + "  FLASHDATE, " + "  FAQ, " + "  EMAILABLE, " + "  EMAILABLEDATE, " + "  SUMMARY, " + "  METRICIND, " + "  PARTNUM, " + "  PUBTYPE, " + "  LNDOCID, " + "  SOURCE, " + "  WORKIND, " + "  MAINTLOCK, " + "  COMMENT,   " + "  STARTDATE, " + "  STOPDATE,  " + "  EXISTINGDOCIND, " + "  SHOW, " + "  TEMPLATE, " + "  REQUESTOR ) values " + "(    " + documentDraft.getDocInd() + ", " + "     'N', " + "     '" + documentDraft.getLastTouchedBy() + "', " + "     CURRENT TIMESTAMP, " + "     " + documentDraft.getDocumentType() + ", " + "     " + documentDraft.getDocumentClass() + ", " + "     " + Text.cleanNullableDBString(documentDraft.getTitle()) + ", " + "     " + Text.cleanNullableDBString(documentDraft.getOwner()) + ", " + "     " + documentDraft.getMonthsToReview() + ", " + "     0, " + "     '" + Text.getYN(documentDraft.getKnowledgeBase()) + "', " + "     '" + Text.getYN(documentDraft.getWebable()) + "', " + "     '" + Text.getYN(documentDraft.getWebOnly()) + "', " + "     '" + Text.getYN(documentDraft.getFaxable()) + "', " + "     '" + Text.getYN(documentDraft.getHotNews()) + "', " + "      " + Text.cleanNullableDBString(documentDraft.getHotNewsDate()) + ", " + "     '" + Text.getYN(documentDraft.getFaq()) + "', " + "     '" + Text.getYN(documentDraft.getEMailable()) + "', " + "      " + Text.cleanNullableDBString(documentDraft.getEMailableDate()) + ", " + "      " + Text.cleanNullableDBString(documentDraft.getEMailComments()) + ", " + "      " + documentDraft.getMetric() + ", " + "      " + Text.cleanNullableDBString(documentDraft.getPartNumber()) + ", " + "      " + documentDraft.getPublicationType() + ", " + "      " + Text.cleanNullableDBString(documentDraft.getFilename()) + ", " + "      " + Text.cleanNullableDBString(documentDraft.getSource()) + ", " + "     " + documentDraft.getWorkRequired() + ", " + "     'N', " + "      " + string + ", " + "     '" + documentDraft.getStartDate() + "', " + "     " + Text.cleanNullableDBString(documentDraft.getStopDate()) + ", " + "     " + documentDraft.getExistingDocInd() + ", " + "      'Y', " + "      '" + Text.getYN(documentDraft.getTemplate()) + "', " + "      " + Text.cleanNullableDBString(documentDraft.getRequestor()) + " ) " + SqlRunner.END_DELIM);
                break;
            }
        }
        return bl;
    }

    private static final boolean writeGraphics(DocumentDraft documentDraft, StringBuffer stringBuffer) {
        boolean bl = true;
        Vector vector = documentDraft.getGraphics();
        stringBuffer.append("DELETE FROM QUESTNEW.GRAPHICS WHERE DOCIND = " + documentDraft.getDocInd() + SqlRunner.END_DELIM);
        if (documentDraft.valid() && vector != null && vector.size() > 0) {
            DocumentGraphic documentGraphic = null;
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                if (documentGraphic != null && documentGraphic.valid()) {
                    stringBuffer.append("INSERT INTO QUESTNEW.GRAPHICS " + "( DOCIND, FILENAME )" + "values " + "( " + documentDraft.getDocInd() + ", " + "  '" + documentGraphic.getFilename() + "')" + SqlRunner.END_DELIM);
                }
                ++n;
            }
        }
        return bl;
    }

    private static final boolean writeLocale(DocumentDraft documentDraft, StringBuffer stringBuffer) {
        LocaleRec localeRec = documentDraft.getLocale();
        boolean bl = false;
        stringBuffer.append("DELETE FROM QUEST.DOCGEO     WHERE DOCIND = " + documentDraft.getDocInd() + SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM QUEST.DOCCOUNTRY WHERE DOCIND = " + documentDraft.getDocInd() + SqlRunner.END_DELIM);
        if (documentDraft.valid() && localeRec != null) {
            Object var4_4 = null;
            Object var5_5 = null;
            if (localeRec.isWorldWide()) {
                stringBuffer.append("INSERT INTO QUEST.DOCGEO " + "( DOCIND, GEOIND, DBUSER, CHANGEDTIME )" + "VALUES " + " ( " + documentDraft.getDocInd() + ", " + "   6, " + "   '" + documentDraft.getLastTouchedBy() + "', " + "   CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
            } else {
                int n;
                Vector vector = localeRec.getGeoListContainingAll();
                Vector vector2 = localeRec.getSingleCountryList();
                int n2 = 0;
                if (vector != null && vector.size() > 0) {
                    n = vector.size();
                    while (n2 < n) {
                        stringBuffer.append("INSERT INTO QUEST.DOCGEO " + "(DOCIND, GEOIND, DBUSER, CHANGEDTIME )" + "VALUES " + " ( " + documentDraft.getDocInd() + ", " + "   " + ((TypeGeoRec)vector.elementAt(n2)).getInd() + "," + "   '" + documentDraft.getLastTouchedBy() + "', " + "   CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
                        ++n2;
                    }
                }
                if (vector2 != null && vector2.size() > 0) {
                    n = vector2.size();
                    n2 = 0;
                    while (n2 < n) {
                        stringBuffer.append("INSERT INTO QUEST.DOCCOUNTRY " + "(DOCIND, COUNTRYCODEIND, DBUSER, CHANGEDTIME )" + "VALUES " + "( " + documentDraft.getDocInd() + ", " + "  " + ((TypeCountryCodeRec)vector2.elementAt(n2)).getInd() + ", " + "  '" + documentDraft.getLastTouchedBy() + "', " + "  CURRENT TIMESTAMP )" + SqlRunner.END_DELIM);
                        ++n2;
                    }
                }
            }
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean writeCategories(DocumentDraft documentDraft, StringBuffer stringBuffer) {
        boolean bl = false;
        Vector vector = documentDraft.getCategory();
        if (documentDraft.valid() && vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            TypeCategoryRec typeCategoryRec = null;
            while (n < n2) {
                typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
                stringBuffer.append("INSERT INTO QUEST.CATEGORY " + "(DOCIND, TYPECATIND )" + "values " + "( " + documentDraft.getDocInd() + ", " + "  " + typeCategoryRec.getInd() + ")" + SqlRunner.END_DELIM);
                ++n;
            }
        }
        bl = true;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean writeBody(DocumentDraft documentDraft) throws Exception {
        SQLMethod sQLMethod = new SQLMethod(1, "writeBody", 5);
        DocumentBody documentBody = documentDraft.getDocumentBody();
        boolean bl = true;
        Statement statement = sQLMethod.createStatement();
        try {
            Vector vector;
            statement.executeUpdate("DELETE FROM QUEST.DOCBODY WHERE DOCIND = " + documentDraft.getDocInd());
            statement.close();
            if (documentBody != null && documentDraft.valid() && (documentBody.getRecStatus() == 2 || documentBody.getRecStatus() == 1) && (vector = documentBody.getBodyChunks()) != null && vector.size() > 0) {
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    PreparedStatement preparedStatement = sQLMethod.createPreparedStatement("INSERT INTO QUEST.DOCBODY " + "(DOCIND, recnum, BODY, DBUSER, CHANGEDTIME) " + "values ( " + documentDraft.getDocInd() + ", " + "         " + (n + 1) + ", " + "         ?, " + "         '" + documentDraft.getLastTouchedBy() + "', " + "         CURRENT TIMESTAMP )");
                    System.out.println("***\n***\n*** Body Chunk SIze:" + ((String)vector.elementAt(n)).length());
                    preparedStatement.setString(1, (String)vector.elementAt(n));
                    preparedStatement.execute();
                    preparedStatement.close();
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            throw exception;
        }
        sQLMethod.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean writeAdditionalInfo(DocumentDraft documentDraft) throws Exception {
        SQLMethod sQLMethod = new SQLMethod(1, "writeAddInfo", 5);
        String string = documentDraft.getAdditionalInfo();
        boolean bl = true;
        Statement statement = sQLMethod.createStatement();
        try {
            PreparedStatement preparedStatement = sQLMethod.createPreparedStatement("UPDATE QUEST.DOCUMENTS " + "SET ADDINFO = ? " + "WHERE DOCIND = " + documentDraft.getDocInd());
            preparedStatement.setString(1, string);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            throw exception;
        }
        sQLMethod.close();
        return bl;
    }

    private static final boolean writeFileAttachments(DocumentDraft documentDraft, StringBuffer stringBuffer) throws Exception {
        boolean bl = true;
        Vector vector = documentDraft.getFileAttachments();
        stringBuffer.append("DELETE FROM QUEST.DOCFILES WHERE DOCIND = " + documentDraft.getDocInd() + SqlRunner.END_DELIM);
        if (documentDraft.valid() && vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            DocumentFile documentFile = null;
            while (n < n2) {
                documentFile = (DocumentFile)vector.elementAt(n);
                if (documentFile != null && documentFile.valid()) {
                    stringBuffer.append("INSERT INTO QUEST.DOCFILES (DOCIND, FILENAME, DESCRIPT, SIZE, URL, VERSION, FTPMODE, ORDERNUM) " + "values " + "( " + documentDraft.getDocInd() + ", " + "  '" + documentFile.getFilename() + "', " + "  '" + Text.cleanDBString(documentFile.getDescription()) + "', " + "  " + documentFile.getSize() + ", " + "  '" + Text.cleanDBString(documentFile.getURL()) + "', " + "  '" + Text.cleanDBString(documentFile.getVersion()) + "', " + "  " + documentFile.getFTPMode() + ", " + "  " + documentFile.getOrderNum() + " )" + SqlRunner.END_DELIM);
                }
                ++n;
            }
        }
        return bl;
    }

    private static final boolean writeStatus(Document document, StringBuffer stringBuffer) {
        if (document.valid() && document.getStatus() != null) {
            document.getStatus().setDocInd(document.getDocInd());
            stringBuffer.append(document.getStatus().toDraftSQL());
        }
        return true;
    }

    private static final boolean writeQueryText(Document document, StringBuffer stringBuffer) {
        stringBuffer.append("DELETE FROM QUEST.DOCQUERYTEXT WHERE DOCIND = " + document.getDocInd() + SqlRunner.END_DELIM);
        if (document.valid() && document.getQueryText() != null && document.getQueryText().toString().length() > 0) {
            stringBuffer.append("INSERT INTO QUEST.DOCQUERYTEXT " + "values ( " + document.getDocInd() + ", " + "         '" + Text.cleanDBString(document.getQueryText().toString()) + "', " + "         'QUEST', " + "         CURRENT TIMESTAMP)" + SqlRunner.END_DELIM);
        }
        return true;
    }

    private static final boolean writeBFTM(Document document, StringBuffer stringBuffer) {
        if (document.valid()) {
            int n;
            int n2;
            Vector vector = document.getBrands();
            Vector vector2 = document.getFamilies();
            Vector vector3 = document.getModels();
            Vector vector4 = document.getMachines();
            Vector vector5 = new Vector();
            if (vector != null && vector.size() > 0) {
                n2 = 0;
                n = vector.size();
                while (n2 < n) {
                    if (!vector5.contains(vector.elementAt(n2))) {
                        vector5.addElement(vector.elementAt(n2));
                    }
                    ++n2;
                }
            }
            if (vector2 != null && vector2.size() > 0) {
                n2 = 0;
                n = vector2.size();
                while (n2 < n) {
                    if (!vector5.contains(vector2.elementAt(n2))) {
                        vector5.addElement(vector2.elementAt(n2));
                    }
                    ++n2;
                }
            }
            if (vector3 != null && vector3.size() > 0) {
                n2 = 0;
                n = vector3.size();
                while (n2 < n) {
                    if (!vector5.contains(vector3.elementAt(n2))) {
                        vector5.addElement(vector3.elementAt(n2));
                    }
                    ++n2;
                }
            }
            if (vector4 != null && vector4.size() > 0) {
                n2 = 0;
                n = vector4.size();
                while (n2 < n) {
                    if (!vector5.contains(vector4.elementAt(n2))) {
                        vector5.addElement(vector4.elementAt(n2));
                    }
                    ++n2;
                }
            }
            if (vector5.size() > 0) {
                n2 = 0;
                n = vector5.size();
                while (n2 < n) {
                    stringBuffer.append("INSERT INTO QUEST.CATEGORY (DOCIND, TYPECATIND) " + "VALUES ( " + document.getDocInd() + ", " + ((TypeCategoryRec)vector5.elementAt(n2)).getInd() + ")" + SqlRunner.END_DELIM);
                    ++n2;
                }
            }
        }
        return true;
    }

    private static final boolean writeProperties(DocumentDraft documentDraft, StringBuffer stringBuffer) {
        Vector vector = documentDraft.getProperties();
        stringBuffer.append("DELETE FROM QUEST.DOCPROPERTIES WHERE DOCIND = " + documentDraft.getDocInd() + SqlRunner.END_DELIM);
        if (documentDraft.valid() && vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            DocumentProperty documentProperty = null;
            while (n < n2) {
                documentProperty = (DocumentProperty)vector.elementAt(n);
                if (documentProperty.getValue() != null) {
                    stringBuffer.append("INSERT INTO QUEST.DOCPROPERTIES VALUES (" + "" + documentDraft.getDocInd() + ", " + "" + documentProperty.getPropertyInd() + ", " + "" + documentProperty.getOrderNum() + ", " + "'" + Text.cleanDBString(documentProperty.getValue()) + "', " + "USER, " + "CURRENT TIMESTAMP)" + SqlRunner.END_DELIM);
                }
                ++n;
            }
        }
        return true;
    }
}

