/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.doc;

import com.ibm.nzna.projects.common.quest.QuestRecord;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.Text;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DocumentFile
extends QuestRecord {
    static final long serialVersionUID = 1000000L;
    public static final int REC_DEASSOCIATE = -100;
    public static String[] locations = new String[]{new String("access_ibm_en"), new String("access_ibm_jp"), new String("access_ibm_fr"), new String("access_ibm_fi"), new String("access_ibm_ne"), new String("access_ibm_no"), new String("access_ibm_sp"), new String("access_ibm_dk"), new String("access_ibm_sv"), new String("access_ibm_gr"), new String("ambra"), new String("aptiva"), new String("backlevel"), new String("bp_aptiva"), new String("bp_netvista"), new String("bp_options"), new String("bp_pc"), new String("bp_server"), new String("bp_sysmgmt"), new String("bp_thinkpad"), new String("commercial_desktop"), new String("communications"), new String("eprm"), new String("dos_util"), new String("intellistation"), new String("ispirati"), new String("mobiles"), new String("mobiles_pdf"), new String("netfinity_manager"), new String("netvista"), new String("network"), new String("network_station"), new String("options"), new String("options_iso"), new String("os2_ews"), new String("pc_servers"), new String("pc_servers_iso"), new String("pc_servers_pdf"), new String("pcug_news"), new String("powerpc"), new String("private/network"), new String("private/options"), new String("private/server_hidden"), new String("private/thinkpad"), new String("private/netfinity"), new String("ps1"), new String("refdisks"), new String("ssg"), new String("sysmgmt"), new String("system_specific"), new String("ta_ibm_tips"), new String("ta_support"), new String("tcpip"), new String("tpnls"), new String("valuepnt"), new String("visuals")};
    private String filename = null;
    private int orderNum = 0;
    private String localFilename = null;
    private String location = null;
    private long size = 0L;
    private int documentInd = 0;
    private String description = null;
    private String url = null;
    private String version = null;
    private int ftpMode = 0;

    public void setLocalFilename(String string) {
        this.localFilename = string;
        this.updateRecStatus(1);
    }

    public void setFilename(String string) {
        if (string == null || string.length() >= 50) {
            throw new IllegalArgumentException("Filenames must not be null and be less than 50 characters in length");
        }
        this.filename = string;
        this.updateRecStatus(1);
    }

    public void setVersion(String string) {
        if (string == null || string.length() >= 25) {
            throw new IllegalArgumentException("The Version must not be null and be less than 25 characters in length");
        }
        this.version = string;
        this.updateRecStatus(1);
    }

    public void setLocation(String string) {
        if (string != null) {
            if (string.indexOf("ftp.pc.ibm.com") >= 0) {
                String string2 = "ftp.pc.ibm.com/pub/pccbbs/";
                string = string.substring(string.indexOf(string2) + string2.length(), string.lastIndexOf("/"));
            }
            if (this.isValidLocation(string)) {
                this.location = string;
                this.updateRecStatus(1);
            }
        } else {
            throw new IllegalArgumentException("The Location must not be null and must be already defined in the DocumentFile.java class. Cannot set location to:" + string);
        }
    }

    public void setSize(long l) {
        this.size = l;
        this.updateRecStatus(1);
    }

    public boolean isValidLocation(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = locations.length;
        while (!bl && n < n2) {
            bl = locations[n].equals(string);
            ++n;
        }
        return bl;
    }

    public void setDescription(String string) {
        if (string == null || string.length() >= 254) {
            throw new IllegalArgumentException("Descriptions cannot be null and must be less than 254 characters in length");
        }
        this.description = string;
        this.updateRecStatus(1);
    }

    public String getDescription() {
        return this.description;
    }

    public void setURL(String string) {
        if (string == null || string.length() >= 1500) {
            throw new IllegalArgumentException("The URL value cannot be NULL and must be less than 1500 characters in length");
        }
        this.url = string;
        this.updateRecStatus(1);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getLocalFilename() {
        return this.localFilename;
    }

    public String getVersion() {
        return this.version;
    }

    public String getURL() {
        return this.url;
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.location;
    }

    public int fileExistsInQuest() throws SQLException, Exception {
        return DocumentFile.fileExistsInQuest(this.filename);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int fileExistsInQuest(String string) throws SQLException, Exception {
        SQLMethod sQLMethod = new SQLMethod(1, "fileExistInQuest ( " + string + " )", 5);
        int n = 0;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.DOCIND " + "FROM TIGRIS.DOCMEDIA A, " + "     TIGRIS.MULTIMEDIA B  " + "WHERE B.FILENAME = '" + string + "' AND " + "      A.MULTIMEDIAIND = B.MULTIMEDIAIND " + "FOR FETCH ONLY");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            throw exception;
        }
        sQLMethod.close();
        return n;
    }

    public static String[] getLocations() {
        return locations;
    }

    public String toSQL() {
        String string = "";
        switch (this.getRecStatus()) {
            case 2: {
                string = "INSERT INTO TIGRIS.DOCFILES " + " ( DOCIND, FILENAME, DESCRIPT, SIZE, URL, VERSION ) " + "VALUES ( " + " " + this.getDocumentInd() + ", " + " '" + this.getFilename() + "', " + " '" + Text.cleanDBString(this.getDescription()) + "', " + " '" + Text.cleanDBString(this.getLocation()) + "', " + " " + this.getSize() + ", " + " '" + Text.cleanDBString(this.getURL()) + "', " + " '" + Text.cleanDBString(this.getVersion()) + "' )";
                break;
            }
            case 1: {
                string = "UPDATE TIGRIS.DOCFILES " + "SET   DOCIND   = " + this.getDocumentInd() + ", " + "      FILENAME = '" + this.getFilename() + "', " + "      DESCRIPT = '" + Text.cleanDBString(this.getDescription()) + "', " + "      SIZE     =  " + this.getSize() + ", " + "      URL      = '" + Text.cleanDBString(this.getURL()) + "', " + "      VERSION  = '" + Text.cleanDBString(this.getVersion()) + "' " + "WHERE DOCIND   = " + this.getDocumentInd() + " AND " + "      FILENAME = '" + this.getFilename() + "'";
                break;
            }
            case 3: {
                string = "DELETE FROM TIGRIS.DOCFILE " + "WHERE DOCIND   = " + this.getDocumentInd() + " AND " + "      FILENAME = '" + this.getFilename() + "'";
                break;
            }
        }
        return string.toString();
    }

    protected void resetRecStatus() {
        this.updateRecStatus(0);
    }

    public int getDocumentInd() {
        return this.documentInd;
    }

    public String toString() {
        return this.filename;
    }

    public String toDraftSQL() {
        String string = "";
        switch (this.getRecStatus()) {
            case 2: {
                string = "INSERT INTO QUEST.DOCFILES " + " ( DOCIND, FILENAME, DESCRIPT, SIZE, URL, VERSION, FTPMODE ) " + "VALUES ( " + " " + this.getDocumentInd() + ", " + " '" + this.getFilename() + "', " + " '" + Text.cleanDBString(this.getDescription()) + "', " + " '" + Text.cleanDBString(this.getLocation()) + "', " + " " + this.getSize() + ", " + " '" + Text.cleanDBString(this.getURL()) + "', " + " '" + Text.cleanDBString(this.getVersion()) + "', " + "  " + this.ftpMode + " )";
                break;
            }
            case 1: {
                string = "UPDATE QUEST.DOCFILES " + "SET   DOCIND   = " + this.getDocumentInd() + ", " + "      FILENAME = '" + this.getFilename() + "', " + "      DESCRIPT = '" + Text.cleanDBString(this.getDescription()) + "', " + "      SIZE     =  " + this.getSize() + ", " + "      URL      = '" + Text.cleanDBString(this.getURL()) + "', " + "      VERSION  = '" + Text.cleanDBString(this.getVersion()) + "', " + "      ftpMode  = " + this.ftpMode + " " + "WHERE DOCIND   = " + this.getDocumentInd() + " AND " + "      FILENAME = '" + this.getFilename() + "'";
                break;
            }
            case 3: {
                string = "DELETE FROM QUEST.DOCFILE " + "WHERE DOCIND   = " + this.getDocumentInd() + " AND " + "      FILENAME = '" + this.getFilename() + "'";
                break;
            }
        }
        return string.toString();
    }

    public int getFTPMode() {
        return this.ftpMode;
    }

    public void setFTPMode(int n) {
        this.ftpMode = n;
    }

    public void setOrderNum(int n) {
        if (this.orderNum != n) {
            this.orderNum = n;
            this.updateRecStatus(1);
        }
    }

    public int getOrderNum() {
        return this.orderNum;
    }

    public DocumentFile() {
        this.updateRecStatus(2);
    }

    public DocumentFile(int n, String string) {
        this.documentInd = n;
        if (string.indexOf("ftp.pc.ibm.com") >= 0) {
            String string2 = "ftp.pc.ibm.com/pub/pccbbs/";
            this.setFilename(string.substring(string.lastIndexOf("/") + 1));
            this.setLocalFilename(string.substring(string.lastIndexOf("/")));
            this.setLocation(string.substring(string.indexOf(string2) + string2.length(), string.lastIndexOf("/")));
        } else if (FileUtil.containsPathInfo(string)) {
            this.setLocalFilename(string);
            this.setFilename(FileUtil.filenameFromPath(string));
        } else {
            this.setFilename(string);
        }
    }

    public DocumentFile(int n, String string, int n2) {
        this.documentInd = n;
        this.updateRecStatus(n2);
        if (FileUtil.containsPathInfo(string)) {
            this.setLocalFilename(string);
            this.setFilename(FileUtil.filenameFromPath(string));
        }
    }
}

