/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.doc;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Lob;
import COM.ibm.db2.app.StoredProc;
import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentBody;
import com.ibm.nzna.projects.common.quest.doc.DocumentComment;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.projects.common.quest.doc.DocumentLink;
import com.ibm.nzna.projects.common.quest.doc.DocumentQueryText;
import com.ibm.nzna.projects.common.quest.doc.DocumentStatus;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.shared.util.CDate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DocumentReader
extends StoredProc {
    private StoredProcRec returnRec = new StoredProcRec();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readDocument(int n, Blob blob, Blob blob2) throws Exception {
        Connection connection = this.getConnection();
        try {
            Document document = new Document(n);
            int n2 = 0;
            n2 = DocumentReader.readDocument(connection, document);
            blob = Lob.newBlob();
            StoredProcUtil.setObjectInBlob(blob, document);
            this.set(2, blob);
            this.returnRec.sqlCode = n2;
            this.returnRec.errorStr = "DocumentReader Returned rc:" + n2;
            this.returnRec.error = n2 != 0;
        }
        catch (Exception exception) {
            StoredProcUtil.writeException(exception, this.returnRec);
        }
        connection.commit();
        connection.close();
        blob2 = Lob.newBlob();
        StoredProcUtil.setObjectInBlob(blob2, this.returnRec);
        this.set(3, blob2);
    }

    public static int readDocument(Connection connection, Document document) throws Exception {
        int n = 0;
        n = DocumentReader.readDocumentBase(connection, document);
        if (n == 0) {
            n = DocumentReader.readDocumentGraphics(connection, document);
        }
        if (n == 0 && document.getDocumentType() != 9) {
            n = DocumentReader.readDocumentBody(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentCategories(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentProperties(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentQueryText(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentLinks(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentReferringLinks(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentStatus(connection, document);
        }
        if (n == 0) {
            DocumentReader.readCommentHistory(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentLocale(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentBrands(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentFamilies(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentMachines(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentModels(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentPartNumbers(connection, document);
        }
        if (n == 0) {
            n = DocumentReader.readDocumentApplicable(connection, document);
        }
        if (n == 0 && (document.getDocumentType() == 9 || document.getDocumentType() == 8)) {
            n = DocumentReader.readDocumentFiles(connection, document);
        }
        return n;
    }

    public static int readDocumentBase(Connection connection, Document document) throws Exception {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        string = "SELECT DOCTYPEIND,   DOCCLASSIND, TITLE,     OWNER,         REVIEWPERIOD, " + "       AUTHIND,      WEBABLE,     WEBONLY,   FAXABLE,       FLASHNEWS,    " + "       FLASHDATE,    FAQ,         EMAILABLE, EMAILABLEDATE, SUMMARY,      " + "       METRICIND,    ADDINFO,     PARTNUM,   PUBTYPE,       LNDOCID,      " + "       SOURCE,       MAINTLOCK,   DBUSER,    CHANGEDTIME,   KNOWLEDGEBASE " + "FROM   TIGRIS.DOCUMENTS                                                   " + "WHERE  DOCIND   = " + document.getDocInd() + "                                " + "       FOR FETCH ONLY                                                     ";
        resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            document.setDocumentType(resultSet.getInt(1));
            document.setDocumentClass(resultSet.getInt(2));
            document.setTitle(resultSet.getString(3).trim());
            document.setOwner(resultSet.getString(4).trim());
            document.setMonthsToReview(resultSet.getInt(5));
            document.setAuthority(resultSet.getInt(6));
            document.setWebable(resultSet.getString(7).equals("Y"));
            document.setWebOnly(resultSet.getString(8).equals("Y"));
            document.setFaxable(resultSet.getString(9).equals("Y"));
            document.setHotNewsDate(resultSet.getString(11));
            document.setFaq(resultSet.getString(12).equals("Y"));
            document.setEMailable(resultSet.getString(13).equals("Y"));
            document.setEMailableDate(resultSet.getString(14));
            document.setEMailComments(resultSet.getString(15));
            document.setMetric(resultSet.getInt(16));
            document.setAdditionalInfo(resultSet.getString(17));
            document.setPartNumber(resultSet.getString(18));
            document.setPublicationType(resultSet.getInt(19));
            document.setFilename(resultSet.getString(20));
            document.setSource(resultSet.getString(21));
            document.setMaintLock(resultSet.getString(22));
            document.setLastTouchedBy(resultSet.getString(23).trim());
            document.setLastTouched(resultSet.getString(24).trim());
            document.setKnowledgeBase(resultSet.getString(25).equals("Y"));
        } else {
            n = 100;
        }
        resultSet.close();
        statement.close();
        return n;
    }

    public static int readDocumentGraphics(Connection connection, Document document) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        Vector<DocumentGraphic> vector = new Vector<DocumentGraphic>(1, 1);
        string = "SELECT FILENAME " + "FROM TIGNEW.GRAPHICS  " + "WHERE DOCIND = " + document.getDocInd() + " " + "FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            DocumentGraphic documentGraphic = new DocumentGraphic(document.getDocInd(), resultSet.getString(1).trim());
            documentGraphic.resetRecStatus();
            vector.addElement(documentGraphic);
        }
        document.setGraphics(vector);
        resultSet.close();
        statement.close();
        return n;
    }

    public static int readDocumentFiles(Connection connection, Document document) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        Vector<DocumentFile> vector = new Vector<DocumentFile>(1, 1);
        string = "SELECT FILENAME, DESCRIPT, SIZE, URL, VERSION, FTPMODE, ORDERNUM        " + "FROM TIGRIS.DOCFILES " + "WHERE DOCIND = " + document.getDocInd() + " " + "ORDER BY ORDERNUM FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            DocumentFile documentFile = new DocumentFile(document.getDocInd(), resultSet.getString(1).trim());
            documentFile.setDescription(resultSet.getString(2).trim());
            documentFile.setSize(resultSet.getInt(3));
            documentFile.setLocation(resultSet.getString(4));
            documentFile.setURL(resultSet.getString(4));
            documentFile.setVersion(resultSet.getString(5).trim());
            documentFile.setFTPMode(resultSet.getInt(6));
            documentFile.setOrderNum(resultSet.getInt(7));
            documentFile.resetRecStatus();
            vector.addElement(documentFile);
        }
        document.setFileAttachments(vector);
        resultSet.close();
        statement.close();
        return n;
    }

    public static int readDocumentBody(Connection connection, Document document) throws Exception {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        string = "SELECT BODY " + "FROM TIGRIS.DOCBODY " + "WHERE DOCIND = " + document.getDocInd() + " " + "ORDER BY RECNUM";
        resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            DocumentBody documentBody = new DocumentBody(resultSet.getString(1).trim());
            while (resultSet.next()) {
                documentBody.addBodyChunk(resultSet.getString(1).trim());
            }
            document.setDocumentBody(documentBody);
        }
        resultSet.close();
        statement.close();
        return n;
    }

    public static int readDocumentCategories(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1, 1);
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER " + "FROM TIGRIS.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL = '" + "doccategory" + "' " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2).trim());
            typeCategoryRec.setCategoryLevel("doccategory");
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5).trim());
            typeCategoryRec.setOwner(resultSet.getString(6).trim());
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setCategory(vector);
        return n;
    }

    public static int readDocumentProperties(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        String string = null;
        ResultSet resultSet = null;
        String string2 = "";
        String string3 = "";
        string = "SELECT PROPERTYIND, ORDERNUM, VALUE " + "FROM TIGRIS.DOCPROPERTIES " + "WHERE DOCIND = " + document.getDocInd() + " " + "ORDER BY ORDERNUM " + "FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            if (resultSet.getString(3) == null) continue;
            switch (resultSet.getInt(1)) {
                case 1: {
                    document.setUniversalNotesId(resultSet.getString(3).trim());
                    break;
                }
                case 2: {
                    string2 = string2 + resultSet.getString(3);
                    break;
                }
                case 3: {
                    document.setReleaseDate(CDate.dateFromDBDate(resultSet.getString(3).trim()));
                    break;
                }
                case 4: {
                    string3 = string3 + resultSet.getString(3).trim();
                    break;
                }
                case 9: {
                    document.setCheckedOutBy(resultSet.getString(3).trim());
                    break;
                }
                case 5: {
                    document.setCreateDate(resultSet.getString(3).trim());
                    break;
                }
                case 10: {
                    document.setCreatedBy(resultSet.getString(3).trim());
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    document.setURL(resultSet.getString(3).trim());
                    break;
                }
                case 8: {
                    document.setVersion(resultSet.getString(3).trim());
                    break;
                }
            }
        }
        if (string2.length() > 0) {
            document.setDescription(string2.trim());
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    public static int readDocumentQueryText(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        string = "SELECT QUERYTEXT " + "FROM TIGRIS.DOCQUERYTEXT " + "WHERE  DOCIND = " + document.getDocInd();
        resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            document.setQueryText(new DocumentQueryText(resultSet.getString(1).trim()));
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    public static int readDocumentLinks(Connection connection, Document document) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        Vector<DocumentLink> vector = new Vector<DocumentLink>(10, 10);
        resultSet = statement.executeQuery("SELECT A.DOCLINKIND, B.TITLE FROM " + "TIGRIS.DOCLINKS A, " + "TIGRIS.DOCUMENTS B " + "WHERE A.DOCLINKIND = B.DOCIND AND " + "A.DOCIND = " + document.getDocInd());
        while (resultSet.next()) {
            DocumentLink documentLink = new DocumentLink(document.getDocInd(), resultSet.getInt(1), resultSet.getString(2).trim());
            vector.addElement(documentLink);
        }
        document.setDocumentLinks(vector);
        resultSet.close();
        statement.close();
        return n;
    }

    public static int readDocumentReferringLinks(Connection connection, Document document) throws SQLException {
        int n = 0;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        Vector<DocumentLink> vector = new Vector<DocumentLink>(10, 10);
        resultSet = statement.executeQuery("SELECT A.DOCIND, B.TITLE FROM " + "TIGRIS.DOCLINKS A, " + "TIGRIS.DOCUMENTS B " + "WHERE A.DOCIND = B.DOCIND AND " + "A.DOCLINKIND = " + document.getDocInd());
        while (resultSet.next()) {
            DocumentLink documentLink = new DocumentLink(resultSet.getInt(1), document.getDocInd(), resultSet.getString(2).trim());
            documentLink.setReferringLink(true);
            vector.addElement(documentLink);
        }
        document.setReferringDocumentLinks(vector);
        resultSet.close();
        statement.close();
        return n;
    }

    public static int readDocumentLocale(Connection connection, Document document) throws Exception {
        LocaleRec localeRec = new LocaleRec(connection);
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        resultSet = statement.executeQuery("SELECT A.GEOIND, B.DESCRIPT " + "FROM TIGRIS.DOCGEO A, " + "     TIGRIS.TYPEGEOGRAPHY B " + "WHERE DOCIND = " + document.getDocInd() + " AND " + "      A.GEOIND = B.GEOIND " + "FOR FETCH ONLY");
        while (bl && resultSet.next()) {
            if (resultSet.getInt(1) == 6) {
                localeRec.setWorldWide(true);
                bl = false;
                continue;
            }
            localeRec.addGeography(new TypeGeoRec(resultSet.getInt(1), resultSet.getString(2).trim()));
        }
        resultSet.close();
        if (bl) {
            resultSet = statement.executeQuery("SELECT A.COUNTRYCODEIND, B.PHONECOUNTRYCODE, B.DESCRIPT,     B.ZIPMASK,   " + "       B.PHONEMASK,      B.ZIPDIGITS,        B.TIMEDIFF,     B.MULTIZONE, " + "       B.USESDST,        B.CURRENCY,         B.CURRENCYMASK, B.LANG01,    " + "       B.LANG02,         B.LANG03,           C.GEOIND,       B.ISOCODE    " + "FROM TIGRIS.DOCCOUNTRY A,                                                 " + "     TIGRIS.TYPECOUNTRYCODE B,                                            " + "     TIGRIS.GEOCOUNTRY C                                                  " + "WHERE DOCIND = " + document.getDocInd() + "  AND                              " + "      A.COUNTRYCODEIND = B.COUNTRYCODEIND AND                             " + "      A.COUNTRYCODEIND = C.COUNTRYCODEIND                                 " + "FOR FETCH ONLY");
        }
        while (bl && resultSet.next()) {
            localeRec.addCountry(new TypeCountryCodeRec(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3).trim(), resultSet.getString(4), resultSet.getString(5), (short)resultSet.getInt(6), resultSet.getString(7), resultSet.getString(8), resultSet.getString(9), resultSet.getString(10), resultSet.getString(11), (short)resultSet.getInt(12), (short)resultSet.getInt(13), (short)resultSet.getInt(14), (short)resultSet.getInt(15), resultSet.getString(16)));
        }
        resultSet.close();
        statement.close();
        document.setLocale(localeRec);
        return n;
    }

    public static int readDocumentBrands(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1, 1);
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER " + "FROM TIGRIS.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL = '" + "brand" + "' " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2).trim());
            typeCategoryRec.setCategoryLevel("brand");
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5).trim());
            typeCategoryRec.setOwner(resultSet.getString(6).trim());
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setBrands(vector);
        return n;
    }

    public static int readDocumentFamilies(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1, 1);
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER " + "FROM TIGRIS.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL = '" + "family" + "' " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2).trim());
            typeCategoryRec.setCategoryLevel("family");
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5).trim());
            typeCategoryRec.setOwner(resultSet.getString(6).trim());
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setFamilies(vector);
        return n;
    }

    public static int readDocumentMachines(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1, 1);
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER,        " + "       B.CATEGORYLEVEL " + "FROM TIGRIS.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL IN ( '" + "machine" + "', '" + "subcategory" + "') " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2));
            typeCategoryRec.setCategoryLevel(resultSet.getString(7));
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5));
            typeCategoryRec.setOwner(resultSet.getString(6));
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setMachines(vector);
        return n;
    }

    private static final int readDocumentPartNumbers(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = document.getModels();
        if (vector == null) {
            vector = new Vector<TypeCategoryRec>(1);
        }
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER " + "FROM TIGRIS.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL = '" + "partnum" + "' " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2).trim());
            typeCategoryRec.setCategoryLevel("partnum");
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5));
            typeCategoryRec.setOwner(resultSet.getString(6));
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setModels(vector);
        return n;
    }

    public static int readDocumentModels(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1, 1);
        resultSet = statement.executeQuery("SELECT A.TYPECATIND,      B.DESCRIPTION, B.PARENTCATIND, " + "       B.ORDERNUM,        B.CHILDSORT,   B.OWNER " + "FROM TIGRIS.CATEGORY A, " + "     PRODUCT.TYPECATEGORY B " + "WHERE A.DOCIND = " + document.getDocInd() + " AND " + "      A.TYPECATIND = B.TYPECATIND AND " + "      B.CATEGORYLEVEL = '" + "model" + "' " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2));
            typeCategoryRec.setCategoryLevel("model");
            typeCategoryRec.setParentCatInd(resultSet.getInt(3));
            typeCategoryRec.setOrderNum(resultSet.getInt(4));
            typeCategoryRec.setChildSort(resultSet.getString(5));
            typeCategoryRec.setOwner(resultSet.getString(6));
            vector.addElement(typeCategoryRec);
        }
        resultSet.close();
        statement.close();
        document.setModels(vector);
        return n;
    }

    public static int readDocumentStatus(Connection connection, Document document) throws Exception {
        DocumentStatus documentStatus = null;
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = null;
        resultSet = statement.executeQuery("SELECT STATUSIND, STATUSDATE " + "FROM TIGRIS.DOCSTATUS " + "WHERE DOCIND = " + document.getDocInd() + " " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            documentStatus = new DocumentStatus(document.getDocInd(), resultSet.getInt(1), resultSet.getString(2).trim());
        }
        resultSet.close();
        statement.close();
        document.setStatus(documentStatus);
        return n;
    }

    public static int readDocumentApplicable(Connection connection, Document document) throws SQLException {
        Statement statement = connection.createStatement();
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        Vector<TypeCategoryRec> vector2 = new Vector<TypeCategoryRec>(1);
        Vector<TypeCategoryRec> vector3 = new Vector<TypeCategoryRec>(1);
        ResultSet resultSet = statement.executeQuery("SELECT A.TYPECATIND, A.DESCRIPTION, A.CATEGORYLEVEL, A.PARENTCATIND " + "FROM PRODUCT.TYPECATEGORY A, " + "     PRODUCT.TYPECATCHILD B " + "WHERE A.TYPECATIND = B.PARENTCATIND AND " + "      B.TYPECATIND IN (SELECT TYPECATIND FROM TIGRIS.CATEGORY WHERE DOCIND = " + document.getDocInd() + ")");
        while (resultSet.next()) {
            TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
            typeCategoryRec.setDescript(resultSet.getString(2).trim());
            typeCategoryRec.setCategoryLevel(resultSet.getString(3));
            typeCategoryRec.setParentCatInd(resultSet.getInt(4));
            typeCategoryRec.updateRecStatus(0);
            if (typeCategoryRec.getCategoryLevel().equals("brand")) {
                if (vector.contains(typeCategoryRec)) continue;
                vector.addElement(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("family")) {
                if (vector2.contains(typeCategoryRec)) continue;
                vector2.addElement(typeCategoryRec);
                continue;
            }
            if (typeCategoryRec.getCategoryLevel().equals("machine")) {
                if (vector3.contains(typeCategoryRec)) continue;
                vector3.addElement(typeCategoryRec);
                continue;
            }
            if (!typeCategoryRec.getCategoryLevel().equals("subcategory") || vector3.contains(typeCategoryRec)) continue;
            vector3.addElement(typeCategoryRec);
        }
        document.setApplicableBrands(vector);
        document.setApplicableFamilies(vector2);
        document.setApplicableMachines(vector3);
        resultSet.close();
        statement.close();
        return 0;
    }

    public static int readCommentHistory(Connection connection, Document document) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        String string = null;
        boolean bl = false;
        string = "SELECT DOCIND, COMMENT, DBUSER, CHANGEDTIME " + "FROM QUEST.DOCUMENTS " + "WHERE  EXISTINGDOCIND = " + document.getDocInd() + " AND " + "       STOPDATE IS NOT NULL AND " + "       RECYCLED = 'N' AND " + "       TEMPLATE = 'N' " + "ORDER BY STOPDATE DESC FETCH FIRST 5 ROWS ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            if (resultSet.getString(2) != null) {
                document.addCommentToHistory(new DocumentComment(resultSet.getInt(1), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim()));
                continue;
            }
            document.addCommentToHistory(new DocumentComment(resultSet.getInt(1), "N/A", resultSet.getString(3).trim(), resultSet.getString(4).trim()));
        }
        resultSet.close();
        statement.close();
        return 0;
    }
}

